
import os
DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

from Ft.Ods import Database
from Ft.Ods.MetaData import UnionCase
from Ft.Ods.MetaData import Union
from Ft.Ods.MetaData import Literal
from Ft.Ods.StorageManager import Adapters
from Ft.Ods.StorageManager.Adapters import Constants
import test_specifier
import test_metadata_util

def Test(tester):

    manager = Adapters.GetManager()
    adapter = Adapters.GetAdapter()
    if manager.exists(DBNAME):
        manager.reinitRepo(DBNAME,adapter)
    else:
        manager.new(DBNAME,adapter)
    
    db = Database.Database()
    db.open(DBNAME)
    
    try:
        test_specifier.Test(tester,db,UnionCase.UnionCase)


        tester.startGroup("UnionCase Interface %s Driver" % tester.test_data['driver'])
        test_metadata_util.test_form_drop(tester,db,UnionCase.UnionCase,'union_type',Union.Union)
        test_metadata_util.test_form_drop(tester,db,UnionCase.UnionCase,'case_labels',Literal.Literal,nSided=1)
        tester.groupDone()

    finally:
        db.close()



