
from Ft.Ods import Database
from Ft.Ods.MetaData import PrimitiveType
from Ft.Ods.MetaData import PrimitiveKind
from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods.StorageManager import Adapters
import test_type

import os
DBNAME=os.environ.get("ODS_TEST_DB","ods:test")


class TestWrapper(PrimitiveType.PrimitiveType):
    def __init__(self,db,data):
        if data is None:
            pk = PrimitiveKind.pk_short
        else:
            pk = None
        PrimitiveType.PrimitiveType.__init__(self,db,data,pk = pk)


def Test(tester):

    tester.startGroup("Primitive Type %s Driver" % tester.test_data['driver'])

    tester.startTest("Init DB")
    manager = Adapters.GetManager()
    adapter = Adapters.GetAdapter()
    if manager.exists(DBNAME):
        manager.reinitRepo(DBNAME,adapter)
    else:
        manager.new(DBNAME,adapter)
    tester.testDone()



    db = Database.Database()
    db.open(DBNAME)
    try:
        test_type.Test(tester,db,TestWrapper)

        tx = db.new()
        tx.begin()

        tester.startTest("Create Primitive Type")
        repo = db.schema()
        t = repo.create_primitive_type(PrimitiveKind.pk_short)
        t.name = 'new short'
        repo.add_defines(t)
        tx.commit()

        id = t._4ods_getId()

        tester.testDone()
        tester.startTest("Retrieve Type")

        tx = db.new()
        tx.begin()

        t = db._4ods_getPersistentObjectById(Constants.Types.ROBJECT,id)
        tester.compare('new short', t.name)
        tx.commit()

        tester.testDone()

        tester.groupDone()
    finally:
        db.close()

