<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
  <!ENTITY ftss "http://schemas.4suite.org/4ss#">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:ft="http://xmlns.4suite.org/ext">

  <!--************ ft:component templates **************-->
  <xsl:template match="ft:component[@type='page-title']">
    <title>
      <xsl:value-of select="$source/page/head/title"/>
    </title>
  </xsl:template>

  <xsl:template match="ft:component[@type='stylesheet']">
    <link rel="STYLESHEET" type="text/css" href="{$source/page/head/stylesheet[@type='minimal']}"/>
    <script language="JavaScript1.1" type="text/javascript">
        if (document.all) document.createStyleSheet("<xsl:value-of select="$source/page/head/stylesheet[@type='ie']"/>");
    </script>
  </xsl:template>

  <xsl:template match="ft:component[@type='login-status']">
    <tr class="cellGray" valign="middle" align="center">
      <td colspan="2">
        <div class="normal" style="padding-top: 2px; padding-bottom: 2px; color: #333">
          <xsl:text>[ </xsl:text>
          <xsl:choose>
            <xsl:when test="$source/page/session='expired'">
              <i>You were logged out due to inactivity. You must log in again.</i>
            </xsl:when>
            <xsl:when test="$source/page/session">
              <i>
                <xsl:text>You are logged in as </xsl:text>
                <b>
                  <xsl:value-of select="$source/page/session/@user-name"/>
                </b>
              </i>
            </xsl:when>
            <xsl:otherwise>
              <i>You are not logged in</i>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:text> ]</xsl:text>
        </div>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="ft:component[@type='top-menu']">
    <tr>
      <td colspan="2">
        <p class="blackTitle">
          <xsl:apply-templates select="$source/page/content/top-menu/element"/>
        </p>
      </td>
    </tr>
  </xsl:template>

  <!--************ element templates **************-->
  <xsl:template match="element[@type='menu-item']">
    <a href="{value}">
      <font color="#000000">
        <xsl:value-of select="label"/>
      </font>
    </a>
      &nbsp; |&nbsp; 
  </xsl:template>

  <xsl:template match="element[@type='link']" mode="row">
    <TD CLASS="hm-nav1">
      <DIV>
        <A HREF="{value}" CLASS="nvlink">
          <xsl:value-of select="label"/>
        </A>
      </DIV>
    </TD>
  </xsl:template>

  <xsl:template match="element[@type='link']">
    <a href="{link}">
      <xsl:value-of select="value"/>
    </a>
  </xsl:template>
  
  <xsl:template match="element[@type='dict-item']">
    <div>
      <b><xsl:value-of select="label"/>: </b>
        <xsl:choose>
          <xsl:when test="link">
            <a href="{link}"><xsl:value-of select="value"/></a>
          </xsl:when>
         <xsl:otherwise>
          <xsl:value-of select="value"/>
        </xsl:otherwise>
       </xsl:choose>
    </div>
  </xsl:template>
  
  <xsl:template match="element[@type='list-item']" mode="li">
    <li>
      <xsl:choose>
        <xsl:when test="link">
          <a href="{link}"><xsl:value-of select="value"/></a>
        </xsl:when>
       <xsl:otherwise>
        <xsl:value-of select="value"/>
      </xsl:otherwise>
     </xsl:choose>
    </li>
  </xsl:template>

  <xsl:template match="element[@type='text']" mode="row">
    <tr>
      <td>
        <xsl:value-of select="label"/>
      </td>
      <td>
        <input type="{@type}" name="{@name}" value="{./value}"/>
      </td>
    </tr>
  </xsl:template>
  
  <xsl:template match="element[@type='select']" mode="row">
    <tr>
      <td>
        <xsl:value-of select="label"/>
      </td>
      <td>
        <select name="{@name}">
          <xsl:for-each select="values/value">
            <option value="{@id}">
              <xsl:value-of select="."/>
            </option>
          </xsl:for-each>
        </select>
      </td>
    </tr>
  </xsl:template>
  
  <!--************ other templates **************-->
  <xsl:template match="section" mode="row">
    <tr class="cellBlue">
      <td class="menu" align="left">
          <xsl:value-of select="title"/>
      </td>
    </tr>
    <xsl:apply-templates select="element-list" mode="row"/>
  </xsl:template>
  
  <xsl:template match="element-list">
    <xsl:apply-templates select="element" mode="row"/>
  </xsl:template>
  
  <xsl:template match="element-list" mode="lower-level">
    <div>
      <xsl:apply-templates select="element"/>
    </div>
  </xsl:template>

  <xsl:template match="element-list[@type='ul']" mode="row">
    <tr>
      <td>
        <ul>
          <xsl:apply-templates select="element" mode="li"/>
        </ul>
      </td>
    </tr>
  </xsl:template>
  
  <xsl:template match="element-list[@type='dict']" mode="row">
    <tr>
      <td>
        <xsl:apply-templates select="element"/>
      </td>
    </tr>
  </xsl:template>

</xsl:stylesheet>
