<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY bbschema "http://uche.ogbuji.net/example/buyerbase/schema#">
  <!ENTITY bb "http://uche.ogbuji.net/example/buyerbase">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
]>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:frdf="http://xmlns.4suite.org/4ss/rdf"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-set="http://exslt.org/sets"
  xmlns:exslt-math="http://exslt.org/math"
  xmlns:exslt-functions="http://exslt.org/functions"
  xmlns:exslt-date-time="http://exslt.org/dates-and-times"
  xmlns:dc="&dc;"
  xmlns:fres="&fres;"
  xmlns:bbschema="&bbschema;"
  xmlns:bb="&bb;"
  xmlns:rdf="&rdf;"
  xmlns:f="&f;"
  extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time"
  exclude-result-prefixes="f frdf fhttp fcore fres exslt exslt-set exslt-math exslt-functions exslt-date-time dc bb rdf bbschema">


  <!--
File:  purchase-summary.xslt

Description:

    This stylesheet renders information about all purchases associated
    with a certain customer.

    This stylesheet expects to be applied to a customer XML document.
    An RDF "complete" is used to get the IDs of the customer's
    purchases, and the purchase data comes from the corresponding
    purchase XML document.

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
  -->

  <xsl:include href="menu-includes.xslt"/>

  <xsl:param name="order-id"/>
  <xsl:param name='fres:absolute-path'/>

  <xsl:template match="/">
    <xsl:choose>
      <xsl:when test="fcore:has-session()">
        <xsl:call-template name="menus">
          <xsl:with-param name="pageTitle" select="'Buyer Base - Customer Purchase Orders'"/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <fhttp:response-uri uri="/buyerbase/?xslt=home.xslt"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="body">
    <table width="695">
      <tr>
        <td colspan="2">
          <p class="blackTitle">
            <a href="/buyerbase/?xslt=index.xslt">
              <font color="#000000">View Customer Index</font>
            </a>
            <xsl:text>&nbsp;|&nbsp;</xsl:text>
            <a href="{$fres:uri-path}?xslt=../customer.xslt">
              <font color="#000000">View Customer File</font>
            </a>
            <xsl:text>&nbsp;|&nbsp;</xsl:text>
            <xsl:choose>
              <xsl:when test='fcore:has-session()'>
                <a href="{$fres:uri-path}?xslt=../new-purchase.xslt">
                  <font color="#000000">New Purchase</font>
                </a>
                <xsl:text>&nbsp;|&nbsp;</xsl:text>
                <a href="/buyerbase/?xslt=logout.xslt">
                  <font color="#000000">Logout</font>
                </a>
              </xsl:when>
              <xsl:otherwise>
                <a href="/buyerbase/?xslt=home.xslt">
                  <font color="#000000">Login</font>
                </a>
              </xsl:otherwise>
            </xsl:choose>
          </p>
        </td>
      </tr>
      <xsl:call-template name="display-customer"/>
      <tr class="cellBlue">
        <td class="menucell" colspan="2" align="left"><div class="menu">Purchase Orders</div></td>
      </tr>
      <tr>
        <td colspan="2" valign="top">
          <table border="1" width="675" cellpadding="2" bgcolor="#FFFFFF" bordercolorlight="#C0C0C0" class="normal">
            <tr class="cellGray">
              <td class="th" align="center">Purchase Order No.</td>
              <td class="th" align="center">Date</td>
              <td class="th" align="center">State</td>
            </tr>
            <!-- statements about submitted purchase orders -->
            <xsl:variable name="orders" select="frdf:complete($fres:absolute-path,'&bbschema;order',frdf:any())"/>
            <xsl:apply-templates select="$orders" mode="previous-order"/>
            <!-- current shopping cart XML -->
            <xsl:variable name='cur' select='fcore:session-data("CART")'/>
            <xsl:variable name="pending-purchases" select="$cur/bb:pending/bb:order[@cust-id = $fres:absolute-path]"/>
            <xsl:if test="$pending-purchases">
              <tr>
                <td align="center">
                  <a href="{$fres:uri-path}?xslt=../new-purchase.xslt">Not yet assigned</a>
                </td>
                <td align="center">
                  <xsl:variable name='now' select='$cur/bb:pending/@date'/>
                  <xsl:value-of select='concat(exslt-date-time:month-abbreviation($now)," ",exslt-date-time:day-in-month($now)," ",exslt-date-time:hour-in-day($now),":",exslt-date-time:minute-in-hour($now))'/>
                </td>
                <td align="center">Pending</td>
              </tr>
            </xsl:if>
            <xsl:if test="not($orders or $pending-purchases)">
              <tr>
                <td align="center" colspan="3">
                  <b>no purchase orders for this customer on file</b>
                </td>
              </tr>
            </xsl:if>
          </table>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template name="display-customer">
    <tr class="cellBlue">
      <td class="menucell" colspan="2" align="left"><div class="menu">Customer</div></td>
    </tr>
    <tr>
      <td><div class="normal">Name: <xsl:value-of select='bb:customer/bb:fullname'/></div></td>
      <td><div class="normal">Work Phone: <xsl:value-of select='bb:customer/bb:phone[@desc="work"]'/></div></td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
    </tr>
  </xsl:template>

  <xsl:template match="Statement" mode="previous-order">
    <tr>
      <td align="center">
        <a href="{fhttp:local-path(Object)}?xslt=../purchase.xslt">
          <xsl:value-of select="document(Object)/bb:purchase/@id"/>
        </a>
      </td>
      <td align="center">
        <xsl:variable name='now' select='document(Object)/bb:purchase/bb:date'/>
        <xsl:value-of select='concat(exslt-date-time:month-abbreviation($now)," ",format-number(exslt-date-time:day-in-month($now),"00")," ",format-number(exslt-date-time:hour-in-day($now),"00"),":",format-number(exslt-date-time:minute-in-hour($now),"00"))'/>
      </td>
      <td align="center">Ordered</td>
    </tr>
  </xsl:template>

</xsl:stylesheet>
