#!/usr/bin/env python
"""
Generate an HTML page displaying all the icons in the icons/
subdirectory.
"""

import os, re
from urllib import quote

HEAD = u"""<html>
  <head>
    <title>Icons</title>
  </head>
  <body>
    <center>
      <h1>Icons</h1>
      <hr>
      <table border="1" cellpadding="4">
"""

FOOT = u"""    </table>
  </body>
</html>"""

imageRE = re.compile(r'.+?\.(gif|GIF|jpg|JPG|jpeg|JPEG|jpe|JPE|png|PNG)$')

def run():
    doc = HEAD
    files = os.listdir(u'icons')
    images = []
    for f in files:
        if imageRE.match(f):
            images.append(f.strip())
    total = len(images)
    rows = total/5
    if total % 5:
        rows = rows + 1
    for i in range(0,total,5):
        doc += u"      <tr>\n"
        for j in range(5):
            if i+j > total:
                break
            img = images[i+j]        
            doc += u"""        <td>
          <img src="icons/%s">
          <br>
          %s
        </td>\n""" % (quote(img), img)
        doc += "      </tr>\n"
    doc += FOOT
    doc = doc.encode('ascii')
    f = open('icons.html','w')
    f.write(doc)
    f.close()
    

if __name__ == '__main__':
    run()

