########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/Xslt/XmlDocument.py,v 1.6 2005/04/06 23:05:46 jkloth Exp $
"""
XSLT extensions providing repository functionality related to
XmlDocument objects

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

from Ft.Xml.XPath import Conversions
from Ft.Xml.Xslt import XsltElement, ContentInfo, AttributeInfo

from Ns import SCORE_NS
import FtssXsltBase


def GetDocumentDefinition(context, path=None):
    path = Conversions.StringValue(path)
    base = FtssXsltBase.FetchBaseObject(context.processor, path)
    dd = base.getDocumentDefinition()
    if dd is None: return ""
    return dd.getAbsolutePath()


class SetDocumentDefinitionElement(XsltElement):
    """
    Change the Document Definition of a XML document
    """
    content = ContentInfo.Empty

    legalAttrs = {
        'path' : AttributeInfo.UriReferenceAvt(
            description=('The path of the resource to change the IMT of.'
                         ' Defaults to current.')),
        'docdef' : AttributeInfo.StringAvt(
            required=1,
            description='The new Document Definition'),
        }

    def instantiate(self, context, processor):
        context.setProcessState(self)
        # This may return None (the 'default' from AttributeInfo)
        path          = self._path.evaluate(context)
        dd          = self._docdef.evaluate(context)

        obj = FtssXsltBase.FetchBaseObject(processor, path)
        if dd == "":
            obj.setDocumentDefinition(None)
        else:
            docdef = obj.fetchResource(dd);
            obj.setDocumentDefinition(docdef)

        return


ExtFunctions = {
    (SCORE_NS, 'get-document-definition'): GetDocumentDefinition,
}

ExtElements = {
    (SCORE_NS, 'set-document-definition'): SetDocumentDefinitionElement,
}
