########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/Update/Extension.py,v 1.7 2004/09/23 20:53:33 mbrown Exp $
"""
Implementation of '4ss update extension' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command reloads an extension module in a 4Suite \
repository. If necessary, you will be prompted first for credentials \
and access info to connect to the repository."""

from Ft.Lib import Uri
from Ft.Server.Client.Commands import CommandUtil


def Run(options,args):
    module = args['module']

    repo = CommandUtil.GetRepository(options,'4ss.update.extension')
    if repo is not None:
        try:
            repo.reloadModule(module)
        finally:
            try:
                repo.txRollback()
            except:
                pass

    return


def Register():

    from Ft.Lib.CommandLine import Options, Command, Arguments

    cmd = Command.Command('extension',
                          """Reload an extension module in a repository""",
                          'Ft.Share.ExtensionModules.SomeModule',
                          __doc__,
                          function = Run,
                          arguments = [
                                       Arguments.RequiredArgument('module',
                                                                  "The Python module name",
                                                                  str),
                                       ],
                          fileName = __file__,
                          )
    return cmd


