########################################################################
#
# File Name:            Command.py
#
# Documentation:        http://docs.4suite.org/4Rdf/Inference/Command.py.html
#
"""

WWW: http://4suite.org/4RDF         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from Ft import Rdf
#import Common
import InferenceEngine

class Command:
    def __init__(self, id_):
        self.id = id_
        return

    def execute(self, infEng, context):
        raise "Must Override"


#Some start and stop actions
class StopCommand(Command):
    def __init__(self):
        Command.__init__(self,Rdf.RIL_NAMESPACE + '#stop')
        return

    def execute(self, infEng, context):
        infEng.state = InferenceEngine.InferenceEngine.STOPPED
        return

    def _4rdf_dump(self,indent=0):
        iStr = "\t"*indent
        rt = iStr + "<ril:stop/>"
        return rt



class FireCommand(Command):
    def __init__(self):
        Command.__init__(self,Rdf.RIL_NAMESPACE + '#fire')
        return

    def execute(self, infEng, context):
        infEng.fire(context)

    def _4rdf_dump(self,indent=0):
        iStr = "\t"*indent
        rt = iStr + "<ril:fire/>"
        return rt


class MessageCommand(Command):
    def __init__(self,args):
        Command.__init__(self,Rdf.RIL_NAMESPACE + '#message')
        self.args = args
        return

    def execute(self, infEng, context):
        infEng.outStream.write("**Start Ril Message**\n")
        for arg in self.args:
            a = arg.execute(infEng,context)
            infEng.outStream.write(str(a) + '\n')
        infEng.outStream.write("**End Ril Message**\n")

    def _4rdf_dump(self,indent=0):
        iStr = "\t"*indent
        rt = iStr + "<ril:message>\n"
        for arg in self.args:
            rt = rt + arg._4rdf_dump(indent+1)
        rt = rt + iStr + "</ril:message>\n"
        return rt

