import string

from Ft.Ods.StorageManager.Adapters import Constants, Manager
from Ft.Ods.StorageManager.Adapters.Manager import UserAccessLevel

class DbManager(Manager.DbManager):

    def init(self, connString):

        db = self.connect(connString)

        #Create the sequences
        for seq in self.sequences.keys():
            self._createSequence(db,seq)


        #NOTE: Check for validity
        if len(g_sortedTableNames) != len(self.tables.keys()):
            for table_name in g_sortedTableNames:
                if table_name not in self.tables.keys():
                    print "%s in sorted but not dictionary" % table_name
            for table_name in self.tables.keys():
                if table_name not in g_sortedTableNames:
                    print "%s in dictionary but not sorted" % table_name
            raise "Definition validity error"


        #Setup the tables
        for table_name in g_sortedTableNames:
            initData = self.tables[table_name][self.TableData.TABLE_INIT]
            inherits = self.tables[table_name][self.TableData.TABLE_INHERITS]
            self._createTable(db,table_name,initData,inherits)

        #Create all of the collection tables
        madeTables = []
        for (table_name,table_type) in self.collectionTableMapping.values():
            if table_name in madeTables: continue
            index_name = '%s_index' % table_name

            data = self.collectionTableData[:]
            data[1][1] = table_type
            
            self._createTable(db,table_name,data,['ftods_collection'])
            self._createIndex(db,index_name,['_cid','index'],table_name)
            madeTables.append(table_name)

        self.close(db)
        del db



    def _createTable(self,db,table_name,initData,inherits):
        st = "CREATE TABLE %s (" % table_name
        st = st + self._tableInitString(table_name,initData,inherits) + ')'
        self._execute(db,st)

    def _dropTable(self,db,tableName):
        db.query("DROP TABLE %s" % tableName)

    def _tableInitString(self,table_name,initData,inherits):
        st = ' '
        iTables = inherits
        for parentTableName in iTables:
            pInitData = self.tables[parentTableName][self.TableData.TABLE_INIT]
            pInherits = self.tables[parentTableName][self.TableData.TABLE_INHERITS]
            st = st + self._tableInitString(parentTableName,pInitData,pInherits) + ','

        for data in initData:
            st = st + "%s %s %s," % (data[0],self.systemTypesToSql[data[1]],data[2])
        st = st[:-1]
        return st

    def _4ods_interfaceTableInitString(self,data):
        tableName,defs,bClasses = data
        st = ""
        for b in bClasses:
            st = st + self._4ods_interfaceTableInitString(b)

        for (name,t) in defs:
            st = '%s%s %s,'%(st,name,t)
        return st


    #Repository Object Helpers
    def _createInterfaceStorage(self,db,data):
        tableName,defs,bClasses = data
        qstr = 'CREATE TABLE %s ( ' % tableName
        qstr = qstr + self._4ods_interfaceTableInitString(data)
        qstr = qstr [:-1] + ')'
        self._execute(db,qstr)


    def reinit(self,dbName,adapter):
        db = self.connect(dbName)
        adapter.begin(db)

        for tableName in self._getAllGeneratedTables(db):
            self._dropTable(db,tableName)

        table_names = map(lambda x:x[0],self.collectionTableMapping.values()) + g_sortedTableNames
        for tableName in table_names:
            try:
                self._deleteTable(db,tableName)
            except:
                pass


        adapter.commit(db)


        del db

    def clear(self, connectString):
        db = self.connect(connectString)

        # Remove the blob objects
        self._deleteAllBlobs(db)

        #Get all of the interfaces
        rt = self._getAllGeneratedTables(db)

        # Get all of the interfaces
        for table_name in self._getAllGeneratedTables(db):
            self._deleteTable(db,table_name)

        for name, id in self._getAllExtentNames(db):
            if name == 'ftods_types':
                continue
            self._deleteExtent(db, id)

        self._dropAllBindings(db)

        self.close(db)
        del db

    def grant(self, connectString, user, level):
        #Get a table list
        db = self.connect(connectString)

        #The table list depends on the level
        readonly = []
        readwrite = []
        writable = [DbManager.AccessTypes.SYSTEM_ACCESS]
        if level == UserAccessLevel.ALL:
            writable.extend([DbManager.AccessTypes.METADATA_ACCESS,
                             DbManager.AccessTypes.OBJECT_ACCESS,
                             ])
        elif level == UserAccessLevel.METADATA:
            writable.append(DbManager.AccessTypes.METADATA_ACCESS)
        elif level == UserAccessLevel.OBJECT:
            writable.append(DbManager.AccessTypes.OBJECT_ACCESS)
                        
        for (table_name, table) in self.tables.items():
            if table[DbManager.TableData.TABLE_ACCESS] in writable:
                readwrite.append(table_name)
            else:
                readonly.append(table_name)

        for (sequence_name, access) in self.sequences.items():
            if access in writable:
                readwrite.append(sequence_name)
            else:
                readonly.append(sequence_name)

        #Grant on the collection tables
        readwrite.extend(map(lambda (name, type): name, self.collectionTableMapping.values()))

        # Get all the object tables
        if level in [UserAccessLevel.ALL, UserAccessLevel.OBJECT]:
            readwrite.extend(self._getAllGeneratedTables(db))

        # Give write access
        user = '"%s"' % user
        for name in readwrite:
            for cmd in ['SELECT','UPDATE','INSERT','DELETE']:
                db.query("GRANT %s on %s to %s" % (cmd, name, user))

        # Give read access
        for name in readonly:
            db.query("GRANT SELECT on %s to %s" % (name, user))
            
        return

    def clean(self, connectString):
        #FIXME: How do we handle ODS object GC?
        return

    class SystemTypes:
        NAME = 1
        OBJECT = 2
        ENUMERATION = 3
        STRING = 4
        BOOLEAN = 5
        SHORT = 6
        STRING = 7
        DOUBLE = 8
        TIMESTAMP = 9
        ANY = 10

    class AccessTypes:
        SYSTEM_ACCESS = 1
        OBJECT_ACCESS = 2
        METADATA_ACCESS = 3

    class TableData:
        TABLE_INIT = 1
        TABLE_ACCESS = 2
        TABLE_INHERITS = 3

    tables = {
        'ftods_binding' : {TableData.TABLE_INIT:[('name',SystemTypes.NAME,'PRIMARY KEY'),
                                                 ('objid',SystemTypes.OBJECT,''),
                                                 ('repoid',SystemTypes.OBJECT,'')
                                                 ],
                           TableData.TABLE_ACCESS:AccessTypes.OBJECT_ACCESS,
                           TableData.TABLE_INHERITS:[]
                           },
        'ftods_extents': {TableData.TABLE_INIT:[('name',SystemTypes.NAME,'PRIMARY KEY'),
                                                ('extentid',SystemTypes.OBJECT,''),
                                                ('persistentType',SystemTypes.ENUMERATION,'')
                                                ],
                          TableData.TABLE_ACCESS:AccessTypes.SYSTEM_ACCESS,
                          TableData.TABLE_INHERITS:[]
                          },


        'ftods_extentmapping': {TableData.TABLE_INIT:[('extentid',SystemTypes.OBJECT,''),
                                                      ('id',SystemTypes.OBJECT,'')
                                                      ],
                                TableData.TABLE_ACCESS:AccessTypes.SYSTEM_ACCESS,
                                TableData.TABLE_INHERITS:[]
                                },

        'ftods_metaname': {TableData.TABLE_INIT:[('repoid',SystemTypes.OBJECT,'PRIMARY KEY'),
                                                 ('meta_kind',SystemTypes.NAME,''),
                                                 ],
                           TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                           TableData.TABLE_INHERITS:[]
                           },

        'ftods_pythonclass': {TableData.TABLE_INIT:[('pythonClassid',SystemTypes.OBJECT,'PRIMARY KEY'),
                                                    ('pythonClassName',SystemTypes.STRING,''),
                                                    ('pythonModuleName',SystemTypes.STRING,''),
                                                    ],
                              TableData.TABLE_ACCESS:AccessTypes.OBJECT_ACCESS,
                              TableData.TABLE_INHERITS:[]
                                },

        'ftods_literalclass': {TableData.TABLE_INIT:[('pythonClassName',SystemTypes.STRING,''),
                                                     ('pythonModuleName',SystemTypes.STRING,''),
                                                     ('type',SystemTypes.OBJECT,''),
                                                     ('repoid',SystemTypes.OBJECT,''),
                                                     ],
                              TableData.TABLE_ACCESS:AccessTypes.OBJECT_ACCESS,
                              TableData.TABLE_INHERITS:[]
                                },

        'ftods_actualclass':{TableData.TABLE_INIT:[('_oid',SystemTypes.OBJECT,'PRIMARY KEY'),
                                                   ('pythonclassid',SystemTypes.OBJECT,''),
                                                   ('lastUpdate',SystemTypes.TIMESTAMP,''),
                                                   ],
                             TableData.TABLE_ACCESS:AccessTypes.OBJECT_ACCESS,
                             TableData.TABLE_INHERITS:[]
                                },
        'ftods_collectionclass':{TableData.TABLE_INIT:[('_cid',SystemTypes.OBJECT,'PRIMARY KEY'),
                                                       ('pythonclassid',SystemTypes.OBJECT,''),
                                                       ('subtype',SystemTypes.ENUMERATION,''),
                                                       ('subtyperepoid',SystemTypes.OBJECT,''),
                                                       ('lastUpdate',SystemTypes.TIMESTAMP,''),
                                                       ],
                                 TableData.TABLE_ACCESS:AccessTypes.OBJECT_ACCESS,
                                 TableData.TABLE_INHERITS:[]
                                },
        'ftods_dictionaryclass':{TableData.TABLE_INIT:[('_did',SystemTypes.OBJECT,'PRIMARY KEY'),
                                                       ('pythonclassid',SystemTypes.OBJECT,''),
                                                       ('keytype',SystemTypes.ENUMERATION,''),
                                                       ('keytyperepoid',SystemTypes.OBJECT,''),
                                                       ('subtype',SystemTypes.ENUMERATION,''),
                                                       ('subtyperepoid',SystemTypes.OBJECT,''),
                                                       ('lastUpdate',SystemTypes.TIMESTAMP,''),
                                                       ],
                                 TableData.TABLE_ACCESS:AccessTypes.OBJECT_ACCESS,
                                 TableData.TABLE_INHERITS:[]
                                },
        'ftods_operationdata':{TableData.TABLE_INIT:[('repoId',SystemTypes.OBJECT,'PRIMARY KEY'),
                                                     ('functionName',SystemTypes.STRING,''),
                                                     ('blobid',SystemTypes.OBJECT,''),
                                                     ],
                                 TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                                 TableData.TABLE_INHERITS:[]
                                },
        'ftods_dictionarydata':{TableData.TABLE_INIT:[('_did',SystemTypes.OBJECT,''),
                                                       ('key',SystemTypes.STRING,''),
                                                       ('value',SystemTypes.STRING,''),
                                                       ],
                                 TableData.TABLE_ACCESS:AccessTypes.OBJECT_ACCESS,
                                 TableData.TABLE_INHERITS:[]
                                },
        'ftods_object':{TableData.TABLE_INIT:[('_oid',SystemTypes.OBJECT,''),
                                              ],
                        TableData.TABLE_ACCESS:AccessTypes.OBJECT_ACCESS,
                        TableData.TABLE_INHERITS:[]
                        },
        'ftods_collection':{TableData.TABLE_INIT:[('_cid',SystemTypes.OBJECT,''),
                                                  ],
                            TableData.TABLE_ACCESS:AccessTypes.SYSTEM_ACCESS,
                            TableData.TABLE_INHERITS:[]
                            },

        'ftods_literal':{TableData.TABLE_INIT:[('_lid',SystemTypes.OBJECT,'PRIMARY KEY'),
                                               ],
                         TableData.TABLE_ACCESS:AccessTypes.OBJECT_ACCESS,
                         TableData.TABLE_INHERITS:[]
                         },
        'ftods_datedata':{TableData.TABLE_INIT:[('year',SystemTypes.SHORT,''),
                                                ('month',SystemTypes.SHORT,''),
                                                ('day',SystemTypes.SHORT,''),
                                                ],
                          TableData.TABLE_ACCESS:AccessTypes.OBJECT_ACCESS,
                          TableData.TABLE_INHERITS:['ftods_literal']
                          },
        'ftods_repomap':{TableData.TABLE_INIT:[('repoid',SystemTypes.OBJECT,'PRIMARY KEY'),
                                               ('meta_kind',SystemTypes.ENUMERATION,''),
                                               ('lastUpdate',SystemTypes.TIMESTAMP,''),
                                               ('pythonclassid',SystemTypes.OBJECT,''),
                                               ],
                         TableData.TABLE_ACCESS:AccessTypes.OBJECT_ACCESS,
                         TableData.TABLE_INHERITS:[]
                         },
        'ftods_repositoryobject':{TableData.TABLE_INIT:[('_repoid',SystemTypes.OBJECT,'PRIMARY KEY'),
                                                        ('meta_kind',SystemTypes.ENUMERATION,''),
                                                        ],
                                  TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                                  TableData.TABLE_INHERITS:[]
                                  },

        'ftods_metaobject':{TableData.TABLE_INIT:[('name',SystemTypes.STRING,''),
                                                  ('comment',SystemTypes.STRING,''),
                                                  ('definedIn',SystemTypes.OBJECT,''),
                                                  ],
                            TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                            TableData.TABLE_INHERITS:["ftods_repositoryobject"]
                         },

        'ftods_definingscope':{TableData.TABLE_INIT:[('defines',SystemTypes.OBJECT,''),
                                                     ],
                               TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                               TableData.TABLE_INHERITS:[]
                               },
        'ftods_module':{TableData.TABLE_INIT:[
                                              ],
                        TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                        TableData.TABLE_INHERITS:["ftods_metaobject","ftods_definingscope"]
                        },
        'ftods_operation':{TableData.TABLE_INIT:[('signature',SystemTypes.OBJECT,''),
                                                 ('result',SystemTypes.OBJECT,''),
                                                 ('exceptions',SystemTypes.OBJECT,''),
                                                 ],
                           TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                           TableData.TABLE_INHERITS:["ftods_metaobject"]
                           },

        'ftods_exception':{TableData.TABLE_INIT:[('result',SystemTypes.OBJECT,''),
                                                 ('operations',SystemTypes.OBJECT,''),
                                                 ],
                           TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                           TableData.TABLE_INHERITS:["ftods_metaobject"]
                         },

        'ftods_constant':{TableData.TABLE_INIT:[('the_value',SystemTypes.OBJECT,''),
                                                ('type',SystemTypes.OBJECT,''),
                                                ('referenced_by',SystemTypes.OBJECT,''),
                                                ('enumeration',SystemTypes.OBJECT,''),
                                                ],
                          TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                          TableData.TABLE_INHERITS:["ftods_metaobject"]
                          },

        'ftods_property':{TableData.TABLE_INIT:[('type',SystemTypes.OBJECT,''),
                                                ],
                          TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                          TableData.TABLE_INHERITS:["ftods_metaobject"]
                         },


        'ftods_attribute':{TableData.TABLE_INIT:[('is_read_only',SystemTypes.BOOLEAN,''),
                                                 ],
                           TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                           TableData.TABLE_INHERITS:["ftods_property"]
                         },

        'ftods_relationship':{TableData.TABLE_INIT:[('traversal',SystemTypes.OBJECT,''),
                                                    ],
                              TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                              TableData.TABLE_INHERITS:["ftods_property"]
                              },

        'ftods_type':{TableData.TABLE_INIT:[('collections',SystemTypes.OBJECT,''),
                                            ('dictionaries',SystemTypes.OBJECT,''),
                                            ('specifiers',SystemTypes.OBJECT,''),
                                            ('unions',SystemTypes.OBJECT,''),
                                            ('operations',SystemTypes.OBJECT,''),
                                            ('properties',SystemTypes.OBJECT,''),
                                            ('constants',SystemTypes.OBJECT,''),
                                            ('type_defs',SystemTypes.OBJECT,''),
                                            ],
                      TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                      TableData.TABLE_INHERITS:["ftods_metaobject"]
                      },

        'ftods_type_definition':{TableData.TABLE_INIT:[('alias',SystemTypes.OBJECT,''),
                                                       ],
                                 TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                                 TableData.TABLE_INHERITS:["ftods_type"]
                         },

        'ftods_primitive_type':{TableData.TABLE_INIT:[('primitive_kind',SystemTypes.ENUMERATION,''),
                                                      ],
                                TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                                TableData.TABLE_INHERITS:["ftods_type"]
                                },

        'ftods_interface':{TableData.TABLE_INIT:[('inherits',SystemTypes.OBJECT,''),
                                                 ('derives',SystemTypes.OBJECT,''),
                                                 ],
                           TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                           TableData.TABLE_INHERITS:["ftods_type","ftods_definingscope"]
                           },

        'ftods_class':{TableData.TABLE_INIT:[('extents',SystemTypes.OBJECT,''),
                                             ('keys',SystemTypes.OBJECT,''),
                                             ('extender',SystemTypes.OBJECT,''),
                                             ('extensions',SystemTypes.OBJECT,''),
                                             ],
                       TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                       TableData.TABLE_INHERITS:["ftods_interface"]
                       },
        
        'ftods_metadatacollection':{TableData.TABLE_INIT:[('collection_kind',SystemTypes.ENUMERATION,''),
                                                          ('max_size',SystemTypes.SHORT,''),
                                                          ('subtype',SystemTypes.OBJECT,''),
                                                          ],
                                    TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                                    TableData.TABLE_INHERITS:["ftods_type"]
                                    },

        'ftods_dictionary':{TableData.TABLE_INIT:[('key_type',SystemTypes.OBJECT,''),
                                                  ],
                            TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                            TableData.TABLE_INHERITS:["ftods_metadatacollection"]
                            },

        'ftods_enumeration':{TableData.TABLE_INIT:[('elements',SystemTypes.OBJECT,''),
                                                   ],
                             TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                             TableData.TABLE_INHERITS:["ftods_type"]
                             },

        'ftods_structure':{TableData.TABLE_INIT:[('fields',SystemTypes.OBJECT,''),
                                                 ('exception_result',SystemTypes.OBJECT,''),
                                                 ],
                           TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                           TableData.TABLE_INHERITS:["ftods_type"]
                           },

        'ftods_union':{TableData.TABLE_INIT:[('cases',SystemTypes.OBJECT,''),
                                             ('switch_type',SystemTypes.OBJECT,''),
                                             ],
                       TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                       TableData.TABLE_INHERITS:["ftods_type"]
                       },

        'ftods_specifier':{TableData.TABLE_INIT:[('name',SystemTypes.STRING,''),
                                                 ('type',SystemTypes.OBJECT,''),
                                                 ],
                           TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                           TableData.TABLE_INHERITS:["ftods_repositoryobject"]
                           },

        'ftods_member':{TableData.TABLE_INIT:[('structure_type',SystemTypes.OBJECT,''),
                                              ],
                        TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                        TableData.TABLE_INHERITS:["ftods_specifier"]
                        },
        'ftods_union_case':{TableData.TABLE_INIT:[('union_type',SystemTypes.OBJECT,''),
                                                 ('case_labels',SystemTypes.OBJECT,''),
                                                 ],
                           TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                           TableData.TABLE_INHERITS:["ftods_specifier"]
                           },

        'ftods_parameter':{TableData.TABLE_INIT:[('parameter_mode',SystemTypes.ENUMERATION,''),
                                                 ('operation',SystemTypes.OBJECT,''),
                                                 ],
                           TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                           TableData.TABLE_INHERITS:["ftods_specifier"]
                           },

        'ftods_operand':{TableData.TABLE_INIT:[('operand_in',SystemTypes.OBJECT,''),
                                               ('value_of',SystemTypes.OBJECT,''),
                                               ('size_of',SystemTypes.OBJECT,''),
                                               ('case_in',SystemTypes.OBJECT,''),
                                               ],
                         TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                         TableData.TABLE_INHERITS:["ftods_repositoryobject"]
                         },

        'ftods_metadataliteral':{TableData.TABLE_INIT:[('_literal_value',SystemTypes.ANY,''),
                                                       ],
                                 TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                                 TableData.TABLE_INHERITS:["ftods_operand"]
                                 },

        'ftods_const_operand':{TableData.TABLE_INIT:[('_references',SystemTypes.OBJECT,''),
                                                     ],
                               TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                               TableData.TABLE_INHERITS:["ftods_operand"]
                               },

        'ftods_expression':{TableData.TABLE_INIT:[('operator',SystemTypes.STRING,''),
                                                  ('the_operands',SystemTypes.OBJECT,''),
                                                  ],
                            TableData.TABLE_ACCESS:AccessTypes.METADATA_ACCESS,
                            TableData.TABLE_INHERITS:["ftods_operand"]
                         },
        }


    sequences = {'ftods_objid':AccessTypes.OBJECT_ACCESS,
                 'ftods_repoid':AccessTypes.METADATA_ACCESS,
                 'ftods_litid':AccessTypes.OBJECT_ACCESS,
                 'ftods_extentid':AccessTypes.OBJECT_ACCESS,
                 'ftods_pythonclassid':AccessTypes.SYSTEM_ACCESS,
                 'ftods_collectionid':AccessTypes.SYSTEM_ACCESS,
                 'ftods_dictionaryid':AccessTypes.SYSTEM_ACCESS,
                 }

    metaKindToTableName = {0:'ftods_attribute',
                           1:'ftods_class',
                           2:'ftods_metadatacollection',
                           3:'ftods_constant',
                           4:'ftods_const_operand',
                           5:'ftods_enumeration',
                           6:'ftods_exception',
                           7:'ftods_expression',
                           8:'ftods_interface',
                           9:'ftods_metadataliteral',
                           10:'ftods_member',
                           11:'ftods_module',
                           12:'ftods_operation',
                           13:'ftods_parameter',
                           14:'ftods_primitive_type',
                           15:'ftods_relationship',
                           16:'ftods_module',
                           17:'ftods_structure',
                           18:'ftods_type_definition',
                           19:'ftods_union',
                           20:'ftods_union_case'
                           }

    collectionTableMapping = {
        Constants.Types.STRING : ('ftods_string_collection',SystemTypes.STRING),
        Constants.Types.CHAR : ('ftods_string_collection',SystemTypes.STRING),
        Constants.Types.POBJECT: ('ftods_long_collection',SystemTypes.OBJECT),
        Constants.Types.ROBJECT: ('ftods_long_collection',SystemTypes.OBJECT),
        Constants.Types.SIGNED_LONG: ('ftods_long_collection',SystemTypes.OBJECT),
        Constants.Types.UNSIGNED_LONG: ('ftods_long_collection',SystemTypes.OBJECT),
        Constants.Types.SIGNED_LONG_LONG: ('ftods_long_collection',SystemTypes.OBJECT),
        Constants.Types.SIGNED_SHORT: ('ftods_short_collection',SystemTypes.SHORT),
        Constants.Types.OCTET: ('ftods_short_collection',SystemTypes.SHORT),
        Constants.Types.UNSIGNED_SHORT: ('ftods_short_collection',SystemTypes.SHORT),
        Constants.Types.DOUBLE : ('ftods_double_collection',SystemTypes.DOUBLE),
        Constants.Types.FLOAT : ('ftods_double_collection',SystemTypes.DOUBLE),
        Constants.Types.BOOLEAN : ('ftods_boolean_collection',SystemTypes.BOOLEAN),
        Constants.Types.DATE : ('ftods_string_collection',SystemTypes.STRING),
        Constants.Types.INTERVAL : ('ftods_string_collection',SystemTypes.STRING),
        Constants.Types.TIME : ('ftods_string_collection',SystemTypes.STRING),
        Constants.Types.TIMESTAMP : ('ftods_string_collection',SystemTypes.STRING),
        Constants.Types.ENUMERATION : ('ftods_string_collection',SystemTypes.STRING),
        Constants.Types.STRUCTURE : ('ftods_string_collection',SystemTypes.STRING),
        Constants.Types.UNION : ('ftods_string_collection',SystemTypes.STRING),

        Constants.Types.LIST_COLLECTION: ('ftods_long_collection',SystemTypes.OBJECT),
        Constants.Types.SET_COLLECTION: ('ftods_long_collection',SystemTypes.OBJECT),
        Constants.Types.BAG_COLLECTION: ('ftods_long_collection',SystemTypes.OBJECT),
        Constants.Types.DICTIONARY_COLLECTION: ('ftods_long_collection',SystemTypes.OBJECT),

        Constants.Types.FIXEDSTRING : ('ftods_string_collection',SystemTypes.STRING),


        }


    collectionTableData = [('index',SystemTypes.SHORT,''),
                           ['value',"PLACE HOLDER",''],
                           ]



#A list of all of the table names in creation order
g_sortedTableNames = ['ftods_binding',
                      'ftods_extents',
                      'ftods_extentmapping',
                      'ftods_metaname',
                      'ftods_pythonclass',
                      'ftods_literalclass',
                      'ftods_actualclass',
                      'ftods_collectionclass',
                      'ftods_dictionaryclass',
                      'ftods_dictionarydata',
                      'ftods_operationdata',
                      'ftods_object',
                      'ftods_collection',
                      'ftods_literal',
                      'ftods_datedata',
                      'ftods_repomap',
                      'ftods_repositoryobject',
                      'ftods_metaobject',
                      'ftods_definingscope',
                      'ftods_module',
                      'ftods_operation',
                      'ftods_exception',
                      'ftods_constant',
                      'ftods_property',
                      'ftods_attribute',
                      'ftods_relationship',
                      'ftods_type',
                      'ftods_type_definition',
                      'ftods_primitive_type',
                      'ftods_interface',
                      'ftods_class',
                      'ftods_metadatacollection',
                      'ftods_dictionary',
                      'ftods_enumeration',
                      'ftods_structure',
                      'ftods_union',
                      'ftods_specifier',
                      'ftods_member',
                      'ftods_union_case',
                      'ftods_parameter',
                      'ftods_operand',
                      'ftods_metadataliteral',
                      'ftods_const_operand',
                      'ftods_expression',                      
                      ]
                      
