########################################################################
#
# File Name: 	        Specifier.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Specifier.py.html
#
"""
Implements the Specifier meta-data interface.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

from Ft.Ods.MetaData import RepositoryObject
from Ft.Ods.StorageManager.Adapters import Constants

from Ft.Ods import PersistentObject
td = PersistentObject.TupleDefinitions

class Specifier(RepositoryObject.RepositoryObject):
    def __init__(self,db,data,metaKind):
        RepositoryObject.RepositoryObject.__init__(self,db,data,metaKind)

        if data == None:
            self.__dict__['name'] = ''


    def form_type(self,target,inverse = 1):
        from Ft.Ods.MetaData import Type
        self._4ods_formRelationship('type',Type.Type,'specifiers','add',target,inverse)

    def drop_type(self,target,inverse = 1):
        self._4ods_dropRelationship('type','specifiers','remove',target,inverse)

    def _4ods_getOdmgType(self):
        return self.type._4ods_getOdmgType()

    def _4ods_findTypePath(self,object):
        if self.type == object:
            return [object]
        return self.type._4ods_findTypePath(object)
        

    _tupleNames =  (('name',),('type',))

    _tupleDefinitions = {'name':{td.TYPE:Constants.Types.STRING,
                                 },
                         'type':{td.TYPE:Constants.Types.ROBJECT,
                                 td.READONLY:1,
                                 td.RELATIONSHIP:1,
                                 },
                         }
    
    _localExtents = ()
