/* Boolean object interface */

#ifndef BOOLEAN_H
#define BOOLEAN_H
#ifdef __cplusplus
extern "C" {
#endif

#include "Python.h"

typedef struct {
  PyObject_HEAD
  int value;
} PyBooleanObject;

extern PyTypeObject PyBoolean_Type;

#define PyBoolean_Check(op)  ((op)->ob_type == &PyBoolean_Type)
#define PyBoolean_AsLong(op)  (((PyBooleanObject *)(op))->value)

/* Do not use these directly */
extern PyBooleanObject _PyBoolean_FalseStruct;
extern PyBooleanObject _PyBoolean_TrueStruct;

#define PyBoolean_False ((PyObject *) &_PyBoolean_FalseStruct)
#define PyBoolean_True ((PyObject *) &_PyBoolean_TrueStruct)


#define PyBoolean_FROM_LONG(op) ((op) ? PyBoolean_True : PyBoolean_False)
extern PyObject *PyBoolean_FromLong(long);
extern PyObject *PyBoolean_FromObject(PyObject *);

#ifdef __cplusplus
}
#endif
#endif
