import os
import InstallLib

class InstallTests(InstallLib.InstallLib):

    command_name = 'install_tests'

    description = "install tests"

    def finalize_options (self):
        # Found out where the build command put the tests
        build = self.get_finalized_command('build')
        self.build_dir = build.build_tests

        install = self.get_finalized_command('install')
        self.install_dir = os.path.join(install.install_tests, 'tests')

        InstallLib.InstallLib.finalize_options(self)
        return

    def build(self):
        if not self.skip_build:
            self.run_command('build_tests')
        return

    def install(self):
        if os.path.isdir(self.build_dir):
            self.mkpath(self.install_dir)
            outfiles = self._copy_outputs(self.distribution.has_tests(),
                                          'build_tests', 'build_dir')
        else:
            outfiles = []
        return outfiles

    def get_inputs(self):
        build_tests = self.get_finalized_command('build_tests')
        return build_tests.get_outputs()

    def get_outputs(self):
        outputs = self._mutate_outputs(1, 'build_tests', 'build_dir',
                                       self.install_dir)
        if self.compile:
            py_outputs = filter(lambda f: f.endswith('.py'), outputs)
            bytecode_outputs = self._bytecode_filenames(py_outputs)
            for output in bytecode_outputs:
                if output not in outputs:
                    outputs.append(output)
        return outputs
