from Xslt import test_harness

sheet_1 = """<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="html">
  <xsl:copy-of select="."/>
</xsl:template>
<xsl:template match="*">
  <xsl:apply-templates select="*"/>
</xsl:template>
</xsl:stylesheet>
"""

source_1 = "<foo>Embedded <html><a href='link'>go</a>.</html></foo>"


expected_1 = """<html>
  <a href='link'>go</a>.</html>"""


sheet_2 = """<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="/">
  <xsl:copy-of select="document('Xslt/Core/svgeg.svg')"/>
</xsl:template>

</xsl:stylesheet>
"""

source_2 = "<dummy/>"


expected_2 = """<?xml version='1.0' encoding='UTF-8'?>
<svg height='10cm' width='10cm' viewBox='0 0 800 800'>
  <desc>SVG Sample for SunWorld Article</desc>

  <style type='text/css'>
    .Lagos { fill: white; stroke: green; stroke-width: 30 }
    .ViaAppia { fill: none; stroke: black; stroke-width: 10 }
    .OrthoLogos { font-size: 32; font-family: helvetica }
  </style>

  <ellipse transform='translate(500 200)' ry='100' rx='250' style='fill: brown; stroke: yellow; stroke-width: 10'/>

  <polygon points='350,75 379,161 469,161 397,215 423,301 350,250 277,                    301 303,215 231,161 321,161' transform='translate(100 200) rotate(45)' class='Lagos'/>

  <text class='OrthoLogos' x='400' y='400'>TO KALON</text>

  <path class='ViaAppia' d='M500,600 C500,500 650,500 650,600                             S800,700 800,600'/>
</svg>"""


def Test(tester):

    tester.startGroup("Test 1")

    source = test_harness.FileInfo(string=source_1)
    sty = test_harness.FileInfo(string=sheet_1)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_1,
                                    )

    xtest.test(tester)
    tester.groupDone()


    tester.startGroup("Test 2")
    source = test_harness.FileInfo(string=source_2)
    sty = test_harness.FileInfo(string=sheet_2)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_2,
                                    )

    xtest.test(tester)
    tester.groupDone()
    return
