from Ft.Rdf.Drivers import Memory
from Ft.Rdf import Model
import cStringIO
def CreateInfEng():
    from Ft.Rdf.Inference import InferenceEngine
    db = Memory.DbAdapter('kb')
    db.begin()
    kb = Model.Model(db)
    return InferenceEngine.InferenceEngine(kb)

def Test(test):
    test.startGroup('Inference Predicates')
    
    test.startTest('Syntax')
    if 1:
    #try:
        from Ft.Rdf.Inference import InferenceEngine
        from Ft.Rdf.Parsers.Ril import RilParserImp
    #except:
    #    test.error('Error in syntax', 1)
    test.testDone()


    exp = """<?xml version = "1.0"?>
<ril:expression xmlns:ril = "http://namespaces.rdfinference.org/ril" xmlns:ft = "http://namespaces.fourthought.com/test">
  <ril:message>
    <ril:string>Test Message</ril:string>
  </ril:message>
  <ril:fire/>
  <ril:stop/>
</ril:expression>
"""
    test.startTest('Parsed Commands')

    infeng = CreateInfEng()
    st = cStringIO.StringIO()
    infeng.outStream = st

    p = RilParserImp.RilParserImp()
    defs = p.parse(exp)

    results = infeng.execute(defs)

    test.testResults([],results)

    test.testDone()
    test.groupDone()
    

if __name__ == '__main__':
    import sys
    from Ft.Lib import TestSuite

    testmgr = TestSuite.TestSuite()
    ret_val = Test(testmgr)
    sys.exit(ret_val)

