import os
DBNAME=os.environ.get("ODS_TEST_DB","ods:test")


from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods.StorageManager import Adapters
from Ft.Ods.Collections import CollectionBase

class DummyCollection(CollectionBase.CollectionBase):

    _collectionType = Constants.CollectionTypes.SET

    def __init__(self,db,cid,subType,subTypeRepoId,values):
        self.changes = []
        CollectionBase.CollectionBase.__init__(self,db,cid,subType,subTypeRepoId,values)

    def _4ods_prepareValue(self,value):
        return value

    def _4ods_unprepareValue(self,value):
        return value

    def _4ods_getOdsType(self):
        return Constants.Types.SET_COLLECTION

def Test(tester):

    tester.startGroup("Collection Base %s Driver" % tester.test_data['driver'])

    #Can't have a full DB here
    tester.startTest("Init DB")
    manager = Adapters.GetManager()
    adapter = Adapters.GetAdapter()
    if manager.exists(DBNAME):
        manager.reinit(DBNAME,adapter)
    else:
        manager.create(DBNAME)
        manager.init(DBNAME)

    tester.testDone()
    

    #Test the low level Collection Base
    from Ft.Ods import Database
    db = Database.Database()
    db.open(DBNAME)

    try:
        tester.startTest("Creation")
        tx = db.new()
        tx.begin()

        c = DummyCollection(db,None,Constants.Types.STRING,-1,{0:'1',1:'2',2:'3'})
        c2 = DummyCollection(db,None,Constants.Types.STRING,-1,{0:'1',1:'2',2:'3'})
        c3 = DummyCollection(db,None,Constants.Types.STRING,-1,None)


        tester.testDone()

        tester.startTest('__cmp__')

        tester.testResults(1,c == ['1','2','3'],done=0,msg='cmp1')
        tester.testResults(0,c == ['1','2'],done=0,msg='cmp2')
        tester.testResults(0,c == c2,done=0,msg='cmp3')
        tester.testResults(0,c == c3,done=0,msg='cmp4')

        tester.testDone()





        tester.startTest("__len__")
        tester.testResults(3,len(c),done=0,msg='len1')
        tester.testDone()

        tester.startTest("__getitem__")
        tester.compare('1',c[0])
        tester.compare('3',c[-1])
        tester.testDone()


        tester.startTest('__getslice__')

        tester.testResults(['1'],c[:1],done=0,msg='getslice1')
        tester.testResults(['1','2'],c[:-1],done=0,msg='getslice2')
        tester.testResults(['2','3'],c[-2:],done=0,msg='getslice3')
        tester.testResults(['2'],c[1:-1],done=0,msg='getslice4')

        tester.testDone()


        tester.startTest("cardinality")
        tester.testResults(3,c.cardinality(),done=0,msg='cardinality1')
        tester.testDone()

        tester.startTest("is_empty")
        tester.testResults(0,c.is_empty(),done=0,msg='is_empty1')
        tester.testResults(1,c3.is_empty(),done=0,msg='is_empty2')
        tester.testDone()


        tester.startTest("contains_element")
        tester.testResults(1,c.contains_element('1'),done=0,msg='contains_element1')
        tester.testResults(0,c.contains_element('7'),done=0,msg='contains_element2')
        tester.testDone()

        tester.startTest("insert_element")
        c.insert_element('c')
        tester.testResults(1,c.contains_element('c'),done=0,msg='insert_element1')
        tester.testDone()

        tester.startTest("remove_element")
        c.remove_element('c')
        tester.testResults(0,c.contains_element('c'),done=0,msg='remove_element1')
        tester.testDone()

        tester.startTest("copy")

        c4 = c.copy(deep=0)
        c5 = c.copy(deep=1)


        tester.testResults(0,len(c4),done=0,msg='copy1')
        tester.testResults(1,c5.value == c.value,done=0,msg='copy2')
        tester.testDone()


        tx.abort()
        tester.groupDone()
    finally:
        db.close()
    return

