import os

#
#Note: While testing it might be useful to use
#
#export TRACEOUT=4ODS:4Suite.PgDatabase
#export TRACEOUT_FLAGS=LABEL
#
#Requires the database to be set up with the schema from varsity1.odl or varsity2.odl
#
#Typical test process:
#
#python ../Tools/4odb_destroy.py test
#python ../Tools/4odb_create.py test
#python basic_test1.py
#


from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods.Exception import FtodsObjectNotFound

odl_string = '''
module Test {
class Professor;

class Student {
  attribute Professor spitBallTarget;
};


class Professor {

  attribute short points;
};

};

'''
#'
DBNAME=os.environ.get("ODS_TEST_DB","ods:test")

import sys, test_util
from Ft.Ods import Database
from Ft.Ods.StorageManager.Adapters import Constants

def Test(tester):
    try:
        _Test(tester)
    finally:
        if os.path.exists('Test'):
            from distutils import dir_util
            dir_util.remove_tree('Test')
        pass
def _Test(tester):

    
    tester.startGroup("Object Attributes %s Driver" % tester.ods_driver_name)

    test_util.DbInit(DBNAME,odl_string)

    tester.startTest('Testing Generated syntax')
    try:
        from Test import Professor,Student
        reload(Professor)
        reload(Student)
    except:
        tester.error('Error in syntax', 1)


    tester.testDone()


    db = Database.Database()
    db.open(DBNAME)


    tester.startTest("Creation and setting")
    tx = db.new()
    tx.begin()

    p = Professor.new(db)
    s = Student.new(db)


    s.spitBallTarget = p
    tester.testResults(p,s.spitBallTarget,done=0,msg="Attribute not set")

    if db.lookup("student"):
        db.unbind("student")

    db.bind(s,"student")

    tx.commit()

    tester.testDone()

    pid = p._4ods_getOid()

    tx = db.new()
    tx.begin()

    p = db._4ods_getPersistentObjectById(Constants.Types.POBJECT,pid)
    s = db.lookup("student")

    sid = s._4ods_getOid()

    tester.startTest("attribute after read")
    tester.testResults(p,s.spitBallTarget,done=0,msg="Attribute not read")

    tester.testDone()

    tester.startTest("Test Delete")
    s.delete()

    tx.commit()

    tx = db.new()
    tx.begin()

    try:
        p = db._4ods_getPersistentObjectById(Constants.Types.POBJECT,pid)
    except FtodsObjectNotFound, e:
        pass
    except:
        tester.error("Wrong Exception raised",1)
    else:
        tester.error("Exception not raised",0)

    try:
        s = db._4ods_getPersistentObjectById(Constants.Types.POBJECT,sid)
    except FtodsObjectNotFound, e:
        pass
    except:
        tester.error("Wrong Exception raised",1)
    else:
        tester.error("Exception not raised",0)

    tester.testDone()
    tester.groupDone()
    tx.abort()
    db.close()

if __name__ == '__main__':

    from Ft.Lib import TestSuite
    tester = TestSuite.TestSuite(1, 1)
    from Ft.Ods.StorageManager import Adapters
    tester.ods_driver_name = Adapters.g_driverName

    retVal = Test(tester)
    sys.exit(retVal)

