########################################################################
#
# File Name:            ValueOfElement.py
#
# Documentation:        http://docs.4suite.org/4XSLT/ValueOfElement.py.html
#
"""
Implementation of the XSLT Spec import stylesheet element.
WWW: http://4suite.org/4XSLT        e-mail: support@4suite.org

Copyright (c) 1999-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

import xml.dom.ext
from xml.xslt import XsltElement, XsltException, Error
from xml.xpath import CoreFunctions, Conversions

class ValueOfElement(XsltElement):
    legalAttrs = ('select', 'disable-output-escaping')

    def __init__(self, doc, uri=xml.xslt.XSL_NAMESPACE, localName='value-of', prefix='xsl', baseUri=''):
        XsltElement.__init__(self, doc, uri, localName, prefix, baseUri)

    def setup(self):
        self._select = self.getAttributeNS('', 'select')
        if not self._select:
            raise XsltException(Error.VALUEOF_MISSING_SELECT)
        self._disable_output_escaping = self.getAttributeNS('', 'disable-output-escaping') == 'yes'
        self._nss = xml.dom.ext.GetAllNs(self)
        self._expr = self.parseExpression(self._select)
        return

    def instantiate(self, context, processor):
        #original = context.processorNss
        original = context.copy()
        context.processorNss = self._nss
        context.currentInstruction = self

        result = self._expr.evaluate(context)
        text = Conversions.StringValue(result)
        if self._disable_output_escaping:
            processor.writers[-1].text(text, escapeOutput=0)
        else:
            processor.writers[-1].text(text)

        #context.processorNss = original
        context.set(original)
        return (context,)

    def __getinitargs__(self):
        return (None, self.namespaceURI, self.localName, self.prefix,
                self.baseUri)

    def __getstate__(self):
         base_state = XsltElement.__getstate__(self)
         new_state = (base_state, self._nss, self._select,
                      self._disable_output_escaping, self._expr)
         return new_state

    def __setstate__(self, state):
        XsltElement.__setstate__(self, state[0])
        self._nss = state[1]
        self._select = state[2]
        self._disable_output_escaping = state[3]
        self._expr = state[4]
        return

