########################################################################
#
# File Name: 		TimeFactory.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/DateFactory.py.html
#
"""
Implements the DateFactory interface.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""
#"
from Ft.Ods import Date,Interval, TimeImp


_default_time_zone = 0



def set_default_time_zone(a_time_zone):
    _default_time_zone = a_time_zone

def default_time_zone():
    return _default_time_zone

def time_zone():
    import time
    return (time.timezone/(-3600))

def from_hmsm(hour,minute,second,millisecond):
    return from_hmsmtz(hour,minute,second,millisecond,default_time_zone(),0)

def from_hmsmtz(hour,minute,second,millisecond,tzhour,tzminute):
    #Map the hour and minute to GMT
    hour = hour - tzhour
    minute = minute - tzminute
    return TimeImp.TimeImp(None,(hour,minute,second,millisecond,tzhour,tzminute))

def current():
    import time
    t = time.gmtime(time.time())
    return from_hmsmtz(t[3],
                       t[4],
                       t[5],
                       0,
                       0,
                       0)

