#include "Python.h"
#include "domlette.h"


char *nodename_from_parts(const char *prefix, const char *localName){
  int prefixSize;
  int localNameSize;
  int totalSize;
  char *nodeName;

  prefixSize = strlen(prefix);
  localNameSize = strlen(localName);
  totalSize = prefixSize ? prefixSize+localNameSize+1 : localNameSize;
  
  if ((nodeName = (char *)malloc((totalSize+1)*sizeof(char))) == NULL) {
    /* Exception: Out of memory */
  }

  if (prefixSize) {
    strcpy(nodeName, prefix);
    nodeName[prefixSize] = ':';
    strcpy(&nodeName[prefixSize+1], localName);
  } else {
    strcpy(nodeName, localName);
  }
  /* caller frees */
  return nodeName;
}



void cleanupTempPyStrings(PyObject **tpsbuffer){
#if !(PY_MAJOR_VERSION == 1 && PY_MINOR_VERSION < 6)
  while (*tpsbuffer){
    Py_XDECREF(*tpsbuffer);
    /* No. Don't get cute and Py_XDECREF(*tpsbuffer++).  Py_XDECREF is a macro */
    tpsbuffer++;
  }
#endif
}



