########################################################################
#
# File Name:            cDomlette.py
#
# Documentation:        http://docs.4suite.org/4Suite/cDomlette.py.html
#
"""
WWW: http://4suite.org/         e-mail: support@4suite.org

Copyright (c) 2000-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""
import os, string
import cDomlettec
import Ft.Lib
from Ft.Lib import ReaderBase
DOM_IMP = Ft.Lib.CDOMLETTE

##ElementType = cDomlettec.ElementType
##DocumentType = cDomlettec.DocumentType
##CommentType = cDomlettec.CommentType
##ProcessingInstructionType = cDomlettec.ProcessingInstructionType
##TextType = cDomlettec.TextType
##CommentType = cDomlettec.CommentType

##cDomletteTypes = [ElementType,
##                  DocumentType,
##                  CommentType,
##                  ProcessingInstructionType,
##                  TextType,
##                  CommentType,
##                  ]


#For the interface
class Node:
    ELEMENT_NODE                = 1
    ATTRIBUTE_NODE              = 2
    TEXT_NODE                   = 3
    CDATA_SECTION_NODE          = 4
    ENTITY_REFERENCE_NODE       = 5
    ENTITY_NODE                 = 6
    PROCESSING_INSTRUCTION_NODE = 7
    COMMENT_NODE                = 8
    DOCUMENT_NODE               = 9
    DOCUMENT_TYPE_NODE          = 10
    DOCUMENT_FRAGMENT_NODE      = 11
    NOTATION_NODE               = 12


implementation = cDomlettec.implementation

class RawExpatReader(ReaderBase.DomletteReader):
    def fromStream(self, stream, baseUri='', ownerDoc=None,
                   stripElements=None):
        try:
            return cDomlettec.parse(
                stream, str(baseUri), stripElements=(stripElements or [])
                )
        except SyntaxError, e:
            fields = string.split(str(e),':')
            if len(fields) < 3:
                raise
            from Ft.Lib import ReaderException
            raise ReaderException(ReaderException.XML_PARSE_ERROR,
                                  int(fields[0]),
                                  int(fields[1]),
                                  string.join(fields[2:]))
            

    def releaseNode(self, node):
        ReleaseNode(node)


def ReleaseNode(node):
    return cDomlettec.ReleaseNode(node)

        
