"""
Nested record array implementation for numarray
===============================================

:Author:   Ivan Vilata i Balaguer
:Contact:  ivilata@carabos.com
:Created:  2007-01-12
:License:  BSD
:Revision: $Id: __init__.py 2426 2007-02-23 12:37:49Z ivilata $

This package provides the `NestedRecArray` and `NestedRecord` classes,
which can be used to handle arrays of nested records in a way which is
compatible with ``numarray.records``.  Several utility functions are
provided for creating nested record arrays.
"""

from tables.nra.nestedrecords import (
    NestedRecArray, NestedRecord, array, fromarrays, fromnumpy )

__all__ = [
    'NestedRecArray', 'NestedRecord',
    'array', 'fromarrays', 'fromnumpy' ]
