;-------------------------------------------------------------------------------
; The GIMP -- an image manipulation program
; Copyright (C) 1995 Spencer Kimball and Peter Mattis
;-------------------------------------------------------------------------------
; pysycache-puzzle.scm : a script for make jigsaw pieces of the drag'n'drop activity
; Copyright (C) 2006 Vincent DEROO (vincent.pysycache@free.fr)
;-------------------------------------------------------------------------------
;
;
; This program is free software; you can redistribute it and/or 
; modify it under the terms of the GNU General Public License 
; as published by the Free Software Foundation; either version 2 
; of the License, or (at your option) any later version. 
; 
; This program is distributed in the hope that it will be useful, 
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
; GNU General Public License for more details. 
; 
; You should have received a copy of the GNU General Public License 
; along with this program; if not, write to the Free Software 
; Foundation, Inc. : 
; 51 Franklin Street, Fifth Floor, Boston, MA02110-1301, USA
;-------------------------------------------------------------------------------



       
;-------------------------------------------------------------------------------
;ouvrir la piece, tout sélectionner le gris, ajouter un calque blanc
;ouvrir le fichier , tout copier et le coller sur le calque blanc
;ancrer
;nonnouveau calque (selection/inverser le masque)
;inverser la selection, copier, coller en tant que nouveau
;-------------------------------------------------------------------------------
(define (script-fu-pysycache-make-piece
	img
	draw
	filepiece
	posx
	filesvg
	)

	(let*	(
			;recuperation de la taille de l'image originale
			(ImgWidth (car (gimp-image-width img)))
			(ImgHeight (car (gimp-image-height img)))

			;copie de l'image
			(MyImg (car (gimp-image-duplicate img)))
			(MyDraw (car (gimp-image-get-active-drawable MyImg)))

			;image transparent
			(MyImgResult (car (gimp-image-new ImgWidth ImgHeight RGB)))
			(MyLayResult (car (gimp-layer-new MyImgResult ImgWidth ImgHeight RGB-IMAGE "ResultLayer" 0 NORMAL-MODE)))
			(MyDrawResult )
			
			;ouverture du fichier de piece
			(ImgPiece (car (gimp-file-load 1 filepiece filepiece)))
			(DrawPiece (car (gimp-image-get-active-drawable ImgPiece)))
			
			(LayPiece )
			(nvodraw )
			(LayPieceNvo )
			(displayResult )
			(LayPieceFinal )
			(drawfinal )
			(lb )
		)

		;image qui recevra le resultat du copier/coller
		(gimp-image-add-layer MyImgResult MyLayResult -1)
		(set! MyDrawResult (car (gimp-image-get-active-drawable MyImgResult)))
		(gimp-drawable-fill MyDrawResult 3)

		;tout selectionner
		(gimp-edit-copy DrawPiece)

		;coller dans la copie de l'image
		(set! LayPiece (car (gimp-edit-paste MyDraw 0) ))

		;nouveau calque
		(gimp-floating-sel-to-layer LayPiece)
			
		;selectionner la couleur gris
		(gimp-fuzzy-select LayPiece posx 1 15 0 FALSE FALSE 0 FALSE)
	
		;inverser la selection
		(gimp-selection-invert MyImg)

		;fusionner vers le bas
		(gimp-image-merge-down MyImg LayPiece 0) 

		;copier
		(set! nvodraw (car (gimp-image-get-active-drawable MyImg)))
		(gimp-edit-copy nvodraw)
 
 		;coller en tant que nouveau		
		(set! LayPieceNvo (car (gimp-edit-paste MyDrawResult 0) ))	
		(gimp-floating-sel-to-layer LayPieceNvo)

		(set! nvodraw3 (car (gimp-image-get-active-drawable MyImgResult)))
		(gimp-edit-copy nvodraw3)

		(set! displayResult (car (gimp-display-new MyImgResult)))
  
		;copier visible
		(set! LayPieceFinal (car (gimp-edit-paste MyDrawResult 0) ))	
		(gimp-floating-sel-to-layer LayPieceFinal)
		(set! drawfinal (car (gimp-image-get-active-drawable MyImgResult)))			
	
		(let*	(
				(selection-bounds (gimp-drawable-mask-bounds drawfinal))
				(select-offset-x  (cadr selection-bounds))
				(select-offset-y  (caddr selection-bounds))
	 			(selection-width  (- (cadr (cddr selection-bounds)) select-offset-x))
				(selection-height (- (caddr (cddr selection-bounds)) select-offset-y))			
				(MyImgFinal )
				(LayPieceFinal2 )
			)

			(set! MyImgFinal (car (gimp-image-new selection-width selection-height RGB)))
			(set! LayPieceFinal2 (car (gimp-layer-new-from-drawable drawfinal MyImgFinal)))	

			(gimp-image-add-layer MyImgFinal LayPieceFinal2 0)		
			(gimp-layer-set-offsets LayPieceFinal2 0 0  )
			(set! displayFinal (car (gimp-display-new MyImgFinal)))
			
			(gimp-file-save RUN-NONINTERACTIVE MyImgFinal drawfinal filesvg filesvg)
		)
	
		(gimp-display-delete displayResult)
		(gimp-image-delete MyImg)
		(gimp-image-delete ImgPiece)
		(gimp-display-delete displayFinal)
	)
)


(define (script-fu-pysycache-jigsaw
	img
	draw
	dirjigsaw
	dirtarget
	prefixfile
	)

	(set! filelist (cadr (file-glob (string-append "" dirjigsaw "/" "*.png") 1)))
	;recuperation de la taille de l'image originale
	(set! MyImgWidth (car (gimp-image-width img)))
	
	
;	si windows
;	(set! filelist (cadr (file-glob (string-append "" dirjigsaw "\\" "*.png") 1)))

	(while filelist
	(let* 	(
       		  (filename (car filelist))
		  		;si unix
	          	(filenamect (car (last (strbreakup (car filelist) "/" ))))
		  		(nomfic  (substring filenamect 0 5 ) )
;		  		;si Windows
;	          	(filenamect (car (last (strbreakup (car filelist) "\\" ))))
				;si windows
				;(filesvg  (string-append dirtarget "\\" prefixfile "-" filenamect  )) 
				;si unix
				(filesvg  (string-append dirtarget "/" prefixfile "-" filenamect  )) 

		)
			
		(if  (substring-equal? "01-01" nomfic 0 5)
			(begin
				(script-fu-pysycache-make-piece img draw filename (- MyImgWidth 1) filesvg)
			)
			(begin
				(script-fu-pysycache-make-piece img draw filename 1 filesvg)
			)
		)
		
	)	
	(set! filelist (cdr filelist))
)
	(gimp-message "Model have been transform in pieces" )


)





;-------------------------------------------------------------------------------
; Register in the Gimp menus
;-------------------------------------------------------------------------------
(script-fu-register "script-fu-pysycache-jigsaw"
		    _"<Image>/Script-Fu/Pysycache/Theme Jigsaw..."
		    "Make jigsaw pieces for the Drag and drop activity "
		    "Vincent DEROO (contact.pysycache@free.fr)"
		    "Vincent DEROO"
		    "16/09/2006 - v 1.0"
		    "RGB GRAY RGBA GRAYA"
			
		    
		    SF-IMAGE "Image" 0
		    SF-DRAWABLE "Drawable" 0

;		    SF-DIRNAME "Jigsaw directory" (string-append "" gimp-directory "/scripts/images/themes-jigsaw/3x3/modele1/")
;		si dans gimp    
		    SF-DIRNAME "Jigsaw directory" (string-append "" gimp-data-dir "/scripts/images/themes-jigsaw/3x3/modele1/")
		    SF-DIRNAME "Target directory" (string-append "" gimp-directory "/scripts/images/themes-jigsaw/")
		    SF-STRING "File prefix" "fondxx-XX"
 
            
            )
