/*
 * Pspell interface header file
 * Copyright 2000 by Kevin Atkinson under the terms of the LGPL
 *
 */

#ifndef PSPELL_WORDLIST__H
#define PSPELL_WORDLIST__H

#include "string_emulation.h"

#ifdef __cplusplus

class PspellWordList {

 public:
  
  virtual const char * encoding() const = 0;

  virtual bool empty() const = 0;
     
  virtual int size() const = 0;
    
  virtual PspellStringEmulation  * elements() const = 0;
  
};

#else

typedef struct PspellWordList        PspellWordList;

#endif

#ifdef __cplusplus
extern "C" {
#endif
  
  const char * pspell_word_list_encoding(const PspellWordList *);
  
  int pspell_word_list_empty(const PspellWordList *);
   
  int pspell_word_list_size(const PspellWordList *);
   
  PspellStringEmulation * pspell_word_list_elements(const PspellWordList *);

#ifdef __cplusplus
}
#endif


#endif
