// Pspell implementation header file.
// Applications that just use the pspell library should not include 
// these files as they are subject to change.
// Pspell Modules MUST include some of the implementation files and
// spell checkers MAY include some of these files.
// If ANY of the implementation files are included you also link with
// libaspell-impl to protect you from changes in these files.

// Copyright 2000 by Kevin Atkinson under the terms of the LGPL

#ifndef PSPELL_GET_DATA__HH
#define PSPELL_GET_DATA__HH

#include <iostream.h>

class PspellString;

class PspellGetLine {
public:
  virtual bool getline(PspellString & str) = 0;
};

bool getdata_pair(PspellGetLine & in, 
		  PspellString & key, 
		  PspellString & data);


class PspellGetLineFromString : public PspellGetLine {
  const char * in_str;
  char         delem;
public:
  PspellGetLineFromString(const char * s, char d = ';') 
    : in_str(s), delem(d) {}
  bool getline(PspellString & str);
};

class PspellGetLineFromStream : public PspellGetLine {
  istream * in;
  char      delem;
public:
  PspellGetLineFromStream(istream * i, char d = '\n') 
    : in(i), delem(d) {}
  bool getline(PspellString & str);
};

#endif
