/*
    EditorTextView.h

    Interface declaration of the EditorTextView class for the
    ProjectManager application.

    Copyright (C) 2005, 2006  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import <AppKit/NSTextView.h>

#import "EditorGuide.h"

@class SourceEditorDocument, NSColor;
@class HKSyntaxHighlighter;

@interface EditorTextView : NSTextView
{
  SourceEditorDocument * editorDocument;
  HKSyntaxHighlighter * highlighter;

  BOOL drawCrosshairs;
  BOOL drawsColumnIndicator;
   // set to YES when the drawing routines are active and we don't want
   // further edits to reinvoke them
  BOOL drawingRecursionProtectionActive;
  NSColor * crosshairColor;

  NSMutableArray * guides;
}

- (void) createSyntaxHighlighterForFileType: (NSString *) fileType;

- (void) insertText: text;

- (void) setDrawsColumnIndicationGuideline: (BOOL) flag;
- (BOOL) drawsColumnIndicationGuideline;

- (NSRect) selectionRect;

- (void) createAndBeginDraggingNewGuide: (BOOL) isHorizontal
                              withStyle: (EditorGuideStyle) style;
- (void) beginDraggingGuide: (EditorGuide *) aGuide;

- (void) setNeedsDisplayInHighlightedCharacters: (BOOL) flag;

@end
