# .......................................................................
#
#   $Id: admin.bashrc,v 1.5 2002/01/01 23:34:26 jaalto Exp $
#
#   These bash functions will help uploading files to Sourceforge project.
#   You need:
#
#	Unix        (Unix)  http://www.fsf.org/directory/bash.html
#		    (Win32) http://www.cygwin.com/
#	Perl 5.4+   (Unix)  http://www.perl.org
#		    (Win32) http://www.ativestate.com
#	t2html.pl   Perl program to convert text -> HTML
#		    http://www.cpan.org/modules/by-authors/id/J/JA/JARIAALTO/
#
#
#   This file is of interest only for the Admin or Co-Developer of
#   project.
#
#	http://sourceforge.net/projects/pm-lib
#	http://pm-lib.sourceforge.net/
#
#   Include this file to your $HOME/.bashrc and make the necessary
#   modifications:
#
#	SF_PM_LIB_USER=<sourceforge-login-name>
#	SF_PM_LIB_USER_NAME="FirstName LastName"
#	SF_PM_LIB_EMAIL=<email address>
#	SF_PM_LIB_ROOT=~/cvs-projects/pm-lib
#	SF_PM_LIB_HTML_TARGET=http://pm-lib.sourceforge.net/
#
#	source ~/sforge/devel/pm-lib/bin/admin.bashrc
#
# .......................................................................

function sfpmlibinit ()
{
    local id="sfpmlibinit"

    local url=http://pm-lib.sourceforge.net/

    SF_PM_LIB_HTML_TARGET=${SF_PM_LIB_HTML_TARGET:-$url}
    SF_PM_LIB_KWD=${SF_PM_LIB_KWD:-"\
procmail, sendmail, programming language, library"}
    SF_PM_LIB_DESC=${SF_PM_LIB_DESC:-"Procmail module library"}
    SF_PM_LIB_TITLE=${SF_PM_LIB_TITLE:-"$SF_PM_LIB_DESC"}
    SF_PM_LIB_ROOT=${SF_PM_LIB_ROOT:-""}


    if [ "$SF_PM_LIB_USER" = "" ]; then
       echo "$id: Identity SF_PM_LIB_USER unknown."
    fi


    if [ "$SF_PM_LIB_USER_NAME" = "" ]; then
       echo "$id: Identity SF_PM_LIB_USER_NAME unknown."
    fi

    if [ "$SF_PM_LIB_EMAIL" = "" ]; then
       echo "$id: Address SF_PM_LIB_EMAIL unknown."
    fi
}



function sfpmlibdate ()
{
    date "+%Y.%m%d"
}

function sfpmlibfilesize ()
{
    #	put line into array ( .. )

    local line
    line=($(ls -l "$1"))

    #	Read 4th element from array
    #	-rw-r--r--    1 root     None         4989 Aug  5 23:37 file

    echo ${line[4]}
}

function sfpmlibscp ()
{

    #	To upload file to project, call from shell prompt
    #
    #	    bash$ sfpmlibscp <FILE>

    local sfuser=$SF_PM_LIB_USER
    local sfproject=p/pm/pm-lib

    if [ "$SF_PM_LIB_USER" = "" ]; then
	echo "sfpmlibscp: identity SF_PM_LIB_USER unknown, can't scp files."
	return
    fi

    scp $* $sfuser@shell.sourceforge.net:/home/groups/$sfproject/htdocs/
}

function sfpmlibhtml ()
{
    local id="sfpmlibhtml"

    #	To generate HTML documentation located in /doc directory, call
    #
    #	    bash$ sfpmlibhtml <FILE.txt>
    #
    #	To generate Frame based documentation
    #
    #	     bash$ sfpmlibhtml <FILE.txt> --html-frame
    #
    #	For simple page, like README.txt
    #
    #	     bash$ sfpmlibhtml <FILE.txt> --as-is


    local input="$1"

    if [ "$input" = "" ]; then
        echo "Usage:   $id FILE [html-options]"
        return
    fi

    if [ ! -f "$input" ]; then
	echo "$id: No file found [$input]"
	return
    fi



    local opt

    if [ "$2" != "" ]; then
	opt="$2"
    fi

    echo "$id: Htmlizing $file $opt $size"

    perl -S t2html.pl                                               \
	  $opt                                                      \
	  --button-top "$SF_PM_LIB_HTML_TARGET"                     \
	  --title  "$SF_PM_LIB_TITLE"                               \
	  --author "$SF_PM_LIB_USER_NAME"                           \
	  --email  "$SF_PM_LIB_EMAIL"                               \
	  --meta-keywords "$SF_PM_LIB_KWD"                          \
	  --meta-description "$SF_PM_LIB_DESC"                      \
	  --name-uniq                                               \
	  --Out                                                     \
	  $input

    if [ -d "../../html/"  ]; then
	mv *.html ../../html/
    elif [ -d "../html/"  ]; then
	mv *.html ../html/
    else
	echo "$id: Can't move generated HTML to ../html/"
    fi


}


function sfpmlibhtmlall ()
{
    local id="sfpmlibhtmlall"

    #	loop all *.txt files and generate HTML
    #	If filesize if bigger than 15K, generate Framed HTML page.

    local dir=$SF_PM_LIB_ROOT/doc/tips

    (
	cd $dir || return
	echo "Source dir:" $(pwd)

	for file in *.txt;
	do
	     local size=$(sfpmdocfilesize $file)

	     if [ $size -gt 15000 ]; then
	       opt=--html-frame
	     fi

	     sfpmdochtml $file $opt

	 done
    )

}



function sfpmlib_release ()
{
    local id="sfpmlib_release"

    local dir=/tmp

    if [ ! -d $dir ]; then
	echo "$id: Can't make release. No directory [$dir]"
	return
    fi

    if [ ! -d "$SF_PM_LIB_ROOT" ]; then
	echo "$id: No SF_PM_LIB_ROOT [$SF_PM_LIB_ROOT]"
	return
    fi


    local opt=-9
    local cmd=gzip
    local ext1=.tar
    local ext2=.gz

    local base=procmail-lib
    local ver=$(sfpmlibdate)
    local tar="$base-$ver$ext1"
    local file="$base-$ver$ext1$ext2"

    if [ -f $dir/$file ]; then
	echo "$id: Removing old archive $dir/$file"
	rm $dir/$file
    fi


    (

	local todir=$base-$ver
        local tmp=$dir/$todir

	if [ -d $tmp ]; then
	    echo "$id: Removing old archive directory $tmp"
	    rm -rf $tmp
	fi

	cp -r $SF_PM_LIB_ROOT $dir/$todir

	cd $dir

	find $todir -type f                     \
	    \( -name "*[#~]*"                   \
	       -o -name ".*[#~]"                \
	       -o -name ".#*"                   \
	       -o -name "*elc"                  \
	       -o -name "*tar"                  \
	       -o -name "*gz"                   \
	       -o -name "*bz2"                  \
	       -o -name .cvsignore              \
	    \) -prune                           \
	    -o -type d \( -name CVS \) -prune   \
	    -o -type f -print                   \
	    | xargs tar cvf $dir/$tar

	echo "$id: Running $cmd $opt $dir/$tar"

	$cmd $opt $dir/$tar

	echo "$id: Made release $dir/$file"
	ls -l $dir/$file
    )
}

dummy=$(sfpmlibinit)			# Run initializer


export SF_PM_LIB_HTML_TARGET
export SF_PM_LIB_KWD
export SF_PM_LIB_DESC
export SF_PM_LIB_TITLE
export SF_PM_LIB_ROOT


# End of file
