#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/time.h>

#include <config.h>
#include <support.h>
#include <xcio.h>

#include "option.h"
#include "console.h"
#include "log.h"
#include "timer.h"
#include "dev/device.h"

#define	TIMER_INTERVAL	1

static struct timer_s *tlHead;

static void
TimerHandler(int sig)
{
    struct timer_s *tp, *tp0;

#ifdef	ONESHOT_SIGNAL
    signal(SIGALRM, TimerHandler);
#endif
    tp = tlHead;
    tp0 = NULL;
    while (tp) {
	if (tp->st_expired) {
	    if (tp0) {
		tp0->next = tp->next;
		tp = tp0;
	    } else tlHead = tp->next;
	} else if (!tp->st_paused) {
	    (*tp->restp) --;
	    if (*tp->restp <= 0 && tp->callback) {
		if (!tp->f_interval) {
		    if (ISLOG(LOG_TIMER))
			Logf(LOG_TIMER, "%s: expire\n", tp->name);
		    tp->st_expired = 1;
		}
		tp->callback(tp->arg);
	    }
	}
	tp0 = tp;
	tp = tp->next;
    }
#define _device_check_	1

#ifdef _device_check_
    if (DevCheck && DevCheck()) {
	CloseDevice();
	PhaseDown();
    }
#endif
    /*    if (DevCheck && DevCheck()) CloseDevice();*/
    if (pppInfo.l_stat & LSTAT_PPP) pppInfo.connect ++;
    ConsoleUpdate(FALSE);
}

void
TimerPause()
{
    struct itimerval it;

    signal(SIGALRM, SIG_IGN);
    it.it_interval.tv_usec = it.it_value.tv_usec = 0;
    it.it_interval.tv_sec = it.it_value.tv_sec = 0;
    setitimer(ITIMER_REAL, &it, NULL);
    if (ISLOG(LOG_TIMER)) Logf(LOG_TIMER, "PAUSE\n");
}

void
TimerStart()
{
    struct itimerval it;

    it.it_interval.tv_usec = it.it_value.tv_usec = 0;
    it.it_interval.tv_sec = it.it_value.tv_sec = TIMER_INTERVAL;
    setitimer(ITIMER_REAL, &it, NULL);
    signal(SIGALRM, TimerHandler);
    if (ISLOG(LOG_TIMER)) Logf(LOG_TIMER, "START\n");
}

void
TimerReset()
{
    TimerPause();
    tlHead = NULL;
    if (ISLOG(LOG_TIMER)) Logf(LOG_TIMER, "STOP\n");
}

struct timer_s *
TimerAdd(struct timer_s *tp)
{
    int running;
    struct timer_s *t;

    t = tlHead;
    while (t) {
	if (tp == t) {
	    if (ISLOG(LOG_TIMER))
		Logf(LOG_TIMER, "%s: restart\n", tp->name);
	    t->st_expired = 0;
	    return(t);
	}
	t = t->next;
    }
    if (!tp->restp) tp->restp = &tp->rest;
    running = tlHead ? 1: 0;
    tp->st_expired = 0;
    tp->next = tlHead;
    tlHead = tp;
    if (!running) TimerStart();
    if (ISLOG(LOG_TIMER)) Logf(LOG_TIMER, "%s: install\n", tp->name);
    return(tp);
}
