#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <stdarg.h>
#include <syslog.h>
#include <time.h>
#include <errno.h>
#include <pwd.h>
#include <grp.h>
#include <sys/wait.h>
#include <signal.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <version.h>
#include <config.h>
#include <support.h>
#include <xcio.h>

#include <sysmsg.h>

#include "option.h"
#include "frame.h"
/*#include "command.h"*/
#include "log.h"
#include "env.h"
#include "auth.h"
#include "console.h"
#include "dev/device.h"

#define	LS_UNLIMITED	(u_int32_t)-1

static char toStr[BUFSIZ];
static struct console_s *conHead, *conCur;

static char *udsPath;
static int bindFd=-1;
static FILE *logFp;
static uid_t usrId;
static bool_t initUid=FALSE;
static int logPPxP=LOG_LOCAL0;

static struct {
    const char *name;
    int priority;
} logInfo[]={
    {"PHASE", LOG_NOTICE},
    {"FSM", LOG_INFO},
    {"OS", LOG_INFO},
    {"SYS", LOG_INFO},
    {"TIMER", LOG_DEBUG},
    {"AUTH", LOG_INFO},
    {"CHAT", LOG_INFO},
    {"CP", LOG_INFO},
    {"LL8", 0},
    {"LL9", 0},
    {"WARN", LOG_DEBUG},
    {"CONS", LOG_DEBUG},
    {"PRIVATE", LOG_INFO},
    {"SECRET", LOG_INFO},
    {"DUMP", LOG_DEBUG},
    {"FLUSH", 0}
};

char *
TostrX16(void *nbo)
{
    sprintf(toStr, "%#04x", ntohs(*(u_int16_t *)nbo));
    return(toStr);
}

char *
TostrX32(void *nbo)
{
    sprintf(toStr, "%#08lx", ntohl(*(u_int32_t *)nbo));
    return(toStr);
}

char *
TostrD8(void *data)
{
    sprintf(toStr, "%d", *(u_int8_t *)data);
    return(toStr);
}

char *
TostrD16(void *data)
{
    sprintf(toStr, "%d", ntohs(*(u_int16_t *)data));
    return(toStr);
}

int
Logf(int level, char *fmt, ...)
{
    static char logBuf[256], *logBp=logBuf;
    va_list ap;
    int retval;

    va_start(ap, fmt);
    retval = vsprintf(logBp, fmt, ap);
    va_end(ap);
    /*
     * check logBp - logBuf < sizeof(logBuf) !!
     */
    if (strchr(logBp, '\n')) {
	if (logFp) {
	    time_t now;
	    struct tm *tm;
	    char str[50];

	    time(&now);
	    tm = localtime(&now);
	    strftime(str, 50, "%b %d %X", tm);
	    fprintf(logFp, "%s [%d] %-5s: %s", str, getpid(),
		    (level < LOG_MAX) ? logInfo[level].name: "ERROR",
		    logBuf);
	    fflush(logFp);
	} else {
	    syslog((level < LOG_MAX)
		   ? logInfo[level].priority|logPPxP: logPPxP|LOG_ERR,
		   "%-5s: %s",
		   (level < LOG_MAX) ? logInfo[level].name: "ERROR",
		   logBuf);
	}
	logBp = logBuf;
    } else logBp += retval;
    return(retval);
}

int
LogError(char *mesg)
{
    int ret, errno_bak=errno;

    ret = Logf(LOG_ERROR, "%s: %s\n", mesg, strerror(errno_bak));
    errno = errno_bak;
    return(ret);
}

int
SwitchUser(uid_t uid)
{
    int r;

    if (uid) seteuid(0);
    if ((r = seteuid(uid)) != 0) {
	char buf[sizeof("euid(65535)")];

	sprintf(buf, "euid(%d)", uid);
	LogError(buf);
    }
    return(r);
}

bool_t
SuperPrivilege(int new)
{
    static bool_t super;
    bool_t old;

    old = super;
    if (new == TRUE || new == FALSE) {
	super = new;
	SwitchUser(super ? 0: usrId);
/*	setreuid(usrId, super ? 0: usrId);*/
    }
    return(old);
}

void
PathsInit()
{
    if (!initUid) usrId = getuid();
    DirNameInit(usrId);
}

/*
 * External Console
 */

static void
XcClose(int fd)
{
    if (fd < 0) return;
    if (ISLOG(LOG_OS))
	Logf(LOG_OS, "Detach console/terminal(%d)\n", fd);
    Close(fd);
}

int
XcWrite(struct console_s *cp, char *buf, int len)
{
    struct xcio_s xc;

    xc.len = len;
    xc.type = XCIO_S_OUT;
    xc.xid = cp->xid;
    memcpy(xc.buf, buf, len);
    return(XcioWrite(cp->fd, &xc));
}

static int
XcRunBuiltInCommand(u_int8_t type, u_int8_t xid, int argc, char *argv[])
{
    struct xcio_s xc;
    int i;
    extern char *ExtractEnvs();

    xc.type = XCIO_RETURN;
    xc.len = 1;
    for (i = 1; i < argc; i ++) {
	if (strstr(argv[i], "$(")) {
	    char *ext;

	    ext = ExtractEnvs(argv[i], 0);
	    Free(argv[i]);
	    argv[i] = Strdup((ext && *ext) ? ext: "");
	}
    }
    xc.buf[0] = (char)RunBuiltInCommand(type, argc, argv, 0);
    xc.xid = xid;
    return(conCur ? XcioWrite(conCur->fd, &xc):0);
}

void
XcUpdate(int fd)
{
    static struct xcio_s xc={
	XCIO_UP_INFO,
	XID_UPDATE,
	sizeof(pppInfo),
    };
    memcpy(xc.buf, &pppInfo, sizeof(pppInfo));
    XcioWrite(fd, &xc);
}

static int
XcTtyIn(char *buf, int len)
{
    extern int devFd;

    DevWrite(devFd, buf, len, 0);
    return(0);
}

static int
XcTtyOut(char *buf, int len)
{
    write(0, buf, len);
    write(0, "\n", 1);
    return(0);
}

void
UnregisterConsole(int fd)
{
    struct console_s *cp, *cp0;

    cp = conHead;
    cp0 = NULL;
    while (cp) {
	if (cp->fd == fd) {
	    if (cp0) cp0->cs_next = cp->cs_next;
	    else conHead = cp->cs_next;
/*	    conCur = (cp->cs_next) ? cp->cs_next: conHead;*/
	    RemoveSelectFdp(&cp->fd);
	    XcioClose(cp->fd);
	    Free(cp->name);
	    Free(cp);
	    break;
	}
	cp0 = cp;
	cp = cp->cs_next;
    }
}

int
XcBye(int argc, char *argv[])
{
    XcClose(conCur->fd);
    UnregisterConsole(conCur->fd);

    return(0);
}

static void
ShowConsole(struct console_s *ccp)
{
    struct console_s *cp;
    struct xcio_s xc;

    cp = conHead;
    xc.type = XCIO_CONSOLES;
    xc.xid = ccp->xid;

    while (cp) {
	xc.len = 0;

	strcpy(xc.buf + xc.len, cp->name);
	xc.len += strlen(cp->name) + 1;

	strcpy(xc.buf + xc.len, cp->from);
	xc.len += strlen(cp->from) + 1;

	xc.buf[xc.len ++] = (cp->f_auto ? CONSOLE_AUTOF: 0)
		| (cp == ccp ? CONSOLE_CURRENT: 0);

	memcpy(xc.buf + xc.len, &cp->fd, sizeof(cp->fd));
	xc.len += sizeof(cp->fd);

	cp = cp->cs_next;
	if (!cp) xc.type |= XCIO_LAST;
	XcioWrite(ccp->fd, &xc);
    }
}

int
XcRead(struct console_s *cp)
{
    int n, argc=0;
    struct xcio_s xc;
    char *argv[128];

    n = XcioRead(cp->fd, &xc);
    if (n > 0) {
	cp->xid = xc.xid;
	switch (xc.type) {
	case XCIO_S_OUT:
	    XcTtyOut(xc.buf, xc.len);
	    break;
	case XCIO_S_IN:
	    XcTtyIn(xc.buf, xc.len);
	    break;
	case XCIO_UP_INFO:
	    XcUpdate(cp->fd);
	    break;
	case XCIO_UP_AUTO:
	    cp->f_auto = xc.buf[0] ? TRUE: FALSE;
	    break;
	case XCIO_CONSOLES:
	    ShowConsole(cp);
	    break;
	case XCIO_PWD_SET:
	    argc = DecodeArgs(argv, xc.buf, xc.len, 128);
	    switch(argc) {
	    case 0:
		XcPasswdGet(cp);
		break;
	    case 1:
		/* not implemented, yet */
		UpdatePasswd(argv[2], NULL, NULL);
		break;
	    case 3:
		UpdatePasswd(argv[2], argv[0], argv[1]);
		break;	/* huum */
	    case 2:
		if (strlen(argv[0])) {
		    SetPasswd(NULL, Strdup(argv[0]),
			      Strdup(argv[1]), 0);
		}
		break;
	    }
	    break;
	case XCIO_PWD_REQ:
	    argc = DecodeArgs(argv, xc.buf, xc.len, 128);
	    ShowPasswd(cp, argc > 0 ? argv[0]: NULL);
	    break;
	case XCIO_ENV_REQ:
	    argc = DecodeArgs(argv, xc.buf, xc.len, 128);
/*{int a;for(a=0;a<argc;a++)printf("<%s>",argv[a]);printf("%d\n",argc);}*/
	    EnvsGet(cp, argc, argv);
	    break;
	case XCIO_ENV_SET:
	    break;
	case XCIO_XCMD:
	    argv[0] = NULL;
	    argc = 1;
	    if ((-- xc.len) > 0)
		argc += DecodeArgs(&argv[1], &xc.buf[1], xc.len, 128);
	    XcRunBuiltInCommand(xc.buf[0], xc.xid, argc, argv);
	    break;
	case XCIO_LISTUP:
	    ListupEnv(cp);
	    ListupCommand(cp);
	    break;
	case XCIO_ACTIVATE:
	    if (pppInfo.l_stat == LSTAT_TTY) {
		LcpMode(RUN_ACTIVE);
		FrameStartLayer(NBO_PROTO_LLPMASK);
	    }
	    break;
	}
	if (argc > 0) FreeArgs(argc, argv);
    } else if (n < 0 && errno != EINTR) {
	XcClose(cp->fd);
	UnregisterConsole(cp->fd);
    }
    return(n);
}

int
XcGetpwd(char *entry)
{
    return(0);
}

int
ConsoleMsg(int mno, char *buf)
{
    struct xcio_s xc;

    if (!conCur) return(-1);
    xc.len = 1;
    xc.type = XCIO_MESSAGE;
    xc.xid = conCur->xid;
    xc.buf[0] = (u_int8_t)mno;
    if (buf && *buf) {
	int len = strlen(buf) + 1;

	memcpy(&xc.buf[xc.len], buf, len);
	xc.len += len;
    }
    return(XcioWrite(conCur->fd, &xc));
}

int
ConsoleOutf(char *fmt, ...)
{
    va_list ap;
    int retval=0;
    char *p=NULL;
    static char buf[BUFSIZ], *bp=buf;

    va_start(ap, fmt);
    bp += vsprintf(bp, fmt, ap);
    va_end(ap);
    if ((pppInfo.l_stat & LSTAT_TTY)
	|| (p = strchr(buf, '\n')) != NULL || (bp - buf >= BUFSIZ)) {
	if (bp - buf && conCur)
	    retval = XcWrite(conCur, buf, bp - buf);
	bp = buf;
    }
    return(retval);
}

static bool_t
EnvLog(int argc, char **argv, char *outs)
{
    int l, a, mode=0;

    if (!argc) {
	char *p;

	p = outs;
	for (l = 0; l < LOG_MAX; l ++) {
	    if (!strncmp(logInfo[l].name, "LL", 2)) continue;
	    if (ISLOG(l)) p += SprintF(p, "%s ", logInfo[l].name);
	}
	return FALSE;
    }
    a = 1;
    if (!strcmp(argv[1], "+"))
	mode = 1;
    else if (!strcmp(argv[1], "-"))
	mode = -1;
    else if (!strcasecmp(argv[1], "ALL")) {
	pppOpt.l_level = 0xFFFF;
	return TRUE;
    }
    if (mode) a = 2;
    else pppOpt.l_level = 0;
    for (; a < argc; a ++) {
	for (l = 0; l < LOG_MAX; l ++)
	    if (!strcasecmp(logInfo[l].name, argv[a])) break;
	if (l == LOG_MAX)
	    ConsoleMsg(MS_E_LOG_UNKNOWN, argv[a]);
	else {
	    if (mode == -1) pppOpt.l_level &= ~(1<<l);
	    else pppOpt.l_level |= 1<<l;
	}
    }
    return TRUE;
}

static bool_t
EnvLogFile(int argc, char **argv, char *outs)
{
    FILE *fp;
    int i;
    struct stat st;
    char *opentype="w", *path, *name;
    static char *fullPath;
    static struct {
	const char *name;
	int facility;
    } slogtab[]={
	{"AUTH", LOG_AUTH},
#ifdef	LOG_AUTHPRIV
	{"AUTHPRIV", LOG_AUTHPRIV},
#endif
	{"DAEMON", LOG_DAEMON},
	{"LOCAL0", LOG_LOCAL0},
	{"LOCAL1", LOG_LOCAL1},
	{"LOCAL2", LOG_LOCAL2},
	{"LOCAL3", LOG_LOCAL3},
	{"LOCAL4", LOG_LOCAL4},
	{"LOCAL5", LOG_LOCAL5},
	{"LOCAL6", LOG_LOCAL6},
	{"LOCAL7", LOG_LOCAL7},
	{NULL}
    };

    if (!argc) {
	if (pppOpt.l_file) strcpy(outs, pppOpt.l_file);
	return FALSE;
    }
    if (strchr(argv[1], '/')) return FALSE;
    for (i = 0; slogtab[i].name; i ++) {
	if (!strcasecmp(argv[1], slogtab[i].name)) {
	    logPPxP = slogtab[i].facility;
	    pppOpt.l_file = Strdup(slogtab[i].name);
	    if (logFp) fclose(logFp);
	    logFp = NULL;
	    return FALSE;
	}
    }
/*    ext = ExtractEnvs(argv[1], 0);*/
    if (usrId) {
	path = usrPPxP;
	name = Malloc(strlen(path) + 5 + strlen(argv[1]) + 1);
	sprintf(name, "%s/log/%s", path, argv[1]);
    } else {
	name = Malloc(14 + strlen(argv[1]) + 1);
	sprintf(name, _PATH_LOG_PPXP"/%s", argv[1]);
    }
    if (!stat(name, &st)) {
	if (pppOpt.l_size == LS_UNLIMITED
	    || st.st_size < (long)pppOpt.l_size) opentype="a";
	if (!S_ISREG(st.st_mode)) {
	    Free(name);
	    return FALSE;
	}
    }
    if ((fp = fopen(name, opentype)) == NULL) {
	syslog(logPPxP|LOG_ERR, "%s: %s\n", name, strerror(errno));
	return FALSE;
    } else
	syslog(logPPxP|LOG_NOTICE, "%s: log file\n", name);
    chown(name, getuid(), getgid());
    if (logFp) fclose(logFp);
    logFp = fp;
    if (fullPath) Free(fullPath);
    fullPath = name;
    if (pppOpt.l_file) Free(pppOpt.l_file);
    pppOpt.l_file = Strdup(argv[1]);
    Logf(LOG_OS, "PPxP version "VERSION"\n");
    return TRUE;
}

static bool_t
EnvLogSize(int argc, char **argv, char *outs)
{
    if (!argc) {
	if (pppOpt.l_size == LS_UNLIMITED) strcpy(outs, "unlimited");
	else sprintf(outs, "%d", pppOpt.l_size);
	return FALSE;
    }
    if (!isdigit(*argv[1])) pppOpt.l_size = LS_UNLIMITED;
    else pppOpt.l_size = atoi(argv[1]);
    return TRUE;
}

void
LogSetup(char *name)
{
    static struct env_s envlist[]={
	{"LEVEL", {EnvLog}, ENV_SET, 0, 0, 0666},
	{"SIZE", {EnvLogSize}, ENV_SET, 0, 0, 0666},
	{"FILE", {EnvLogFile}, ENV_SET, 0, 0, 0666},
	{NULL}
    };
    logFp = NULL;
    openlog(name, LOG_PID, logPPxP);
/*    pppOpt.l_size = LS_UNLIMITED;*/
    RegisterEnvs(envlist, "LOG", NULL);
}

int
ConsoleRead(int fd)
{
    struct console_s *cp;
    int ret;

    cp = conHead;
    conCur = cp;
    while (cp) {
	if (cp->fd == fd) {
	    conCur = cp;
	    break;
	}
	cp = cp->cs_next;
    }
    ret = XcRead(conCur);
    return(ret);
}

#if 0
int
ConsoleReadLine(char *buf, int max, bool_t secret)
{
    int n=0;
    char ch=0;

    if (*buf) ConsoleOutf(buf);
    max --;
    while (n < max && read(conCur->fd, &ch, 1)) {
	if (ch == '\n' || ch == '\r') break;
	if (ch < ' ') continue;
	if (!secret) ConsoleOutf("%c", ch);
	buf[n ++] = ch;
	ch = 0;
    }
    buf[n] = '\0';
    ConsoleOutf("\n");
    return(n);
}
#endif

void
ConsoleUpdate(bool_t all)
{
    struct console_s *cp;
    struct xcio_s xc={
	XCIO_UP_INFO,
	XID_UPDATE,
	sizeof(pppInfo),
    };

    cp = conHead;
    memcpy(xc.buf, &pppInfo, sizeof(pppInfo));
    while (cp) {
	if (all || cp->f_auto) XcioWrite(cp->fd, &xc);
	cp = cp->cs_next;
    }
}

static struct console_s *
RegisterConsole(int fd, char *name, char *from)
{
    struct console_s *cp;

    cp = TALLOC(struct console_s);
    cp->cs_next = conHead;
    cp->name = Strdup(name);
    cp->from = Strdup(from);
    conHead = cp;
    cp->fd = fd;
    cp->f_auto = FALSE;
    NewSelectLink("CONSOLE", &cp->fd, ConsoleRead, NULL, FALSE, FALSE);
    return(cp);
}

void
ConsoleCloseAll()
{
    struct console_s *cp;

    cp = conHead;
    while (cp) {
	if (cp->fd >= 0) XcClose(cp->fd ? cp->fd: -1);
	cp = cp->cs_next;
    }
}

static int
BindRead(int fd)
{
    int len, sfd;
    size_t siz;
    struct xcio_s hello;
    struct sockaddr sa;
    struct console_s *cp=NULL;

    siz = sizeof(struct sockaddr);
    memset(&sa, 0, sizeof(struct sockaddr));
    if ((sfd = accept(bindFd, &sa, &siz)) < 0) {
	LogError("BindRead accept");
	return(-1);
    }
    len = read(sfd, &hello, sizeof(hello));
    if (hello.type == XCIO_HELLO) {
	uid_t uid;
	struct passwd *pw;

	memcpy(&uid, &hello.buf[strlen(hello.buf) + 1], sizeof(uid));
	pw = getpwuid(uid);
	if (pw && pw->pw_name) {
	    cp = RegisterConsole(sfd, pw->pw_name, hello.buf);
	    if (cp) {
		XcioOpen(sfd);
		if (!initUid) {
		    usrId = uid;
		    initUid = TRUE;
		    SuperPrivilege(TRUE);
		    initgroups(pw->pw_name, 0);
		    chown(udsPath, uid, getgid());
		    chmod(udsPath, 0700);
		    SuperPrivilege(FALSE);
		    PathsInit();
		}
	    }
	}
    }
    if (cp == NULL) close(sfd);
    else if (ISLOG(LOG_OS))
	Logf(LOG_OS, "Attach console(%s)=%d\n", cp->name, cp->fd);
    return(0);
}

void
BindClose()
{
    if (udsPath) unlink(udsPath);
    if (bindFd < 0) return;
    RemoveSelectFdp(&bindFd);
    Close(bindFd);
    bindFd = -1;
}

void
XcSetup(char *ifname)
{
    struct sockaddr sa;

    /* create UDS */
    memset(&pppInfo, 0, sizeof(struct pppinfo_s));
    pppInfo.minfo = (unsigned)-1;
    if (chdir("/tmp")) {
	LogError("XcSetup chdir");
	exit(-1);
    }
    udsPath = Malloc(sizeof("/tmp/.ppxp-") + strlen(ifname) + 1);
    sprintf(udsPath, "/tmp/.ppxp-%s", ifname);
    sprintf(sa.sa_data, ".ppxp-%s", ifname);
    unlink(udsPath);
    sa.sa_family = AF_UNIX;
    if ((bindFd = socket(AF_UNIX, SOCK_STREAM, 0)) < 0) {
	LogError("XcSetup socket");
	return;
    }
    if (bind(bindFd, &sa, LEN_SA_DATA(sa))) {
	LogError("XcSetup bind");
	Close(bindFd);
	bindFd = -1;
	return;
    }
    listen(bindFd, 1);
/*
    chown(udsPath, getuid(), getgid());
    chmod(udsPath, 0700);
*/
    if (pppOpt.mode == RUN_DIRECT || pppOpt.mode == RUN_GETTY) {
	initUid = TRUE;
	chmod(udsPath, 0700);
    } else chmod(udsPath, 0766);
    NewSelectLink("BIND", &bindFd, BindRead, NULL, FALSE, FALSE);
    return;
}

void
EnvUpdate(bool_t all, const char *buf, int len)
{
    struct console_s *cp;
    struct xcio_s xc={
	XCIO_UP_ENVS,
	XID_UPDATE,
    };

    cp = conHead;
    xc.len = len;
    memcpy(xc.buf, buf, len);

    while (cp) {
	if (all || cp->f_auto) XcioWrite(cp->fd, &xc);
	cp = cp->cs_next;
    }
}
