#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <pwd.h>
#include <syslog.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <signal.h>

#include <config.h>
#include <support.h>
#include <xcio.h>

#ifndef	LOG_PPXP
#define	LOG_PPXP	LOG_LOCAL0
#endif

static char *
CallIdent(struct sockaddr_in *sap)
{
    struct servent *sp;
    FILE *ofp, *ifp;
    char *p, buf[80];
    int sd, len;
    unsigned short pport, mport;

    pport = ntohs(sap->sin_port);
    sap->sin_family = AF_INET;
    sap->sin_port = (sp = getservbyname("ident", "tcp")) != NULL ?
	sp->s_port: htons(113);
    len = sizeof(*sap);
    if ((sd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
	syslog(LOG_PPXP|LOG_ERR, "can not open socket");
	return(NULL);
    }
    if (connect(sd, (struct sockaddr *)sap, len) < 0) {
	syslog(LOG_PPXP|LOG_ERR, "can not connect to identd");
	return(NULL);
    }
    if (getsockname(0, (struct sockaddr *)sap, &len) < 0) {
	syslog(LOG_PPXP|LOG_ERR, "can not get socket");
	return(NULL);
    }
    mport = ntohs(sap->sin_port);
    ifp = fdopen(sd, "r");
    ofp = fdopen(sd, "w");
    fprintf(ofp, "%d , %d\n", pport, mport);
    fflush(ofp);
    shutdown(sd, 1);
    fgets(buf, sizeof(buf), ifp);
    fclose(ofp);
    fclose(ifp);
    close(sd);
    if ((p = strpbrk(buf, "\r\n")) != NULL) *p = '\0';
    if ((p = strrchr(buf, ':')) != NULL) *p ++;
    while (*p && *p == ' ') p ++;
    return(Strdup(p));
}

char *
CheckRemote()
{
    int sd;
    size_t len;
    unsigned i;
    struct sockaddr_in sa;
    struct hostent *hp;
    unsigned int laddr, raddr;
    struct passwd *pwp;
    FILE *fp;
    uid_t uid;
    char buf[80], addr[16], luser[40], *ruser, *p;

    len = sizeof(sa);
    memset(&sa, 0, len);
    if (getpeername(0, (struct sockaddr *)&sa, &len) < 0) {
	syslog(LOG_PPXP|LOG_ERR, "can not get peer");
	return(NULL);
    }
    raddr = sa.sin_addr.s_addr;

    uid = getuid();
    if (uid) {
	if ((pwp = getpwuid(uid)) == NULL) {
	    syslog(LOG_PPXP|LOG_ERR, "unknown user(%d)", uid);
	    return(NULL);
	}
	ruser = Strdup(pwp->pw_name);
    } else {
	ruser = CallIdent(&sa);
	if ((pwp = getpwnam(ruser)) == NULL) {
	    syslog(LOG_PPXP|LOG_ERR, "unknown user(%s)", ruser);
	    return(NULL);
	}
    }
    if ((fp = fopen(RUSERS, "r")) == NULL) {
	syslog(LOG_PPXP|LOG_ERR, "can not open %s", RUSERS);
	return(NULL);
    }
    laddr = INADDR_NONE;
    while (fgets(buf, sizeof(buf), fp)) {
	luser[0] = '\0';
	sscanf(buf, "%s %s", addr, luser);
	if (((laddr = inet_addr(addr)) == INADDR_NONE)) {
	    if ((hp = gethostbyname(addr)) == NULL) continue;
	    for (i = 0; i < hp->h_length/sizeof(laddr); i ++) {
		laddr = *(unsigned int *)hp->h_addr_list[i];
		if (laddr == raddr) break;
	    }
	}
	if (laddr == raddr
	    && (!luser[0] || !strcmp(ruser, luser))) break;
    }
    if (laddr == raddr) {
	struct passwd *pw;
	char *user;

	user = (luser[0]) ? luser: ruser;
	if ((pw = getpwnam(user)) == NULL) {
	    syslog(LOG_PPXP|LOG_ERR, "%s: unknown user", user);
	    return(NULL);
	}
	setgid(pw->pw_gid);
	setuid(pw->pw_uid);
	sprintf(buf, "%s@%s", ruser, addr);
	syslog(LOG_PPXP|LOG_INFO, "connect from %s", buf);
	free(ruser);
	return(strdup(buf));
    }
    syslog(LOG_PPXP|LOG_ERR, "permission denied");
    return(NULL);
}

static void
PPxPBridge(int fd)
{
    int maxfd, n;
    fd_set rfds, orfds;
    char buf[BUFSIZ];

    FD_ZERO(&orfds);
    FD_SET(0, &orfds);
    FD_SET(fd, &orfds);
    maxfd = fd + 1;
    while (1) {
	rfds = orfds;
	n = select(maxfd, &rfds, NULL, NULL, NULL);
	if (n <= 0 && errno == EINTR) continue;
	if (FD_ISSET(fd, &rfds)) {
	    n = read(fd, buf, sizeof(buf));
	    if (n > 0) write(0, buf, n);
	    else if (errno != EINTR) exit(0);
	}
	if (FD_ISSET(0, &rfds)) {
	    n = read(0, buf, sizeof(buf));
	    if (n > 0) write(fd, buf, n);
	    else if (errno != EINTR) exit(0);
	}
    }
}

int
main(int argc, char *argv[])
{
    int ifnum, fd, n;
    struct xcio_s hello;
    char *name, *rname;
    uid_t uid;
    int httpMode=0;

    openlog(argv[0], LOG_PID, LOG_PPXP);
    if (isatty(0)) rname = "debugger";
    else if ((rname = CheckRemote()) == NULL) exit(-1);
    DirNameInit(getuid());
    n = read(0, &hello.type, sizeof(hello.type));

    if (hello.type != XCIO_HELLO) {
	SysMsgInit();
	ifnum = 0;
	httpMode = 1;
	sprintf(hello.buf, "http (%s)", rname);
	HttpdMain(rname, hello.type);
    } else {
	n = read(0, &hello + sizeof(hello.type),
		 sizeof(hello) - sizeof(hello.type));
	ifnum = hello.buf[hello.len];
	name = strdup(hello.buf);
	sprintf(hello.buf, "%s (%s)", name, rname);
	free(name);

	if ((fd = PPxPLocalOpen(&ifnum)) < 0) exit(-1);
	hello.len = strlen(hello.buf) + 1;
	uid = getuid();
	memcpy(hello.buf + hello.len, &uid, sizeof(uid));
	hello.len += sizeof(uid);

	write(fd, &hello, sizeof(hello));
	PPxPBridge(fd);
    }
    return(0);
}
