#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/select.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/sockio.h>
#include <unistd.h>
#include <netinet/in.h>
#include <net/if.h>
#ifndef	if_mtu
#include <net/if_var.h>
#endif
#include <net/if_tun.h>

#include <config.h>
#include <support.h>
#include <xcio.h>

#include <env.h>
#include <dev/device.h>
#include <frame.h>

#define	IFBUFSIZ	4096

static char ifBuf[IFBUFSIZ];
static int ifFd=-1;
int sockFd=-1;

int
SysIfOpen(char *ifname, int *ifnp)
{
    int n;
    char name[IFNAMSIZ+5];

    sockFd = socket(AF_INET, SOCK_DGRAM, 0);
    for (n = 0; n < 10; n ++) {
	sprintf(name, "/dev/tun%1d", n);
	ifFd = open(name, O_RDWR);
	if (ifFd >= 0) {
	    sprintf(ifname, "tun%d", n);
	    *ifnp = n;
	    /* NON-BLOCK mode */
	    n = 1;
	    ioctl(ifFd, FIONBIO, &n);
	    return(ifFd);
	}
    }
    return(-1);
}

void
SysIfClose()
{
    if (ifFd >= 0) close(ifFd);
    if (sockFd >= 0) close(sockFd);
    ifFd = sockFd = -1;
}

#ifdef	TUNSIFINFO
int
SysIfSetMtu(short mtu)
{
    struct tuninfo tun;

    tun.type = 23;
    tun.mtu = mtu;
    tun.baudrate = GetSpeed();
    return(ioctl(ifFd, TUNSIFINFO, &tun));
}
#endif

int
SysIfWrite(u_char *buf, int len, long hbo_proto)
{
#ifdef	IFHEAD_T
    IFHEAD_T *hp;

    buf -= sizeof(IFHEAD_T);
    len += sizeof(IFHEAD_T);
    hp = (IFHEAD_T *)buf;
    hp->tun_af = AF_INET;
#endif
    return(write(ifFd, buf, len));
}

int
SysIfRead(int fd, char **bp, u_int16_t *proto)
{
    int n;

    if ((n = read(fd, ifBuf, IFBUFSIZ)) > 0) {
#ifdef	IFHEAD_T
	n -= sizeof(IFHEAD_T);
	*bp = &ifBuf[sizeof(IFHEAD_T)];
	*proto = NBO_PROTO_IP;
#else
	*bp = ifBuf;
	*proto = NBO_PROTO_IP;
#endif
    }
    return(n);
}
