/* SPARC floating point unit related functions.
   Copyright (C) 2001-2006 Roberto Bagnara <bagnara@cs.unipr.it>

This file is part of the Parma Polyhedra Library (PPL).

The PPL is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

The PPL is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02111-1307, USA.

For the most up-to-date information see the Parma Polyhedra Library
site: http://www.cs.unipr.it/ppl/ . */

#ifdef HAVE_IEEEFP_H
#include <ieeefp.h>

#define FPU_TONEAREST ((int) FP_RN)
#define FPU_UPWARD ((int) FP_RP)
#define FPU_DOWNWARD ((int) FP_RM)
#define FPU_TOWARDZERO ((int) FP_RZ)

namespace Parma_Polyhedra_Library {

inline fpu_rounding_direction_type
fpu_get_rounding_direction() {
  return fpgetround();
}

inline void
fpu_set_rounding_direction(fpu_rounding_direction_type dir) {
  fpsetround((fp_rnd) dir);
}

inline fpu_rounding_control_word_type
fpu_save_rounding_direction(fpu_rounding_direction_type dir) {
  return fpsetround((fp_rnd) dir);
}

inline void
fpu_reset_inexact() {
  fp_except except = fpgetmask();
  except &= ~FP_X_IMP;
  fpsetmask(except);
}

inline fpu_rounding_control_word_type
fpu_save_rounding_direction_reset_inexact(fpu_rounding_direction_type dir) {
  fpu_reset_inexact();
  return fpu_save_rounding_direction((fp_rnd) dir);
}

inline void
fpu_restore_rounding_direction(fpu_rounding_control_word_type w) {
  fpsetround((fp_rnd) w);
}

inline int
fpu_check_inexact() {
  return (fpgetmask() & FP_X_IMP) ? 1 : 0;
}

} // namespace Parma_Polyhedra_Library

#endif // !defined(HAVE_IEEEFP_H)
