/*
Codecs.h
*/

#ifndef __CODECS_H
#define __CODECS_H

#include <stdio.h>
#include <string.h>

#include "c-client.h"
#include "Utils.h"
#include "XString.h"
#include "XVector.h"

/* NOP is the "encoded" value for non-significant characters */
#define NOP  255
/* EQUAL is the "encode" value for the equal sign */
#define EQUAL 64
/* LINE is the number of encoded byte quadruplets printed per line */
#define LINE  19

/* Possible return values */
#define ERROR_NONE       0
#define ERROR_ARGS       1
#define ERROR_EQUAL      2
#define ERROR_INCOMPLETE 3

/* 76th position only used by continuation = */
#define MAXLONGLINEAQUOTEDPRINTABLE 75

int EncodeBase64Buffer (TBuffer abufin, int sz_abufin, TBuffer abufout, int *sz_abufout);
int EncodeBase64 (FILE *FR, int size);
int EncodeBase64File (FILE *FR, FILE *FW, int size);
int DecodeBase64 (FILE *FR, int size);
int DecodeBase64Buffer (TBuffer abufin, int sz_abufin, TBuffer abufout, int *sz_abufout);
int DecodeQuotedPrintable (FILE *FR, int size);
bool IsQuotedPrintable (char *texto);
char *ToQuotedPrintableFile (char *texto);
xuchar *ToQuotedPrintableString (xuchar *src, xulong srcl, xulong *len);
bool IsThereASCII8bitsInHeaders (xuchar *lin);
char *DecodificaHeader (char *header);
xuchar *CodificaHeaderQuotedP_AllInOne (xuchar *header);
xuchar *CodificaHeaderQuotedP_One2One (xuchar *header);
bool IsUuencodedPChar (const char *pc);
const char *getUuencodedFileName (const char *beginline, TBuffer TrueName);
bool UudecodeFiles (const char *fnin, const char *forced_outname, TBuffer TrueName, int numatt);
void Encrypt1 (char *password, TBuffer buffer2encrypt, int len_buffer2encrypt, TBuffer bufferencrypted, int *lenbufferencrypted);
void Decrypt1 (char *password, TBuffer buffer2decrypt, int len_buffer2decrypt, TBuffer bufferdecrypted, int *lenbufferdecrypted);
void encryptcasero (char *password, TBuffer buffer2encrypt, int len_buffer2encrypt, TBuffer bufferencrypted, int *lenbufferencrypted);
void crc32_init (void);
unsigned int crc32(unsigned char *data, int len);
const char *AuthBasic (const char *user, const char *pw, TBuffer value);
 
#endif                           
