/*
Addressbook.cc
*/

#include "Addressbook.h"
#include "Utils.h"

extern Language *L;

/*
NOTE: The field Fcc will be for the addressbook name,
      in Pine is used for other thing.
*/


Addressbook::Addressbook (const char *fn, UserOptions *auo)
  {        
  MODIFIED = false;
  xstrncpy (fnaddressbook, MAXLENGTHLINE, fn);
  uo = auo;
  sortby = uo->getSort_ab();
  readAddressbook ();
  }
  
Addressbook::~Addressbook ()
  {
  if (MODIFIED) SaveAddressbook ();
  }
  
void Addressbook::setSortby (int asortby)
  {
  if (asortby != -1) sortby = asortby;
  uo->setSort_ab (sortby);  
  }  
  
void Addressbook::initEntry (TEntry *aentry)
  {
  aentry->Nickname   = ""; 
  aentry->Fullname   = ""; 
  aentry->Addresses  = "";    
  aentry->Fcc        = ""; 
  aentry->Comment    = ""; 
  }  

//minickname	mifullname	(miaddresses,otra)	mifcc	micomment 
void Addressbook::readAddressbook ()
  {
  agenda.Clear();
  if (!FileExists(fnaddressbook)) return;
  XString XS;
  FILE *FR;
  TBuffer linea, token;
  TEntry aentry;
  FR = fopen (fnaddressbook, "r");
  XS = "";
  while (fgets (linea, CMAXBUFFER, FR) != NULL)
    {
    QuitaRetornoCarroDeLinea (linea);
    if (linea[0] == ' ')
      {
      trim (linea);
      XS += linea;
      }
    else
      {
      if (!IsEmpty(XS.cstr()) || (strcmp (XS.cstr(), "\t\t\t\t") == 0)) 
        {
        aentry.Nickname   = getToken (XS.cstr(), 1, token); 
        aentry.Fullname   = getToken (XS.cstr(), 2, token); 
        aentry.Addresses  = getToken (XS.cstr(), 3, token); 
        if ((aentry.Addresses.startsWith("(") == true) && (aentry.Addresses.endsWith(")") == true))
          {
          aentry.Addresses  = aentry.Addresses.substring (1, aentry.Addresses.length() - 1);
          }
        aentry.Fcc        = getToken (XS.cstr(), 4, token); 
        aentry.Comment    = getToken (XS.cstr(), 5, token); 
        agenda.Add (aentry);
        }
      XS = linea;
      }
    }
  fclose (FR);  
  if (XS.length() > 0) 
    {
    if (!IsEmpty(XS.cstr()) || (strcmp (XS.cstr(), "\t\t\t\t") == 0)) 
      {
      aentry.Nickname   = getToken (XS.cstr(), 1, token); 
      aentry.Fullname   = getToken (XS.cstr(), 2, token); 
      aentry.Addresses  = getToken (XS.cstr(), 3, token); 
      if ((aentry.Addresses.startsWith("(") == true) && (aentry.Addresses.endsWith(")") == true))
        {
        aentry.Addresses  = aentry.Addresses.substring (1, aentry.Addresses.length() - 1);
        }
      aentry.Fcc        = getToken (XS.cstr(), 4, token); 
      aentry.Comment    = getToken (XS.cstr(), 5, token); 
      agenda.Add (aentry);    
      }
    }
  }    

char *Addressbook::getToken (const char *linea, int numtoken, TBuffer token)
  {
  char c;
  int numtab, poschar;
  numtab = 0;
  poschar = 0;
  token [0] = '\0';
  for (xuint L = 0; L < strlen(linea); ++L)
    {
    c = linea[L];
    if (c == TAB) 
      {
      ++numtab;
      if (numtab == numtoken)
        {
        trim (token);
        return token;
        } 
      else 
        {
        poschar = 0;
        token [0] = '\0'; 
        }
      }
    else 
      {
      token[poschar] = c;
      token[poschar + 1] = '\0';
      ++poschar;
      }
    }
  if ((strlen (token) > 0) && (numtab == numtoken - 1))
    {
    trim (token);
    return token;
    }
  return token;
  }

bool Addressbook::SaveAddressbook ()
  {
  return (SaveAddressbookAs (fnaddressbook));
  }  
  
bool Addressbook::SaveAddressbookAs (const char *fn)
  {
  XString XS;
  FILE *FW;
  TFileName fntmp;
  bool b;
  
  MakeTmpName (fntmp, CMAXFILENAME);
  FW = fopen (fntmp, "w");
  if (FW == NULL) return false;
  for (int i = 0; i < agenda.Count (); ++i)
    {  
    if (agenda[i].Addresses.indexOf(',') > -1) 
      {
      XS = "("; XS += agenda[i].Addresses; XS += (")");
      }
    else XS = agenda[i].Addresses;
    fprintf (FW, "%s\t%s\t%s\t%s\t%s\n", agenda[i].Nickname.cstr(),  
                                         agenda[i].Fullname.cstr(),
                                         XS.cstr(), 
                                         agenda[i].Fcc.cstr(),
                                         agenda[i].Comment.cstr());    
    }  
  fclose (FW);  
  b = CopyFileOverWrite (fntmp, fn);
  if (b == false)
    {
    LOG ("Error copying the tmp addressbook '%s' to '%s'", fntmp, fn);
    return false;
    }
  else
    {
    DeleteFile (fntmp);
    return true;
    }
  }  
  
void Addressbook::Clear ()
  {
  agenda.Clear(); 
  MODIFIED = true; 
  }

int Addressbook::Count (void)
  {
  return agenda.Count();
  }    

const char *Addressbook::getNickname (int pos)
  {
  return agenda[pos].Nickname.cstr();
  }

const char *Addressbook::getFullname (int pos)
  {
  return agenda[pos].Fullname.cstr();
  }  

const char *Addressbook::getAddresses (int pos)
  {
  return agenda[pos].Addresses.cstr();
  }  

char *Addressbook::getMultiAddresses (const char *positions)
  {
  StringList *SL;
  TBuffer abuff;
  UINT ppos;
  
  SL = new StringList ();
  initStr (abuff);
  SeparaTokensEnStringList (positions, ',', SL);
  if (SL->Count() > 0)
    {
    for (int i=0; i < SL->Count(); ++i)
      {
      ppos = xatoidef (SL->getString(i).cstr(), 0);
      if (ppos > 0) 
        {
        xstrncat (abuff, CMAXBUFFER, agenda[ppos - 1].Addresses.cstr()); 
        }
      if (i < SL->Count() - 1) 
        {
        xstrncat (abuff, CMAXBUFFER, ",");
        }
      }
    }
  delete SL;
  return xstrdup(abuff);
  }  

bool Addressbook::DeleteEntries (const char *positions)
  {
  StringList *SL;
  UINT ppos;
  SL = new StringList ();
  SeparaTokensEnStringList (positions, ',', SL);
  if (SL->Count() <= 0) {delete SL; return false;}
  MODIFIED = true;
  for (int i=SL->Count() - 1; i>=0; --i)
    {
    ppos = xatoidef (SL->getString(i).cstr(), 0);    
    agenda.removeElementAt (ppos);
    }
  delete SL;
  return true;
  } 
    
const char *Addressbook::getFcc (int pos)
  {                    
  return agenda[pos].Fcc.cstr();
  }  

const char *Addressbook::getComment (int pos)
  {
  return agenda[pos].Comment.cstr();
  }  
 
void Addressbook::setNickname (int pos, char *value)
  {
  agenda[pos].Nickname = value;
  }

void Addressbook::setFullname (int pos, char *value)
  {
  agenda[pos].Fullname = value;
  }  

void Addressbook::setAddresses (int pos, char *value)
  {
  agenda[pos].Addresses = value;
  }  

void Addressbook::setFcc (int pos, char *value)
  {                    
  agenda[pos].Fcc = value;
  }  

void Addressbook::setComment (int pos, char *value)
  {
  agenda[pos].Comment = value;
  }    

void Addressbook::UpdateEntryFromFile (int numentry, char *fn)
  {
  if (numentry == -1) return;
  TBuffer linea;
  int cont;
  FILE *FR;
  FR = fopen (fn, "r");
  if (FR == NULL) return;
  cont = 0;
  while (fgets (linea, MAXLENGTHLINE, FR) != NULL) 
    {
    ++cont;
    QuitaRetornoCarroDeLinea (linea); 
    switch (cont)
      {
      case 1: setNickname  (numentry, linea); break;
      case 2: setFullname  (numentry, linea); break;
      case 3: setAddresses (numentry, linea); break;
      case 4: setFcc       (numentry, linea); break;
      case 5: setComment   (numentry, linea); break;
      }    
    } 
  fclose (FR);
  DeleteFile (fn);
  MODIFIED = true;
  }

int Addressbook::AddNewEntry (void)
  {
  TEntry aentry;
  initEntry (&aentry);
  agenda.addElement (aentry);
  MODIFIED = true;
  return (agenda.Count () - 1);
  }

int Addressbook::AddNewEntry (const char *addresses)
  {
  TEntry aentry;
  initEntry (&aentry);
  aentry.Addresses = addresses;
  agenda.addElement (aentry);
  MODIFIED = true;
  return (agenda.Count () - 1);
  }

void FlipEntries (const void *e1, const void *e2)
  {
  TEntry temp;
  temp.Nickname  = PEntry (e1)->Nickname;
  temp.Fullname  = PEntry (e1)->Fullname;  
  temp.Addresses = PEntry (e1)->Addresses;
  temp.Fcc       = PEntry (e1)->Fcc;
  temp.Comment   = PEntry (e1)->Comment;
  PEntry (e1)->Nickname  = PEntry (e2)->Nickname;  PEntry (e2)->Nickname  = temp.Nickname;
  PEntry (e1)->Fullname  = PEntry (e2)->Fullname;  PEntry (e2)->Fullname  = temp.Fullname;  
  PEntry (e1)->Addresses = PEntry (e2)->Addresses; PEntry (e2)->Addresses = temp.Addresses;  
  PEntry (e1)->Fcc       = PEntry (e2)->Fcc;       PEntry (e2)->Fcc       = temp.Fcc;  
  PEntry (e1)->Comment   = PEntry (e2)->Comment;   PEntry (e2)->Comment   = temp.Comment;  
  }
   
int CompareEntriesByNickname (const void *e1, const void *e2)
  {
  return (strcasecmp (PEntry (e1)->Nickname.cstr(), PEntry(e2)->Nickname.cstr()));
  }

int CompareEntriesByFullname (const void *e1, const void *e2)
  {
  return (strcasecmp (PEntry (e1)->Fullname.cstr(), PEntry(e2)->Fullname.cstr()));
  }

int CompareEntriesByFcc (const void *e1, const void *e2)
  {
  return (strcasecmp (PEntry (e1)->Fcc.cstr(), PEntry(e2)->Fcc.cstr()));
  }
   
int CompareEntriesByAddresses (const void *e1, const void *e2)
  {
  return (strcasecmp (PEntry (e1)->Addresses.cstr(), PEntry(e2)->Addresses.cstr()));
  }   
   
void Addressbook::SORT (int asortby)            
  { 
  setSortby (asortby);
  switch (sortby)
    {
    case 0:  agenda.SORT (CompareEntriesByNickname,  FlipEntries); break;
    case 1:  agenda.SORT (CompareEntriesByFullname,  FlipEntries); break;
    case 2:  agenda.SORT (CompareEntriesByAddresses, FlipEntries); break;
    case 3:  agenda.SORT (CompareEntriesByFcc, FlipEntries); break;
    default: agenda.SORT (CompareEntriesByNickname,  FlipEntries); break;
    }
  MODIFIED = true; 
  }


          
