/*
ClientTIMSIEVED.h
*/

#ifndef __CLIENTTIMSIEVED_H
#define __CLIENTTIMSIEVED_H

#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <signal.h>

#include "Configuration.h"
#include "Language.h"
#include "Utils.h"
#include "Config.h"
#include "XSocket.h"
#include "XVector.h"
#include "Codecs.h"

#define DEFTIMSIEVEDPORT 2000

#define PREDEF_ANTISPAMFILTERNAME "antispam"
#define SPAMMAILBOX "SPAM"

#define SIEVE_CMD_LISTSCRIPTS   1
#define SIEVE_CMD_GETSCRIPT     2
#define SIEVE_CMD_PUTSCRIPT     3
#define SIEVE_CMD_DELETESCRIPT  4
#define SIEVE_CMD_SETACTIVE     5

#define CMAXFILTERS 100
#define POSTMANSIEVEFILTERNAME "postman"
#define VACATIONSECTIONNAME "vacations"
#define CAUTOMATICRESPONSE "[Respuesta automatica]"
#define SEPCR "@@@@@@@@SEP@@@@@@@@"

typedef struct 
  {
  TBuffer sectionname, name, from, to, subject, size, header_name, header_value, folder, action, rejecttext;
  } XFilter, *PXFilter;    
typedef XVector<XFilter> FilterList;

typedef struct 
  {
  TBuffer vacations_active, vacations_msgtext, vacations_msgsubject, vacations_days2repeat, vacations_ausenstaddresses;
  } XVacation, *PXVacation;    

class ClientTIMSIEVED
  {
  private:
    IPNAME server;
    TBuffer ErrorMsg, user, pw, base64, sievefile;
    int timsievedport; 
    Configuration *ConfSieve;
  public:
    ClientTIMSIEVED (const char *aserver, int aport, const char *auser, const char *apw, const char *asievefile);
    virtual ~ClientTIMSIEVED ();
    void initFilter (XFilter *filter);
    void initVacation (XVacation *vacation);
    const char *getErrorMsg (void);
    bool doSession (int sieve_cmd, TBuffer scriptname, StringList *SLRes, const char *data2put, TBuffer ErrorString);
    void loadFiltersFromFile (void);
    bool saveFiltersToFile (const char *fncgi, const char *sectionname);
    bool saveAntiSpamFilterToFile (const char *fncgi, const char *spammailbox);    
    bool delFilters (StringList *SLFilters_section, int *contdel);
    bool getFilter (const char *secname, XFilter *filter);
    bool upSection (const char *secname);
    bool downSection (const char *secname);
    bool isValidSection (const char *secname);
    bool saveVacationToFile (const char *fncgi, PXVacation avacation);
    bool getVacationFromFile (void);  
    void makeSieveScript (char *sieveprogram, int MAXLENGTH);
    bool saveSieveNetwork (void);
    bool isThereFilter (const char *filtername);
  };

#endif

