#  Postilion software and its included text and images
#  Copyright (C) 1998 Nic Bernstein
#
#  The full text of the legal notices is contained in the file called
#  COPYING, included with this distribution.
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# CreateMainMenu --
#
# Create the main menu widget which will be reconfigured by each window 
# as needed
#
# Arguments:
proc CreateMainMenu {{handler ""}} {
    global option t b composeHeaderList vFolderCurrent app ratDeferred

    if $option(next_menu) {
	global mmenu
	set ptop .tearoff1
	set w [menu .menu -tearoff 1 -title Postilion]
    } else {
	upvar #0 $handler wh
	set ptop $wh(w).#$handler#menubar
	set w [set wh(menubar) [menu $wh(w).menubar -relief flat -bd 0]]
	$wh(w) configure -menu $w
	upvar #0 $w mmenu
    }

    # Create the main menu
    set p $ptop
    set mmenu(main) $w
    $w add cascade -label Info -menu $w.help
    set mmenu(minfo) [$w index end]
    set b($p,[$w index end]) help_menu
    if {$option(next_menu) || ![string compare $wh(win_type) folder]} {
	$w add cascade -label $t(mailbox) -menu $w.mbox
	set mmenu(mmbox) [$w index end]
	set b($p,[$w index end]) mailbox_menu
	$w add cascade -label $t(message) -menu $w.msg
	set mmenu(mmsg) [$w index end]
	set b($p,[$w index end]) message_menu
	$w add cascade -label $t(group) -menu $w.group
	set mmenu(mgroup) [$w index end]
	set b($p,[$w index end]) group_menu
    }
    if {$option(next_menu) || ![string compare $wh(win_type) compose]} {
	$w add cascade -label $t(compose) -menu $w.comp
	set mmenu(mcomp) [$w index end]
	set b($p,[$w index end]) compose_menu
	$w add cascade -label Edit -menu $w.edit -state disabled
	set mmenu(medit) [$w index end]
	set b($p,[$w index end]) edit_menu
    }
#     $w add cascade -label Format -menu $w.frmt -state disabled
#     set mmenu(mfrmt) [$w index end]
#     set b($p,[$w index end]) format_menu
    $w add cascade -label $t(window) -menu $w.win
    set mmenu(mwin) [$w index end]
    set b($p,[$w index end]) window_menu
#     $w add command -label $t(print)... -accelerator P \
#	-command "PrintDialog" -state disabled
#     set mmenu(mprint) [$w index end]
#     set b($p,[$w index end]) print_menu
    $w add cascade -label Services -menu $w.serv
    set mmenu(mserv) [$w index end]
    set b($p,[$w index end]) admin_menu
    if $option(next_menu) {
	$w add command -label Hide -accelerator H -command "HideAll"
	set mmenu(mhide) [$w index end]
	set b($p,[$w index end]) hide
	$w add command -label $t(quit) -accelerator Q -command "Quit all"
	set mmenu(mquit) [$w index end]
	set b($p,[$w index end]) quit
    }

    # First the "Info" menu
    set m [menu $w.help -tearoff 1 -title Info]
    set mmenu(info) $m
    if $option(next_menu) { 
	set p $ptop.#menu#help
    } else {
	set p $ptop.#$handler#menubar#help
    }
    $m add command -label $t(version)... -command Version
    set b($p,[$m index end]) show_version
    $m add command -label $t(preferences)... -command Preferences
    set b($p,[$m index end]) preferences
    $m add command -label Ratatosk... -command Ratatosk
    set b($p,[$m index end]) explain_ratatosk
    $m add command -label Postilion... -command Postilion
    $m add command -label $t(help_window)... -command Help
    set b($p,[$m index end]) help_window
    $m add checkbutton -label $t(balloon_help) \
	-variable option(show_balhelp) \
	-command {SaveOptions}
    set b($p,[$m index end]) balloon_help
    $m add command -label $t(send_bug)... -command SendBugReport
    set b($p,[$m index end]) send_bug
    $m add command -label $t(define_keys)... -state disabled
    set b($p,[$m index end]) define_keys
    set mmenu(info-keys) [$m index end]
    $m add command -label $t(see_log)... -command "SeeLog $w"
    set b($p,[$m index end]) see_log

    # The Mailbox menu
    if $option(next_menu) { 
	set p $ptop.#menu#mbox
	set showmenu 1
    } else {
	if [string compare $wh(win_type) folder] {
	    set showmenu 0
	} else {
	    set showmenu 1
	}
	set p $ptop.#$handler#menubar#mbox
    }
    if $showmenu {
	set m [menu $w.mbox -tearoff 1 -title $t(mailbox)]
	set mmenu(mbox) $m
	$m add cascade -label $t(open) -menu $m.folder
	set mmenu(mbox-open) [$m index end]
	menu $m.folder -title "$t(open) $t(mailbox)" \
	    -postcommand "PostFolder dummy $m.folder"
	set mmenu(mbox-openmenu) $m.folder
	$m add cascade -label $t(new) -menu $m.new
	set b($p,[$m index end]) vd_foldermenu
	menu $m.new -title $t(new_folder)
	$m.new add command -label $t(create_submenu)... \
	    -command {set vFolderCurrent {0 end}; VFolderCreateMenu}
	if $option(next_menu) { 
	    set p $ptop.#menu#mbox.#menu#mbox#new
	} else {
	    set p $ptop.#$handler#menubar#mbox.#$handler#menubar#mbox#new
	}
	set b($p,[$m.new index end]) vd_createsub
	$m.new add command -label $t(new_file)... \
	    -command {set vFolderCurrent {0 end}; VFolderNew file}
	set b($p,[$m.new index end]) vd_newfile
	$m.new add command -label $t(new_mh)... \
	    -command {set vFolderCurrent {0 end}; VFolderNew mh}
	set b($p,[$m.new index end]) vd_newmh
	$m.new add command -label $t(new_dbase)... \
	    -command {set vFolderCurrent {0 end}; VFolderNew dbase}
	set b($p,[$m.new index end]) vd_newdbase
	$m.new add command -label $t(new_imap)... \
	    -command {set vFolderCurrent {0 end}; VFolderNew imap}
	set b($p,[$m.new index end]) vd_newimap
	$m.new add command -label $t(new_pop3)... \
	    -command {set vFolderCurrent {0 end}; VFolderNew pop3}
	set b($p,[$m.new index end]) vd_newpop
	$m.new add command -label $t(new_dynamic)... \
	    -command {set vFolderCurrent {0 end}; VFolderNew dynamic}
	set b($p,[$m.new index end]) vd_newdynamic
	$m add cascade -label $t(import) -menu $m.import
	set b($p,[$m index end]) vd_importmenu
	menu $m.import
	$m.import add command -label $t(directory)... \
	    -command VFolderImportDirectory
	if $option(next_menu) { 
	    set p $ptop.#menu#mbox.#menu#mbox#import
	} else {
	    set p $ptop.#$handler#menubar#mbox.#$handler#menubar#mbox#import
	}
	set b($p,[$m.import index end]) vd_importdir
	$m.import add command -label "MH $t(directory)..." \
	    -command VFolderImportMHDirectory
	set b($p,[$m.import index end]) vd_importmh
	$m.import add command -label $t(import_IMAP)... \
	    -command VFolderImportIMAP
	set b($p,[$m.import index end]) vd_importimap
	$m add command -label $t(mailboxes)... -accelerator M \
	    -command "CreateMBoxWin"
	if $option(next_menu) { 
	    set p $ptop.#menu#mbox
	} else {
	    set p $ptop.#$handler#menubar#mbox
	}
	set mmenu(mbox-create) [$m index end]
	$m add command -label $t(update_folder) -state disabled
	set mmenu(mbox-update) [$m index end]
	set b($p,[$m index end]) update
	$m add checkbutton -label $t(browse_mode) -state disabled
	set mmenu(mbox-browse) [$m index end]
	set b($p,[$m index end]) browse_mode
	$m add cascade -label $t(sort_order) -menu $m.sort -state disabled
	set mmenu(mbox-sortorder) [$m index end]
	set b($p,[$m index end]) sort_order
	menu $m.sort -tearoff 1 -title $t(sort_order)
	set mmenu(mbox-sort) $m.sort
	$m.sort add radiobutton -label $t(subject_by_date)
	set mmenu(mbox-sort-subjectbydate) [$m.sort index end]
	if $option(next_menu) { 
	    set p $ptop.#menu#mbox.#menu#mbox#sort
	} else {
	    set p $ptop.#$handler#menubar#mbox.#$handler#menubar#mbox#sort
	}
	set b($p,[$m.sort index end]) sort_subjdate
	$m.sort add radiobutton -label $t(subjectonly)
	set mmenu(mbox-sort-subjectonly) [$m.sort index last]
	set b($p,[$m.sort index end]) sort_subj
	$m.sort add radiobutton -label $t(bysender)
	set mmenu(mbox-sort-bysender) [$m.sort index end]
	set b($p,[$m.sort index end]) sort_sender
	$m.sort add radiobutton -label $t(natural_order)
	set mmenu(mbox-sort-natural) [$m.sort index end]
	set b($p,[$m.sort index end]) sort_natural
	$m.sort add radiobutton -label $t(reverse_natural_order)
	set mmenu(mbox-sort-rev_natural) [$m.sort index end]
	set b($p,[$m.sort index end]) sort_reverse_natural
	$m.sort add radiobutton -label $t(by_date)
	set mmenu(mbox-sort-bydate) [$m.sort index end]
	set b($p,[$m.sort index end]) sort_date
	$m.sort add radiobutton -label $t(reverse_date)
	set mmenu(mbox-sort-rev_date) [$m.sort index end]
	set b($p,[$m.sort index end]) sort_reversedate
	if $option(next_menu) { 
	    set p $ptop.#menu#mbox
	} else {
	    set p $ptop.#$handler#menubar#mbox
	}
	$m add command -label "Hide Sizes" -state disabled
	set mmenu(mbox-hide_size) [$m index end]
	set b($p,[$m index end]) hide_size
	$m add command -label "Hide Deleted" -state disabled
	set mmenu(mbox-hide_del) [$m index end]
	set b($p,[$m index end]) hide_deleted
	$m add command -label "Compact" -state disabled
	set mmenu(mbox-compact) [$m index end]
	set b($p,[$m index end]) sync
	$m add command -label "Incorporate Mail" -state disabled
	set mmenu(mbox-inc) [$m index end]
	if !$option(next_menu) {
	    $m add command -label Hide -accelerator H -command "HideAll"
	    set mmenu(mhide) [$m index end]
	    set b($p,[$m index end]) hide
	    $m add command -label $t(quit) -accelerator Q -command "Quit all"
	    set mmenu(mquit) [$m index end]
	    set b($p,[$m index end]) quit
	}

	# The Message menu
	set m [menu $w.msg -tearoff 1 -title $t(message)]
	set mmenu(msg) $m
	if $option(next_menu) { 
	    set p $ptop.#menu#msg
	} else {
	    set p $ptop.#$handler#menubar#msg
	}
	$m add command -label $t(find)... -state disabled
	set mmenu(msg-find) [$m index end]
	set b($p,[$m index end]) find
	$m add command -label $t(compose)... -command "Compose dummy"
	set mmenu(msg-comp) [$m index end]
	set b($p,[$m index end]) compose
	$m add command -label $t(reply_sender)... -state disabled
	set mmenu(msg-reply) [$m index end]
	set b($p,[$m index end]) reply_sender
	$m add command -label $t(reply_all)... -state disabled
	set mmenu(msg-replya) [$m index end]
	set b($p,[$m index end]) reply_all
	$m add command -label $t(reply_quote_sender)... -state disabled
	set mmenu(msg-replyq) [$m index end]
	set b($p,[$m index end]) reply_quote_sender
	$m add command -label $t(reply_quote_all)... -state disabled
	set mmenu(msg-replyqa) [$m index end]
	set b($p,[$m index end]) reply_quote_all
	$m add command -label $t(forward_inline)... -state disabled
	set mmenu(msg-fwd_in) [$m index end]
	set b($p,[$m index end]) forward_inline
	$m add command -label $t(forward_as_attachment)... -state disabled
	set mmenu(msg-fwd_attach) [$m index end]
	set b($p,[$m index end]) forward_attached
	$m add command -label $t(bounce)... -state disabled
	set mmenu(msg-bounce) [$m index end]
	set b($p,[$m index end]) bounce
	$m add command -label $t(extract_adr)... 
	set mmenu(msg-extract) [$m index end]
	set b($p,[$m index end]) extract_adr
	$m add cascade -label $t(move) -menu $m.move -state disabled
	set mmenu(msg-moveto) [$m index end]
	set b($p,[$m index end]) move
	menu $m.move -title "$t(message) $t(move_to)"
	set mmenu(msg-move) $m.move
	$m add command -label $t(flag_seen) -state disabled
	set mmenu(msg-seen) [$m index end]
	set b($p,[$m index end]) flag_seen
# 	$m add command -label $t(flag_unseen) -state disabled
# 	set mmenu(msg-unseen) [$m index end]
# 	set b($p,[$m index end]) flag_unseen
	$m add command -label $t(flag_ans) -state disabled
	set mmenu(msg-ans) [$m index end]
	set b($p,[$m index end]) flag_ans
	$m add command -label $t(delete) -state disabled
	set mmenu(msg-del) [$m index end]
	set b($p,[$m index end]) delete
# 	$m add command -label $t(undelete) -state disabled
# 	set mmenu(msg-undel) [$m index end]
# 	set b($p,[$m index end]) undelete
	$m add command -label $t(print) -state disabled
	set mmenu(msg-print) [$m index end]
	set b($p,[$m index end]) print
	$m add radiobutton -label $t(show_all_headers)
	set mmenu(msg-hdr_all) [$m index end]
	set b($p,[$m index end]) show_all_headers
	$m add radiobutton -label $t(show_selected_headers)
	set mmenu(msg-hdr_sel) [$m index end]
	set b($p,[$m index end]) show_selected_headers
	$m add radiobutton -label $t(show_no_headers)
	set mmenu(msg-hdr_no) [$m index end]
	set b($p,[$m index end]) show_no_headers

	# The Group menu
	set m [menu $w.group -tearoff 1 -title $t(group)]
	set mmenu(group) $m
	if $option(next_menu) { 
	    set p $ptop.#menu#group
	} else {
	    set p $ptop.#$handler#menubar#group
	}
	$m add command -label Focus -state disabled
	set mmenu(group-focus) [$m index end]
	set b($p,[$m index end]) focus
	$m add command -label Unfocus -state disabled
	set mmenu(group-unfocus) [$m index end]
	set b($p,[$m index end]) unfocus
	$m add command -label $t(create_by_expr)... -state disabled
	set mmenu(group-create_exp) [$m index end]
	set b($p,[$m index end]) create_by_expr
	$m add cascade -label $t(use_saved_expr) -menu $m.saved -state disabled
	set mmenu(group-use_save) [$m index end]
	set b($p,[$m index end]) use_saved_expr
	menu $m.saved -title $t(use_saved_expr)
	set mmenu(group-saved) $m.saved
	$m add command -label $t(saved_expr)... -command ExpHandleSaved
	set mmenu(group-edit_saved) [$m index end]
	set b($p,[$m index end]) saved_expr
	$m add command -label $t(select_all) -state disabled
	set mmenu(group-all) [$m index end]
	set b($p,[$m index end]) group_all
	$m add command -label $t(deselect_all) -state disabled
	set mmenu(group-clear) [$m index end]
	set b($p,[$m index end]) clear_group
	$m add command -label $t(flag_seen) -state disabled
	set mmenu(group-seen) [$m index end]
	set b($p,[$m index end]) seen_group
# 	$m add command -label $t(flag_unseen) -state disabled
# 	set mmenu(group-unseen) [$m index end]
# 	set b($p,[$m index end]) unseen_group
	$m add command -label $t(flag_ans) -state disabled
	set mmenu(group-ans) [$m index end]
	set b($p,[$m index end]) ans_group
	$m add command -label $t(delete) -state disabled
	set mmenu(group-del) [$m index end]
	set b($p,[$m index end]) delete_group
# 	$m add command -label $t(undelete) -state disabled
# 	set mmenu(group-undel) [$m index end]
# 	set b($p,[$m index end]) undelete_group
	$m add command -label $t(print) -state disabled
	set mmenu(group-print) [$m index end]
	set b($p,[$m index end]) print_group
	$m add cascade -label $t(move) -menu $m.move -state disabled
	set mmenu(group-moveto) [$m index end]
	set b($p,[$m index end]) move_group
	menu $m.move -title "$t(group) $t(move_to)"
	set mmenu(group-move) $m.move
    }
    # Compose menu
    if $option(next_menu) { 
	set p $ptop.#menu#comp
	set showmenu 1
    } else {
	if [string compare $wh(win_type) compose] {
	    set showmenu 0
	} else {
	    set showmenu 1
	}
	set p $ptop.#$handler#menubar#comp
    }
    if $showmenu {
	set m [menu $w.comp -tearoff 1 -title $t(compose)]
	set mmenu(comp) $m
	$m add cascade -label $t(drafts) -menu $m.draft
	menu $m.draft -tearoff 1 -title $t(drafts)
	set mmenu(comp-draft) $m.draft
	$m.draft add command -label $t(hold)... -state disabled
	set mmenu(comp-draft-save) [$m.draft index end]
	if $option(next_menu) { 
	    set p $ptop.#menu#comp.#menu#comp#draft
	} else {
	    set p $ptop.#$handler#menubar#comp.#$handler#menubar#comp#draft
	}
	set b($p,[$m.draft index end]) hold
	$m.draft add command -label $t(getheld)... -command "ComposeHeld"
	set b($p,[$m.draft index end]) compose_held
	set mmenu(comp-draft-restore) [$m.draft index end]
	if $option(next_menu) { 
	    set p $ptop.#menu#comp
	} else {
	    set p $ptop.#$handler#menubar#comp
	}
	$m add command -label $t(send) -state disabled
	set mmenu(comp-send) [$m index end]
	set b($p,[$m index end]) send
	$m add cascade -label $t(send_save) -menu $m.sendsave -state disabled
	menu $m.sendsave -title $t(send_save)
	set mmenu(comp-sendsave) [$m index end]
	set mmenu(comp-send_save) $m.sendsave
	set b($p,[$m index end]) sendsave
	$m add command -label $t(insert_file)... -state disabled
	set mmenu(comp-file) [$m index end]
	set b($p,[$m index end]) compose_insert_file
	$m add checkbutton -label $t(automatic_wrap) -state disabled
	set mmenu(comp-wrap) [$m index end]
	set b($p,[$m index end]) automatic_wrap
	$m add checkbutton -label $t(automatic_indent) -state disabled
	set mmenu(comp-indent) [$m index end]
	set b($p,[$m index end]) automatic_indent
	$m add cascade -label $t(headers) -menu $m.headers -state disabled
	set mmenu(comp-hdrs) [$m index end]
	set b($p,[$m index end]) headers_menu
	menu $m.headers -tearoff 0 -title $t(headers)
	foreach header $composeHeaderList {
	    $mmenu(comp).headers add checkbutton -label $t($header) \
		-state disabled
	    set mmenu(comp-hdrs-$header) [$m.headers index end]
	}
	$m add checkbutton -label $t(copy_attached_files) -state disabled
	set mmenu(comp-attach) [$m index end]
	set b($p,[$m index end]) copy_attached_files
	$m add checkbutton -label $t(request_notification) -state disabled
	set mmenu(comp-reqdsn) [$m index end]
	set b($p,[$m index end]) request_notification
	if $option(pgp_enable) {
	    $m add checkbutton -label $t(sign) -state disabled
	    set mmenu(comp-sign) [$m index end]
	    set b($p,[$m index end]) pgp_sign
	    $m add checkbutton -label $t(encrypt) -state disabled
	    set mmenu(comp-crypt) [$m index end]
	    set b($p,[$m index end]) pgp_encrypt
	}
	$m add command -label $t(command_list)... -command CmdList -state disabled
	set mmenu(comp-cmdlst) [$m index end]
	set b($p,[$m index end]) command_list
	$m add command -label $t(abort) -state disabled
	set mmenu(comp-abort) [$m index end]
	set b($p,[$m index end]) abort_compose
	if !$option(next_menu) {
	    $m add command -label Hide -accelerator H -command "HideAll"
	    set mmenu(mhide) [$m index end]
	    set b($p,[$m index end]) hide
	    $m add command -label $t(quit) -accelerator Q -command "Quit all"
	    set mmenu(mquit) [$m index end]
	    set b($p,[$m index end]) quit
	}

	# Edit menu
	set m [menu $w.edit -tearoff 1 -title $t(edit)]
	set mmenu(edit) $m
	if $option(next_menu) { 
	    set p $ptop.#menu#edit
	} else {
	    set p $ptop.#$handler#menubar#edit
	}
	$m add command -label $t(undo) -state disabled
	set mmenu(edit-undo) [$m index end]
	set b($p,[$m index end]) undo
	set mh(undo_menu) [list $m [$m index end]]
	$m add command -label $t(cut) -state disabled
	set mmenu(edit-cut) [$m index end]
	set b($p,[$m index end]) cut
	$m add command -label $t(copy) -state disabled
	set mmenu(edit-copy) [$m index end]
	set b($p,[$m index end]) copy
	$m add command -label $t(paste) -state disabled
	set mmenu(edit-paste) [$m index end]
	set b($p,[$m index end]) paste
	$m add command -label $t(cut_all) -state disabled
	set mmenu(edit-cut_all) [$m index end]
	set b($p,[$m index end]) cut_all
	$m add command -label $t(copy_all) -state disabled
	set mmenu(edit-copy_all) [$m index end]
	set b($p,[$m index end]) copy_all
	$m add command -label $t(wrap_lines) -state disabled
	set mmenu(edit-wrap) [$m index end]
	set b($p,[$m index end]) wrap_lines
	$m add command -label "Spell Check" -state disabled
	set mmenu(edit-spell) [$m index end]
	$m add command -label $t(run_through_command)... -state disabled
	set mmenu(edit-runcmd) [$m index end]
	set b($p,[$m index end]) run_through_command

	#     # The Format menu
	#     set m [menu $w.frmt -tearoff 1 -title Format]
	#     set mmenu(format) $m
	#     if $option(next_menu) { 
	# 	set p $ptop.#menu#frmt
	#     } else {
	# 	set p $ptop.#$handler#menubar#frmt
	#     }
    }
    # The Window menu
    set m [menu $w.win -tearoff 1 -title Windows]
    set mmenu(window) $m
    if $option(next_menu) { 
	set p $ptop.#menu#win
    } else {
	set p $ptop.#$handler#menubar#win
    }
    $m add command -label $t(address)... -command CreateAddressWin
    set mmenu(window-addr) [$m index end]
    set b($p,[$m index end]) aliases
    $m add command -label $t(mailboxes)... -command CreateMBoxWin
    set mmenu(window-mbox) [$m index end]
    set b($p,[$m index end]) mailboxes
    $m add command -label $t(saved_expr)... -command ExpHandleSaved
    set mmenu(window-expr) [$m index end]
    set b($p,[$m index end]) saved_expr

    # The Services menu
    set m [menu $w.serv -tearoff 1 -title Services]
    set mmenu(serv) $m
    if $option(next_menu) { 
	set p $ptop.#menu#serv
    } else {
	set p $ptop.#$handler#menubar#serv
    }
    $m add command -label $t(send_deferred) \
	-command SendDeferred -state disabled
    set mmenu(serv-send_def) [$m index end]
    set b($p,[$m index end]) send_deferred
    trace variable ratDeferred w "TraceDeferred $m [$m index end]"
    $m add command -label $t(notifications)... -command ShowDSNList
    set mmenu(serv-notify) [$m index end]
    set b($p,[$m index end]) show_notifications
    $m add checkbutton -label $t(watcher) \
	-variable option(watcher_enable) -onvalue 1 -offvalue 0 \
	-command SaveOptions
    set mmenu(serv-watcher) [$m index end]
    set b($p,[$m index end]) watcher_enable
    $m add command -label $t(reread_aliases) -command AliasRead
    set mmenu(serv-read_alias) [$m index end]
    set b($p,[$m index end]) reread_aliases
    $m add command -label $t(reread_userproc) -command ReadUserproc
    set mmenu(serv-read_userproc) [$m index end]
    set b($p,[$m index end]) reread_userproc
    $m add command -label $t(import_aliases) -command ScanAliases
    set mmenu(serv-imp_alias) [$m index end]
    set b($p,[$m index end]) import_aliases
    $m add command -label $t(reread_mailcap) -command RatMailcapReload
    set mmenu(serv-read_mailcap) [$m index end]
    set b($p,[$m index end]) reread_mailcap
    $m add command -label $t(check_dbase)... -command "DbaseCheck $w 0"
    set mmenu(serv-chk_dbase) [$m index end]
    set b($p,[$m index end]) check_dbase
    $m add command -label $t(check_fix_dbase)... -command "DbaseCheck $w 1"
    set mmenu(serv-fix_dbase) [$m index end]
    set b($p,[$m index end]) check_fix_dbase

    if $option(next_menu) {
	set app [$w invoke 0]
	wm resizable $app 0 0
	wm transient $app .
	wm group $app .
	wm protocol $app WM_DELETE_WINDOW "Quit all"
	wm geometry $app +0+0
	wm withdraw $app
	wm deiconify $app
    }

}

# ConfigMainMenu --
#
# Configures the main menu for whichever window has focus
#
# Arguments:
# handler   -  The handler for the active window
proc ConfigMainMenu {handler} {
    global option t composeHeaderList

    set oldFocus [focus]

    if [string compare $handler default] {
	upvar #0 $handler wh
    } else {
	set wh(win_type) $handler
    }
    if !$option(next_menu) {
	if {![string compare $wh(win_type) folder] || ![string compare $wh(win_type) compose]} {
	    if [info exists wh(menubar)] { return }
	    CreateMainMenu $handler
	    upvar #0 $wh(menubar) mmenu
	} else {
	    return
	}
    } else {
	global mmenu
    }

    switch $wh(win_type) {
	folder {
	    #Info menu
	    $mmenu(info) entryconfigure $mmenu(info-keys) -state normal \
		-command "KeyDef folder"

	    #mailbox menu
	    $mmenu(mbox-openmenu) configure -postcommand \
		"PostFolder $handler $mmenu(mbox-openmenu)"
	    $mmenu(mbox) entryconfigure $mmenu(mbox-update) \
		-command "Sync $handler 0" -state normal
	    set wh(update_menu) [list $mmenu(mbox) $mmenu(mbox-update)]
	    $mmenu(mbox) entryconfigure $mmenu(mbox-browse) -state normal \
		-variable ${handler}(browse)
	    $mmenu(mbox) entryconfigure $mmenu(mbox-sortorder) -state normal
	    $mmenu(mbox-sort) entryconfigure $mmenu(mbox-sort-subjectbydate) \
		-command "Sync $handler 0" -variable ${handler}(folder_sort) \
		-value subject
	    $mmenu(mbox-sort) entryconfigure $mmenu(mbox-sort-subjectonly) \
		-command "Sync $handler 0" -variable ${handler}(folder_sort) \
		-value subjectonly
	    $mmenu(mbox-sort) entryconfigure $mmenu(mbox-sort-bysender) \
		-command "Sync $handler 0" -variable ${handler}(folder_sort) \
		-value sender
	    $mmenu(mbox-sort) entryconfigure $mmenu(mbox-sort-natural) \
		-command "Sync $handler 0" -variable ${handler}(folder_sort) \
		-value folder
	    $mmenu(mbox-sort) entryconfigure $mmenu(mbox-sort-rev_natural) \
		-command "Sync $handler 0" -variable ${handler}(folder_sort) \
		-value reverseFolder
	    $mmenu(mbox-sort) entryconfigure $mmenu(mbox-sort-bydate) \
		-command "Sync $handler 0" -variable ${handler}(folder_sort) \
		-value date
	    $mmenu(mbox-sort) entryconfigure $mmenu(mbox-sort-rev_date) \
		-command "Sync $handler 0" -variable ${handler}(folder_sort) \
		-value reverseDate
	    $mmenu(mbox) entryconfigure $mmenu(mbox-compact) \
		-command "Sync $handler 1" -state normal
	    set wh(sync_menu) [list $mmenu(mbox) $mmenu(mbox-compact)]
	    $mmenu(mbox) entryconfigure $mmenu(mbox-inc) \
		-command "MailSteal $handler 0" -state normal

	    # message menu
	    set wh(message_menu_nokeep) {}
	    $mmenu(main) entryconfigure $mmenu(mmsg) -state normal
	    $mmenu(msg) entryconfigure $mmenu(msg-find) \
		-command "FolderFind $handler" -state normal
	    set wh(find_menu) [list $mmenu(msg) $mmenu(msg-find)]
	    $mmenu(msg) entryconfigure $mmenu(msg-comp) \
		-command "Compose $handler"
	    set wh(compose_menu) [list $mmenu(msg) $mmenu(msg-comp)]
	    $mmenu(msg) entryconfigure $mmenu(msg-reply) -state normal \
		-command "FolderReply $handler sender 1"
	    lappend wh(message_menu_nokeep) $mmenu(msg-reply)
	    set wh(replys_menu) [list $mmenu(msg) $mmenu(msg-reply)]
	    $mmenu(msg) entryconfigure $mmenu(msg-replya) -state normal \
		-command "FolderReply $handler all 1"
	    lappend wh(message_menu_nokeep) $mmenu(msg-replya)
	    set wh(replya_menu) [list $mmenu(msg) $mmenu(msg-replya)]
	    $mmenu(msg) entryconfigure $mmenu(msg-replyq) -state normal \
		-command "FolderReply $handler sender 0"
	    lappend wh(message_menu_nokeep) $mmenu(msg-replyq)
	    set wh(replyq_menu) [list $mmenu(msg) $mmenu(msg-replyq)]
	    $mmenu(msg) entryconfigure $mmenu(msg-replyqa) -state normal \
		-command "FolderReply $handler all 0"
	    lappend wh(message_menu_nokeep) $mmenu(msg-replyqa)
	    set wh(replyqa_menu) [list $mmenu(msg) $mmenu(msg-replyqa)]
	    $mmenu(msg) entryconfigure $mmenu(msg-fwd_in) -state normal \
		-command "FolderSomeCompse $handler ComposeForwardInline"
	    lappend wh(message_menu_nokeep) $mmenu(msg-fwd_in)
	    set wh(forward_i_menu) [list $mmenu(msg) $mmenu(msg-fwd_in)]
	    $mmenu(msg) entryconfigure $mmenu(msg-fwd_attach) \
		-command "FolderSomeCompse $handler ComposeForwardAttachment" \
		-state normal
	    lappend wh(message_menu_nokeep) $mmenu(msg-fwd_attach)
	    set wh(forward_a_menu) [list $mmenu(msg) $mmenu(msg-fwd_attach)]
	    $mmenu(msg) entryconfigure $mmenu(msg-bounce) \
		-command "FolderSomeCompse $handler ComposeBounce" \
		-state normal
	    lappend wh(message_menu_nokeep) $mmenu(msg-bounce)
	    set wh(bounce_menu) [list $mmenu(msg) $mmenu(msg-bounce)]
	    $mmenu(msg) entryconfigure $mmenu(msg-extract) \
		-command "AliasExtract $handler; focus $wh(w)" -state normal
	    lappend wh(message_menu_nokeep) $mmenu(msg-extract)
	    $mmenu(msg) entryconfigure $mmenu(msg-moveto) -state normal
	    lappend wh(message_menu_nokeep) $mmenu(msg-moveto)
	    $mmenu(msg-move) configure -postcommand \
		"PostMove $handler current $mmenu(msg-move); focus $wh(w)"
	    $mmenu(msg) entryconfigure $mmenu(msg-seen) -state normal \
		-command "SetFlag $handler seen toggle $option(adv_on_flag); focus $wh(w)"
	    set wh(seen_menu) [list $mmenu(msg) $mmenu(msg-seen)]
	    lappend wh(message_menu_nokeep) $mmenu(msg-seen)
# 	    $mmenu(msg) entryconfigure $mmenu(msg-unseen) -state normal \
# 		-command "SetFlag $handler seen 0 $option(adv_on_flag); focus $wh(w)"
# 	    set wh(unseen_menu) [list $mmenu(msg) $mmenu(msg-unseen)]
# 	    lappend wh(message_menu_nokeep) $mmenu(msg-unseen)
	    $mmenu(msg) entryconfigure $mmenu(msg-ans) -state normal \
		-command "SetFlag $handler answered toggle $option(adv_on_flag); focus $wh(w)"
	    set wh(ans_menu) [list $mmenu(msg) $mmenu(msg-ans)]
	    lappend wh(message_menu_nokeep) $mmenu(msg-ans)
	    $mmenu(msg) entryconfigure $mmenu(msg-del) -state normal \
		-command "SetFlag $handler deleted toggle $option(adv_on_flag); focus $wh(w)"
	    set wh(delete_menu) [list $mmenu(msg) $mmenu(msg-del)]
	    lappend wh(message_menu_nokeep) $mmenu(msg-del)
# 	    $mmenu(msg) entryconfigure $mmenu(msg-undel) -state normal \
# 		-command "SetFlag $handler deleted 0 $option(adv_on_flag); focus $wh(w)"
# 	    set wh(undelete_menu) [list $mmenu(msg) $mmenu(msg-undel)]
# 	    lappend wh(message_menu_nokeep) $mmenu(msg-undel)
	    $mmenu(msg) entryconfigure $mmenu(msg-print) -state normal \
		-command "Print $handler current; focus $wh(w)"
	    $mmenu(msg) entryconfigure $mmenu(msg-hdr_all) -state normal \
		-variable $wh(text)(show_header) -value all \
		-command "FolderSelect $handler \
		      \$${handler}(active) 0; SaveOptions; focus $wh(w)"
	    $mmenu(msg) entryconfigure $mmenu(msg-hdr_sel) -state normal \
		-variable $wh(text)(show_header) -value selected \
		-command "FolderSelect $handler \
		      \$${handler}(active) 0; SaveOptions; focus $wh(w)"
	    $mmenu(msg) entryconfigure $mmenu(msg-hdr_no) -state normal \
		-variable $wh(text)(show_header) -value no \
		-command "FolderSelect $handler \
		      \$${handler}(active) 0; SaveOptions; focus $wh(w)"

	    # Group menu
	    $mmenu(main) entryconfigure $mmenu(mgroup) -state normal
	    $mmenu(group) configure -postcommand \
		"SetupGroupMenu $mmenu(group) $handler"
	    $mmenu(group) entryconfigure $mmenu(group-focus) -state normal \
		-command "FocusOn $handler"
	    $mmenu(group) entryconfigure $mmenu(group-unfocus) -state disabled \
		-command "FocusOff $handler"
	    $mmenu(group) entryconfigure $mmenu(group-create_exp) \
		-state normal -command "ExpCreate $handler"
	    $mmenu(group) entryconfigure $mmenu(group-use_save) -state normal
	    $mmenu(group-saved) configure \
		-postcommand "ExpBuildMenu $mmenu(group-saved) $handler"
	    $mmenu(group) entryconfigure $mmenu(group-all) \
		-state normal -command "GroupAll $handler; focus $wh(w)"
	    set wh(group_all_menu) [list $mmenu(group) $mmenu(group-all)]
	    $mmenu(group) entryconfigure $mmenu(group-clear) \
		-state normal -command "GroupClear $handler; focus $wh(w)"
	    set wh(group_clear_menu) [list $mmenu(group) $mmenu(group-clear)]
	    $mmenu(group) entryconfigure $mmenu(group-seen) -state normal \
		-command "SetFlag $handler seen toggle 0 \
                \[\$${handler}(folder_handler) flagged flagged\]; focus $wh(w)"
#	    $mmenu(group) entryconfigure $mmenu(group-unseen) -state normal \
#		-command "SetFlag $handler seen 0 0 \
#               \[\$${handler}(folder_handler) flagged flagged\]; focus $wh(w)"
	    $mmenu(group) entryconfigure $mmenu(group-ans) -state normal \
		-command "SetFlag $handler answered toggle 0 \
                \[\$${handler}(folder_handler) flagged flagged\]; focus $wh(w)"
	    $mmenu(group) entryconfigure $mmenu(group-del) -state normal \
		-command "SetFlag $handler deleted toggle 0 \
                \[\$${handler}(folder_handler) flagged flagged\]; focus $wh(w)"
#	    $mmenu(group) entryconfigure $mmenu(group-undel) -state normal \
#		-command "SetFlag $handler deleted 0 0 \
#                \[\$${handler}(folder_handler) flagged flagged\]; focus $wh(w)"
	    $mmenu(group) entryconfigure $mmenu(group-print) -state normal \
		-command "Print $handler group; focus $wh(w)"
	    $mmenu(group) entryconfigure $mmenu(group-moveto) -state normal
	    $mmenu(group-move) configure -postcommand \
		"PostMove $handler group $mmenu(group-move); focus $wh(w)"

	    if $option(next_menu) { 
		#Compose menu
		$mmenu(comp-draft) entryconfigure $mmenu(comp-draft-save) \
		    -state disabled
		$mmenu(comp-draft) entryconfigure $mmenu(comp-draft-restore) \
		    -state normal -command "ComposeHeld"
		$mmenu(comp) entryconfigure $mmenu(comp-send) -state disabled
		$mmenu(comp) entryconfigure $mmenu(comp-sendsave) -state disabled
		$mmenu(comp) entryconfigure $mmenu(comp-file) -state disabled
		$mmenu(comp) entryconfigure $mmenu(comp-wrap) -state disabled
		$mmenu(comp) entryconfigure $mmenu(comp-indent) -state disabled
		$mmenu(comp) entryconfigure $mmenu(comp-hdrs) -state disabled
		$mmenu(comp) entryconfigure $mmenu(comp-attach) -state disabled
		$mmenu(comp) entryconfigure $mmenu(comp-reqdsn) -state disabled
		if $option(pgp_enable) {
		    $mmenu(comp) entryconfigure $mmenu(comp-sign) \
			-state disabled
		    $mmenu(comp) entryconfigure $mmenu(comp-crypt) \
			-state disabled
		}
		$mmenu(comp) entryconfigure $mmenu(comp-cmdlst) -state disabled
		$mmenu(comp) entryconfigure $mmenu(comp-abort) -state disabled

		#Edit menu
		$mmenu(main) entryconfigure $mmenu(medit) -state disabled
	}
	}
	compose {
	    set wh(eEditBlock) {}
	    #Info menu
	    $mmenu(info) entryconfigure $mmenu(info-keys) -state normal \
		-command "KeyDef compose"
	    if $option(next_menu) {
		#mailbox menu
		$mmenu(mbox-openmenu) configure -postcommand \
		    "PostFolder dummy $mmenu(mbox-openmenu)"
		$mmenu(mbox) entryconfigure $mmenu(mbox-update) -state disabled
		$mmenu(mbox) entryconfigure $mmenu(mbox-browse) \
		    -state disabled -variable ""
		$mmenu(mbox) entryconfigure $mmenu(mbox-sortorder) \
		    -state disabled
		$mmenu(mbox) entryconfigure $mmenu(mbox-compact) \
		    -state disabled
		$mmenu(mbox) entryconfigure $mmenu(mbox-inc) -state disabled

		# message menu
		$mmenu(main) entryconfigure $mmenu(mmsg) -state disabled

		# Group menu
		$mmenu(main) entryconfigure $mmenu(mgroup) -state disabled
	    }
	    #Compose menu
	    $mmenu(comp-draft) entryconfigure $mmenu(comp-draft-save) \
		-state normal -command "ComposeHold $wh(toplevel) $handler"
	    $mmenu(comp-draft) entryconfigure $mmenu(comp-draft-restore) \
		-state normal -command "ComposeHeld"
	    $mmenu(comp) entryconfigure $mmenu(comp-send) \
		-state normal -command "DoCompose2 $wh(toplevel) $handler send"
	    $mmenu(comp) entryconfigure $mmenu(comp-sendsave) -state normal
	    $mmenu(comp-send_save) configure \
		-postcommand "RatSendSavePostMenu $wh(toplevel) $mmenu(comp-send_save) $handler"
	    $mmenu(comp) entryconfigure $mmenu(comp-file) -state normal \
		-command "ComposeInsertFile $handler"
	    set wh(file_menu) [list $mmenu(comp) $mmenu(comp-file)]
	    $mmenu(comp) entryconfigure $mmenu(comp-wrap) -state normal \
		-variable ${handler}(doWrap) -command "focus $wh(composeBody)"
	    $mmenu(comp) entryconfigure $mmenu(comp-indent) -state normal \
		-variable ${handler}(doIndent) -command "focus $wh(composeBody)"
	    $mmenu(comp) entryconfigure $mmenu(comp-hdrs) -state normal
	    foreach header $composeHeaderList {
		$mmenu(comp).headers entryconfigure $mmenu(comp-hdrs-$header)\
		    -variable ${handler}(O_$header) -onvalue 1 -offvalue 0 \
		    -command "ComposeBuildHeaderEntries $handler; focus $wh(composeBody)" \
		    -state normal
	    }
	    $mmenu(comp) entryconfigure $mmenu(comp-attach) -state normal \
		-variable ${handler}(copy_attached) -onvalue 1 -offvalue 0 \
		-command "focus $wh(composeBody)"
	    $mmenu(comp) entryconfigure $mmenu(comp-reqdsn) -state normal \
		-variable ${handler}(request_dsn) -onvalue 1 -offvalue 0 \
		-command "focus $wh(composeBody)"
	    if $option(pgp_enable) {
		$mmenu(comp) entryconfigure $mmenu(comp-sign) -state normal \
		    -variable ${handler}(pgp_sign) -onvalue 1 -offvalue 0 \
		    -command "focus $wh(composeBody)"
		$mmenu(comp) entryconfigure $mmenu(comp-crypt) -state normal \
		    -variable ${handler}(pgp_encrypt) -onvalue 1 -offvalue 0 \
		    -command "focus $wh(composeBody)"
	    }
	    $mmenu(comp) entryconfigure $mmenu(comp-cmdlst) -state normal
	    $mmenu(comp) entryconfigure $mmenu(comp-abort) -state normal \
		-command "ComposeBuildStruct $handler; \
                          ComposeQuit $wh(toplevel) $handler"
	    set wh(abort_menu) [list $mmenu(comp) $mmenu(comp-abort)]
	    lappend wh(eEditBlock) [list $mmenu(main) $mmenu(mcomp)]

	    # Edit menu
	    $mmenu(main) entryconfigure $mmenu(medit) -state normal
	    $mmenu(edit) configure \
		-postcommand "ComposePostEdit $handler $mmenu(edit)"
	    $mmenu(edit) entryconfigure $mmenu(edit-undo) -state normal \
		-command "ComposeUndo $handler; focus $wh(composeBody)"
	    set wh(undo_menu) [list $mmenu(edit) $mmenu(edit-undo)]
	    $mmenu(edit) entryconfigure $mmenu(edit-cut) -state normal \
		-command "ComposeEditOP $handler cut; focus $wh(composeBody)"
	    set wh(cut_menu) [list $mmenu(edit) $mmenu(edit-cut)]
	    $mmenu(edit) entryconfigure $mmenu(edit-copy) -state normal \
		-command "ComposeEditOP $handler copy; focus $wh(composeBody)"
	    set wh(copy_menu) [list $mmenu(edit) $mmenu(edit-copy)]
	    $mmenu(edit) entryconfigure $mmenu(edit-paste) -state normal \
		-command "ComposePaste $handler; focus $wh(composeBody)"
	    set wh(paste_menu) [list $mmenu(edit) $mmenu(edit-paste)]
	    $mmenu(edit) entryconfigure $mmenu(edit-cut_all) -state normal \
		-command "ComposeEditOP $handler cut_all; focus $wh(composeBody)"
	    set wh(cut_all_menu) [list $mmenu(edit) $mmenu(edit-cut_all)]
	    $mmenu(edit) entryconfigure $mmenu(edit-copy_all) -state normal \
		-command "ComposeEditOP $handler copy_all; focus $wh(composeBody)"
	    $mmenu(edit) entryconfigure $mmenu(edit-wrap) -state normal \
		-command "ComposeWrapSelection $handler; focus $wh(composeBody)"
	    $mmenu(edit) entryconfigure $mmenu(edit-spell) -state normal \
		-command "Ispell_CheckEntireWindow $wh(composeBody)"
	    $mmenu(edit) entryconfigure $mmenu(edit-runcmd) -state normal \
		-command "ComposeSpecifyCmd $handler"
	    lappend wh(eEditBlock) [list $mmenu(main) $mmenu(medit)]
	}
	address {
	    if $option(next_menu) {
		#Info menu
		$mmenu(info) entryconfigure $mmenu(info-keys) -state disabled

		#mailbox menu
		$mmenu(mbox-openmenu) configure -postcommand \
		    "PostFolder dummy $mmenu(mbox-openmenu)"
		$mmenu(mbox) entryconfigure $mmenu(mbox-update) -state disabled
		$mmenu(mbox) entryconfigure $mmenu(mbox-browse) \
		    -state disabled -variable ""
		$mmenu(mbox) entryconfigure $mmenu(mbox-sortorder) \
		    -state disabled
		$mmenu(mbox) entryconfigure $mmenu(mbox-compact) \
		    -state disabled
		$mmenu(mbox) entryconfigure $mmenu(mbox-inc) -state disabled

		# message menu
		$mmenu(main) entryconfigure $mmenu(mmsg) -state disabled

		# Group menu
		$mmenu(main) entryconfigure $mmenu(mgroup) -state disabled

		# Compose menu
		$mmenu(comp-draft) entryconfigure $mmenu(comp-draft-restore) \
		    -state normal -command "ComposeHeld"
		$mmenu(comp-draft) entryconfigure $mmenu(comp-draft-save) \
		    -state disabled
		$mmenu(comp) entryconfigure $mmenu(comp-send) -state disabled
		$mmenu(comp) entryconfigure $mmenu(comp-sendsave) -state disabled
		$mmenu(comp) entryconfigure $mmenu(comp-file) -state disabled
		$mmenu(comp) entryconfigure $mmenu(comp-wrap) -state disabled
		$mmenu(comp) entryconfigure $mmenu(comp-indent) -state disabled
		$mmenu(comp) entryconfigure $mmenu(comp-hdrs) -state disabled
		$mmenu(comp) entryconfigure $mmenu(comp-attach) -state disabled
		$mmenu(comp) entryconfigure $mmenu(comp-reqdsn) -state disabled
		if $option(pgp_enable) {
		    $mmenu(comp) entryconfigure $mmenu(comp-sign) \
			-state disabled
		    $mmenu(comp) entryconfigure $mmenu(comp-crypt) \
			-state disabled
		}
		$mmenu(comp) entryconfigure $mmenu(comp-cmdlst) -state disabled
		$mmenu(comp) entryconfigure $mmenu(comp-abort) -state disabled

		#Edit menu
		$mmenu(main) entryconfigure $mmenu(medit) -state disabled
	    }
	}
	mailbox -
	expressions -
	preferences -
	default {
	    if $option(next_menu) {
		#Info menu
		$mmenu(info) entryconfigure $mmenu(info-keys) -state disabled

		#mailbox menu
		$mmenu(mbox-openmenu) configure -postcommand \
		    "PostFolder dummy $mmenu(mbox-openmenu)"
		$mmenu(mbox) entryconfigure $mmenu(mbox-update) -state disabled
		$mmenu(mbox) entryconfigure $mmenu(mbox-browse) \
		    -state disabled -variable ""
		$mmenu(mbox) entryconfigure $mmenu(mbox-sortorder) \
		    -state disabled
		$mmenu(mbox) entryconfigure $mmenu(mbox-compact) \
		    -state disabled
		$mmenu(mbox) entryconfigure $mmenu(mbox-inc) -state disabled

		# message menu
		$mmenu(main) entryconfigure $mmenu(mmsg) -state disabled

		# Group menu
		$mmenu(main) entryconfigure $mmenu(mgroup) -state disabled

		# Compose menu
		$mmenu(comp-draft) entryconfigure $mmenu(comp-draft-restore) \
		    -state normal -command "ComposeHeld"
		$mmenu(comp-draft) entryconfigure $mmenu(comp-draft-save) \
		    -state disabled
		$mmenu(comp) entryconfigure $mmenu(comp-send) -state disabled
		$mmenu(comp) entryconfigure $mmenu(comp-sendsave) -state disabled
		$mmenu(comp) entryconfigure $mmenu(comp-file) -state disabled
		$mmenu(comp) entryconfigure $mmenu(comp-wrap) -state disabled
		$mmenu(comp) entryconfigure $mmenu(comp-indent) -state disabled
		$mmenu(comp) entryconfigure $mmenu(comp-hdrs) -state disabled
		$mmenu(comp) entryconfigure $mmenu(comp-attach) -state disabled
		$mmenu(comp) entryconfigure $mmenu(comp-reqdsn) -state disabled
		if $option(pgp_enable) {
		    $mmenu(comp) entryconfigure $mmenu(comp-sign) \
			-state disabled
		    $mmenu(comp) entryconfigure $mmenu(comp-crypt) \
			-state disabled
		}
		$mmenu(comp) entryconfigure $mmenu(comp-cmdlst) -state disabled
		$mmenu(comp) entryconfigure $mmenu(comp-abort) -state disabled

		#Edit menu
		$mmenu(main) entryconfigure $mmenu(medit) -state disabled
	    }
	}
    }
    focus $oldFocus
}

# HideAll --
#
# Hide all windows
#
# Arguments:
proc HideAll {} {
    foreach window [winfo children .] {
	if ![string match *_icon $window] {
	    wm withdraw $window
	}
    }
}

# UnHideAll --
#
# Unhide all windows
#
# Arguments:
proc UnHideAll {} {
    foreach window [winfo children .] {
	if ![string match *_icon $window] {
	    wm deiconify $window
	}
    }
}

# FocusOn --
#
# Focus the message selection keys and buttons to the flagged messages
#
# Arguments:
# handler -     The handler which identifies the folder window
proc FocusOn {handler} {
    upvar #0 $handler wh

    RatBind $wh(w) folder_key_next "FolderSelectNext flagged $handler 1"
    RatBind $wh(w) folder_key_prev "FolderSelectNext flagged $handler -1"
    RatBind $wh(w) folder_key_nextu \
	"FolderSelectNext fl_seen $handler 1; break"
    $wh(w).buttons.updown.up configure \
	-command "FolderSelectNext flagged $handler -1"
    $wh(w).buttons.updown.down configure \
	-command "FolderSelectNext flagged $handler 1"
    set wh(focus) 1
    focus $wh(w)
}
# FocusOff --
#
# Unfocus the message selection keys and buttons to the flagged messages
#
# Arguments:
# handler -     The handler which identifies the folder window
proc FocusOff {handler} {
    upvar #0 $handler wh

    RatBind $wh(w) folder_key_next "FolderNext $handler"
    RatBind $wh(w) folder_key_prev "FolderPrev $handler"
    RatBind $wh(w) folder_key_nextu "FolderSelectNext seen $handler 1; break"
    $wh(w).buttons.updown.up configure -command "FolderNext $handler"
    $wh(w).buttons.updown.down configure -command "FolderNext $handler"
    set wh(focus) 0
    focus $wh(w)
}