// ------------------------------------------------------------------------- //
// $Id: logging.cpp,v 1.9 2004/01/06 22:16:09 weismann Exp $
// ------------------------------------------------------------------------- //

/*
 * Copyright (c) 2002 
 *				see AUTHORS list
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#if HAVE_CONFIG_H
# include <config.h>
#endif

#if STDC_HEADERS
# include <stdio.h>
# include <stdlib.h>
#endif
#if HAVE_STDARG_H
# include <stdarg.h>
#endif

#include "logging.h"
#include "common.h"

// ------------------------------------------------------------------------- //
// C++ interface

// under construction - FIXME


// ------------------------------------------------------------------------- //
// C interface

#ifdef __cplusplus
extern "C" {
#endif

unsigned int log_level = 2;		// default log_level

void log_abort(const char *fmt, ...)
{
	va_list ap;

	fprintf(stderr, "(EE) ");
	va_start(ap, fmt);
	vfprintf(stderr, _(fmt), ap);
	va_end(ap);
	fprintf(stderr, "\n");
	exit(1);
}

void log_warning(const char *fmt, ...)
{
	if (log_level >= 1) {
		va_list ap;

		fprintf(stderr, "(WW) ");
		va_start(ap, fmt);
		vfprintf(stderr, _(fmt), ap);
		va_end(ap);
		fprintf(stderr, "\n");
	}
}

void log_info(const char *fmt, ...)
{
	if (log_level >= 2) {
		va_list ap;

		fprintf(stderr, "(II) ");
		va_start(ap, fmt);
		vfprintf(stderr, _(fmt), ap);
		va_end(ap);
		fprintf(stderr, "\n");
	}
}

void log_debug(const char *fmt, ...)
{
	if (log_level >= 3) {
		va_list ap;

		fprintf(stderr, "(DD) ");
		va_start(ap, fmt);
		vfprintf(stderr, _(fmt), ap);
		va_end(ap);
		fprintf(stderr, "\n");
	}
}

#ifdef __cplusplus
}	/* end extern C */
#endif

// ------------------------------------------------------------------------- //
