// ------------------------------------------------------------------------- //
// $Id: clock.cpp,v 1.17 2003/04/01 10:29:08 weismann Exp $
// ------------------------------------------------------------------------- //

/*
 * Copyright (c) 2002 
 *				see AUTHORS list
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* 
 * NOTE:
 * =====
 * Ideas for obtaining a better resolution (if it is required)
 *
 * POSIG.1b: nanosleep and struct timespec instead of struc timeval
 *
 */

#if HAVE_CONFIG_H
# include <config.h>
#endif

#if STDC_HEADERS
# include <stdio.h>
#endif

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#if HAVE_UNISTD_H
# include <unistd.h>
#endif

#ifndef __GNUC__
# ifdef _WIN32
#  include <windows.h>
# endif
#endif

#include "common.h"
#include "clock.h"

#if defined HAVE_PENTIUM && ( defined __GNUC__ || defined _WIN32 )
#ifdef __GNUC__
__inline__ unsigned long long int rdtsc()
{
	unsigned long long int x;
	__asm__ volatile(".byte 0x0f, 0x31" : "=A" (x));
	return x;
}
#else
inline __int64 __fastcall rdtsc()
{
	__int64	count;
	__asm
	{
		pushad
		_emit	0x0f
		_emit	0x31
		lea		ebx,			count
		mov		[ebx],			eax
		mov		[ebx+4],		edx
		popad
	}
	return count;
}
#endif
uint64 Clock::cycles() { return rdtsc(); }
#endif

Clock::Clock()
{
#if defined HAVE_PENTIUM && ( defined __GNUC__ || defined _WIN32 )
	calibrate();
	assert(cycles_per_sec);
#endif
	reset();
}

Clock::~Clock()
{
}

void Clock::print()
{
	log_debug("The time is: %f\n", time());
}

float Clock::time()
{
#if defined HAVE_PENTIUM && ( defined __GNUC__ || defined _WIN32 )
	return (float)(rdtsc()-time_zero)/cycles_per_sec;
	if (rdtsc() > time_zero) { 
		return (float)(rdtsc()-time_zero)/cycles_per_sec;
	}
	else {
		log_warning("Clock::time - fatal event, please report it!!!");
	} 
#else
	struct timezone tz;
	struct timeval tvcurrent;
	memset(&tz, 0, sizeof(tz));
	gettimeofday(&tvcurrent, &tz);
	return (float)(0.000001*((tvcurrent.tv_sec*1000000 + 
			tvcurrent.tv_usec - time_zero)));
#endif
}

void Clock::reset()
{
#if defined HAVE_PENTIUM && ( defined __GNUC__ || defined _WIN32 )
	time_zero = rdtsc();
#else
	struct timezone tz;
	struct timeval tvcurrent;
	memset(&tz, 0, sizeof(tz));
	gettimeofday(&tvcurrent, &tz);
	time_zero = tvcurrent.tv_sec*1000000 + tvcurrent.tv_usec;
#endif
}

void Clock::calibrate()
{
#if defined HAVE_PENTIUM && ( defined __GNUC__ || defined _WIN32 )
	log_debug("Clock::calibrate - using assembler code in the clock!!!");

	uint64 cycles[2];
	unsigned int microsecs;

#ifdef _WIN32
	cycles[0] = rdtsc();
	::Sleep(100);
	cycles[1] = rdtsc();
#else
	struct timezone tz;
	struct timeval tvstart, tvstop;

	memset(&tz, 0, sizeof(tz));
	gettimeofday(&tvstart, &tz);
	cycles[0] = rdtsc();          gettimeofday(&tvstart, &tz);
	usleep(1000);
	cycles[1] = rdtsc();          gettimeofday(&tvstop,  &tz);
#endif

#ifdef _WIN32
	microsecs = 100000;
#else
	microsecs = (tvstop.tv_sec  - tvstart.tv_sec) * 1000000 +
	            (tvstop.tv_usec - tvstart.tv_usec);
#endif
	cycles_per_sec = (uint64)((float)(cycles[1] - 
				cycles[0])/microsecs)*1000000;
#endif
}

