/*  Copyright (C) 2000-2001  MandrakeSoft S.A.
 *
 *    MandrakeSoft S.A.
 *    43, rue d'Aboukir
 *    75002 Paris - France
 *    http://www.linux-mandrake.com/
 *    http://www.mandrakesoft.com/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */


#include "plex86.h"
#define IN_MONITOR_SPACE
#include "monitor.h"




  Bit32u
picIORead(vm_t *vm, Bit32u address, unsigned io_len)
{
  if (io_len > 1) {
    monpanic(vm, "pic: io read from port %04x, len=%u\n", (unsigned) address,
             (unsigned) io_len);
    }

  switch (address) {
    case 0x20:
      if (vm->pic.s.master_pic.read_reg_select) { /* ISR */
        return(vm->pic.s.master_pic.isr);
        }
      else { /* IRR */
        return(vm->pic.s.master_pic.irr);
        }
      break;
    case 0x21:
      return(vm->pic.s.master_pic.imr);
      break;
    case 0xA0:
      if (vm->pic.s.slave_pic.read_reg_select) { /* ISR */
        return(vm->pic.s.slave_pic.isr);
        }
      else { /* IRR */
        return(vm->pic.s.slave_pic.irr);
        }
      break;
    case 0xA1:
      return(vm->pic.s.slave_pic.imr);
      break;
    }

  monpanic(vm, "pic: io read to address %04x\n", (unsigned) address);
}

  void
picIOWrite(vm_t *vm, Bit32u address, Bit32u value, unsigned io_len)
{
  int irq;

  if (io_len > 1) {
    monpanic(vm, "pic: io write to port %04x, len=%u\n", (unsigned) address,
             (unsigned) io_len);
    }

  switch (address) {
    case 0x20:
      if (value & 0x10) { /* initialization command 1 */
            // (mch) Ignore...
            // monprint(vm, "pic:master: init command 1 found %02x\n", (unsigned) value);
        vm->pic.s.master_pic.init.in_init = 1;
        vm->pic.s.master_pic.init.requires_4 = (value & 0x01);
        vm->pic.s.master_pic.init.byte_expected = 2; /* operation command 2 */
        vm->pic.s.master_pic.imr           = 0xFF; /* all IRQ's initially masked */
        vm->pic.s.master_pic.isr           = 0x00; /* no IRQ's in service */
        vm->pic.s.master_pic.irr           = 0x00; /* no IRQ's requested */
        vm->pic.s.master_pic.INT = 0; /* reprogramming clears previous INTR request */
        if ( (value & 0x02) == 1 ) {
          monpanic(vm, "pic:master: init command: single mode\n");
          }
        setINTR(vm, 0);
        return;
        }

      if ( (value & 0x18) == 0x08 ) { /* OCW3 */
        Bit8u special_mask, poll, read_op;

        special_mask = (value & 0x60) >> 5;
        poll         = (value & 0x04) >> 2;
        read_op      = (value & 0x03);
        if (poll)
          monpanic(vm, "pic:master:OCW3: poll bit set\n");
        if (read_op == 0x02) /* read IRR */
          vm->pic.s.master_pic.read_reg_select = 0;
        else if (read_op == 0x03) /* read ISR */
          vm->pic.s.master_pic.read_reg_select = 1;
        if (special_mask == 0x02) { /* cancel special mask */
          vm->pic.s.master_pic.special_mask = 0;
          }
        else if (special_mask == 0x03) { /* set specific mask */
          vm->pic.s.master_pic.special_mask = 1;
          picServiceMaster(vm);
          }
        return;
        }

      /* OCW2 */
      switch (value) {
        case 0x00: // Rotate in Auto-EOI mode
          monpanic(vm, "PIC: Rotate in Auto-EOI mode command received.\n");
        case 0x0A: /* select read interrupt request register */
          vm->pic.s.master_pic.read_reg_select = 0;
          break;
        case 0x0B: /* select read interrupt in-service register */
          vm->pic.s.master_pic.read_reg_select = 1;
          break;

        case 0x20: /* end of interrupt command */
          /* clear highest current in service bit */
          for (irq=0; irq<=7; irq++) {
            if (vm->pic.s.master_pic.isr & (1 << irq)) {
              vm->pic.s.master_pic.isr &= ~(1 << irq);
              break; /* out of for loop */
              }
            }
          picServiceMaster(vm);
          break;

        case 0x60: /* specific EOI 0 */
        case 0x61: /* specific EOI 1 */
        case 0x62: /* specific EOI 2 */
        case 0x63: /* specific EOI 3 */
        case 0x64: /* specific EOI 4 */
        case 0x65: /* specific EOI 5 */
        case 0x66: /* specific EOI 6 */
        case 0x67: /* specific EOI 7 */
          vm->pic.s.master_pic.isr &= ~(1 << (value-0x60));
          picServiceMaster(vm);
          break;

        // IRQ lowest priority commands
        case 0xC0: // 0 7 6 5 4 3 2 1
        case 0xC1: // 1 0 7 6 5 4 3 2
        case 0xC2: // 2 1 0 7 6 5 4 3
        case 0xC3: // 3 2 1 0 7 6 5 4
        case 0xC4: // 4 3 2 1 0 7 6 5
        case 0xC5: // 5 4 3 2 1 0 7 6
        case 0xC6: // 6 5 4 3 2 1 0 7
        case 0xC7: // 7 6 5 4 3 2 1 0
          // ignore for now
          monprint(vm, "pic: IRQ lowest command 0x%x\n", value);
          break;

        default:
          monpanic(vm, "PIC: write to port 20h = %02x\n", value);
        } /* switch (value) */
      break;

    case 0x21:
      /* initialization mode operation */
      if (vm->pic.s.master_pic.init.in_init) {
        switch (vm->pic.s.master_pic.init.byte_expected) {
          case 2:
            vm->pic.s.master_pic.interrupt_offset = value & 0xf8;
            vm->pic.s.master_pic.init.byte_expected = 3;
            return;
            break;
          case 3:
            if (vm->pic.s.master_pic.init.requires_4) {
              vm->pic.s.master_pic.init.byte_expected = 4;
              }
            else {
              vm->pic.s.master_pic.init.in_init = 0;
              }
            return;
            break;
          case 4:
            if (value & 0x01) {
              }
            else
              monpanic(vm, "pic:        not 80x86 mode\n");
            vm->pic.s.master_pic.init.in_init = 0;
            return;
            break;
          default:
            monpanic(vm, "pic:master expecting bad init command\n");
          }
        }

      /* normal operation */
      vm->pic.s.master_pic.imr = value;
      picServiceMaster(vm);
      return;
      break;

    case 0xA0:
      if (value & 0x10) { /* initialization command 1 */
        vm->pic.s.slave_pic.init.in_init = 1;
        vm->pic.s.slave_pic.init.requires_4 = (value & 0x01);
        vm->pic.s.slave_pic.init.byte_expected = 2; /* operation command 2 */
        vm->pic.s.slave_pic.imr           = 0xFF; /* all IRQ's initially masked */
        vm->pic.s.slave_pic.isr           = 0x00; /* no IRQ's in service */
        vm->pic.s.slave_pic.irr           = 0x00; /* no IRQ's requested */
        vm->pic.s.slave_pic.INT = 0; /* reprogramming clears previous INTR request */
        if ( (value & 0x02) == 1 )
          monpanic(vm, "pic:slave: init command: single mode\n");
        return;
        }

      if ( (value & 0x18) == 0x08 ) { /* OCW3 */
        Bit8u special_mask, poll, read_op;

        special_mask = (value & 0x60) >> 5;
        poll         = (value & 0x04) >> 2;
        read_op      = (value & 0x03);
        if (poll)
          monpanic(vm, "pic:slave:OCW3: poll bit set\n");
        if (read_op == 0x02) /* read IRR */
          vm->pic.s.slave_pic.read_reg_select = 0;
        else if (read_op == 0x03) /* read ISR */
          vm->pic.s.slave_pic.read_reg_select = 1;
        if (special_mask == 0x02) { /* cancel special mask */
          vm->pic.s.slave_pic.special_mask = 0;
          }
        else if (special_mask == 0x03) { /* set specific mask */
          vm->pic.s.slave_pic.special_mask = 1;
          picServiceSlave(vm);
          monprint(vm, "pic:slave: OCW3 not implemented (%02x)\n",
            (unsigned) value);
          }
        return;
        }

      switch (value) {
        case 0x0A: /* select read interrupt request register */
          vm->pic.s.slave_pic.read_reg_select = 0;
          break;
        case 0x0B: /* select read interrupt in-service register */
          vm->pic.s.slave_pic.read_reg_select = 1;
          break;
        case 0x20: /* end of interrupt command */
          /* clear highest current in service bit */
          for (irq=0; irq<=7; irq++) {
            if (vm->pic.s.slave_pic.isr & (1 << irq)) {
              vm->pic.s.slave_pic.isr &= ~(1 << irq);
              break; /* out of for loop */
              }
            }
          picServiceSlave(vm);
          break;

        case 0x60: /* specific EOI 0 */
        case 0x61: /* specific EOI 1 */
        case 0x62: /* specific EOI 2 */
        case 0x63: /* specific EOI 3 */
        case 0x64: /* specific EOI 4 */
        case 0x65: /* specific EOI 5 */
        case 0x66: /* specific EOI 6 */
        case 0x67: /* specific EOI 7 */
          vm->pic.s.slave_pic.isr &= ~(1 << (value-0x60));
          picServiceSlave(vm);
          break;

        default:
          monpanic(vm, "PIC: write to port A0h = %02x\n", value);
        } /* switch (value) */
      break;

    case 0xA1:
      /* initialization mode operation */
      if (vm->pic.s.slave_pic.init.in_init) {
        switch (vm->pic.s.slave_pic.init.byte_expected) {
          case 2:
            vm->pic.s.slave_pic.interrupt_offset = value & 0xf8;
            vm->pic.s.slave_pic.init.byte_expected = 3;
            return;
            break;
          case 3:
            if (vm->pic.s.slave_pic.init.requires_4) {
              vm->pic.s.slave_pic.init.byte_expected = 4;
              }
            else {
              vm->pic.s.slave_pic.init.in_init = 0;
              }
            return;
            break;
          case 4:
            if (value & 0x01) {
              }
            else
              monpanic(vm, "pic: not 80x86 mode\n");
            vm->pic.s.slave_pic.init.in_init = 0;
            return;
            break;
          default:
            monpanic(vm, "pic:slave: expecting bad init command\n");
          }
        }

      /* normal operation */
      vm->pic.s.slave_pic.imr = value;
      picServiceSlave(vm);
      return;
      break;
    } /* switch (address) */

  return;
}
