#include "dt.h"

/* Area for storing handler values */
unsigned handler_DS;
unsigned handler_ESP;
unsigned handler_target_EIP;

/* Area for storing guest values */
unsigned guest_SS;
unsigned guest_ESP;
unsigned guest_EIP;

unsigned char handler_stack_area[HANDLER_STACK_SIZE];


asm (
  ".text \n\t"
  ".globl __r3h_branch \n\t"
  "__r3h_branch:       \n\t"
  /* Save guest context modified by the handler */
  "  pushl %ds \n\t" /* Save guest DS/ES since handler needs to use these */
  "  pushl %es \n\t" /* and sets them to its own segment. */
  "  pushal    \n\t" /* Save guest general registers. */
  "  pushfl    \n\t" /* Save guest eflags */

  "  mov  %ss, %ax   \n\t" /* Copy handler SS to {DS,ES}. */
  "  mov  %ax, %ds   \n\t"
  "  mov  %ax, %es   \n\t"
  "  cld             \n\t"
  "  call r3h_branch \n\t" /* Call C handler */

  /* Restore guest context modified by the handler */
  "  popfl    \n\t" /* Restore guest eflags */
  "  popal    \n\t" /* Restore guest general registers */
  "  popl %es \n\t" /* Restore guest DS/ES segments which were modified */
  "  popl %ds \n\t" /* for use by handler. */

  "  cs; mov guest_SS,  %ss         \n\t"
  "  cs; mov guest_ESP, %esp        \n\t"
  "  cs; jmp *(handler_target_EIP)  \n\t"
  );



/* This represents the C component of the dynamic branch convenience
 * routine.  I just pretend the targets of the branches are already
 * translated in the cache, and use a simple switch statement to
 * get the translated code address.  Real table lookup logic would
 * go here.  This should be coded extremely efficiently, as it will
 * be executed a lot.
 *
 * If we opened the code cache pages and related tables up for write
 * permissions from ring3 (and thus the ring3 convenience handlers),
 * conceivably we could code the translation here, kicking in upon
 * cache misses.  Otherwise, we would defer to the monitor at ring0.
 */

  void
r3h_branch(gc_t gc, unsigned target_offset)
{
  switch (target_offset) {
    case 0xa0000001:
      handler_target_EIP = (unsigned) __seq0001;
      break;
    case 0xa0000002:
      handler_target_EIP = (unsigned) __seq0002;
      break;
    case 0xa0000003:
      handler_target_EIP = (unsigned) __seq0003;
      break;
    case 0xa0000004:
      handler_target_EIP = (unsigned) __seq0004;
      break;

    default:
      handler_target_EIP = (unsigned) __exit_bad;
      break;
    }
}
