<?php
	/**************************************************************************\
	* phpGroupWare - Todo list                                                 *
	* http://www.phpgroupware.org                                              *
    * Written by Joseph Engo <jengo@phpgroupware.org>                          *
	*            Bettina Gille [ceb@phpgroupware.org]                          *
	* -----------------------------------------------                          *
	*  This program is free software; you can redistribute it and/or modify it *
	*  under the terms of the GNU General Public License as published by the   *
	*  Free Software Foundation; either version 2 of the License, or (at your  *
	*  option) any later version.                                              *
	\**************************************************************************/
	/* $Id: class.ui.inc.php,v 1.2 2002/01/07 10:50:42 seek3r Exp $ */

	class ui
	{
		var $grants;
		var $historylog;
		var $public_functions = array
		(
			'show_list'	=> True,
			'view'      => True,
			'add'       => True,
			'edit'      => True,
			'delete'		=> True,
			'matrix'		=> True
		);

		function ui()
		{
			$this->bo     = CreateObject('todo.bo',True);
			$this->nextmatchs = CreateObject('phpgwapi.nextmatchs');
			$this->historylog = CreateObject('phpgwapi.historylog','todo');
			$this->historylog->types = array(
				'A' => lang('Entry added'),
				'C' => lang('Category changed'),
				'S' => lang('Start date changed'),
				'E' => lang('End date changed'),
				'U' => lang('Urgency changed'),
				's' => lang('Status changed'),
				'T' => lang('Title changed'),
				'D' => lang('Description changed'),
				'a' => lang('Access changed'),
				'P' => lang('Parent changed')
			);

			$this->historylog->alternate_handlers = array(
				'S' => '$GLOBALS[\'phpgw\']->common->show_date',
				'E' => '$GLOBALS[\'phpgw\']->common->show_date',
				'C' => '$GLOBALS[\'phpgw\']->categories->id2name'
			);

			$this->cats       = CreateObject('phpgwapi.categories');
			$GLOBALS['phpgw']->categories = $this->cats;
			$this->sbox       = CreateObject('phpgwapi.sbox');
			$this->matrix     = CreateObject('phpgwapi.matrixview');
			$this->account    = $GLOBALS['phpgw_info']['user']['account_id'];
			$this->t          = $GLOBALS['phpgw']->template;
			$this->grants     = $GLOBALS['phpgw']->acl->get_grants('todo');
			$this->grants[$this->account]	= PHPGW_ACL_READ + PHPGW_ACL_ADD + PHPGW_ACL_EDIT + PHPGW_ACL_DELETE;

			$this->start      = $this->bo->start;
			$this->query      = $this->bo->query;
			$this->filter     = $this->bo->filter;
			$this->order      = $this->bo->order;
			$this->sort       = $this->bo->sort;
			$this->cat_id     = $this->bo->cat_id;
		}

		function save_sessiondata()
		{
			$data = array
			(
				'start'		=> $this->start,
				'query'		=> $this->query,
				'filter'	=> $this->filter,
				'order'		=> $this->order,
				'sort'		=> $this->sort,
				'cat_id'	=> $this->cat_id
			);
			$this->bo->save_sessiondata($data);
		}

		function set_app_langs()
		{
			$this->t->set_var('th_bg',$GLOBALS['phpgw_info']['theme']['th_bg']);
			$this->t->set_var('lang_category',lang('Category'));
			$this->t->set_var('lang_select',lang('Select'));
			$this->t->set_var('lang_descr',lang('Description'));
			$this->t->set_var('lang_title',lang('Title'));
			$this->t->set_var('lang_none',lang('None'));
			$this->t->set_var('lang_urgency',lang('Urgency'));
			$this->t->set_var('lang_completed',lang('completed'));
			$this->t->set_var('lang_start_date',lang('Start Date'));
			$this->t->set_var('lang_end_date',lang('End Date'));
			$this->t->set_var('lang_date_due',lang('date due'));
			$this->t->set_var('lang_access',lang('Private'));
			$this->t->set_var('lang_parent',lang('Parent project'));
		}

		function show_list()
		{
			$GLOBALS['phpgw']->common->phpgw_header();
			echo parse_navbar();

			$this->t->set_file(array('todo_list_t' => 'list.tpl'));
			$this->t->set_block('todo_list_t','todo_list','list');

			$this->set_app_langs();

			$this->t->set_var(lang_action,lang('todo list'));
			$this->t->set_var('lang_all',lang('All'));

			if (!$this->start)
			{
				$this->start = 0;
			}

			$todo_list = $this->bo->_list($this->start, True, $this->query,$this->filter,$this->order,$this->sort,$this->cat_id,'all');

// --------------------- nextmatch variable template-declarations ------------------------

			$left = $this->nextmatchs->left('/index.php',$this->start,$this->bo->total_records,'&menuaction=todo.ui.show_list');
			$right = $this->nextmatchs->right('/index.php',$this->start,$this->bo->total_records,'&menuaction=todo.ui.show_list');
			$this->t->set_var('left',$left);
			$this->t->set_var('right',$right);

			$this->t->set_var('total_matchs',$this->nextmatchs->show_hits($this->bo->total_records,$this->start));

// ------------------------- end nextmatch template --------------------------------------

            $this->t->set_var('cat_action',$GLOBALS['phpgw']->link('/index.php','menuaction=todo.ui.show_list'));
			$this->t->set_var('categories',$this->cats->formated_list('select','all',$this->cat_id,'True'));
            $this->t->set_var('filter_action',$GLOBALS['phpgw']->link('/index.php','menuaction=todo.ui.show_list'));
            $this->t->set_var('filter_list',$this->nextmatchs->filter(1,1));
            $this->t->set_var('search_action',$GLOBALS['phpgw']->link('/index.php','menuaction=todo.ui.show_list'));
            $this->t->set_var('search_list',$this->nextmatchs->search(1));

// ---------------- list header variable template-declarations --------------------------

    		$this->t->set_var(sort_status,$this->nextmatchs->show_sort_order($this->sort,'todo_status',$this->order,'/todo/index.php',lang('Status')));
    		$this->t->set_var(sort_urgency,$this->nextmatchs->show_sort_order($this->sort,'todo_pri',$this->order,'/todo/index.php',lang('Urgency')));
    		$this->t->set_var(sort_title,$this->nextmatchs->show_sort_order($this->sort,'todo_title',$this->order,'/todo/index.php',lang('title')));
    		$this->t->set_var(sort_lastupdated,$this->nextmatchs->show_sort_order($this->sort,'todo_startdate',$this->order,'/todo/index.php',lang('start date')));
    		$this->t->set_var(sort_datedue,$this->nextmatchs->show_sort_order($this->sort,'todo_enddate',$this->order,'/todo/index.php',lang('end date')));
    		$this->t->set_var(sort_owner,$this->nextmatchs->show_sort_order($this->sort,'todo_owner',$this->order,'/todo/index.php',lang('created by')));
    		$this->t->set_var(h_lang_sub,lang('Add Sub'));
    		$this->t->set_var(h_lang_view,lang('View'));
    		$this->t->set_var(h_lang_edit,lang('Edit'));
    		$this->t->set_var(h_lang_delete,lang('Delete'));

// -------------- end header declaration --------------------------------------- 

			for ($i=0;$i<count($todo_list);$i++)
			{
				$this->nextmatchs->template_alternate_row_color(&$this->t);
				$level = $todo_list[$i]['level'];

				$title = $GLOBALS['phpgw']->strip_html($todo_list[$i]['title']); 

				if (!$title)
				{
					$words = split(' ',$GLOBALS['phpgw']->strip_html($todo_list[$i]['descr']));
					$title = "$words[0] $words[1] $words[2] $words[3] ...";
				}

				if ($level == 0)
				{
					$title = '<font color="FF0000"><b>' . $title . '</b></font>';
				}
				else
				{
					$space = '&nbsp;&nbsp;';
					$spaceset = str_repeat($space,$level);
					$title = $spaceset . $title;
				}

				switch ($todo_list[$i]['pri'])
				{
					case 1: $pri = lang('Low'); break;
					case 2: $pri = '<b>' . lang('normal') . '</b>'; break;
					case 3: $pri = '<font color="CC0000">' . lang('high') . '</font>'; break;
				}

				if ($todo_list[$i]['edate'] == 0)
				{
					$datedueout = '&nbsp;';
				}
				else
				{

					$datedue = $todo_list[$i]['edate'];
					$month	= $GLOBALS['phpgw']->common->show_date(time(),'n');
					$day	= $GLOBALS['phpgw']->common->show_date(time(),'d');
					$year	= $GLOBALS['phpgw']->common->show_date(time(),'Y');
					$currentdate = mktime(2,0,0,$month,$day,$year);

					$datedue = $datedue + (60*60) * $GLOBALS['phpgw_info']['user']['preferences']['common']['tz_offset'];
					if ($currentdate >= $datedue)
					{
						$datedueout =  '<font color="CC0000">';
					}
					else
					{
						$datedueout = '';
					}

					$datedueout .= $todo_list[$i]['edate'];
					if ($currentdate >= $datedue)
					{
						$datedueout .= '</font>';
					}
				}

//				$cached_data = $this->bo->cached_accounts($todo_list[$i]['owner']);			

				$ownerout = $todo_list[$i]['owner']; //$phpgw->strip_html($cached_data[$todo_list[$i]['owner']]['account_lid']
//										. ' <' . $cached_data[$todo_list[$i]['owner']]['firstname'] . ' '
//										. $cached_data[$todo_list[$i]['owner']]['lastname'] . '>');

// --------------- template declaration for list records -------------------------------------

 				$this->t->set_var(array
				(
					'status'		=> $todo_list[$i]['status'],
					'pri'			=> $pri,
					'title'			=> $title,
					'datecreated'	=> $todo_list[$i]['sdate'],
					'datedue'		=> $datedueout,
					'owner'			=> $ownerout
				));

				$this->t->set_var('view','<a href="' . $GLOBALS['phpgw']->link('/index.php','menuaction=todo.ui.view&todo_id=' . $todo_list[$i]['id'])
					. '">' . lang('View') . '</a>');

				if ($this->bo->check_perms($this->grants[$todo_list[$i]['owner_id']],PHPGW_ACL_EDIT))
				{
					$this->t->set_var('edit','<a href="' . $GLOBALS['phpgw']->link('/index.php','menuaction=todo.ui.edit&todo_id=' . $todo_list[$i]['id'])
											. '">' . lang('Edit') . '</a>');
				}
				else
				{
					$this->t->set_var('edit','&nbsp;');
				}

				if ($this->bo->check_perms($this->grants[$todo_list[$i]['owner_id']],PHPGW_ACL_DELETE))
				{
					$this->t->set_var('delete','<a href="' . $GLOBALS['phpgw']->link('/index.php','menuaction=todo.ui.delete&todo_id=' . $todo_list[$i]['id'])
												. '">' . lang('Delete') . '</a>');
				}
				else
				{
					$this->t->set_var('delete','&nbsp;');
				}

				if ($this->bo->check_perms($this->grants[$todo_list[$i]['owner_id']],PHPGW_ACL_ADD))
				{
					$this->t->set_var('subadd', '<a href="' . $GLOBALS['phpgw']->link('/index.php','menuaction=todo.ui.add&parent=' . $todo_list[$i]['id']
																. '&cat_id=' . $this->cat_id) . '">' . lang('Add Sub') . '</a>');
				}
				else
				{
					$this->t->set_var('subadd','&nbsp;');
				}

				$this->t->parse('list','todo_list',True);
			}

// ------------------------- end record declaration ------------------------

// --------------- template declaration for Add Form --------------------------

			if ($this->cat_id && $this->cat_id != 0)
			{
				$cat = $this->cats->return_single($this->cat_id);
			}

			if ($cat[0]['app_name'] == 'phpgw' || !$this->cat_id)
			{
				$this->t->set_var('add','<form method="POST" action="' . $GLOBALS['phpgw']->link('/index.php','menuaction=todo.ui.add&cat_id=' . $this->cat_id)
										. '"><input type="submit" name="Add" value="' . lang('Add') .'"></form>');
			}
			else
			{
				if ($this->bo->check_perms($this->grants[$cat[0]['owner']],PHPGW_ACL_ADD) || $cat[0]['owner'] == $this->account)
				{
					$this->t->set_var('add','<form method="POST" action="' . $GLOBALS['phpgw']->link('/index.php','menuaction=todo.ui.add&cat_id=' . $this->cat_id)
											. '"><input type="submit" name="Add" value="' . lang('Add') .'"></form>');
				}
				else
				{
					$this->t->set_var('add','');
				}
			}

// ----------------------- end Add form declaration ----------------------------

// ------------ get actual date and year for matrixview arguments --------------

			$year = date('Y');
			$month = date('m');

			$this->t->set_var('matrixview',$GLOBALS['phpgw']->common->check_owner($this->account,'/index.php',
								lang('View matrix of actual month'),'menuaction=todo.ui.matrix&month=' . $month . '&year=' . $year));

			$this->t->pfp('out','todo_list_t',True);
			$this->save_sessiondata();
		}

		function add()
		{
			global $cat_id, $new_cat, $values, $submit, $new_parent, $parent;

			if ($new_parent)
			{
				$parent = $new_parent;
			}

			if ($new_cat)
			{
				$cat_id = $new_cat;
			}

			if ($submit)
			{
				$values['cat'] = $cat_id;
				$values['parent'] = $parent;

				$error = $this->bo->check_values($values);
				if (is_array($error))
				{
					$this->t->set_var('error',$GLOBALS['phpgw']->common->error_list($error));
				}
				else
				{
					$this->bo->save($values);
					Header('Location: ' . $GLOBALS['phpgw']->link('/index.php','menuaction=todo.ui.show_list&cat_id=' . $cat_id));
				}
			}

			$GLOBALS['phpgw']->common->phpgw_header();
			echo parse_navbar();

			$this->t->set_file('todo_add','form.tpl');
			$this->t->set_block('todo_add','add','addhandle');
			$this->t->set_block('todo_add','edit','edithandle');

			$this->set_app_langs();
			$this->t->set_var('actionurl',$GLOBALS['phpgw']->link('/index.php','menuaction=todo.ui.add'));

			if ($parent)
			{
				$this->t->set_var('lang_todo_action',lang('Add sub project'));
			}
			else
			{
				$this->t->set_var('lang_todo_action',lang('Add main project'));
			}

			$this->t->set_var('cat_list',$this->cats->formated_list('select','all',$cat_id,'True'));
			$this->t->set_var('todo_list',$this->bo->select_todo_list($parent));

			$this->t->set_var('descr',$values['descr']);

			$this->t->set_var('pri_list',$this->sbox->getPriority('values[pri]'));
			$this->t->set_var('stat_list',$this->sbox->getPercentage('values[status]',0));

			if (!$values['smonth'])
			{
				$values['smonth'] = date('m',time());
			}

			if (!$values['sday'])
			{
				$values['sday'] = date('d',time());
			}

			if (!$values['syear'])
			{
				$values['syear'] = date('Y',time());
			}

			$this->t->set_var('start_select_date',$GLOBALS['phpgw']->common->dateformatorder($this->sbox->getYears('values[syear]',$values['syear']),
										$this->sbox->getMonthText('values[smonth]',$values['smonth']),$this->sbox->getDays('values[sday]',$values['sday'])));
			$this->t->set_var('end_select_date',$GLOBALS['phpgw']->common->dateformatorder($this->sbox->getYears('values[eyear]',$values['eyear']),
										$this->sbox->getMonthText('values[emonth]',$values['emonth']),$this->sbox->getDays('values[eday]',$values['eday'])));

			$this->t->set_var('selfortoday','<input type="checkbox" name="values[seltoday]" value="True">');

			$this->t->set_var('daysfromstartdate','<input type="text" name="values[daysfromstart]" size="3" maxlength="3">');

			$this->t->set_var('access_list', '<input type="checkbox" name="values[access]" value="True"' . ($values['access'] == 'private'?' checked':'') . '>');

			$this->t->set_var('lang_selfortoday',lang('or: select for today:'));
			$this->t->set_var('lang_daysfromstartdate',lang('or: days from startdate:'));
			$this->t->set_var('lang_submit',lang('Submit'));
			$this->t->set_var('lang_reset',lang('Clear form'));
			$this->t->set_var('edithandle','');
			$this->t->set_var('addhandle','');
			$this->t->pfp('out','todo_add');
			$this->t->pfp('addhandle','add');
		}

		function view()
		{
			$GLOBALS['phpgw']->common->phpgw_header();
			echo parse_navbar();

			$values = $this->bo->read($GLOBALS['todo_id']);
			$this->t->set_file('_view','view.tpl');

			$this->t->set_var('lang_todo_action',lang('View todo item'));

			$this->t->set_var('lang_title',lang('Title'));
			$this->t->set_var('value_title',$values['title']);

			$this->t->set_var('lang_descr',lang('Description'));
			$this->t->set_var('value_descr',$values['descr']);

			$this->t->set_var('lang_start_date',lang('Start date'));
			$this->t->set_var('value_start_date',$GLOBALS['phpgw']->common->show_date($values['sdate'],$GLOBALS['phpgw_info']['user']['preferences']['common']['dateformat']));

			$this->t->set_var('lang_end_date',lang('End date'));
			$this->t->set_var('value_start_date',$GLOBALS['phpgw']->common->show_date($values['edate'],$GLOBALS['phpgw_info']['user']['preferences']['common']['dateformat']));

			$parent_values = $this->bo->read($values['parent']);
			$this->t->set_var('lang_parent',lang('Parent'));
			$this->t->set_var('value_parent',$parent_values['title']);

			$this->t->set_var('lang_completed',lang('Completed'));
			$this->t->set_var('value_completed',$values['status']);


			switch ($values['pri'])
			{
				case 1: $pri = lang('Low'); break;
				case 2: $pri = lang('normal'); break;
				case 3: $pri = '<font color="CC0000">' . lang('high') . '</font>'; break;
			}

			$this->t->set_var('lang_urgency',lang('Urgency'));
			$this->t->set_var('value_urgency',$pri);

			$this->t->set_var('lang_access',lang('Access'));

			$this->t->set_var('history',$this->historylog->return_html(array(),'','',$GLOBALS['todo_id']));
			$this->t->pfp('out','_view');
		}

		function edit()
		{
			global $cat_id, $new_cat, $values, $submit, $new_parent, $parent, $todo_id;

			if ($new_parent)
			{
				$parent = $new_parent;
			}

			if ($new_cat)
			{
				$cat_id = $new_cat;
			}

            if ($submit)
            {
                $values['cat'] = $cat_id;
                $values['parent'] = $parent;
                $values['id'] = $todo_id;

				$error = $this->bo->check_values($values);
				if (is_array($error))
				{
					$this->t->set_var('error',$GLOBALS['phpgw']->common->error_list($error));
				}
				else
				{
					$this->bo->save($values,'edit');
					Header('Location: ' . $GLOBALS['phpgw']->link('/index.php','menuaction=todo.ui.show_list&cat_id=' . $cat_id));
				}
			}

			$GLOBALS['phpgw']->common->phpgw_header();
			echo parse_navbar();

			$this->t->set_file(array('todo_edit' => 'form.tpl'));
			$this->t->set_block('todo_edit','add','addhandle');
			$this->t->set_block('todo_edit','edit','edithandle');

			$this->set_app_langs();
			$this->t->set_var('actionurl',$GLOBALS['phpgw']->link('/index.php','menuaction=todo.ui.edit&todo_id=' . $todo_id));

			$values = $this->bo->read($todo_id);

			if ($values['parent'] != 0)
			{
				$this->t->set_var('lang_todo_action',lang('Edit sub project'));
			}
			else
			{
				$this->t->set_var('lang_todo_action',lang('Edit main project'));
			}

			$this->t->set_var('cat_list',$this->cats->formated_list('select','all',$values['cat'],'True'));
			$this->t->set_var('todo_list',$this->bo->select_todo_list($values['parent']));

			$this->t->set_var('descr',$GLOBALS['phpgw']->strip_html($values['descr']));
			$this->t->set_var('title',$GLOBALS['phpgw']->strip_html($values['title']));

			$this->t->set_var('pri_list',$this->sbox->getPriority('values[pri]',$values['pri']));
			$this->t->set_var('stat_list',$this->sbox->getPercentage('values[status]',$values['status']));

			if ($values['sdate'] == 0)
			{
				$values['sday'] = 0;
				$values['smonth'] = 0;
				$values['syear'] = 0;
			}
			else
			{
				$values['sday'] = date('d',$values['sdate']);
				$values['smonth'] = date('m',$values['sdate']);
				$values['syear'] = date('Y',$values['sdate']);
			}

			$this->t->set_var('start_select_date',$GLOBALS['phpgw']->common->dateformatorder($this->sbox->getYears('values[syear]',$values['syear']),
										$this->sbox->getMonthText('values[smonth]',$values['smonth']),$this->sbox->getDays('values[sday]',$values['sday'])));

			if ($values['edate'] == 0)
			{
				$values['eday'] = 0;
				$values['emonth'] = 0;
				$values['eyear'] = 0;
			}
			else
			{
				$values['eday'] = date('d',$values['edate']);
				$values['emonth'] = date('m',$values['edate']);
				$values['eyear'] = date('Y',$values['edate']);
			}

			$this->t->set_var('end_select_date',$GLOBALS['phpgw']->common->dateformatorder($this->sbox->getYears('values[eyear]',$values['eyear']),
										$this->sbox->getMonthText('values[emonth]',$values['emonth']),$this->sbox->getDays('values[eday]',$values['eday'])));

			$this->t->set_var('selfortoday','&nbsp;');
			$this->t->set_var('lang_selfortoday','&nbsp;');
			$this->t->set_var('lang_daysfromstartdate','&nbsp;');
			$this->t->set_var('daysfromstartdate','&nbsp;');

			$this->t->set_var('access_list', '<input type="checkbox" name="values[access]" value="True"' . ($values['access'] == 'private'?' checked':'') . '>');

			if ($this->bo->check_perms($this->grants[$values['owner']],PHPGW_ACL_DELETE) || $values['owner'] == $this->account)
			{
				$this->t->set_var('delete','<form method="POST" action="' . $GLOBALS['phpgw']->link('/index.php','menuaction=todo.ui.delete&todo_id=' . $values['id'])
                                    . '"><input type="submit" value="' . lang('Delete') .'"></form>');
			}
			else
			{
				$this->t->set_var('delete','&nbsp;');
			}

			$this->t->set_var('lang_submit',lang('Submit'));
			$this->t->set_var('edithandle','');
			$this->t->set_var('addhandle','');
			$this->t->pfp('out','todo_edit');
			$this->t->pfp('edithandle','edit');
		}

		function delete()
		{
			global $confirm, $todo_id, $subs;

			if ($confirm)
			{
				if ($subs)
				{
					$this->bo->delete_todo($todo_id,True);
				}
				else
				{
					$this->bo->delete($todo_id);
				}
				Header('Location: ' . $GLOBALS['phpgw']->link('/index.php','menuaction=todo.ui.show_list'));
			}

			$GLOBALS['phpgw']->common->phpgw_header();
			echo parse_navbar();

			$this->t->set_file(array('todo_delete' => 'delete.tpl'));
			$this->t->set_var('actionurl',$GLOBALS['phpgw']->link('/index.php','menuaction=todo.ui.delete&todo_id=' . $todo_id));

			$exists = $this->bo->exists($todo_id);

			if ($exists)
			{
				$this->t->set_var('lang_subs',lang('Do you also want to delete all sub projects ?'));
				$this->t->set_var('subs','<input type="checkbox" name="subs" value="True">');
			}
			else
			{
				$this->t->set_var('lang_subs','');
				$this->t->set_var('subs', '');
			}

			$this->t->set_var('nolink',$GLOBALS['phpgw']->link('/index.php','menuaction=todo.ui.show_list'));
			$this->t->set_var('deleteheader',lang('Are you sure you want to delete this entry'));
			$this->t->set_var('lang_no',lang('No'));
			$this->t->set_var('lang_yes',lang('Yes'));

			$this->t->pfp('out','todo_delete');
		}

		function matrix()
		{
			global $month, $year, $o;

			$GLOBALS['phpgw']->common->phpgw_header();
			echo parse_navbar();

			$colors = array
			(
				'#CC0033',
				'#006600',
				'#00CCFF',
				'#FF6600',
				'#0000FF'
			);

			$this->matrix->matrixview($month,$year);

			$entries = $this->bo->_list($start,False,$query,$filter,$order,$sort,$cat_id,'mains');

			for ($i=0;$i<count($entries);$i++)
			{
				$o++;
				$ind = $o % count($colors);

				if ($entries[$i]['sdate'] > 0 && $entries[$i]['edate'] > 0)
				{
					$startd = date('Y',$entries[$i]['sdate']) . date('m',$entries[$i]['sdate']) . date('d',$entries[$i]['sdate']);
					$endd = date('Y',$entries[$i]['edate']) . date('m',$entries[$i]['edate']) . date('d',$entries[$i]['edate']);
					$this->matrix->setPeriod($GLOBALS['phpgw']->strip_html($entries[$i]['descr']),$startd,$endd,$colors[$ind]);

					$subentries = $this->bo->_list($start,False,$query,$filter,$order,$sort,$cat_id,'subs',$entries[$i]['id']);
					for ($j=0;$j<count($subentries);$j++)
					{
						if ($subentries[$j]['sdate'] > 0 && $subentries[$j]['edate'] > 0)
						{
							$startd = date('Y',$subentries[$j]['sdate']) . date('m',$subentries[$j]['sdate']) . date('d',$subentries[$j]['sdate']);                                                        
                    		$endd = date('Y',$subentries[$j]['edate']) . date('m',$subentries[$j]['edate']) . date('d',$subentries[$j]['edate']);                                                          
                    		$this->matrix->setPeriod($GLOBALS['phpgw']->strip_html($subentries[$j]['descr']),$startd,$endd,$colors[$ind]);
						}
					}
				}
			}

			$this->matrix->out($GLOBALS['phpgw']->link('/index.php','menuaction=todo.ui.matrix'));

		}
	}
?>
