<?php
	/**************************************************************************\
	* phpGroupWare - Inventory                                                 *
	* http://www.phpgroupware.org                                              *
	* Written by Bettina Gille [ceb@phpgroupware.org]                          *
	* -----------------------------------------------                          *
	* This program is free software; you can redistribute it and/or modify it  *
	* under the terms of the GNU General Public License as published by the    *
	* Free Software Foundation; either version 2 of the License, or (at your   *
	* option) any later version.                                               *
	\**************************************************************************/
	/* $Id: viewproduct.php,v 1.12 2001/07/03 12:10:00 bettina Exp $ */

	if ($submit || !$con)
	{
		$phpgw_info['flags'] = array('noheader' => True,
									'nonavbar' => True);
	}
    
	if (! $con)
	{
		Header('Location: ' . $HTTP_REFERER);
		$phpgw->common->phpgw_exit();
	}

	$phpgw_info['flags']['currentapp'] = 'inv';
	include('../header.inc.php');

	$t = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
	$t->set_file(array('view' => 'view_product.tpl'));

	$hidden_vars = '<input type="hidden" name="sort" value="' . $sort . '">' . "\n"
				. '<input type="hidden" name="order" value="' . $order . '">' . "\n"
				. '<input type="hidden" name="query" value="' . $query . '">' . "\n"
				. '<input type="hidden" name="start" value="' . $start . '">' . "\n"
				. '<input type="hidden" name="filter" value="' . $filter . '">' . "\n"
				. '<input type="hidden" name="con" value="' . $con . '">' . "\n";

	$c = CreateObject('phpgwapi.categories');
	$d = CreateObject('phpgwapi.contacts');

	if (isset($phpgw_info['user']['preferences']['common']['currency']))
	{
		$currency = $phpgw_info['user']['preferences']['common']['currency'];
		$t->set_var('error','');
	}
	else { $t->set_var('error',lang('Please set your preferences for this application !')); }

	$t->set_var('lang_action',lang('View product'));
	$t->set_var('hidden_vars',$hidden_vars);
	$t->set_var('lang_id',lang('Product ID'));
	$t->set_var('lang_short_name',lang('Short name'));
	$t->set_var('lang_url',lang('WWW'));
	$t->set_var('lang_ftp',lang('FTP'));
	$t->set_var('lang_description',lang('Description'));
	$t->set_var('lang_purchase_date',lang('Purchase date'));
	$t->set_var('lang_selling_date',lang('Selling date'));
	$t->set_var('lang_category',lang('Category'));
	$t->set_var('lang_in_stock',lang('in Stock'));
	$t->set_var('lang_min_stock',lang('min Stock'));
	$t->set_var('lang_cost',lang('Purchase price'));
	$t->set_var('lang_price',lang('Selling price'));
	$t->set_var('lang_retail',lang('Retail'));
	$t->set_var('lang_status',lang('Status'));
	$t->set_var('lang_serial',lang('Serial number'));  
	$t->set_var('lang_distributor',lang('Distributor'));  
	$t->set_var('currency',$currency);  

	$phpgw->db->query("select * from phpgw_inv_products where con='$con'");
	$phpgw->db->next_record();

	$t->set_var('cat_name',$c->id2name($phpgw->db->f('category'),'name'));

	$cols = array('org_name' => 'org_name');
	$entry = $d->read_single_entry($phpgw->db->f('dist'),$cols);
	$t->set_var('dist',$entry[0]['org_name']);

	$price = $phpgw->db->f('price');
	$category = $phpgw->db->f('category');
	$pdate = $phpgw->db->f('pdate');
	$sdate = $phpgw->db->f('sdate');
	$status = $status_list[$phpgw->db->f('status')];
	$t->set_var('status',lang($status));

	$t->set_var('id',$phpgw->db->f('id'));
	$t->set_var('name',$phpgw->strip_html($phpgw->db->f('name')));
	$t->set_var('descr',$phpgw->strip_html($phpgw->db->f('descr')));
	$t->set_var('serial',$phpgw->strip_html($phpgw->db->f('serial')));

	$url = $phpgw->db->f('url');
	if (!$url || ($url == 'http://')) { $url = ''; }
	else
	{ 
		$url = $phpgw->strip_html($phpgw->db->f('url'));
		if (! ereg('http://',$url)) { $url = 'http://'. $url; }
	}
	$t->set_var('url',$url);

	$ftp = $phpgw->db->f('ftp');
	if (!$ftp || ($ftp == 'ftp://')) { $ftp = ''; }
	else
	{ 
		$ftp = $phpgw->strip_html($phpgw->db->f('ftp'));
		if (! ereg('ftp://',$ftp)) { $ftp = 'ftp://'. $ftp; }
	}
	$t->set_var('ftp',$ftp);

	$t->set_var('cost',$phpgw->db->f('cost'));
	$t->set_var('price',$price);
	$t->set_var('stock',$phpgw->db->f('stock'));                                                                                                               
	$t->set_var('mstock',$phpgw->db->f('mstock'));

	$taxpercent = select_tax($category);
	$retail = round($price*(1+$taxpercent),2);
	$t->set_var('retail',sprintf("%01.2f",$retail));

	if ($pdate != 0)
	{
		$pmonth = $phpgw->common->show_date(time(),'n');
		$pday = $phpgw->common->show_date(time(),'d');
		$pyear = $phpgw->common->show_date(time(),'Y');
		$pdate = $pdate + (60*60) * $phpgw_info['user']['preferences']['common']['tz_offset'];
		$pdateout = $phpgw->common->show_date($pdate,$phpgw_info['user']['preferences']['common']['dateformat']);
	}
	else { $pdateout = '&nbsp;'; }
	$t->set_var('pdate',$pdateout);

	if ($sdate != 0)
	{
		$smonth = $phpgw->common->show_date(time(),'n');
		$sday = $phpgw->common->show_date(time(),'d');
		$syear = $phpgw->common->show_date(time(),'Y');
		$sdate = $sdate + (60*60) * $phpgw_info['user']['preferences']['common']['tz_offset'];
		$sdateout = $phpgw->common->show_date($sdate,$phpgw_info['user']['preferences']['common']['dateformat']);
	}
	else { $sdateout = '&nbsp;'; }
	$t->set_var('sdate',$sdateout);

	$t->set_var('done_action',$HTTP_REFERER);
	$t->set_var('lang_done',lang('Done'));
	$t->pparse('out','view');

	$phpgw->common->phpgw_footer();
?>
