<?php
/*
 * $Id: class.htmlTimeCardForm.inc.php,v 1.2 2001/05/31 05:24:57 themaniac Exp $
 *
 * Double Choco Latte - Source Configuration Management System
 * Copyright (C) 1999  Michael L. Dean & Tim R. Norman
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Select License Info from the Help menu to view the terms and conditions of this license.
 */



class htmlTimeCardForm
{
	function Show($ccs, $obj = '', $selected = '')
	{
		echo $this->GetForm($ccs, $obj, $selected);

	}

	function GetForm($ccs, $obj = '', $selected = '')
	{
		global $dcl_info,$phpgw,$phpgw_info;
		$isBatch = is_array($selected) && count($selected) > 0;
		$isEdit = is_object($obj) && !$isBatch; // Don't allow batch updates for now...

		if (!$isBatch)
		{
			$objWorkorder = CreateObject('ccs.dbCCS');
			//$objWorkorder->Connect();
			$objWorkorder->Load($ccs);

			//	$objProduct = CreateObject('dbProducts');
			//$objProduct->Connect();
			//$objProduct->Query('SELECT wosetid FROM products WHERE id=' . $objWorkorder->product);
			//$setid = $objProduct->GetField(0);
		}
		else
			$setid = 0;

		$setid = 0; //avoid attribute maps for now


		$Template = CreateObject('phpgwapi.Template',$phpgw->common->get_tpl_dir('ccs'));
		$Template->set_file(array('hForm' => 'htmlTimeCardForm.tpl'));
		$Template->set_block('hForm', 'modify', 'hModify');
		$Template->set_block('hForm', 'batch', 'hBatch');
		$Template->set_var('hModify', '');
		$Template->set_var('hBatch', '');

		$Template->set_var('COLOR_DARK', $dcl_info['DCL_COLOR_DARK']);
		$Template->set_var('COLOR_LIGHT', $dcl_info['DCL_COLOR_LIGHT']);

            // if editing, we go 100%
		if ($isEdit)
			$Template->set_var('VAL_OUTERTABLEWIDTH', '100%');
		else
			$Template->set_var('VAL_OUTERTABLEWIDTH', '');

		$title = '';
		if ($isEdit)
			$title .= sprintf('%s&nbsp;', "Edit TimeCard");

		if ($isBatch)
			$title .= "STR_TC_BATCHUPDATE" . '&nbsp;';
		else
	//		$title .= sprintf("%s: $ccs &nbsp;&nbsp; %s: $seq", "Customer Complaint Number", "STR_TC_SEQ");
			$title .= sprintf("%s:$ccs", "Customer Complaint Number");
		if (!$isEdit)
			$title .= " (Detail Below)";

		if (!$isBatch)
			$title .= sprintf('<br>%s:&nbsp;%s', "Complaint Subject", htmlspecialchars($objWorkorder->subject));

		$Template->set_var('TXT_TITLE', $title);

		$hiddenvars = '';
		if ($isBatch)
		{
			$hiddenvars .= GetHiddenVar('menuAction', 'boTimecards.dbbatchadd');
		}
		elseif ($isEdit)
		{
			$hiddenvars .= GetHiddenVar('menuAction', 'ccs.boTimecards.dbmodify');
			$hiddenvars .= GetHiddenVar('id', $obj->id);
		}
		else
			$hiddenvars .= GetHiddenVar('menuAction', 'ccs.boTimecards.dbadd');


		/*		if ($isBatch){
			$objView = CreateObject('boView');
			$objView->SetFromURL();
			$hiddenvars .= $objView->GetForm();
			reset($selected);
			while (list($key, $val) = each($selected))
				$hiddenvars .= GetHiddenVar('selected[]', $val);
		}
		 else */
		{
			$hiddenvars .= GetHiddenVar('ccs', $ccs);
			//	$hiddenvars .= GetHiddenVar('seq', $seq);
		}

		$Template->set_var('HIDDEN_VARS', $hiddenvars);

		$objStatuses = CreateObject('ccs.htmlStatuses');
		$objActions = CreateObject('ccs.htmlActions');
		$objPersonnel = CreateObject('ccs.htmlPersonnel');

		$Template->set_var('VAL_JSDATEFORMAT', GetJSDateFormat());
		$Template->set_var('TXT_DATE', "Date");
		$Template->set_var('TXT_BY', "TimeCard By");
		$Template->set_var('TXT_STATUS', "Status");
		$Template->set_var('TXT_ACTION', "Action");
		// $Template->set_var('TXT_HOURS', "STR_TC_HOURS");
		// $Template->set_var('TXT_ETC', "STR_TC_ETC");
		// $Template->set_var('TXT_VERSION', "STR_TC_VERSION");
		$Template->set_var('TXT_SUMMARY', "Summary");
		$Template->set_var('TXT_DESCRIPTION', "Description");
		$Template->set_var('TXT_HIGHLIGHTEDNOTE', "Highlighted Fields are Required");
		$Template->set_var('TXT_MODIFYNOTE', "STR_TC_MODIFYNOTE");
		$Template->set_var('TXT_ATTRIBUTENOTE', '');
		$Template->set_var('BTN_SAVE', "Save");
		$Template->set_var('BTN_RESET', "Reset");

		$Template->set_var('VAL_ETCHOURS', '');

		if ($isEdit)
		{
			$Template->set_var('VAL_ACTIONON', $obj->actionon);
			//$Template->set_var('VAL_HOURS', $obj->hours);
			//$Template->set_var('VAL_REVISION', htmlspecialchars($obj->revision));
			$Template->set_var('VAL_SUMMARY', htmlspecialchars($obj->summary));
			$Template->set_var('VAL_DESCRIPTION', htmlspecialchars($obj->description));
			$Template->set_var('CMB_ACTIONBY', $objPersonnel->GetCombo($obj->actionby, 'actionby', 'lastfirst', 0, false, $dcl_info['DCL_HAVE_WO']));
			$Template->set_var('CMB_STATUS', $objStatuses->GetCombo($obj->status, 'status', 'name', 0, false, $setid));
			$Template->set_var('CMB_ACTION', $objActions->GetCombo($obj->action, 'action', 'name', 0, false, $setid));

			$Template->parse('hModify', 'modify');
		}
		else
		{
			$Template->set_var('VAL_ACTIONON', date($dcl_info['DCL_DATE_FORMAT']));
			$Template->set_var('VAL_HOURS', '');
			$Template->set_var('VAL_REVISION', '');
			$Template->set_var('VAL_SUMMARY', '');
			$Template->set_var('VAL_DESCRIPTION', '');
			$Template->set_var('CMB_ACTIONBY', $objPersonnel->GetCombo($GLOBALS['DCLID'], 'actionby', 'lastfirst', 0, true, $dcl_info['DCL_HAVE_WO']));
			//for now default to current user dbtimecards will use current user as well any change here make there too!!!
			//$Template->set_var('CMB_ACTIONBY',$phpgw_info['user']['account_id']);
			$Template->set_var('CMB_ACTION', $objActions->GetCombo(0, 'action', 'name', 0, true, $setid));


			/*	if ($isBatch)
			{
				$Template->set_var('CMB_STATUS', $objStatuses->GetCombo(1, 'status', 'name', 0, true, $setid));
				$Template->parse('hBatch', 'batch');
			}
			 else */
			$Template->set_var('CMB_STATUS', $objStatuses->GetCombo($objWorkorder->status, 'status', 'name', 0, true, $setid));
		}

		return $Template->parse('out', 'hForm');
	}
}

?>
