<?php
  /**************************************************************************\
  * phpGroupWare app (Bookkeeping)                                           *
  * http://www.phpgroupware.org                                              *
  * Written by Rick Bakker <r.bakker@linvision.com>                          *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

// ------------------------------ HTTP_POST_VARS ------------------------------
  $submit=$HTTP_POST_VARS['submit'];
  $res=$HTTP_POST_VARS['res'];
  $from_year=$HTTP_POST_VARS['from_year'];
  $from_month=$HTTP_POST_VARS['from_month'];
  $from_week=$HTTP_POST_VARS['from_week'];
  $from_day=$HTTP_POST_VARS['from_day'];
  $till_year=$HTTP_POST_VARS['till_year'];
  $till_month=$HTTP_POST_VARS['till_month'];
  $till_week=$HTTP_POST_VARS['till_week'];
  $till_day=$HTTP_POST_VARS['till_day'];
  $category_id=$HTTP_POST_VARS['category_id'];
// ------------------------------  ------------------------------
  $phpgw_info["flags"]["currentapp"]='bookkeeping';
  include('../header.inc.php');
  include('inc/bookkeeping_header.inc.php');

  $phpgw->template->set_file(array( "statistics" => "statistics.tpl"));
  $phpgw->template->set_block("statistics", "results", "results_t");

// ------------------------------  ------------------------------
// $hidden_vars='<input type="hidden" name="account_id" value='.$phpgw_info["user"]["account_id"].'">';

// ------------------------------  ------------------------------
  $lang_switch=lang("switch to");
  if($selected==""){
    $selected="expenses";
  }

  if($selected=='expenses')
  {
    $lang_selected=lang('expense');
    $lang_switch.=': <a href="'.$phpgw->link("/bookkeeping/statistics.php","selected=income").'">'.lang("income").'</a>';
    $income_expense='E';
  }else{
    $lang_selected=lang('income');
    $lang_switch.=': <a href="'.$phpgw->link("/bookkeeping/statistics.php","selected=expenses").'">'.lang("expenses").'</a>';
    $income_expense='I';
  }

// ------------------------------ $resolution ------------------------------
  if($res=='')
  {
    $resolution='month';
  }
  else
  {
    $resolution=$res;
  }
  $hidden_vars.='<input type="hidden" name="res" value="'.$resolution.'">';

  $phpgw->template->set_var('lang_resolution',lang('resolution'));
  if($resolution=='month')
  {
    $selectbox_resolution='<select name="res"><option value="month" selected>'.lang('month').
                                             '<option value="day7">'.lang('7 days').
                                             '<option value="day1">'.lang('1 day').'</select>';
  }
  if($resolution=='day7')
  { 
    $selectbox_resolution='<select name="res"><option value="month">'.lang('month').
                                             '<option value="day7" selected>'.lang('7 days').
                                             '<option value="day1">'.lang('1 day').'</select>';
  }
  if($resolution=='day1')
  {
    $selectbox_resolution='<select name="res"><option value="month">'.lang('month').
                                             '<option value="day7">'.lang('7 days').
                                             '<option value="day1" selected>'.lang('1 day').'</select>';
  }
  $submit_resolution='<input type="submit" value="'.lang('submit').'">';
// ------------------------------  ------------------------------
  $lang_from=lang("from");
  $lang_till=lang("till");
  $now=getdate();
  $week=ceil($now["yday"]/7);
// ------------------------------  ------------------------------
  if($submit=='')
  {
// ------------------------------ no submit - $resolution=='month' ------------------------------
    if($resolution=='month')
    {
      $from='<select name="from_year">';
      $till='<select name="till_year">';
      $temp='';
      for($i=($now["year"]-2);$i<=($now["year"]+1);$i++)
      {
        if($i==$now["year"])
        {
          $temp.='<option value="'.$i.'" selected>'.$i;
        }
        else
        {
          $temp.='<option value="'.$i.'">'.$i;
        }
      }
      $temp.='</select>';
      $from.=$temp;
      $till.=$temp;

      $from.='<select name="from_month">';
      $till.='<select name="till_month">';
      $temp='';
      for($i=1;$i<=12;$i++)
      {
        if($i==$now["mon"])
        {
          $temp.='<option value="'.$i.'" selected>'.$i;
        }
        else
        {
          $temp.='<option value="'.$i.'">'.$i;
        }
      }
      $temp.='</select>';
      $from.=$temp;
      $till.=$temp;
    }
// ------------------------------ no submit - $resolution=='day7' || 'day1' ------------------------------
    if(($resolution=='day7') || ($resolution=='day1'))
    {
      $from='<select name="from_year">';
      $till='<select name="till_year">';
      $temp='';
      for($i=($now["year"]-2);$i<=($now["year"]+1);$i++)
      {
        if($i==$now["year"])
        {
          $temp.='<option value="'.$i.'" selected>'.$i;
        }
        else
        {
          $temp.='<option value="'.$i.'">'.$i;
        }
      }
      $temp.='</select>';
      $from.=$temp;
      $till.=$temp;

      $from.='<select name="from_month">';
      $till.='<select name="till_month">';
      $temp='';
      for($i=1;$i<=12;$i++)
      {
        if($i==$now["mon"])
        {
          $temp.='<option value="'.$i.'" selected>'.$i;
        }
        else
        {
          $temp.='<option value="'.$i.'">'.$i;
        }
      }
      $temp.='</select>';
      $from.=$temp;
      $till.=$temp;

      $from.='<select name="from_day">';
      $till.='<select name="till_day">';
      $temp='';
      for($i=1;$i<=31;$i++)
      {
        if($i==$now["mday"])
        {
          $temp.='<option value="'.$i.'" selected>'.$i;
        }
        else
        {
          $temp.='<option value="'.$i.'">'.$i;
        }
      }
      $temp.='</select>';
      $from.=$temp;
      $till.=$temp;
    }
// ------------------------------ no submit ------------------------------
    $lang_category=lang('category');
    $sql="select category_id,description from phpgw_bk_categories where income_expense='$income_expense' order by description asc";
    $phpgw->db->query($sql);
    $category='<select name="category_id">';
    while( $phpgw->db->next_record() )
    {
      $category.='<option value="'.$phpgw->db->f('category_id').'">'.$phpgw->db->f('description');
    }
    $category.='</select>';

    $phpgw->template->set_var('result','&nbsp');
    $phpgw->template->parse('results_t', 'results', true);

  }
  else
  {
// ------------------------------ submit - $resolution=='month' ------------------------------
    if($resolution=='month')
    {
      $from='<select name="from_year">';
      $till='<select name="till_year">';
      $temp='';
      for($i=($now["year"]-2);$i<=($now["year"]+1);$i++)
      {
        if($i==$from_year)
        {
          $temp.='<option value="'.$i.'" selected>'.$i;
        }
        else
        {
          $temp.='<option value="'.$i.'">'.$i;
        }
      }
      $from.=$temp;
      $from.='</select>';
      $temp='';
      for($i=($now["year"]-2);$i<=($now["year"]+1);$i++)
      {
        if($i==$till_year)
        {
          $temp.='<option value="'.$i.'" selected>'.$i;
        }
        else
        {
          $temp.='<option value="'.$i.'">'.$i;
        }
      }
      $till.=$temp;
      $till.='</select>';

      $from.='<select name="from_month">';
      $till.='<select name="till_month">';
      $temp='';
      for($i=1;$i<=12;$i++)
      {
        if($i==$from_month)
        {
          $temp.='<option value="'.$i.'" selected>'.$i;
        }
        else
        {
          $temp.='<option value="'.$i.'">'.$i;
        }
      }
      $from.=$temp;
      $from.='</select>';
      $temp='';
      for($i=1;$i<=12;$i++)
      {
        if($i==$till_month)
        {
          $temp.='<option value="'.$i.'" selected>'.$i;
        }
        else
        {
          $temp.='<option value="'.$i.'">'.$i;
        }
      }
      $till.=$temp;
      $till.='</select>';
    }
// ------------------------------ submit - $resolution=='day7' || 'day1' ------------------------------
    if(($resolution=='day7') || ($resolution=='day1'))
    {
      $from='<select name="from_year">';
      $till='<select name="till_year">';
      $temp='';
      for($i=($now["year"]-2);$i<=($now["year"]+1);$i++)
      {
        if($i==$from_year)
        {
          $temp.='<option value="'.$i.'" selected>'.$i;
        }
        else
        {
          $temp.='<option value="'.$i.'">'.$i;
        }
      }
      $from.=$temp;
      $from.='</select>';
      $temp='';
      for($i=($now["year"]-2);$i<=($now["year"]+1);$i++)
      {
        if($i==$till_year)
        {
          $temp.='<option value="'.$i.'" selected>'.$i;
        }
        else
        {
          $temp.='<option value="'.$i.'">'.$i;
        }
      }
      $till.=$temp;
      $till.='</select>';

      $from.='<select name="from_month">';
      $till.='<select name="till_month">';
      $temp='';
      for($i=1;$i<=12;$i++)
      {
        if($i==$from_month)
        {
          $temp.='<option value="'.$i.'" selected>'.$i;
        }
        else
        {
          $temp.='<option value="'.$i.'">'.$i;
        }
      }
      $from.=$temp;
      $from.='</select>';
      $temp='';
      for($i=1;$i<=12;$i++)
      {
        if($i==$till_month)
        {
          $temp.='<option value="'.$i.'" selected>'.$i;
        }
        else
        {
          $temp.='<option value="'.$i.'">'.$i;
        }
      }
      $till.=$temp;
      $till.='</select>';

      $from.='<select name="from_day">';
      $till.='<select name="till_day">';
      $temp='';
      for($i=1;$i<=31;$i++)
      {
        if($i==$from_day)
        {
          $temp.='<option value="'.$i.'" selected>'.$i;
        }
        else
        {
          $temp.='<option value="'.$i.'">'.$i;
        }
      }
      $from.=$temp;
      $from.='</select>';
      $temp='';
      for($i=1;$i<=31;$i++)
      {
        if($i==$till_day)
        {
          $temp.='<option value="'.$i.'" selected>'.$i;
        }
        else
        {
          $temp.='<option value="'.$i.'">'.$i;
        }
      }
      $till.=$temp;
      $till.='</select>';
    }
// ------------------------------  ------------------------------
    $lang_category=lang('category');
    $sql="select category_id,description from phpgw_bk_categories where income_expense='$income_expense' order by description asc";
    $phpgw->db->query($sql);
    $category='<select name="category_id">';
    while( $phpgw->db->next_record() )
    {
      if($category_id==$phpgw->db->f('category_id'))
      {
        $category.='<option value="'.$phpgw->db->f('category_id').'" selected>'.$phpgw->db->f('description');
      }
      else
      {
        $category.='<option value="'.$phpgw->db->f('category_id').'">'.$phpgw->db->f('description');
      }
    }
    $category.='</select>';

    $phpgw->template->set_var('result','&nbsp');
    $phpgw->template->parse('results_t', 'results', true);
// ------------------------------  ------------------------------
    $graphWidthMax='600';
    $barHeight='10';
// ------------------------------ submit - fill $entry - $resolution=='month' ------------------------------
    if($resolution=='month')
    {
      $begin_year=$from_year;
      $begin_month=$from_month;
      if($till_month=='12')
      {
        $end_year=$till_year+1;
        $end_month='1';
      }
      else
      {
        $end_year=$till_year;
        $end_month=$till_month+1;
      }
      $begin_date=mktime(0,0,0,$begin_month,1,$begin_year);
      $end_date=mktime(0,0,0,$end_month,1,$end_year);

      $temp_begin_date=$begin_date;
      while($temp_begin_date<$end_date)
      {
        $temp_end_date=addMonth($temp_begin_date);
        $sql="select sum(amount) as amount from phpgw_bk_entries where date_entry>='$temp_begin_date' and date_entry<'$temp_end_date' and category_id='$category_id'";
        $phpgw->db->query($sql);
        $phpgw->db->next_record();
        $temp=getdate($temp_begin_date);
        $entry[]=$temp["year"].':'.$temp["mon"].':'.$phpgw->db->f('amount');
        $temp_begin_date=$temp_end_date;
      }
    }
// ------------------------------ submit - fill $entry - $resolution=='day7' ------------------------------
    if($resolution=='day7')
    {
      $begin_year=$from_year;
      $begin_month=$from_month;
      $begin_day=$from_day;

      if(lastDayOfMonth($till_year,$till_month,$till_day))
      {
        if($till_month==12)
        {
          $end_year=$till_year+1;
          $end_month=1;
          $end_day=1;
        }
        else
        {
          $end_year=$till_year;
          $end_month=$till_month+1;
          $end_day=1;
        }
      }
      else
      {
        $end_year=$till_year;
        $end_month=$till_month;
        $end_day=$till_day+1;
      }
      $begin_date=mktime(0,0,0,$begin_month,$begin_day,$begin_year);
      $end_date=mktime(0,0,0,$end_month,$end_day,$end_year);
      $temp_begin_date=$begin_date;
      while($temp_begin_date<$end_date)
      {
        $temp_end_date=addWeek($temp_begin_date);
        if($temp_end_date >= $end_date)
        { 
          $sql="select sum(amount) as amount from phpgw_bk_entries where date_entry>='$temp_begin_date' and date_entry<'$end_date' and category_id='$category_id'";
        }
        else
        {
          $sql="select sum(amount) as amount from phpgw_bk_entries where date_entry>='$temp_begin_date' and date_entry<'$temp_end_date' and category_id='$category_id'";
        }
        $phpgw->db->query($sql);
        $phpgw->db->next_record();
        $temp=getdate($temp_begin_date);
        if($temp_end_date >= $end_date)
        {
          $entry[]=$temp["year"].':'.$temp["mon"].':'.$temp["mday"].':'.$phpgw->db->f('amount').':'.$till_year.':'.$till_month.':'.$till_day;
        }
        else
        {
          $temp2=$temp_begin_date;
          for($i=0;$i<6;$i++)
          {
            $temp2=addDay($temp2);
          }
          $temp3=getdate($temp2);
          $entry[]=$temp["year"].':'.$temp["mon"].':'.$temp["mday"].':'.$phpgw->db->f('amount').':'.$temp3["year"].':'.$temp3["mon"].':'.$temp3["mday"];
        }
        $temp_begin_date=$temp_end_date;
      }
    }
// ------------------------------ submit - fill $entry - $resolution=='day1' ------------------------------
    if($resolution=='day1')
    {
      $begin_year=$from_year;
      $begin_month=$from_month;
      $begin_day=$from_day;

      if(lastDayOfMonth($till_year,$till_month,$till_day))
      {
        if($till_month==12)
        {
          $end_year=$till_year+1;
          $end_month=1;
          $end_day=1;
        }
        else
        {
          $end_year=$till_year;
          $end_month=$till_month+1;
          $end_day=1;
        }
      }
      else
      {
        $end_year=$till_year;
        $end_month=$till_month;
        $end_day=$till_day+1;
      }
      $begin_date=mktime(0,0,0,$begin_month,$begin_day,$begin_year);
      $end_date=mktime(0,0,0,$end_month,$end_day,$end_year);

      $temp_begin_date=$begin_date;
      while($temp_begin_date<$end_date)
      {
        $temp_end_date=addDay($temp_begin_date);
        $sql="select sum(amount) as amount from phpgw_bk_entries where date_entry>='$temp_begin_date' and date_entry<'$temp_end_date'  and category_id='$category_id'";
        $phpgw->db->query($sql);
        $phpgw->db->next_record();
        $temp=getdate($temp_begin_date);
        $entry[]=$temp["year"].':'.$temp["mon"].':'.$temp["mday"].':'.$phpgw->db->f('amount');
        $temp_begin_date=$temp_end_date;
      }
    }
// ------------------------------ submit - show results ------------------------------
// ------------------------------ $resolution=='month' ------------------------------
    if($resolution=='month')
    {
      $barMax=getMaxValue($entry,'month');
      $count=count($entry);

      $result='<table width="90%" align="center">';
      $phpgw->template->set_var('result',$result);
      $phpgw->template->parse('results_t', "results", true);

      $_year='';
      for($k=0;$k<$count;$k++)
      {
        $year=strtok($entry[$k],':');
        $month=strtok(':');
        $amount=strtok(':');
        $barWidth=intval($graphWidthMax*($amount/$barMax));

        if(strcmp($_year,$year))
        {
          $_year=$year;
          $result='<tr><td colspan="2">&nbsp;</td></tr>';
          $result.='<tr align="center"><td colspan="2">'.lang('year').'&nbsp;'.$year.'</td></tr>';
          $phpgw->template->set_var('result',$result);
          $phpgw->template->parse('results_t', "results", true);
        }
        $result='<tr><td>'.lang('month').'&nbsp;'.$month.'</td><td>';
        if(!$amount=='')
        {
          $result.='<img src="reddot.jpg" width="'.$barWidth.'" height="'.$barHeight.'" border="0">&nbsp;&nbsp;'.$amount.'</td></tr>';
        }
        else
        {
          $result.='0.00';
        }
        $phpgw->template->set_var('result',$result);
        $phpgw->template->parse('results_t', "results", true);
      }
      $result='</table>';
      $phpgw->template->set_var('result',$result);
      $phpgw->template->parse('results_t', "results", true);
    }
// ------------------------------ $resolution=='day7' ------------------------------
    if($resolution=='day7')
    {
      $barMax=getMaxValue($entry,'day');
      $count=count($entry);

      $result='<table width="90%" align="center">';
      $phpgw->template->set_var('result',$result);
      $phpgw->template->parse('results_t', "results", true);
      
      $_month='';
      for($k=0;$k<$count;$k++)
      {
        $f_year=strtok($entry[$k],':');
        $f_month=strtok(':');
        $f_day=strtok(':');
        $amount=strtok(':');
        $t_year=strtok(':');
        $t_month=strtok(':');
        $t_day=strtok(':');
        $barWidth=intval($graphWidthMax*($amount/$barMax));
      
        $result='<tr><td>'.$f_year.'-'.$f_month.'-'.$f_day.'&nbsp;'.'*'.'&nbsp;'.$t_year.'-'.$t_month.'-'.$t_day.'</td><td>';
        if(!$amount=='')
        {
          $result.='<img src="reddot.jpg" width="'.$barWidth.'" height="'.$barHeight.'" border="0">&nbsp;&nbsp;'.$amount.'</td></tr>';
        }
        else
        {
          $result.='0.00';
        }
        $phpgw->template->set_var('result',$result);
        $phpgw->template->parse('results_t', "results", true);
      }
      $result='</table>';
      $phpgw->template->set_var('result',$result);
      $phpgw->template->parse('results_t', "results", true);
    }
// ------------------------------ $resolution=='day1' ------------------------------
    if($resolution=='day1')
    {
      $barMax=getMaxValue($entry,'day');
      $count=count($entry);

      $result='<table width="90%" align="center">';
      $phpgw->template->set_var('result',$result);
      $phpgw->template->parse('results_t', "results", true);

      $_month='';
      for($k=0;$k<$count;$k++)
      {
        $year=strtok($entry[$k],':');
        $month=strtok(':');
        $day=strtok(':');
        $amount=strtok(':');
        $barWidth=intval($graphWidthMax*($amount/$barMax));

        if(strcmp($_month,$month))
        {
          $_month=$month;
          $result='<tr><td colspan="2">&nbsp;</td></tr>';
          $result.='<tr align="center"><td colspan="2">'.lang('year').'&nbsp;'.$year.'&nbsp;'.'-'.'&nbsp;'.lang('month').'&nbsp;'.$_month.'</td></tr>';
          $phpgw->template->set_var('result',$result);
          $phpgw->template->parse('results_t', "results", true);
        }
        $result='<tr><td>'.lang('day').'&nbsp;'.$day.'</td><td>';
        if(!$amount=='')
        {
          $result.='<img src="reddot.jpg" width="'.$barWidth.'" height="'.$barHeight.'" border="0">&nbsp;&nbsp;'.$amount.'</td></tr>';
        }
        else
        {
          $result.='0.00';
        }
        $phpgw->template->set_var('result',$result);
        $phpgw->template->parse('results_t', "results", true);
      }
      $result='</table>';
      $phpgw->template->set_var('result',$result);
      $phpgw->template->parse('results_t', "results", true);
    }
  }
// ------------------------------ define template vars ------------------------------
  $phpgw->template->set_var('header',$header);
  $phpgw->template->set_var('head_color','D3DCE3');
  $phpgw->template->set_var('lang_app_title',lang("bookkeeping"));
  $phpgw->template->set_var('lang_title',lang("statistics"));

  $phpgw->template->set_var('hidden_vars',$hidden_vars);
  $phpgw->template->set_var('lang_selected',$lang_selected);
  $phpgw->template->set_var('lang_switch',$lang_switch);

  $phpgw->template->set_var('submit_resolution_actionurl',$phpgw->link('/bookkeeping/statistics.php','res='.$resolution));
  $phpgw->template->set_var('lang_resolution',lang('resolution'));
  $phpgw->template->set_var('selectbox_resolution',$selectbox_resolution);
  $phpgw->template->set_var('submit_resolution',$submit_resolution);

  $phpgw->template->set_var('lang_from',$lang_from);
  $phpgw->template->set_var('from',$from);
  $phpgw->template->set_var('lang_till',$lang_till);
  $phpgw->template->set_var('till',$till);
  $phpgw->template->set_var('lang_category',$lang_category);
  $phpgw->template->set_var('category',$category);
  $phpgw->template->set_var('lang_show',lang('show'));

  $phpgw->template->set_var('actionurl',$phpgw->link("/bookkeeping/statistics.php","resolution=$resolution"));
  $phpgw->template->set_var('lang_show',lang('show'));
  $phpgw->template->parse('out', 'statistics', true);
  $phpgw->template->p('out');

  $phpgw->common->phpgw_footer();
?>
