<?php

/*************************************************************************\
* phpGroupWare app (Bookkeeping)                                          *
* http://www.phpgroupware.org                                             *
* Written by Rick Bakker <r.bakker@linvision.com>                         *
* --------------------------------------------                            *
* This program is free software; you can redistribute it and/or modify it *
* under the terms of the GNU General Public License as published by the   *
* Free Software Foundation; either version 2 of the License, or (at your  *
* option) any later version.                                              *
\*************************************************************************/

/* $Id: class.bookkeeping.inc.php,v 1.9 2001/06/18 22:13:57 darw1n Exp $ */

class bookkeeping
{
	// functions:
	// is_initialized()
	// initialized_check()
	// access_to_bookkeeping_account($bookkeeping_id, account_id)
	// show_all_modules($bookkeeping_id)
	// show_modules(bookkeeping_id);
	// get_bookkeeping_account_list($account_id)

	// get_bookkeeping_admin_list($order)
	// show_bookkeeping_header()
	// is_admin($bookkeeping_id)
	// access_to_bookkeeping_id($bookkeeping_id)
	// bookkeeping_admins()
	// number_of_bookkeeping_admins()
	// number_of_users_without_bookkeeping_admins()
	// get_users_without_bookkeeping_admins_list()
	// bookkeeping_ids_of_user()
	// index_message()

	function get_location_list()
	{
		global $phpgw;
		$phpgw->db->query("SELECT location_id, location FROM phpgw_bk_l");
		while ($phpgw->db->next_record())
		{
			$bookkeeping_location[$phpgw->db->f('location')] = $phpgw->db->f('location_id');
		}
		return ($bookkeeping_location);
	}

	function bookkeeping_rights($bookkeeping_account_id, $phpgw_account_id)
	{
		global $phpgw;
		$db2 = $phpgw->db;
		$db3 = $phpgw->db;
		$phpgw->db->query("SELECT group_id FROM phpgw_bk_gpa WHERE phpgw_account_id=$phpgw_account_id");
		while ($phpgw->db->next_record())
		{
			$db2->query("SELECT location_id, acl_right FROM phpgw_bk_gr WHERE group_id=" . $phpgw->db->f('group_id'));
			while ($phpgw->db->next_record())
			{
				$db3->query("SELECT location FROM phpgw_bk_l WHERE location_id=$db2->f('location_id')");
				$db3->next_record();
				$bookkeeping_rights[$db3->f('location')][$db2->f('acl_right')] = '';
			}
		}
		return ($bookkeeping_rights);
	}

	function is_initialized()
	{
		global $phpgw;
		$phpgw->db->query("SELECT bm.bookkeeping_account_id FROM phpgw_bk_bm bm, phpgw_bk_m WHERE bm.module_id=m.module_id AND m.module='bookkeeping' AND bm.bookkeeping_account_id='0'");
		if ($phpgw->db->num_rows() == 0)
		{	
			return (FALSE);
		}
		else
		{
			return (TRUE);
		}
	}

	function initialized_check()
	{
		global $phpgw;
		$phpgw->db->query("SELECT module_id FROM phpgw_bk_m WHERE module='bookkeeping'");
		if ($phpgw->db->num_rows() == 0)
		{
			$db2 = $phpgw->db;
			$db2->query("INSERT INTO phpgw_bk_ba (bookkeeping_account) VALUES ('general')");
			$db2->query("INSERT INTO phpgw_bk_m (module,module_order) VALUES ('bookkeeping',999)");
			$db2->query("INSERT INTO phpgw_bk_bm VALUES (1,1)");
			$db2->query("INSERT INTO phpgw_bk_at (account_type) VALUES ('cash')");
			$db2->query("INSERT INTO phpgw_bk_at (account_type) VALUES ('bank')");
		}
	}

	function access_to_bookkeeping_account($bookkeeping_account_id, $phpgw_account_id)
	{
		global $phpgw;
		$phpgw->db->query("SELECT acl_rights FROM phpgw_acl WHERE acl_appname='bookkeeping' AND acl_location='$bookkeeping_account_id' AND acl_account='$phpgw_account_id'");
		$return = '';
		// 0 means no access
		// 1 means admin access
		// 2 means access.
		while ($phpgw->db->next_record())
		{
			if ($phpgw->db->f('acl_rights') == 0)
			{
				$return = '0';
			}
			if ($phpgw->db->f('acl_rights') == 1)
			{
				if ($return != '0')
				{
					$return = '1';
				}
			}
			if ($phpgw->db->f('acl_rights') == 2)
			{
				if ($return != '0')
				{
					if ($return != '1')
					{
						$return = '2';
					}
				}
			}
		}
		if ($return == '')
		{
			return ('0');
		}
		else
		{
			return ($return);
		}
	}

	function show_all_modules($bookkeeping_account_id)
	{
		global $phpgw;
		$phpgw->db->query("SELECT m.module FROM phpgw_bk_m m, phpgw_bk_bm bm WHERE bm.bookkeeping_account_id='$bookkeeping_account_id' AND bm.module_id=m.module_id ORDER BY m.module_order");
		$modules = '';
		while ($phpgw->db->next_record())
		{
			if ($modules == '')
			{
				$modules = '<a href="' . $phpgw->link('/bookkeeping/' . $phpgw->db->f('module') . '/index.php') . '">' . lang($phpgw->db->f('module')) . '</a>';
			}
			else
			{
				$modules .= '&nbsp;&nbsp;&nbsp';
				$modules .= '<a href="' . $phpgw->link('/bookkeeping/' . $phpgw->db->f('module') . '/index.php') . '">' . lang($phpgw->db->f('module')) . '</a>';
			}
		}
		return($modules);
	}

	function show_modules($bookkeeping_id, $phpgw_account_id)
	{
		global $phpgw, $phpgw_info;
		$phpgw->db->query("SELECT m.module_id, m.module FROM phpgw_bk_m m, phpgw_bk_bm bm WHERE bm.bookkeeping_account_id='$bookkeeping_id' AND bm.module_id=m.module_id ORDER BY m.module_order");
		$modules = '';
		while ($phpgw->db->next_record())
		{
			$db2 = $phpgw->db;
			$sql = "SELECT acl_rights FROM phpgw_acl WHERE acl_appname='bookkeeping_" . $bookkeeping_id . "' AND acl_location='" . $phpgw->db->f('module_id') . "' AND acl_account='" . $phpgw_info['user']['account_id'] . "'";
			$db2->query($sql);
			if ($db2->num_rows() > 0)
			{
				$show = TRUE;
				while ($db2->next_record())
				{
					if ($db2->f('acl_rights') == '0')
					{
						$show = FALSE;
					}
				}
				if ($show)
				{
					if ($modules == '')
					{
						$modules = '<a href="' . $phpgw->link('/bookkeeping/' . $phpgw->db->f('module') . '/index.php') . '">' . lang($phpgw->db->f('module')) . '</a>';
					}
					else
					{
						$modules .= '&nbsp;&nbsp;&nbsp;';
						$modules .= '<a href="' . $phpgw->link('/bookkeeping/' . $phpgw->db->f('module') . '/index.php') . '">' . lang($phpgw->db->f('module')) . '</a>';
					}
				}
			}
		}
		return ($modules);
	}

	// Function:	get_bookkeeping_account
	// Abstract:	returns an array which contains all bookkeeping accounts the
	//		user has access to.
	// Created by:	Rick Bakker
	function get_bookkeeping_account_list ($phpgw_account_id)
	{
		global $phpgw;
		$bookkeeping_account = array();
		$phpgw->db->query("SELECT acl_location as bookkeeping_account_id, acl_rights FROM phpgw_acl WHERE acl_account='$phpgw_account_id' AND acl_appname='bookkeeping' AND  acl_location!='run' ORDER BY acl_location,acl_rights");
		$i = 0;
		while ($phpgw->db->next_record())
		{
			if ($phpgw->db->f('acl_rights') == 0)
			{
				$bookkeeping_account_id = $phpgw->db->f('bookkeeping_account_id');
			}
			else
			{
				if ($bookkeeping_account_id != $phpgw->db->f('bookkeeping_account_id'))
				{
					if (($phpgw->db->f('acl_rights') == 1) || ($phpgw->db->f('acl_rights') == 2))
					{
						$db2 = $phpgw->db;
						$db2->query("SELECT bookkeeping_account FROM phpgw_bk_ba WHERE bookkeeping_account_id='" . $phpgw->db->f('bookkeeping_account_id') . "'");
						$db2->next_record();
						$bookkeeping_account[$i]['bookkeeping_account_id'] = $phpgw->db->f('bookkeeping_account_id');
						$bookkeeping_account[$i]['bookkeeping_account'] = $db2->f('bookkeeping_account');
						$i++;
					}
				}
			}
                }
		return ($bookkeeping_account);
	}

	// Function:    is_admin
	// Abstract:    returns TRUE if the given account has admin rights for the given bookkeeping account,
	//		and returns FALSE otherwise.
	// Created by:  Rick Bakker
	function is_admin($bookkeeping_account_id, $phpgw_account_id)
	{
		global $phpgw, $phpgw_info;
		$sql = "SELECT acl_appname  FROM phpgw_acl WHERE acl_appname='bookkeeping' AND acl_location='" . $bookkeeping_account_id . "' AND acl_account='" . $phpgw_account_id . "' AND acl_rights='1'";
		$phpgw->db->query($sql);
		if ($phpgw->db->num_rows() > 0)
		{
			return (TRUE);
		}
		else
		{
			return (FALSE);
		}
	}

/*
	function show_bookkeeping_header()
	{
                $template = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
                $template->set_file(array('index' => 'index.tpl'));
                $template->set_var('lang_app_title', lang('bookkeeping'));
                $head_color = $phpgw_info['theme']['th_bg'];
                $template->set_var('head_color', $head_color);
                $template->set_var('sub_template', $bookkeeping_general->bookkeeping_header());
                $template->parse('out', 'admin_delete', true);
                $template->p('out');
                $phpgw->common->phpgw_footer();
	}

	function bookkeeping_header()
	{
		global $phpgw, $phpgw_info;
		$sql = "SELECT module FROM phpgw_bk_acl WHERE bookkeeping_id='" . $phpgw_info['bookkeeping']['id'] . "' GROUP BY module";
		$phpgw->db->query($sql);
		$string = '';
		while($phpgw->db->next_record())
		{
			$string .= '<a href="' . $phpgw->link('/bookkeeping/' . $phpgw->db->f('module') . '/index.php') . '">' . lang($phpgw->db->f('module')) . '</a>';
			$string .= 'nbsp;nbsp;nbsp;';
		}

	}

	function index_message()
	{
		global $phpgw, $phpgw_info;
		$sql = "SELECT a.bookkeeping_id FROM phpgw_bk_acl a, phpgw_bk_gu g WHERE a.group_id = g.group_id AND g.user_id='" . $phpgw_info['user']['id'] . "' GROUP BY a.module";
		$phpgw->db->query($sql);
		if ($phpgw->db->num_rows == 0)
		{
			return ('Geen toegang');
		}
		elseif ($phpgw->db->num_rows == 1)
		{
			return ($this->bookkeeping_header());
		}
		elseif ($phpgw->db->num_rows > 1)
		{
			return ('Selectbox');
		}
	}

*/
}

?>
