<?php
/**
*
* common.php [Albanian]
*
* @package language
* @version $Id: $
* @copyright (c) 2008 phpBB Group
* @author 2008-12-06 - www.dea-portal.com
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> '',
	'DIRECTION'			=> 'ltr',
	'DATE_FORMAT'		=> '|d M Y|',	// 01 Jan 2007 (with Relative days enabled)
	'USER_LANG'			=> 'sq',
	
	'1_DAY'			=> '1 ditë',
	'1_MONTH'		=> '1 muaj',
	'1_YEAR'		=> '1 vit',
	'2_WEEKS'		=> '2 javë',
	'3_MONTHS'		=> '3 muaj',
	'6_MONTHS'		=> '6 muaj',
	'7_DAYS'		=> '7 ditë',
	
	'ACCOUNT_ALREADY_ACTIVATED'		=> 'Llogaria juaj u aktivizua.',
	'ACCOUNT_DEACTIVATED'			=> 'Llogaria juaj është ç\'aktivuar manualisht dhe e vetmja mënyrë është të aktivizohet nga Administratori.',
	'ACCOUNT_NOT_ACTIVATED'			=> 'Llogaria juaj nuk është aktivizuar akoma.',
	'ACP'							=> 'Paneli i Administratorit',
	'ACTIVE'						=> 'aktive',
	'ACTIVE_ERROR'					=> 'Pseudonimi i specifikuar është momentalisht jo-aktive. Nqs keni probleme me aktivizimin e llogarisë, ju lutemi kontaktoni Bordin e Administrimit.',
	'ADMINISTRATOR'					=> 'Administratori',
	'ADMINISTRATORS'				=> 'Administratorët',
	'AGE'							=> 'Mosha',
	'AIM'							=> 'AIM',
	'ALLOWED'						=> 'E Lejuar',
	'ALL_FILES'						=> 'Të gjithë skedarët',
	'ALL_FORUMS'					=> 'Të gjithë forumet',
	'ALL_MESSAGES'					=> 'Të gjithë mesazhet',
	'ALL_POSTS'						=> 'Të gjithë postimet',
	'ALL_TIMES'						=> 'Të gjitha oraret janë %1$s %2$s',
	'ALL_TOPICS'					=> 'Të gjitha temat',
	'AND'							=> 'Dhe',
	'ARE_WATCHING_FORUM'			=> 'Ju jeni abonuar në këtë forum që të njoftoheni kur ka postime të reja.',
	'ARE_WATCHING_TOPIC'			=> 'Ju jeni abonuar në këtë temë që të njoftoheni kur ka postime të reja.',
	'ASCENDING'						=> 'Në rritje',
	'ATTACHMENTS'					=> 'Shtojca',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'Imazhi që ju po përpiqeni të bashkangjisni, nuk është i vlefshëm.',
	'AUTHOR'						=> 'Autori',
	'AUTH_NO_PROFILE_CREATED'		=> 'Krijimi i profilit të antarit nuk ishte i suksesshëm.',
	'AVATAR_DISALLOWED_CONTENT'		=> 'Ngarkimi u refuzua sepse skedari i ngarkuar u identifikua si vektor sulmues.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'Ky skedar nuk mund të shfaqet sepse prapashtesa <strong>%s</strong> nuk është e lejueshme.',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'Avatari i specifikuar nuk mund të ngarkohet sepse të dhënat në remote duket sikur janë të pa vlefshme ose skedar i korruptuar.',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'Skedari në hapësiren e ngarkimit është bosh.',
	'AVATAR_INVALID_FILENAME'		=> '%s është një skedar i pavefshëm.',
	'AVATAR_NOT_UPLOADED'			=> 'Avatari nuk mund të ngarkohet.',
	'AVATAR_NO_SIZE'				=> 'Gjerësia dhe lartësia e avatarit të linkuar nuk mund të përcaktohet. Ju lutem vendosini ato manualisht.',
	'AVATAR_PARTIAL_UPLOAD'			=> 'Skedari i specifikuar u ngarkua pjesërisht.',
	'AVATAR_PHP_SIZE_NA'			=> 'Dimesioni i avatarit është shumë i madh.<br />Maksimumi i lejueshëm është përcaktuar në php.ini dhe nuk mund të ndryshohet.',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'Masa e avatarit është shumë e madhe. Masa maksimale e lejuar për ngarkim është %1$d %2$s.<br />Vini re që kjo është caktuar në php.ini dhe nuk mund të mbishkruhet.',
	'AVATAR_URL_INVALID'			=> 'Adresa URL që ju specifikuat është e pavlefshme.',
	'AVATAR_URL_NOT_FOUND'			=> 'Skedari i specifikuar nuk mund të gjendet.',
	'AVATAR_WRONG_FILESIZE'			=> 'Dimesioni i avatarit duhet të jetë midis 0 dhe %1d %2s.',
	'AVATAR_WRONG_SIZE'				=> 'Avatari dërguar është %5$d pixel gjerësi dhe %6$d pixel lartësi. Avatarët duhet të jenë të paktën %1$d pixel gjerësi dhe %2$d pixel lartësi, por jo më të mëdhenj se %3$d pixel gjerësi dhe %4$d pixel lartësi.',
	
	'BACK_TO_TOP'			=> 'Ngjitu lart',
	'BACK_TO_PREV'			=> 'Kthehu tek faqja e mëparshme',
	'BAN_TRIGGERED_BY_EMAIL'=> 'Adresa juaj e-mail është përjashtuar.',
	'BAN_TRIGGERED_BY_IP'	=> 'Adresa juaj IP është përjashtuar.',
	'BAN_TRIGGERED_BY_USER'	=> 'Pseudonimi juaj është përjashtuar.',
	'BBCODE_GUIDE'			=> 'Guida BBCode',
	'BCC'					=> 'BCC',
	'BIRTHDAYS'				=> 'Ditëlindjet',
	'BOARD_BAN_PERM'		=> 'Ju jeni përjashtuar <strong>përkohësisht</strong> nga ky bord.<br /><br />Ju lutemi kontaktoni %2$sBoard Administrator%3$s për më shumë informacion.',
	'BOARD_BAN_REASON'		=> 'Arsyeja e dhënë për përjashtimin: <strong>%s</strong>',
	'BOARD_BAN_TIME'		=> 'Ju jeni përjashtuar nga ky board deri më <strong>%1$s</strong>.<br /><br />Ju lutemi kontaktoni %2$sBoard Administrator%3$s për më shumë informacione.',
	'BOARD_DISABLE'			=> 'Ky board është momentalisht i pa disponueshëm.',
	'BOARD_DISABLED'		=> 'Bordi është i ç\'aktivuar momentalisht.',
	'BOARD_UNAVAILABLE'		=> 'Bordi është përkohësisht i pa disponueshëm. Ju lutemi provojeni pas disa minutash.',
	'BROWSING_FORUM'		=> 'Antarë duke shfletuar këtë forum: %1$s',
	'BROWSING_FORUM_GUEST'	=> 'Antarë duke shfletuar këtë forum: %1$s dhe %2$d vizitor',
	'BROWSING_FORUM_GUESTS'	=> 'Antarë duke shfletuar këtë forum: %1$s dhe %2$d vizitorë',
	'BYTES'					=> 'Bytes',
	
	'CANCEL'				=> 'Anullo',
	'CHANGE'				=> 'Ndrysho',
	'CHANGE_FONT_SIZE'		=> 'Ndrysho madhësinë e shkrimit',
	'CHANGING_PREFERENCES'	=> 'Ndrysho preferencat e Bordit',
	'CHANGING_PROFILE'		=> 'Ndrysho preferencat e Profilit',
	'CLICK_VIEW_PRIVMSG'	=> '%sShko tek mesazhet e marra%s',
	'COLLAPSE_VIEW'			=> 'Pamje përmbys',
	'CLOSE_WINDOW'			=> 'Mbyll dritaren',
	'COLOUR_SWATCH'			=> 'Zgjedhje e ngjyrave',
	'COMMA_SEPARATOR'		=> ', ',	// Used in pagination of ACP & prosilver, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'Konfirmo',
	'CONFIRM_CODE'			=> 'Kodi konfirmimit',
	'CONFIRM_CODE_EXPLAIN'	=> 'Vendos kodin ashtu siç shfaqet. Nuk ka asnjë zero.',
	'CONFIRM_CODE_WRONG'	=> 'Kodi konfirmimit që ju vendosët nuk është i saktë.',
	'CONFIRM_OPERATION'		=> 'Jeni i sigurt që doni të bëni këtë veprim?',
	'CONGRATULATIONS'		=> 'Urime për',
	'CONNECTION_FAILED'		=> 'Lidhja nuk u krye.',
	'CONNECTION_SUCCESS'	=> 'Lidhja u krye me sukses!',
	'COOKIES_DELETED'		=> 'Të gjithë "cookies" u fshinë me suskes.',
	'CURRENT_TIME'			=> 'Ora %s',
	
	'DAY'					=> 'Ditë',
	'DAYS'					=> 'Ditë',
	'DELETE'				=> 'Fshi',
	'DELETE_ALL'			=> 'Fshi të gjitha',
	'DELETE_COOKIES'		=> 'Fshi të gjitha "cookies" e bordit',
	'DELETE_MARKED'			=> 'Fshi të zgjedhurat',
	'DELETE_POST'			=> 'Fshi postim',
	'DELIMITER'				=> 'Delimitër',
	'DESCENDING'			=> 'Në zbritje',
	'DISABLED'				=> 'I ç\'aktivizuar',
	'DISPLAY'				=> 'Shfaq',
	'DISPLAY_GUESTS'		=> 'Shfaq vizitorët',
	'DISPLAY_MESSAGES'		=> 'Trego mesazhet nga i fundit',
	'DISPLAY_POSTS'			=> 'Trego postimet nga i fundit',
	'DISPLAY_TOPICS'		=> 'Trego temat nga e fundit',
	'DOWNLOADED'			=> 'Shkarkuar',
	'DOWNLOADING_FILE'		=> 'Duke shkarkuar skedar',
	'DOWNLOAD_COUNT'		=> 'Shkarkuar %d herë',
	'DOWNLOAD_COUNTS'		=> 'Shkarkuar %d herë',
	'DOWNLOAD_COUNT_NONE'	=> 'Pa shkarkuar akoma',
	'VIEWED_COUNT'			=> 'Parë %d herë',
	'VIEWED_COUNTS'			=> 'Parë %d herë',
	'VIEWED_COUNT_NONE'		=> 'Pa parë ndonjëherë',
	
	'EDIT_POST'							=> 'Modifiko postimin',
    'EMAIL'                        		=> 'E-mail', // Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'Adresa E-mail',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'Njoftoni për probleme duke njoftuar me e-mail në <strong>Line %1$s</strong>. Përgjigje: %2$s.',
	'EMPTY_SUBJECT'						=> 'Ju duhet të specifikoni një subjekt për temën e re.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'Ju duhet të specifikoni një subjekt kur dërgoni një mesazh të ri.',
	'ENABLED'							=> 'Aktivizuar',
	'ENCLOSURE'							=> 'Mbyllur',
	'ERR_CHANGING_DIRECTORY'			=> 'I pamundur ndërrimi i direktorisë.',
	'ERR_CONNECTING_SERVER'				=> 'Gabim duke u lidhur me serverin.',
	'ERR_JAB_AUTH'						=> 'Nuk mund të autorizohet serveri Jabber.',
	'ERR_JAB_CONNECT'					=> 'Nuk mund të kryhet lidhja me serverin Jabber.',
	'ERR_UNABLE_TO_LOGIN'				=> 'Pseudonimi ose fjalëkalimi i specifikuar është i gabuar.',
	'ERR_UNWATCHING'					=> 'An error occured while trying to unsubscribe.',
	'ERR_WATCHING'						=> 'An error occured while trying to subscribe.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'Vendodhja e specifikuar e phpBB duket e pavlefshme.',
	'EXPAND_VIEW'						=> 'Zgjero pamjen',
	'EXTENSION'							=> 'Prapashtesë',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'Prapashtesa <strong>%s</strong> është ç\'aktivizuar dhe nuk mund të shfaqet më.',
	
	'FAQ'					=> 'FAQ',
	'FAQ_EXPLAIN'			=> 'Informacione ndihmuese',
	'FILENAME'				=> 'Emri i skedarit',
	'FILESIZE'				=> 'Masa e skedarit',
	'FILEDATE'				=> 'Data e skedarit',
	'FILE_COMMENT'			=> 'Komenti i skedarit',
	'FILE_NOT_FOUND'		=> 'Skedari i kërkuar nuk mund të gjëndet.',
	'FIND_USERNAME'			=> 'Gjej një antar',
	'FOLDER'				=> 'Kartelë',
	'FORGOT_PASS'			=> 'Kam harruar fjalëkalimin.',
	'FORM_INVALID'			=> 'Forma e dërguar nuk është e saktë. Mundohuni ta dërgoni atë përsëri.',
	'FORUM'					=> 'Forum',
	'FORUMS'				=> 'Forume',
	'FORUMS_MARKED'			=> 'Të gjithë forumet janë shënuar si të lexuar.',
	'FORUM_CAT'				=> 'Kategoria Forumit',
	'FORUM_INDEX'			=> 'Forumi',
	'FORUM_LINK'			=> 'Linku Forumit',
	'FORUM_LOCATION'		=> 'Vendodhja e Forumit',
	'FORUM_LOCKED'			=> 'Forum i mbyllur',
	'FORUM_RULES'			=> 'Rregullat e Forumit',
	'FORUM_RULES_LINK'		=> 'Klikoni këtu për të përë rregullat e forumit',
	'FROM'					=> 'nga',
	'FSOCK_DISABLED'		=> 'Operacioni nuk mund të kompletohet sepse funksioni <var>fsockopen</var> është ë\'aktivizuar ose lidhja me serverin nuk u bë.',
	
	'FTP_FSOCK_HOST'				=> 'Host FTP',
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'Serveri FTP që duhet të përdoret për t\'u lidhur me sitin',
	'FTP_FSOCK_PASSWORD'			=> 'Fjalëkalimi FTP',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'Fjalëkalimi për përdoruesin e FTP.',
	'FTP_FSOCK_PORT'				=> 'Porta FTP',
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'Porta që duhet të përdoret për t\'u lidhur me serverin.',
	'FTP_FSOCK_ROOT_PATH'			=> 'Vendodhja e phpBB',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'Vendodhja e direktorisë së bordit tuaj phpBB.',
	'FTP_FSOCK_TIMEOUT'				=> 'FTP jashtë kohe',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'Koha në sekonda, gjatë së cilës sistemi do të presë për përgjigje nga serveri juaj.',
	'FTP_FSOCK_USERNAME'			=> 'Pseudonimi FTP',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'Pseudonimi që do të përdoret për t\'u lidhur me serverin.',
	
	'FTP_HOST'					=> 'Hosti FTP',
	'FTP_HOST_EXPLAIN'			=> 'Serveri FTP që do të përdoret për tu lidhur me faqen tuaj.',
	'FTP_PASSWORD'				=> 'Fjalëkalimi FTP',
	'FTP_PASSWORD_EXPLAIN'		=> 'Fjalëkalimi per pseudonimin tuaj FTP.',
	'FTP_PORT'					=> 'Porta FTP',
	'FTP_PORT_EXPLAIN'			=> 'Porta që do të përdoret për tu lidhur me serverin tuaj.',
	'FTP_ROOT_PATH'				=> 'Vendodhja e phpBB',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'Direktoria e vendodhjes së bordit tuaj phpBB.',
	'FTP_TIMEOUT'				=> 'FTP jashtë kohe',
	'FTP_TIMEOUT_EXPLAIN'		=> 'Koha në sekonda, gjatë së cilës sistemi do të presë për përgjigje nga serveri juaj.',
	'FTP_USERNAME'				=> 'Pseudonimi FTP',
	'FTP_USERNAME_EXPLAIN'		=> 'Pseudonimi që do të përdoret për t\'u lidhur me serverin.',
	
	'GENERAL_ERROR'				=> 'Gabim i Përgjithshëm',
    'GB'                  		=> 'GB',
    'GIB'                  		=> 'GiB',
	'GO'						=> 'Shko',
	'GOTO_PAGE'					=> 'Shko tek faqa',
	'GROUP'						=> 'Grupi',
	'GROUPS'					=> 'Grupet',
	'GROUP_ERR_TYPE'			=> 'Lloji i grupit i specifikuar nuk është i përshtatshëm.',
	'GROUP_ERR_USERNAME'		=> 'Asnjë emër grupi i specifikuar.',
	'GROUP_ERR_USER_LONG'		=> 'Emrat e grupeve nuk mund t\'i kalojnë 60 shkronjat. Emri i grupit të specifikuar është shumë i gjatë.',
	'GUEST'						=> 'Vizitor',
	'GUEST_USERS_ONLINE'		=> 'Janë %d përdorues në linjë.',
	'GUEST_USERS_TOTAL'			=> '%d vizitorë',
	'GUEST_USERS_ZERO_ONLINE'	=> 'Gjënden 0 vizitorë në linjë',
	'GUEST_USERS_ZERO_TOTAL'	=> '0 vizitorë',
	'GUEST_USER_ONLINE'			=> 'Gjëndet %d vizitor në linjë',
	'GUEST_USER_TOTAL'			=> '%d vizitor',
	'G_ADMINISTRATORS'			=> 'Administratorë',
	'G_BOTS'					=> 'Bots',
	'G_GUESTS'					=> 'Vizitorë',
	'G_REGISTERED'				=> 'Antarë të regjistruar',
	'G_REGISTERED_COPPA'		=> 'Antarë të regjistruar COPPA',
	'G_GLOBAL_MODERATORS'		=> 'Moderatorë Global',
	
	'HIDDEN_USERS_ONLINE'			=> '%d antarë të fshehur në linjë',
	'HIDDEN_USERS_TOTAL'			=> '%d të fshehur',
	'HIDDEN_USERS_TOTAL_AND'		=> '%d të fshehur dhe ',
	'HIDDEN_USERS_ZERO_ONLINE'		=> '0 antarë të fshehur në linjë',
	'HIDDEN_USERS_ZERO_TOTAL'		=> '0 të fshehur',
	'HIDDEN_USERS_ZERO_TOTAL_AND'	=> '0 të fshehur dhe ',
	'HIDDEN_USER_ONLINE'			=> '%d antarë të fshehur në linjë',
	'HIDDEN_USER_TOTAL'				=> '%d të fshehur',
	'HIDDEN_USER_TOTAL_AND'			=> '%d të fshehur dhe ',
	'HIDE_GUESTS'					=> 'Mos trego vizitorët',
	'HIDE_ME'						=> 'Mos trego statusin tim në linjë këtë seancë',
	'HOURS'							=> 'Orë',
	'HOME'							=> 'Faqja Kryesore',
	
	'ICQ'						=> 'ICQ',
	'ICQ_STATUS'				=> 'Statusi ICQ',
	'IF'						=> 'Nëse',
	'IMAGE'						=> 'Imazh',
	'IMAGE_FILETYPE_INVALID'	=> 'Tipi imazhit %d për mimetype %s nuk suportohet.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'Mosperputhje në llojin e imazhit: prapashtesa e duhur %1$s prapashtesa e dhënë %2$s.',
	'IN'						=> 'në',
	'INDEX'						=> 'Indeksi',
	'INFORMATION'				=> 'Informacion',
	'INTERESTS'					=> 'Interesat',
	'INVALID_DIGEST_CHALLENGE'	=> 'Invalid digest challenge.',
	'INVALID_EMAIL_LOG'			=> '<strong>%s</strong> ndoshta një adresë e-mail e pa vlefshme?',
	'IP'						=> 'IP',
	'IP_BLACKLISTED'			=> 'IP juaj %1$s është bllokuar sepse bën pjesë në listën e zezë. Për detaje ju lutem shikoni <a href="%2$s">%2$s</a>.',
	
	'JABBER'				=> 'Jabber',
	'JOINED'				=> 'Antarësuar',
	'JUMP_PAGE'				=> 'Vendos numrin e faqes ku doni të shkoni.',
	'JUMP_TO'				=> 'Kalo tek',
	'JUMP_TO_PAGE'			=> 'Kliko për të kaluar tek faqja…',
	
	'KB'					=> 'KB',
	'KIB'					=> 'KiB',
	
	'LAST_POST'							=> 'Postimi fundit',
	'LAST_UPDATED'						=> 'Azhornimi fundit',
	'LAST_VISIT'						=> 'Vizita e fundit',
	'LDAP_NO_LDAP_EXTENSION'			=> 'Prapashtesa LDAP është e pavlefshme.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'Nuk mund të bëhet lidhja me serverin LDAP.',
	'LEGEND'							=> 'Legjenda',
	'LOCATION'							=> 'Vendodhja',
	'LOCK_POST'							=> 'Mbyll postim',
	'LOCK_POST_EXPLAIN'					=> 'Ndalo modifikimin',
	'LOCK_TOPIC'						=> 'Mbyll temë',
	'LOGIN'								=> 'Identifikimi',
	'LOGIN_CHECK_PM'					=> 'Identifikohu që të kontrolloni mesazhet private.',
	'LOGIN_CONFIRMATION'				=> 'Konfirmimi i identifikimit',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'Për të evituar hyrjen me forcë në llogarinë tuaj, bordi ju kërkon që të fusni një kod konfirmimi pas një numër të caktuar hyrjesh të dështuara! Kodi është shfaqur në imazhin që duhet të shihni më poshtë! Nëse keni probleme me shikimin ose nuk mund të lexoni këtë imazh, ju lutem komunikoni me  %sAdministratorin%s.',
	'LOGIN_ERROR_ATTEMPTS'				=> 'Keni tejkaluar numrin e lejueshëm të mundësive për të hyrë. Tani përvec pseudonimit dhe fjalëkalimit ju duhet të fusni edhe kodin që shfaqet në imazhin e mëposhtëm.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'Ju nuk jeni autentikuar nga Apache.',
	'LOGIN_ERROR_PASSWORD'				=> 'Ju keni specifikuar një fjalëkalim të gabuar. Ju lutemi të kontrolloni fjalëkalimin dhe ta provoni përsëri. Nëse vazhdoni të keni probleme kontaktoni %sAdministratorin%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'Ishte i pamundur konvertimi i fjalëkalimit tuaj pas azhornimit të bordit. Ju lutemi %skërkoni një fjalëkalim tëe ri%s. Nëse vazhdoni të keni probleme kontaktoni %sAdministratorin%s.',
	'LOGIN_ERROR_USERNAME'				=> 'Ju keni specifikuar një pseudonim të gabuar. Ju lutemi të kontrolloni pseudonimin tuaj dhe ta provoni përsëri. Nëse vazhdoni të keni probleme kontaktoni %sAdministratorin%s.',
	'LOGIN_FORUM'						=> 'Që të hyni në këtë pjesë të forumit ju duhet të shkruani një fjalëkalim të paracaktuar nga bordi.',
	'LOGIN_INFO'						=> 'Para se të identifikoheni ju duhet të jeni të regjistruar. Regjistrimi zgjat vetëm pak minuta dhe ju jep ju të drejta të shumta. Para se të regjistroheni sigurohuni që të jeni dakord me rregullat dhe termat e përdorimit. Ju lutemi lexojini rregullat në çdo forum që vizitoni.',
	'LOGIN_VIEWFORUM'					=> 'Për të parë këtë forum, bordi kërkon që ju të jeni të regjistruar dhe të identifikuar.',
	'LOGIN_EXPLAIN_EDIT'				=> 'Ju duhet të jeni të regjistruar dhe të identifikuar që të modifikoni këtë forum.',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'Ju duhet të jeni të regjistruar dhe të identifikuar që të shikoni listën e përdoruesve në linjë.',
	'LOGOUT'							=> 'Ç\'identifikimi',
	'LOGOUT_USER'						=> 'Ç\'identifikohu [ %s ]',
	'LOG_ME_IN'							=> 'Më identifiko automatikisht çdo vizitë',
	
	'MARK'					=> 'Selekto',
	'MARK_ALL'				=> 'Selekto të gjithë',
	'MARK_FORUMS_READ'		=> 'Shënoji forumet si të lexuar',
	'MB'					=> 'MB',
	'MIB'					=> 'MiB',
	'MCP'					=> 'Paneli i Moderatorit',
	'MEMBERLIST'			=> 'Antarët',
	'MEMBERLIST_EXPLAIN'	=> 'Shiko listen e plotë të antarëve',
	'MERGE'					=> 'Bashko',
	'MERGE_POSTS'			=> 'Bashko postime',
	'MERGE_TOPIC'			=> 'Bashko tema',
	'MESSAGE'				=> 'Mesazh',
	'MESSAGES'				=> 'Mesazhe',
	'MESSAGE_BODY'			=> 'Trupi mesazhit',
	'MINUTES'				=> 'Minuta',
	'MODERATE'				=> 'Modero',
	'MODERATOR'				=> 'Moderator',
	'MODERATORS'			=> 'Moderatorë',
	'MONTH'					=> 'Muaj',
	'MOVE'					=> 'Lëviz',
	'MSNM'					=> 'MSNM/WLM',
	
	'NA'						=> 'N/A',
	'NEWEST_USER'				=> 'Antari më i ri <strong>%s</strong>',
	'NEW_MESSAGE'				=> 'Mesazh i ri',
	'NEW_MESSAGES'				=> 'Mesazhe të rinj',
	'NEW_PM'					=> '<strong>%d</strong> mesazh i ri',
	'NEW_PMS'					=> '<strong>%d</strong> mesazhe të rinj',
	'NEW_POST'					=> 'Postimi ri',
	'NEW_POSTS'					=> 'Postime të reja',
	'NEXT'						=> 'Përpara',
	'NEXT_STEP'					=> 'Tjetra',
	'NEVER'						=> 'Kurrë',
	'NO'						=> 'Jo',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'Ju nuk ju lejohet të menaxhoni këtë grup.',
	'NOT_AUTHORISED'			=> 'Ju nuk jeni të autorizuar të keni të drejtën e hyrjes në këtë hapsirë.',
	'NOT_WATCHING_FORUM'		=> 'Ju nuk jeni më i abonuar për azhornimet në këtë forum.',
	'NOT_WATCHING_TOPIC'		=> 'Ju nuk jeni më të abonuar tek kjo temë.',
	'NOTIFY_ADMIN'				=> 'Ju lutem, njoftoni bordin administrativ ose webmasterin.',
	'NOTIFY_ADMIN_EMAIL'		=> 'Ju lutem, njoftoni bordin administrativ ose webmasterin.: <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'		=> 'Ju nuk jeni të autorizuar të hapni këtë skedar.',
	'NO_ACTION'					=> 'Asnjë veprim i specifikuar.',
	'NO_ADMINISTRATORS'			=> 'Asnjë administrator',
	'NO_AUTH_ADMIN'				=> 'Nuk keni te drejta për të patur hyrje në ACP, me qënë se ju nuk jeni të autorizuar.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'Nuk është e mundur që ju të ri-identifikoheni si një antar tjetër.',
	'NO_AUTH_OPERATION'			=> 'Ju nuk keni të drejtat e duhura për të kompletuar këte veprim.',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'Nuk mund të arrihet lidhja me hostin smtp : %1$s : %2$s',
	'NO_BIRTHDAYS'				=> 'Asnjë antar nuk ka ditëlindjen sot.',
	'NO_EMAIL_MESSAGE'			=> 'Mesazhi E-mail ishte bosh.',
	'NO_EMAIL_RESPONSE_CODE'	=> 'Nuk u gjëndën kodet e e-mail në server.',
	'NO_EMAIL_SUBJECT'			=> 'Nuk u specifikua një subjekt për e-mail.',
	'NO_FORUM'					=> 'Forumi që ju zgjodhët nuk ekziston.',
	'NO_FORUMS'					=> 'Ky bord nuk ka forume.',
	'NO_GROUP'					=> 'Grupi i përdoruesve të kërkuar nuk ekziston.',
	'NO_GROUP_MEMBERS'			=> 'Ky grup nuk ka antarë.',
	'NO_IPS_DEFINED'			=> 'Nuk u përcaktua asnjë adresë IP ose emër hosti.',
	'NO_MEMBERS'				=> 'Nuk u gjet asnjë antar me këto kritere kërkimi.',
	'NO_MESSAGES'				=> 'Asnjë mesazh',
	'NO_MODE'					=> 'Asnjë mënyrë e specifikuar.',
	'NO_MODERATORS'				=> 'Nuk ka moderator.',
	'NO_NEW_MESSAGES'			=> 'Asnjë mesazh i ri',
	'NO_NEW_PM'					=> '<strong>0</strong> mesazhe',
	'NO_NEW_POSTS'				=> 'Asnjë postim i ri',
	'NO_ONLINE_USERS'			=> 'Asnjë antar i regjistruar',
	'NO_POSTS'					=> 'Asnjë postim',
	'NO_POSTS_TIME_FRAME'		=> 'Në këtë temë nuk ka postime për kohën e caktuar.',
	'NO_SUBJECT'				=> 'Subjekti i pa specifikuar',
	'NO_SUCH_SEARCH_MODULE'		=> 'Kërkimi i specifikuar nuk ekziston.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'Asnjë metodë autentikimi e suportuar.',
	'NO_TOPIC'					=> 'Tema e kërkuar nuk ekziston.',
	'NO_TOPIC_FORUM'			=> 'Tema ose forumi nuk ekzistojnë më.',
	'NO_TOPICS'					=> 'Në këtë forum nuk ka asnjë temë apo postim.',
	'NO_TOPICS_TIME_FRAME'		=> 'Në këtë forum nuk ka tema për kohën e caktuar.',
	'NO_UNREAD_PM'				=> '<strong>0</strong> mesazhe të palexuara',
	'NO_UPLOAD_FORM_FOUND'		=> 'Ngarkimi filloi por nuk u gjet asnjë mënyrë e vlefshme ngarkimi.',
	'NO_USER'					=> 'Antari kërkuar nuk ekziston.',
	'NO_USERS'					=> 'Antarët e kërkuar nuk akzistojnë.',
	'NO_USER_SPECIFIED'			=> 'Nuk u specifikua pseudonimi.',
	
	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_POSTS_IN_QUEUE'		=> array(
		0			=> 'Nuk ka postime në pritje',		// 0
		1			=> '1 Postim në pritje',		// 1
		2			=> '%d Postime në pritje',			// 2+
	),

	'OCCUPATION'				=> 'Profesioni',
	'OFFLINE'					=> 'Jo në linjë',
	'ONLINE'					=> 'Në linjë',
	'ONLINE_BUDDIES'			=> 'Shokë në linjë',
	'ONLINE_USERS_TOTAL'		=> 'Në total janë <strong>%d</strong> përdorues në linjë :: ',
	'ONLINE_USERS_ZERO_TOTAL'	=> 'Në total janë <strong>0</strong> përdorues në linjë :: ',
	'ONLINE_USER_TOTAL'			=> 'Në total është <strong>%d</strong> përdorues në linjë :: ',
	'OPTIONS'					=> 'Opsione',
	
	'PAGE_OF'				=> 'Faqe <strong>%1$d</strong> prej <strong>%2$d</strong>',
	'PASSWORD'				=> 'Fjalëkalimi',
	'PLAY_QUICKTIME_FILE'	=> 'Luaj skedarin Quicktime',
	'PM'					=> 'PM',
	'POSTING_MESSAGE'		=> 'Duke postuar mesazh në %s',
	'POSTING_PRIVATE_MESSAGE'	=> 'Duke shkruar mesazh privat',
	'POST'					=> 'Post',
	'POST_ANNOUNCEMENT'		=> 'Lajmërim',
	'POST_STICKY'			=> 'Kryetemë',
	'POSTED'				=> 'Postuar',
	'POSTED_IN_FORUM'		=> 'në',
	'POSTED_ON_DATE'		=> 'më',
	'POSTS'					=> 'Poste',
	'POSTS_UNAPPROVED'		=> 'Të paktën një postim i kësaj teme nuk është aprovuar.',
	'POST_BY_AUTHOR'		=> 'nga',
	'POST_BY_FOE'			=> 'Ky postim është bërë nga <strong>%1$s</strong> që momentalisht është në listën tuaj të injorimit. %2$sTrego këtë postim%3$s.',
	'POST_DAY'				=> '%.2f postime për ditë',
	'POST_DETAILS'			=> 'Detajet e postimit',
	'POST_NEW_TOPIC'		=> 'Posto temë të re',
	'POST_PCT'				=> '%.2f%% prej të gjithë postimeve',
	'POST_PCT_ACTIVE'		=> '%.2f%% e postimeve të antarëve',
	'POST_PCT_ACTIVE_OWN'	=> '%.2f%% e postimeve tuaja',
	'POST_REPLY'			=> 'Posto një përgjigje',
	'POST_REPORTED'			=> 'Kliko për të parë raportimin',
	'POST_SUBJECT'			=> 'Subjekti postimit',
	'POST_TIME'				=> 'Ora e postimit',
	'POST_TOPIC'			=> 'Posto një temë të re',
	'POST_UNAPPROVED'		=> 'Ky post është në pritje për aprovim',
	'PREVIEW'				=> 'Shiko',
	'PREVIOUS'				=> 'Mëparshme',
	'PREVIOUS_STEP'			=> 'Mëparshme',
	'PRIVACY'				=> 'Privacy policy',
	'PRIVATE_MESSAGE'		=> 'Mesazh privat',
	'PRIVATE_MESSAGES'		=> 'Mesazhe private',
	'PRIVATE_MESSAGING'		=> 'Mesazhimi privat',
	'PROFILE'				=> 'Paneli i Antarit',
	
	'READING_FORUM'				=> 'Duke parë temë në %s',
	'READING_GLOBAL_ANNOUNCE'	=> 'Duke lexuar lajmërimet globale',
	'READING_LINK'				=> 'Ndiq linkun e forumit %s',
	'READING_TOPIC'				=> 'Duke lexuar temë në %s',
	'READ_PROFILE'				=> 'Profili',
	'REASON'					=> 'Arsyeja',
	'RECORD_ONLINE_USERS'		=> 'Numri Rekord i përdoruesve në linjë ishte <strong>%1$s</strong> më %2$s',
	'REDIRECT'					=> 'Ridrejtuar',
	'REDIRECTS'					=> 'Totali ridrejtimeve',
	'REGISTER'					=> 'Regjistrohu',
	'REGISTERED_USERS'			=> 'Antarë të regjistruar:',
	'REG_USERS_ONLINE'			=> 'Gjënden %d antarë të regjistruar dhe ',
	'REG_USERS_TOTAL'			=> '%d të regjistruar, ',
	'REG_USERS_TOTAL_AND'		=> '%d të regjistruar dhe ',
	'REG_USERS_ZERO_ONLINE'		=> 'Gjënden 0 antarë të regjistruar dhe ',
	'REG_USERS_ZERO_TOTAL'		=> '0 të regjistruar, ',
	'REG_USERS_ZERO_TOTAL_AND'	=> '0 registered and ',
	'REG_USER_ONLINE'			=> 'Gjëndet %d antar i regjistruar dhe ',
	'REG_USER_TOTAL'			=> '%d të regjistruar ',
	'REG_USER_TOTAL_AND'		=> '%d të regjistruar dhe ',
	'REMOVE'					=> 'Fshi',
	'REMOVE_INSTALL'			=> 'Ju lutemi fshini, lëvizni ose riemertoni direktorinë e instalimit para se të përdorni bordin. Nëse kjo direktori është akoma prezente, vetëm Paneli i Administratoritl (ACP) do të jetë i përdorshëm.',
	'REPLIES'					=> 'Përgjigjet',
	'REPLY_WITH_QUOTE'			=> 'Përgjigju duke Cituar',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'Duke ju përgjigjur Lajmërimit Global',
	'REPLYING_MESSAGE'			=> 'Duke ju përgjigjur mesazhit në %s',
	'REPORT_BY'					=> 'Raport nga',
	'REPORT_POST'				=> 'Raporto këtë postim',
	'REPORTING_POST'			=> 'Duke raportuar postim',
	'RESEND_ACTIVATION'			=> 'Ridërgo email-in e aktivizimit.',
	'RESET'						=> 'Reseto',
	'RESTORE_PERMISSIONS'		=> 'Reseto të drejtat',
	'RETURN_INDEX'				=> '%sKthehu tek indeksi%s',
	'RETURN_FORUM'				=> '%sKthehu tek forumi i vizituar së fundmi%s',
	'RETURN_PAGE'				=> '%sKthehu tek faqja e mëparshme%s',
	'RETURN_TOPIC'				=> '%sKthehu tek tema e vizituar së fundmi%s',
	'RETURN_TO'					=> 'Kthehu tek',
	'RULES_ATTACH_CAN'			=> 'Ju <strong>mund</strong> të bashkëngjisni skedarë',
	'RULES_ATTACH_CANNOT'		=> 'Ju <strong>nuk mund</strong> të bashkëngjisni skedarë',
	'RULES_DELETE_CAN'			=> 'Ju <strong>mund</strong> të fshini postimet tuaja',
	'RULES_DELETE_CANNOT'		=> 'Ju <strong>nuk mund</strong> të fshini postimet tuaja',
	'RULES_DOWNLOAD_CAN'		=> 'Ju <strong>mund</strong> të shkarkoni skedarë',
	'RULES_DOWNLOAD_CANNOT'		=> 'Ju <strong>nuk mund</strong> të shkarkoni skedarë',
	'RULES_EDIT_CAN'			=> 'Ju <strong>mund</strong> të modifikoni postimet tuaja',
	'RULES_EDIT_CANNOT'			=> 'Ju <strong>nuk mund</strong> të modifikoni postimet tuaja',
	'RULES_LOCK_CAN'			=> 'Ju <strong>mund</strong> të mbyllni temat tuaja',
	'RULES_LOCK_CANNOT'			=> 'Ju <strong>uk mund</strong> të mbyllni temat tuaja',
	'RULES_POST_CAN'			=> 'Ju <strong>mund</strong> të hapni tema të reja',
	'RULES_POST_CANNOT'			=> 'Ju <strong>nuk mund</strong> të hapni tema të reja',
	'RULES_REPLY_CAN'			=> 'Ju <strong>mund</strong> të postoni përgjigje',
	'RULES_REPLY_CANNOT'		=> 'Ju <strong>nuk mund</strong> të postoni përgjigje',
	'RULES_VOTE_CAN'			=> 'Ju <strong>mund</strong> të votoni në këtë forum',
	'RULES_VOTE_CANNOT'			=> 'Ju <strong>nuk mund</strong> të votoni në këtë forum',
	
	'SEARCH'					=> 'Kërko',
	'SEARCH_MINI'				=> 'Kërkoni…',
	'SEARCH_ADV'				=> 'Kërkim i avancuar',
	'SEARCH_ADV_EXPLAIN'		=> 'Shiko opsionet e kërkimit të avancuar',
	'SEARCH_KEYWORDS'			=> 'Kërko për fjalë kyçe',
	'SEARCHING_FORUMS'			=> 'Duke kërkuar forumet',
	'SEARCH_ACTIVE_TOPICS'		=> 'Temat më aktive',
	'SEARCH_FOR'				=> 'Kërko për',
	'SEARCH_FORUM'				=> 'Kërko në këtë forum...',
	'SEARCH_NEW'				=> 'Postimet e Reja',
	'SEARCH_POSTS_BY'			=> 'Kërko postimet nga',
	'SEARCH_SELF'				=> 'Shiko postimet e tua',
	'SEARCH_TOPIC'				=> 'Kërko në temë...',
	'SEARCH_UNANSWERED'			=> 'Postimet pa përgjigje',
	'SECONDS'					=> 'Sekonda',
	'SELECT'					=> 'Selekto',
	'SELECT_ALL_CODE'			=> 'Selekto të gjithë',
	'SELECT_DESTINATION_FORUM'	=> 'Zgjidh një forum si destinacion',
	'SELECT_FORUM'				=> 'Zgjidh një forum',
    'SEND_EMAIL'            	=> 'E-mail',            	// Used for submit buttons
	'SEND_EMAIL_USER'			=> 'E-mail',				// Used as: {L_SEND_EMAIL_USER} {USERNAME} -> E-mail UserX
	'SEND_PRIVATE_MESSAGE'		=> 'Dërgo mesazh privat',
	'SETTINGS'					=> 'Preferenca',
	'SIGNATURE'					=> 'Firma',
	'SKIP'						=> 'Kalo tek përmbajtja',
	'SMTP_NO_AUTH_SUPPORT'		=> 'Serveri SMTP nuk suporton autentikim.',
	'SORRY_AUTH_READ'			=> 'Ju nuk mund të lexoni këtë forum.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'Ju nuk mund të shkarkoni këtë shtojcë.',
	'SORT_BY'					=> 'Rrjeshto sipas',
	'SORT_JOINED'				=> 'Data e regjistrimit',
	'SORT_LOCATION'				=> 'Vendodhja',
	'SORT_RANK'					=> 'Grada',
	'SORT_TOPIC_TITLE'			=> 'Titulli i Temës',
	'SORT_USERNAME'				=> 'Pseudonimi',
	'SPLIT_TOPIC'				=> 'Nda temën',
	'SQL_ERROR_OCCURRED'		=> 'Gabim në SQL gjatë hapjes së kësaj faqeje. Ju lutemi të kontaktoni %sAdministratorin%s nëse ky problem ju shfaqet përsëri.',
	'STATISTICS'				=> 'Statistikat',
	'START_WATCHING_FORUM'		=> 'Abonohu në këtë forum',
	'START_WATCHING_TOPIC'		=> 'Abonohu në këtë temë',
	'STOP_WATCHING_FORUM'		=> 'Hiq abomomin në këtë forum',
	'STOP_WATCHING_TOPIC'		=> 'Hiq abominin në këtë temë',
	'SUBFORUM'					=> 'Nënforum',
	'SUBFORUMS'					=> 'Nënforume',
	'SUBJECT'					=> 'Subjekti',
	'SUBMIT'					=> 'Posto Përgjigjen',
	
	'TERMS_USE'			=> 'Termat e përdorimit',
	'TEST_CONNECTION'	=> 'Testo lidhjen',
	'THE_TEAM'			=> 'Drejtuesit',
	'TIME'				=> 'Koha',
	
	'TOO_LONG'						=> 'Vlera e caktuar është shumë e gjatë.',
	
	'TOO_LONG_AIM'					=> 'Emri i shfaqjes që caktuat është shumë i gjatë.',
	'TOO_LONG_CONFIRM_CODE'			=> 'Kodi i konfirmimit që caktuat është shumë i gjatë.',
	'TOO_LONG_DATEFORMAT'			=> 'Formati i datës që ju caktuat është shumë i gjatë.',
	'TOO_LONG_ICQ'					=> 'Numri ICQ që ju caktuat është shumë i gjatë.',
	'TOO_LONG_INTERESTS'			=> 'Interesat që caktuat janë shumë të gjata.',
	'TOO_LONG_JABBER'				=> 'Emri i llogarise Jabber që caktuat është shumë i gjatë.',
	'TOO_LONG_LOCATION'				=> 'Vendodhja që caktuat është shumë e gjatë.',
	'TOO_LONG_MSN'					=> 'Emri MSNM/WLM që caktuat është shumë i gjatë.',
	'TOO_LONG_NEW_PASSWORD'			=> 'Fjalëkalimi që caktuat është shumë i gjatë.',
	'TOO_LONG_OCCUPATION'			=> 'Profesioni që caktuat është shumë i gjatë.',
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'Fjalëkalimi i konfirmimit është shumë i gjatë.',
	'TOO_LONG_USER_PASSWORD'		=> 'Fjalëkalimi që caktuat është shumë i gjatë.',
	'TOO_LONG_USERNAME'				=> 'Pseudonimi që caktuat është shumë i gjatë.',
	'TOO_LONG_EMAIL'				=> 'Adresa e-mail që caktuat është shumë e gjatë.',
	'TOO_LONG_EMAIL_CONFIRM'		=> 'Adresa e-mail e konfirmimit që caktuat është shumë e gjatë.',
	'TOO_LONG_WEBSITE'				=> 'Adresa web që caktuat është shumë e gjatë.',
	'TOO_LONG_YIM'					=> 'Emri i Yahoo! Messenger që caktuat është shumë i gjatë.',
	
	'TOO_MANY_VOTE_OPTIONS'			=> 'Ju u munduat të votoni shumë opsione.',
	
	'TOO_SHORT'						=> 'Vlera e caktuar është shumë e shkurtër.',
	
	'TOO_SHORT_AIM'					=> 'Emri i shfaqjes që caktuat është shumë i shkurtër.',
	'TOO_SHORT_CONFIRM_CODE'		=> 'Kodi i konfirmimit që caktuat është shumë i shkurtër.',
	'TOO_SHORT_DATEFORMAT'			=> 'Formati i datës që caktuat është shumë i shkurtër.',
	'TOO_SHORT_ICQ'					=> 'Numri ICQ që ju caktuat është shumë i shkurtër.',
	'TOO_SHORT_INTERESTS'			=> 'Interesat që caktuat janë shumë të shkurtra.',
	'TOO_SHORT_JABBER'				=> 'Emri i llogarise Jabber që caktuat është shumë i shkurtër.',
	'TOO_SHORT_LOCATION'			=> 'Vendodhja që caktuat është shumë e shkurtër.',
	'TOO_SHORT_MSN'					=> 'Emri MSNM/WLM që caktuat është shumë i shkurtër.',
	'TOO_SHORT_NEW_PASSWORD'		=> 'Fjalëkalimi që caktuat është shumë i shkurtër.',
	'TOO_SHORT_OCCUPATION'			=> 'Profesioni që caktuat është shumë i shkurtër.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'Fjalëkalimi i konfirmimit është shumë i shkurtër.',
	'TOO_SHORT_USER_PASSWORD'		=> 'Fjalëkalimi që caktuat është shumë i shkurtër.',
	'TOO_SHORT_USERNAME'			=> 'Pseudonimi që caktuat është shumë i shkurtër.',
	'TOO_SHORT_EMAIL'				=> 'Adresa e-mail që caktuat është shumë e shkurtër.',
	'TOO_SHORT_EMAIL_CONFIRM'		=> 'Adresa e-mail e konfirmimit që caktuat është shumë e shkurtër.',
	'TOO_SHORT_WEBSITE'				=> 'Adresa web që caktuat është shumë e shkurtër.',
	'TOO_SHORT_YIM'					=> 'Emri i Yahoo! Messenger që caktuat është shumë i shkurtër.',
	
	'TOPIC'				=> 'Temë',
	'TOPICS'			=> 'Tema',
	'TOPIC_ICON'		=> 'Ikona e temës',
	'TOPIC_LOCKED'		=> 'Kjo temë ëshë e mbyllur, ju nuk mund të redaktoni postime ose të përgjigjeni.',
	'TOPIC_LOCKED_SHORT'=> 'Tema u mbyll',
	'TOPIC_MOVED'		=> 'Sposto temë',
	'TOPIC_REVIEW'		=> 'Rishikimi i temës',
	'TOPIC_TITLE'		=> 'Titulli i temës',
	'TOPIC_UNAPPROVED'	=> 'Kjo temë nuk është aprovuar',
	'TOTAL_ATTACHMENTS'	=> 'Shtojcë (a)',
	'TOTAL_LOG'			=> '1 hyrje',
	'TOTAL_LOGS'		=> '%d hyrje',
	'TOTAL_NO_PM'		=> '0 mesazhe private në total',
	'TOTAL_PM'			=> '1 mesazh privat në total',
	'TOTAL_PMS'			=> '%d mesazhe private në total',
	'TOTAL_POSTS'		=> 'Totali postimeve',
	'TOTAL_POSTS_OTHER'	=> 'Totali postimeve <strong>%d</strong>',
	'TOTAL_POSTS_ZERO'	=> 'Totali postimeve <strong>0</strong>',
	'TOPIC_REPORTED'	=> 'Kjo temë është raportuar',
	'TOTAL_TOPICS_OTHER'=> 'Tema <strong>%d</strong>',
	'TOTAL_TOPICS_ZERO'	=> 'Totali temave <strong>0</strong>',
	'TOTAL_USERS_OTHER'	=> 'Antarë <strong>%d</strong>',
	'TOTAL_USERS_ZERO'	=> 'Totali i Antarëve <strong>0</strong>',
	'TRACKED_PHP_ERROR'	=> 'Gjurmë gabimesh PHP: %s',
	
	'UNABLE_GET_IMAGE_SIZE'	=> 'Ishte i pamundur përcaktimi i dimensioneve të imazhit.',
	'UNABLE_TO_DELIVER_FILE'=> 'I pamundur dorëzimi i skedarit.',
	'UNKNOWN_BROWSER'		=> 'Shfletues i panjohur',
	'UNMARK_ALL'			=> 'Ç\'selekto të gjithë',
	'UNREAD_MESSAGES'		=> 'Mesazhe të palexuar',
	'UNREAD_PM'				=> '<strong>%d</strong> mesazh i palexuar',
	'UNREAD_PMS'			=> '<strong>%d</strong> mesazhe të palexuara',
	'UNWATCHED_FORUMS'			=> 'Ju nuk jeni më të abonuar në forumet e zgjedhur.',
	'UNWATCHED_TOPICS'			=> 'Ju nuk jeni më të abonuar në forumet e zgjedhur.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'Ju nuk jeni më të abonuar në hyrjet e zgjedhura.',
	'UPDATE'				=> 'Azhorno',
	'UPLOAD_IN_PROGRESS'	=> 'Ngarkimi është momentalisht në proçes.',
	'URL_REDIRECT'			=> 'Nëse shfletuesi juaj nuk suporton ridrejtim %sklikoni KETU që të ridrejtoheni%s.',
	'USERGROUPS'			=> 'Grupet',
	'USERNAME'				=> 'Pseudonimi',
	'USERNAMES'				=> 'Pseudonimet',
	'USER_AVATAR'			=> 'Avatari i antarit',
	'USER_CANNOT_READ'		=> 'Ju nuk mund të lexoni postime në këtë forum.',
	'USER_POST'				=> '%d Postim',
	'USER_POSTS'			=> '%d Postime',
	'USERS'					=> 'Përdorues',
	'USE_PERMISSIONS'		=> 'Provo te drejtat e përdoruesit',
	
	'VARIANT_DATE_SEPARATOR'	=> ' / ',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'Parë',
	'VIEWING_FAQ'				=> 'Duke parë FAQ',
	'VIEWING_MEMBERS'			=> 'Duke parë detajet e antarit',
	'VIEWING_ONLINE'			=> 'Duke parë kush është ne linjë',
	'VIEWING_MCP'				=> 'Duke parë panelin e kontrollit të moderatorit',
	'VIEWING_MEMBER_PROFILE'	=> 'Duke parë profilin e antarit',
	'VIEWING_PRIVATE_MESSAGES'	=> 'Duke parë mesazhe private',
	'VIEWING_REGISTER'			=> 'Duke regjistruar llogari',
	'VIEWING_UCP'				=> 'Duke parë panelin e kontrollit të përdoruesit',
	'VIEWS'						=> 'Shikime',
	'VIEW_BOOKMARKS'			=> 'Shiko të preferuarat',
	'VIEW_FORUM_LOGS'			=> 'Shiko Hyrjet',
	'VIEW_LATEST_POST'			=> 'Shiko postimet e fundit',
	'VIEW_NEWEST_POST'			=> 'Shiko postimin e parë të palexuar',
	'VIEW_NOTES'				=> 'Shiko shënimet e përdoruesit',
	'VIEW_ONLINE_TIME'			=> 'Këto të dhëna bazohen në regjistrimet para %d minute',
	'VIEW_ONLINE_TIMES'			=> 'Këto të dhëna bazohen në regjistrimet para %d minutash',
	'VIEW_TOPIC'				=> 'Shiko temë',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'Lajmërim: ',
	'VIEW_TOPIC_GLOBAL'			=> 'Lajmërim Global: ',
	'VIEW_TOPIC_LOCKED'			=> 'Mbyllur: ',
	'VIEW_TOPIC_LOGS'			=> 'Shiko hyrjet',
	'VIEW_TOPIC_MOVED'			=> 'Lëvizur: ',
	'VIEW_TOPIC_POLL'			=> 'Sondazh: ',
	'VIEW_TOPIC_STICKY'			=> 'Kryetemë: ',
	'VISIT_WEBSITE'				=> 'Vizito faqen',
	
	'WARNINGS'			=> 'Paralajmërime',
	'WARN_USER'			=> 'Paralajmëro antar',
	'WELCOME_SUBJECT'	=> 'Mirë se vini tek %s forum',
	'WEBSITE'			=> 'Website',
	'WHOIS'				=> 'Kush është',
	'WHO_IS_ONLINE'		=> 'Kush është në linjë',
	'WRONG_PASSWORD'	=> 'Ju vendosët një fjalëkalim të gabuar.',
	
	'WRONG_DATA_ICQ'			=> 'Numri që shkruat nuk është një numër i vlefshëm ICQ.',
	'WRONG_DATA_JABBER'			=> 'Emri që shkruat nuk është një emër i një llogarie të vlefshme për Jabber.',
	'WRONG_DATA_LANG'			=> 'Gjuha e zgjedhur është e pavlefshme.',
	'WRONG_DATA_WEBSITE'		=> 'Adresa e faqes duhet të jetë një adresë e vlefshme, duke përfshirë protokollin. Për shëmbull: http://www.shëmbull.com/.',
	'WROTE'						=> 'shkroi',
	
	'YEAR'				=> 'Viti',
	'YEAR_MONTH_DAY'	=> '(YYYY-MM-DD)',
	'YES'				=> 'Po',
	'YIM'				=> 'YIM',
	'YOU_LAST_VISIT'	=> 'Mirë se vini, vizita juaj e fundit ishte më: %s',
	'YOU_NEW_PM'		=> 'Keni mesazh të ri në "Inbox".',
	'YOU_NEW_PMS'		=> 'Keni mesazhe të reja në "Inbox".',
	'YOU_NO_NEW_PM'		=> 'Nuk keni mesazhe të reja.',

	'datetime'			=> array(
		'TODAY'		=> 'Sot',
		'TOMORROW'	=> 'Nesër',
		'YESTERDAY'	=> 'Dje',		
		'AGO'		=> array(
			0		=> 'më pak se një minutë më parë',
			1		=> '%d minutë më parë',
			2		=> '%d minuta më parë',
			60		=> '1 orë më parë',
		),

		'Sunday'	=> 'E Djelë',
		'Monday'	=> 'E Hënë',
		'Tuesday'	=> 'E Martë',
		'Wednesday'	=> 'E Mërkurë',
		'Thursday'	=> 'E Enjte',
		'Friday'	=> 'E Premte',
		'Saturday'	=> 'E Shtunë',
		
		'Sun'		=> 'E Djelë',
		'Mon'		=> 'E Hënë',
		'Tue'		=> 'E Martë',
		'Wed'		=> 'E Mërkurë',
		'Thu'		=> 'E Enjte',
		'Fri'		=> 'E Premte',
		'Sat'		=> 'E Shtunë',
		
		'January'	=> 'Janar',
		'February'	=> 'Shkurt',
		'March'		=> 'Mars',
		'April'		=> 'Prill',
		'May'		=> 'Maj',
		'June'		=> 'Qeshor',
		'July'		=> 'Korrik',
		'August'	=> 'Gusht',
		'September'	=> 'Shtator',
		'October'	=> 'Tetor',
		'November'	=> 'Nëntor',
		'December'	=> 'Dhjetor',
		
		'Jan'		=> 'Janar',
		'Feb'		=> 'Shkurt',
		'Mar'		=> 'Mars',
		'Apr'		=> 'Prill',
		'May_short'	=> 'Maj',	// Short representation of "May". May_short used because in English the short and long date are the same for May.
		'Jun'		=> 'Qershor',
		'Jul'		=> 'Korrik',
		'Aug'		=> 'Gusht',
		'Sep'		=> 'Shtator',
		'Oct'		=> 'Tetor',
		'Nov'		=> 'Nëntor',
		'Dec'		=> 'Dhjetor',
	),

	'tz'				=> array(
		'-12'	=> 'UTC - 12 orë',
		'-11'	=> 'UTC - 11 orë',
		'-10'	=> 'UTC - 10 orë',
		'-9.5'	=> 'UTC - 9:30 orë',
		'-9'	=> 'UTC - 9 orë',
		'-8'	=> 'UTC - 8 orë',
		'-7'	=> 'UTC - 7 orë',
		'-6'	=> 'UTC - 6 orë',
		'-5'	=> 'UTC - 5 orë',
		'-4.5'	=> 'UTC - 4:30 orë',
		'-4'	=> 'UTC - 4 orë',
		'-3.5'	=> 'UTC - 3:30 orë',
		'-3'	=> 'UTC - 3 orë',
		'-2'	=> 'UTC - 2 orë',
		'-1'	=> 'UTC - 1 orë',
		'0'		=> 'UTC',
		'1'		=> 'UTC + 1 orë',
		'2'		=> 'UTC + 2 orë',
		'3'		=> 'UTC + 3 orë',
		'3.5'	=> 'UTC + 3:30 orë',
		'4'		=> 'UTC + 4 orë',
		'4.5'	=> 'UTC + 4:30 orë',
		'5'		=> 'UTC + 5 orë',
		'5.5'	=> 'UTC + 5:30 orë',
		'5.75'	=> 'UTC + 5:45 orë',
		'6'		=> 'UTC + 6 orë',
		'6.5'	=> 'UTC + 6:30 orë',
		'7'		=> 'UTC + 7 orë',
		'8'		=> 'UTC + 8 orë',
		'8.75'	=> 'UTC + 8:45 orë',
		'9'		=> 'UTC + 9 orë',
		'9.5'	=> 'UTC + 9:30 orë',
		'10'	=> 'UTC + 10 orë',
		'10.5'	=> 'UTC + 10:30 orë',
		'11'	=> 'UTC + 11 orë',
		'11.5'	=> 'UTC + 11:30 orë',
		'12'	=> 'UTC + 12 orë',
		'12.75'	=> 'UTC + 12:45 orë',
		'13'	=> 'UTC + 13 orë',
		'14'	=> 'UTC + 14 orë',
		'dst'	=> '[ <abbr title="Daylight Saving Time">DST</abbr> ]',
	),

	'tz_zones'	=> array(
		'-12'	=> '[UTC - 12] Baker Island Time',
		'-11'	=> '[UTC - 11] Niue Time, Samoa Standard Time',
		'-10'	=> '[UTC - 10] Hawaii-Aleutian Standard Time, Cook Island Time',
		'-9.5'	=> '[UTC - 9:30] Marquesas Islands Time',
		'-9'	=> '[UTC - 9] Alaska Standard Time, Gambier Island Time',
		'-8'	=> '[UTC - 8] Pacific Standard Time',
		'-7'	=> '[UTC - 7] Mountain Standard Time',
		'-6'	=> '[UTC - 6] Central Standard Time',
		'-5'	=> '[UTC - 5] Eastern Standard Time',
		'-4.5'	=> '[UTC - 4:30] Venezuelan Standard Time',
		'-4'	=> '[UTC - 4] Atlantic Standard Time',
		'-3.5'	=> '[UTC - 3:30] Newfoundland Standard Time',
		'-3'	=> '[UTC - 3] Amazon Standard Time, Central Greenland Time',
		'-2'	=> '[UTC - 2] Fernando de Noronha Time, South Georgia &amp; the South Sandwich Islands Time',
		'-1'	=> '[UTC - 1] Azores Standard Time, Cape Verde Time, Eastern Greenland Time',
		'0'		=> '[UTC] Western European Time, Greenwich Mean Time',
		'1'		=> '[UTC + 1] Central European Time, West African Time',
		'2'		=> '[UTC + 2] Eastern European Time, Central African Time',
		'3'		=> '[UTC + 3] Moscow Standard Time, Eastern African Time',
		'3.5'	=> '[UTC + 3:30] Iran Standard Time',
		'4'		=> '[UTC + 4] Gulf Standard Time, Samara Standard Time',
		'4.5'	=> '[UTC + 4:30] Afghanistan Time',
		'5'		=> '[UTC + 5] Pakistan Standard Time, Yekaterinburg Standard Time',
		'5.5'	=> '[UTC + 5:30] Indian Standard Time, Sri Lanka Time',
		'5.75'	=> '[UTC + 5:45] Nepal Time',
		'6'		=> '[UTC + 6] Bangladesh Time, Bhutan Time, Novosibirsk Standard Time',
		'6.5'	=> '[UTC + 6:30] Cocos Islands Time, Myanmar Time',
		'7'		=> '[UTC + 7] Indochina Time, Krasnoyarsk Standard Time',
		'8'		=> '[UTC + 8] Chinese Standard Time, Australian Western Standard Time, Irkutsk Standard Time',
		'8.75'	=> '[UTC + 8:45] Southeastern Western Australia Standard Time',
		'9'		=> '[UTC + 9] Japan Standard Time, Korea Standard Time, Chita Standard Time',
		'9.5'	=> '[UTC + 9:30] Australian Central Standard Time',
		'10'	=> '[UTC + 10] Australian Eastern Standard Time, Vladivostok Standard Time',
		'10.5'	=> '[UTC + 10:30] Lord Howe Standard Time',
		'11'	=> '[UTC + 11] Solomon Island Time, Magadan Standard Time',
		'11.5'	=> '[UTC + 11:30] Norfolk Island Time',
		'12'	=> '[UTC + 12] New Zealand Time, Fiji Time, Kamchatka Standard Time',
		'12.75'	=> '[UTC + 12:45] Chatham Islands Time',
		'13'	=> '[UTC + 13] Tonga Time, Phoenix Islands Time',
		'14'	=> '[UTC + 14] Line Island Time',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'd M Y, H:i'			=> '01 Jan 2007, 13:37',
		'd M Y H:i'				=> '01 Jan 2007 13:37',
		'M jS, \'y, H:i'		=> 'Jan 1st, \'07, 13:37',
		'D M d, Y g:i a'		=> 'Hen Jan 01, 2007 1:37 pm',
		'F jS, Y, g:i a'		=> 'Janar 1st, 2007, 1:37 pm',
		'|d M Y|, H:i'			=> 'Sot, 13:37 / 01 Jan 2007, 13:37',
		'|F jS, Y|, g:i a'		=> 'Sot, 1:37 pm / Janar 1st, 2007, 1:37 pm',
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=> 'D M d, Y g:i a', // Mon Jan 01, 2007 1:37 pm

));

?>