<?php
/**
*
* install.php [Norwegian Bokmaal]
*
* @package language
* @version $Id: $
* @copyright (c) 2007 phpBB Group
* @author 2007-12-08 - phpBB.no
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

$lang = array_merge($lang, array(
	'CONVERT_OPTIONS'	=> 'Innstillinger',
	'VERIFY_OPTIONS'	=> 'Verifiserer konverteringsinnstillinger',
	'COLLECTING_FILE_DIFFS'	=> 'Samler inn filendringer mellom gammel og ny phpBB-versjon',
	'MERGING_FILES'	=> 'Slår sammen forskjeller',
	'MERGING_FILES_EXPLAIN'	=> 'Scriptet samler nå inn filendringer.<br /><br />Vennligst vent til phpBB har fullført denne sammenligningen.',
	'NUMBER_OF_FILES_COLLECTED'	=> 'Filforandringer for t %1$d av %2$d filer er innsamlet<br />Vennligst vent til alle forandringer er innsamlet.',
	'TOGGLE_DISPLAY'	=> 'Vis/Skjul fillisten',
	'CLEANING_USERNAMES'	=> 'Renser brukernavn',
	'LONG_SCRIPT_EXECUTION'	=> 'Denne operasjonen kan ta litt tid... Vennligst ikke lukk nettleservinduet før den har fullført.',
	'BOT'	=> 'Søkerobot',
	'CHANGE_CLEAN_NAMES'	=> 'Metoden som skal sørge for at ingen brukere har tilsynelatende samme brukernavn har blitt endret på. Det er derfor noen av dine brukere som etter den nye regelen viser seg å ha tilsynelatende samme brukernavn. Du må enten slette eller endre navn på disse brukerene før du kan fortsette oppdateringen.',
	'DELETE_USER_REMOVE'	=> 'Slett bruker, og fjern alle innlegg skrevet av brukeren',
	'DELETE_USER_RETAIN'	=> 'Slett bruker, men behold alle innlegg skrevet av brukeren',
	'EDIT_USERNAME'	=> 'Endre brukernavn',
	'KEEP_OLD_NAME'	=> 'Behold brukernavn',
	'MERGE_MODIFICATIONS_OPTION'	=> 'Sammenflett endringer',
	'NEW_USERNAME'	=> 'Nytt brukernavn',
	'PACKAGE_UPDATES_TO'	=> 'Denne pakken oppdaterer forumet til versjon',
	'UPDATE_REQUIRES_FILE'	=> 'Oppdateringssystemet krever at følgende filer ligger i mappestrukturen på serveren: %s',
	'USER_ACTIVE'	=> 'Aktiv bruker',
	'USER_INACTIVE'	=> 'Inaktiv bruker',
	'CONV_OPTIONS_BODY'	=> 'Denne siden samler nødvendig informasjon som trengs for å aksessere det gamle forumet ditt. Skriv inn databasedetaljene til ditt forrige forum. Informasjonen i denne databasen vil ikke bli endret - kun lest, men det anbefales likevel at du deaktiverer forumet (gjøres i adminpanelet) for å oppnå en konsistent konvertering.',
	'SYNC_POST_COUNT'	=> 'Synkroniserer antall innlegg',
	'SYNC_POST_COUNT_ID'	=> 'Synkroniserer innlegg fra <var>entry</var> %1$s til %2$s.',
	'UPDATE_INSTRUCTIONS_INCOMPLETE'	=> '    <h1>Uferdig oppdatering oppdaget</h1>    <p>phpBB oppdaget at oppdateringen av forumet ditt ikke er fullført. Hvis du ikke har gått igjennom alle stegene, så må du fortsette der du slapp. Dette kan du gjøre ved å følge nedenforstående link</p>',
	'REPORT_WAREZ'	=> 'Innlegget inneholder linker til ulovlig eller piratkopiert programvare.',
	'REPORT_SPAM'	=> 'Innleggets eneste hensikt er å reklamere for en nettside eller et annet produkt.',
	'REPORT_OFF_TOPIC'	=> 'Innlegget dreier seg ikke om emnet.',
	'REPORT_OTHER'	=> 'Det rapporterte innlegget passer ikke inn i noen annen kategori. Bruk beskrivelsesfeltet istedenfor.',
	'CAT_UPDATE'	=> 'Oppdater',
	'COLLIDING_CLEAN_USERNAME'	=> '<strong>%s</strong> er det rene brukernavnet for:',
	'COLLIDING_USERNAMES_FOUND'	=> 'Flere brukernavn på ditt gamle forum er for like. For å gjøre ferdig konverteringen, vennligst slett eller omdøp disse brukerne sånn at det bare er en bruker på ditt gamle forum som har det brukernavnet.',
	'COLLIDING_USER'	=> '» Bruker-ID: <strong>%d</strong> Brukernavn: <strong>%s</strong> (%d innlegg)',
	'CONV_ERR_FATAL'	=> 'Kritisk konverteringsfeil',
	'PHP_GETIMAGESIZE_SUPPORT'	=> 'PHP-funksjonen getimagesize() er tilgjengelig',
	'PHP_GETIMAGESIZE_SUPPORT_EXPLAIN'	=> '<strong>Obligatorisk</strong> - For at phpBB skal fungere skikkelig, må getimagesize funksjonen være tilgjengelig.',
	'PHP_URL_FOPEN_SUPPORT'	=> 'PHP-innstillingen <var>allow_url_fopen</var> er aktivert.',
	'PHP_URL_FOPEN_SUPPORT_EXPLAIN'	=> '<strong>Alternativ</strong> - Denne innstillingen er alternativ, men uten den kan ikke noen brukerne linke til avatarer som ligger på andre sider.',
	'SEARCH_INDEX_UNCONVERTED'	=> 'Søkeindeksen ble ikke konvertert.',
	'SEARCH_INDEX_UNCONVERTED_EXPLAIN'	=> 'Din gamle søkeindeks ble ikke konvertert. Søking vil alltid svikte på tomt resultat. For å lage en ny søkeindeks, gå til administrasjonspanelet, velg vedlikehold og velg deretter søkeindeks i undermenyen.',
	'UNWRITABLE'	=> 'Ikke skrivbar',
	'UPDATE_TOPICS_POSTED_ERR'	=> 'En feil inntraff da frambringing av emneinformasjon foregikk. Du kan gjenforsøke dette steget i kontrollpanelet etter at konverteringen er fullført.',
	'WRITABLE'	=> 'Skrivbar',
	'CONTINUE_UPDATE_NOW'	=> 'Fortsett oppdateringsprosessen nå.',
	'INLINE_UPDATE_SUCCESSFUL'	=> 'Databasen ble vellykket oppdatert. Nå må du fortsette oppdateringsprosessen.',
	'ADMIN_CONFIG'	=> 'Administratorkonfigurasjon',
	'ADMIN_PASSWORD'	=> 'Administratorpassord',
	'ADMIN_PASSWORD_CONFIRM'	=> 'Bekreft administratorpassord',
	'ADMIN_PASSWORD_EXPLAIN'	=> '(Skriv et passord mellom 6 og 30 tegn.)',
	'ADMIN_TEST'	=> 'Sjekk administratorinnstillinger',
	'ADMIN_USERNAME'	=> 'Administrators brukernavn',
	'ADMIN_USERNAME_EXPLAIN'	=> '(Skriv et brukernavn mellom 3 og 20 bokstaver)',
	'APP_MAGICK'	=> 'Bildesupport [ Vedlegg ]',
	'AUTHOR_NOTES'	=> 'Forfatternoteringer<br />» %s',
	'AVAILABLE'	=> 'Tilgjengelig',
	'AVAILABLE_CONVERTORS'	=> 'Tilgjengelige konverteringer',
	'BEGIN_CONVERT'	=> 'Begynn konvertering',
	'BLANK_PREFIX_FOUND'	=> 'Det finnes en mulig installasjon uten noen tabellprefiks.',
	'BOARD_NOT_INSTALLED'	=> 'Ingen foruminstallasjon er funnet.',
	'BOARD_NOT_INSTALLED_EXPLAIN'	=> 'For å utføre en konvertering må du først installere phpBB 3.  Du kan nå <a href="%s">utføre en installasjon</a>.',
	'CATEGORY'	=> 'Kategori',
	'CACHE_STORE'	=> 'Hurtiglagringstype',
	'CACHE_STORE_EXPLAIN'	=> 'Den fysiske plassingen til alle data, filsystem er foretrukket.',
	'CAT_CONVERT'	=> 'Konverter',
	'CAT_INSTALL'	=> 'Installer',
	'CAT_OVERVIEW'	=> 'Oversikt',
	'CHANGE'	=> 'Endre',
	'CHECK_TABLE_PREFIX'	=> 'Sjekk tabellprefiksen og prøv igjen.',
	'CLEAN_VERIFY'	=> 'Rydder opp og kontrollerer den endelige strukturen.',
	'CONFIG_CONVERT'	=> 'Konverterer konfigurasjonen',
	'CONFIG_FILE_UNABLE_WRITE'	=> 'Det var ikke mulig å skrive konfigurasjonsfilen. Alternative metoder for å opprette denne filen vises nedenfor.',
	'CONFIG_FILE_WRITTEN'	=> 'Konfigurasjonsfilen er nå blitt skrevet. Du kan nå fortsette din installasjon av phpBB3.',
	'CONFIG_PHPBB_EMPTY'	=> 'PhpBB3-kofigurasjonsvariabelen "%s" er tom.',
	'CONFIG_RETRY'	=> 'Prøv igjen',
	'CONTACT_EMAIL_CONFIRM'	=> 'Bekreft kontaktepost',
	'CONTINUE_CONVERT'	=> 'Fortsett konvertering',
	'CONTINUE_CONVERT_BODY'	=> 'Du har tidligere forsøkt å konvertere forumet ditt, men ikke fullført dette. Du kan nå velge mellom å starte en ny konvertering eller fortsette den forrige.',
	'CONTINUE_LAST'	=> 'Fortsett forrige uttrykk',
	'CONTINUE_OLD_CONVERSION'	=> 'Fortsett forrige konvertering',
	'CONVERT'	=> 'Konverter',
	'CONVERT_COMPLETE'	=> 'Konverteringen er utført.',
	'CONVERT_COMPLETE_EXPLAIN'	=> 'Du har nå konvertert ditt forum til phpBB 3.0. Du kan nå logge inn i <a href="../">forumet ditt</a>. Vennligst kontroller at innstillingene ble overført riktig, før du gjør forumet tilgjengelig ved å slette install-mappen. Husk at du kan få online hjelp med phpBB i <a href="http://www.phpbb.com/support/documentation/3.0/">phpBB.coms brukerguide</a> og i <a href="http://www.phpbb.com/phpBB/viewforum.php?f=46">supportforumet (på phpBB.com)</a>. Du kan også få norsk hjelp i <a href="http://phpbb.no/forum/index.php?c=13">phpBB.nos supportforum til phpBB3</a>.',
	'CONVERT_INTRO'	=> 'Velkommen til phpBBs samlede konverteringsstruktur',
	'CONVERT_INTRO_BODY'	=> 'Herfra kan du importere data fra andre (installerte) forumsystemer. Listen under viser alle konverteringsmoduler som nå er tilgjengelige. Hvis det ikke vises noen konvertering i listen for forumprogramvaren du ønsker å konvertere fra, sjekk <a href="http://phpbb.com/">phpBB.com</a> for flere konverteringsmoduler som kan lastes ned.',
	'CONVERT_NEW_CONVERSION'	=> 'Ny konvertering',
	'CONVERT_NOT_EXIST'	=> 'Den spesifiserte konverteringen eksisterer ikke.',
	'CONVERT_SETTINGS_VERIFIED'	=> 'Informasjonen du oppga har blitt kontrollert. Klikk på knappen under for å starte konfigurasjonsprosessen.',
	'CONV_ERROR_ATTACH_FTP_DIR'	=> 'FTP-opplasting av vedlegg er aktivert i det gamle forumet. Deaktiver FTP-opplastingsfunksjonen, bekreft at en gyldig opplastingsmappe er tilgjengelig og kopier alle vedleggsfilene til denne mappen. Start konverteringen på nytt når du har gjort dette.',
	'CONV_ERROR_CONFIG_EMPTY'	=> 'Ingen konfigusrasjonsinformasjon er tilgjengelig for konverteringen.',
	'CONV_ERROR_FORUM_ACCESS'	=> 'Fant ikke forumtilgangsinformasjon.',
	'CONV_ERROR_GET_CATEGORIES'	=> 'Fant ingen kategorier.',
	'CONV_ERROR_GET_CONFIG'	=> 'Kunne ikke hente forumkonfigurasjonen din.',
	'CONV_ERROR_COULD_NOT_READ'	=> 'Kunne ikke lese / fikk ikke tilgang til "%s".',
	'CONV_ERROR_GROUP_ACCESS'	=> 'Fikk ikke gruppebekreftelsesinformasjon.',
	'CONV_ERROR_INCONSISTENT_GROUPS'	=> 'Det har oppstått en uoverensstemmelse i gruppetabellen oppdaget i add_bots() - du må legge til alle spesialgrupper hvis du gjør det manuelt.',
	'CONV_ERROR_INSERT_BOT'	=> 'Kunne ikke sette inn søkemotor til brukertabell.',
	'CONV_ERROR_INSERT_BOTGROUP'	=> 'Kunne ikke sette inn søkemotor til bottabell.',
	'CONV_ERROR_INSERT_USER_GROUP'	=> 'Kunne ikke sette inn bruker til brukergruppetabellen.',
	'CONV_ERROR_MESSAGE_PARSER'	=> 'Meldingslesefeil',
	'CONV_ERROR_NO_AVATAR_PATH'	=> 'Melding til forfatter: Du må spesifisere $convertor[\'avatar_path\'] for å kunne bruke %s.',
	'CONV_ERROR_NO_FORUM_PATH'	=> 'Stien til forumet er ikke spesifisert.',
	'CONV_ERROR_NO_GALLERY_PATH'	=> 'Melding til forfatter: Du må spesifisere $convertor[\'avatar_gallery_path\'] for å kunne bruke %s.',
	'CONV_ERROR_NO_GROUP'	=> 'Gruppen "%1$s" kunne ikke bli funnet i %2$s.',
	'CONV_ERROR_NO_RANKS_PATH'	=> 'Melding til forfatter: Du må spesifisere $convertor[\'ranks_path\'] for å kunne bruke %s.',
	'CONV_ERROR_NO_SMILIES_PATH'	=> 'Melding til forfatter: Du må spesifisere $convertor[\'smilies_path\'] for å kunne bruke %s.',
	'CONV_ERROR_NO_UPLOAD_DIR'	=> 'Melding til forfatter: Du må spesifisere $convertor[\'upload_path\'] for å kunne bruke %s.',
	'CONV_ERROR_PERM_SETTING'	=> 'Kunne ikke lage/oppdatere rettighetsinnstillinger.',
	'CONV_ERROR_PM_COUNT'	=> 'Ikke i stand til å velge mappe til PM-telleren.',
	'CONV_ERROR_REPLACE_CATEGORY'	=> 'Kunne ikke erstatte den gamle kategorien.',
	'CONV_ERROR_REPLACE_FORUM'	=> 'Kunne ikke erstatte det gamle forumet.',
	'CONV_ERROR_USER_ACCESS'	=> 'Fikk ikke brukerautentiseringinformasjon.',
	'CONV_ERROR_WRONG_GROUP'	=> 'Feil gruppe "%1$s" definert i %2$s.',
	'CONV_SAVED_MESSAGES'	=> 'Lagrede meldinger',
	'COULD_NOT_COPY'	=> 'Kunne ikke kopiere filen <strong>%1$s</strong> til <strong>%2$s</strong>.<br /><br />Undersøk om mappen eksisterer og om den kan skrives til.',
	'COULD_NOT_FIND_PATH'	=> 'Kunne ikke finne stien til ditt forrige forum. Undersøk innstillingene dine og prøv igjen.<br />» Den spesifiserte stien var %s.',
	'DBMS'	=> 'Databasetype',
	'DB_CONFIG'	=> 'Databasekonfigurasjon',
	'DB_CONNECTION'	=> 'Databasetilkobling',
	'DB_ERR_INSERT'	=> 'Feil under behandling av <code>INSERT</code>-spørring.',
	'DB_ERR_LAST'	=> 'Feil under behandling av <var>query_last</var>.',
	'DB_ERR_QUERY_FIRST'	=> 'Feil under utføring av <var>query_first</var>.',
	'DB_ERR_QUERY_FIRST_TABLE'	=> 'Feil under utføring av <var>query_first</var>, %s ("%s").',
	'DB_ERR_SELECT'	=> 'Feil under utføring av <code>SELECT</code>-spørring.',
	'DB_HOST'	=> 'Databaseserverdomene eller DSN',
	'DB_HOST_EXPLAIN'	=> 'DSN står for Data Source Name og er kun tilgjengelig under ODBC-installeringer.',
	'DB_NAME'	=> 'Databasenavn',
	'DB_PASSWORD'	=> 'Databasepassord',
	'DB_PORT'	=> 'Databaseserverport',
	'DB_PORT_EXPLAIN'	=> 'La denne stå tom med mindre du vet at serveren bruker en ikkestandard port.',
	'DB_USERNAME'	=> 'Databasebrukernavn',
	'DB_TEST'	=> 'Testtilkobling',
	'DEFAULT_LANG'	=> 'Standard forumspråk',
	'DEFAULT_PREFIX_IS'	=> 'Konvertøren kunne ikke finne tabeller med den spesifiserte prefiksen. Finn ut om du har den gamle innenfor den samme databasen som phpBB 3.0.-installasjonen din. Standardtabellprefiksen for %1$s er <strong>%2$s</strong>.',
	'DEV_NO_TEST_FILE'	=> 'Ingen verdi er spesifisert for test_file-variabelen i konverteringen. Er du en bruker av denne konverteringen, burde du ikke ha fått denne feilmeldingen. Hvis sistnevnte er tilfelle, rapporter denne feilmeldingen til konverteringsforfatteren. Hvis du har laget / vært med på å lage den, må du spesifisere navnet til en fil som eksisterer i kildeforumet for å tillate stien til det å bli verifisert.',
	'DIRECTORIES_AND_FILES'	=> 'Mappe- og filinnstillinger',
	'DISABLE_KEYS'	=> 'Deaktiver nøkler',
	'DLL_FIREBIRD'	=> 'Firebird',
	'DLL_FTP'	=> 'Ekstern FTP-support [ Installasjon ]',
	'DLL_GD'	=> 'GD-graffikksupport [ Visuell bekreftelse ]',
	'DLL_MBSTRING'	=> 'Multi-byte-tegnsupport',
	'DLL_MSSQL'	=> 'MSSQL-server 2000+',
	'DLL_MSSQL_ODBC'	=> 'MSSQL-server 2000+ via ODBC',
	'DLL_MYSQL'	=> 'MySQL',
	'DLL_MYSQLI'	=> 'MySQL med MySQLi-filtype',
	'DLL_ORACLE'	=> 'Oracle',
	'DLL_POSTGRES'	=> 'PostgreSQL 7.x/8.x',
	'DLL_SQLITE'	=> 'SQLite',
	'DLL_XML'	=> 'XML-support [ Jabber ]',
	'DLL_ZLIB'	=> 'zlib-komprimeringssupport [ gz, .tar.gz, .zip ]',
	'DL_CONFIG'	=> 'Last ned konfigurasjon',
	'DL_CONFIG_EXPLAIN'	=> 'Du kan laste ned config.php til din egen datamaskin. Så må du laste den opp manuelt og erstatte den eksisterende config.php i din phpBB 3.0.-mappe. Husk å laste opp filen i ASCII-format (se FTP-dokumentasjonen din hvis du ikke vet hvordan man gjør dette, som regel fikser FTP-programmet dette automatisk). Klikk på OK når du er ferdig for å gå videre til neste steg.',
	'DL_DOWNLOAD'	=> 'Last ned',
	'DONE'	=> 'OK',
	'ENABLE_KEYS'	=> 'Reaktiverer nøkler. Dette kan ta en stund.',
	'FILES_OPTIONAL'	=> 'Valgfrie filer og mapper',
	'FILES_OPTIONAL_EXPLAIN'	=> '<strong>Valgfritt</strong> - Disse filene, mappene og rettighetsinnstillingene er ikke påkrevd. Installasjonssystemet vil forsøke å bruke forskjellige teknikker til å lage dem hvis de ikke eksisterer eller ikke kan bli skrevet til. Hvis de finnes, vil installasjonen ta raskere tid.',
	'FILES_REQUIRED'	=> 'Filer og mapper',
	'FILES_REQUIRED_EXPLAIN'	=> '<strong>Påkrevd</strong> - For at phpBB skal virke, må alle nødvendige filer og mapper være opplastet med nødvendige rettigheter. Hvis det står “Ikke funnet”, må du laste opp filen eller mappen det henvises til. Hvis du får beskjeden “Ikke skrivbar”, må du endre rettigheten til henvist fil eller mappe for at phpBB skal kunne skrive til den.',
	'FILLING_TABLE'	=> 'Fyller tabellen <strong>%s</strong>.',
	'FILLING_TABLES'	=> 'Fyller tabeller.',
	'FINAL_STEP'	=> 'Utfører siste trinn.',
	'FORUM_ADDRESS'	=> 'Forumets URL',
	'FORUM_ADDRESS_EXPLAIN'	=> 'Dette er URL-en til ditt tidligere forum, for eksempel <samp>http://www.ditt.domene/phpBB2/</samp>. Alle innlegg, private meldinger og signaturer vil bli overført fra denne adressen til ditt nye forum.',
	'FORUM_PATH'	=> 'Forumets sti',
	'FORUM_PATH_EXPLAIN'	=> 'Dette er den <strong>relative</strong> stien til ditt tidligere forum <strong>fra stien til phpBB-installasjonen</strong>.',
	'FOUND'	=> 'Funnet',
	'FTP_CONFIG'	=> 'Overfør konfigurasjon med FTP',
	'FTP_CONFIG_EXPLAIN'	=> 'phpBB har funnet tilstedeværelsen til FTP-modulen på denne serveren. Du kan installerere forumet via denne hvis du ønsker det. I så fall må du oppgi informasjonen under. Husk riktig brukernavn og passord! (Spår webhotelladministrasjonen hvis du er usikker på disse.)',
	'FTP_PATH'	=> 'FTP-sti',
	'FTP_PATH_EXPLAIN'	=> 'Dette er stien til ditt phpBB-forum, for eksempel htdocs/phpBB3/.',
	'FTP_UPLOAD'	=> 'Last opp',
	'GPL'	=> 'General Public License',
	'INITIAL_CONFIG'	=> 'Grunnleggende konfigurasjon',
	'INITIAL_CONFIG_EXPLAIN'	=> 'Nå som installasjonen er ferdig og serveren kan kjøre phpBB, må du oppgi litt spesifikk informasjon. Hvis du ikke vet hvordan du kobler til databasen, kontakt webhotellet ditt eller phpBBs supportforum. Undersøk om innstillingene er riktige før du fortsetter.',
	'INSTALL_CONGRATS'	=> 'Gratulerer!',
	'INSTALL_CONGRATS_EXPLAIN'	=> '<p>Du har nå installert phpBB %1$s. Nå kan du gjøre to ting med ditt nye forum3:</p> <h2>Konverter et gammelt forum til phpBB3</h2> <p>phpBBs konverteringssystem lar deg konvertere både phpBB 2.0x og andre forumtyper til phpBB3. hvis du har et eksisterende forum som du ønsker å konvertere, gå til <a href="%2$s">konvertereren</a>.</p> <h2>Begynn å bruke phpBB3!</h2> <p>Dersom du starter et nytt forum, så er du nå ferdig. Klikk på knappen nedenfor for å gå til administratorpanelet (ACP). Bruk litt tid på å utforske alle mulighetene du har der. Husk at du alltid kan finne hjelp i <a href="http://www.phpbb.com/support/documentation/3.0/">dukumentasjonen</a> og på <a href="http://www.phpbb.com/community/viewforum.php?f=46">supportforumet</a> til phpBB.com. Du kan også besøke <a href="http://www.phpbb.no">phpBB.no</a> for å få hjelp på norsk. Se forøvrig <a href="%3$s">README</a>-filen for mer informasjon.</p><p><strong>Vennligst slett, flytt eller endre navn på installasjonsmappen (/install) før du bruker forumet ditt. Før du gjør dette er det kun administrasjonspanelet som er tilgjengelig.</strong></p>',
	'INSTALL_INTRO'	=> 'Velkommen til installasjonen!',
	'INSTALL_INTRO_BODY'	=> 'Med dette alternativet kan du installere phpBB på serveren.</p><p>Da må du oppgi noen databaseinnstillinger. Kontakt webhotellet ditt hvis du er usikker på disse, da du ikke kan installere forumet uten dem. Dette er påkrevd informasjon:</p> <ul> <li>Databasetype - databasen du skal bruke.</li> <li>Databaseservernavn (DSN) - adressen til databaseserveren.</li> <li>Databaseserverport - porten til databaseserveren (unødvendig i de fleste tilfeller).</li> <li>Databasenavn - databasens navn.</li> <li>Databasebrukernavn og -passord - innloggingsdata for tilkobling.</li> </ul> <p><strong>Merk:</strong> Hvis du bruker SQLite, bør du oppgi hele DSN-en til databasen og la feltene brukernavn og passord stå tomme. Databasen bør være plassert et sted som er utilgjengelig på nettet.</p> <p>phpBB3 kan bruke følgende databasetyper:</p> <ul> <li>MySQL 3.23 eller nyere (eventuelt MySQLi)</li> <li>PostgreSQL 7.3+</li> <li>SQLite 2.8.2+</li> <li>Firebird 2.0+</li> <li>MS SQL Server 2000 eller over (directly eller via ODBC)</li> <li>Oracle</li> </ul> <p>Kun de databasene som serveren kan kjøre vil bli vist.',
	'INSTALL_INTRO_NEXT'	=> 'Klikk på knappen under for å fullføre installasjonen.',
	'INSTALL_LOGIN'	=> 'Logg inn',
	'INSTALL_NEXT'	=> 'Neste',
	'INSTALL_NEXT_FAIL'	=> 'Noen undersøkelser ble ikke fullført, og du må rette dem opp før du går til neste steg. Gjør du ikke det, blir ikke installasjonen komplett.',
	'INSTALL_NEXT_PASS'	=> 'Alle basiske undersøkelser er fullført, og du kan gå videre til neste steg. Hvis du har endret noen rettigheter, moduler eller lignende og ønsker å undersøke omigjen, kan du gjøre det.',
	'INSTALL_PANEL'	=> 'Installasjonspanel',
	'INSTALL_SEND_CONFIG'	=> 'PhpBB kunne ikke skrive direkte til config.php. Det kan være fordi filen ikke eksisterer eller fordi den ikke er skrivbar. Du vil nå se et visst antall alternativer angående installasjonen av config.php.',
	'INSTALL_START'	=> 'Start installasjon',
	'INSTALL_TEST'	=> 'Gjenta undersøkelse',
	'INST_ERR'	=> 'Installasjonsfeil',
	'INST_ERR_DB_CONNECT'	=> 'Kunne ikke koble til databasen, se feilmeldingen under.',
	'INST_ERR_DB_FORUM_PATH'	=> 'Den spesifiserte databasefilen er innenfor din forummappe. Du må plassere filen i et område som ikke er tilgjengelig fra nettet.',
	'INST_ERR_DB_NO_ERROR'	=> 'Ingen feilmelding er gitt.',
	'INST_ERR_DB_NO_MYSQLI'	=> 'Versjonen av  MySQL på denne maskinen er inkompatibel med “MySQL med MySQLi-utvidelsen”-valget du har valgt. Vennligst prøv “MySQL”-valget istedet.',
	'INST_ERR_DB_NO_SQLITE'	=> 'Versjonen av SQLite-utvidelsen du har installert er for gammel, den må være minst oppgradert til versjon 2.8.2.',
	'INST_ERR_DB_NO_ORACLE'	=> 'Versjonen av Oracle installert på denne maskinen krever at du setter <var>NLS_CHARACTERSET</var>-parameteret til <var>UTF8</var>. Enten oppgraderer du installasjonen til 9.2+ eller skift parameteret.',
	'INST_ERR_DB_NO_FIREBIRD'	=> 'Versjonen av Firebird installert på denne maskinen er eldre enn 2.0; vennligst oppgrader til en nyere versjon.',
	'INST_ERR_DB_NO_FIREBIRD_PS'	=> 'Databasen du har valgt for Firebird har en sidestørrelse på mindre enn 8192, som er den minste mulige størrelsen.',
	'INST_ERR_DB_NO_POSTGRES'	=> 'Databasen du har valgt var ikke opprettet i <var>UNICODE</var>- eller <var>UTF8</var>-koding. Prøv å installere i en database med <var>UNICODE</var>- eller <var>UTF8</var>-koding.',
	'INST_ERR_DB_NO_NAME'	=> 'Ingen databasenavn ble spesifisert',
	'INST_ERR_EMAIL_INVALID'	=> 'Epostadressene du skrev inn er ugyldige.',
	'INST_ERR_EMAIL_MISMATCH'	=> 'Epostadressene du skrev inn stemmer ikke med hverandre.',
	'INST_ERR_FATAL'	=> 'Fatal installasjonsfeil',
	'INST_ERR_FATAL_DB'	=> 'En fatal databasefeil har inntruffet. Det kan være fordi brukeren ikke har rettigheter til å utføre handlingen <code>CREATE TABLES</code>, <code>INSERT</code> eller lignende. Du finner mer informasjon under. Kontakt webhotellet ditt, eller spør i phpBB.coms eller phpBB.nos supportforum hvis du skulle ha bruk for hjelp.',
	'INST_ERR_FTP_PATH'	=> 'Kunne ikke skifte til den oppgitte mappen, vennligst undersøk stien.',
	'INST_ERR_FTP_LOGIN'	=> 'Kunne ikke logge inn med FTP. Undersøk om brukernavnet og passordet er riktige.',
	'INST_ERR_MISSING_DATA'	=> 'Du må fylle ut alle feltene i denne boksen.',
	'INST_ERR_NO_DB'	=> 'Kan ikke laste PHP-modulen for den valgte databasetypen.',
	'INST_ERR_PASSWORD_MISMATCH'	=> 'Passordene du skrev stemmer ikke med hverandre.',
	'INST_ERR_PASSWORD_TOO_LONG'	=> 'Passordet du skrev er for langt. Den maskimale lengden er på 30 tegn.',
	'INST_ERR_PASSWORD_TOO_SHORT'	=> 'Passordet du skrev er for kort. Minimumslengden er på 6 tegn.',
	'INST_ERR_PREFIX'	=> 'Tabellen med den spesifiserte prefiksen finnes allerede, vennligst velg et annet alternativ.',
	'INST_ERR_PREFIX_INVALID'	=> 'Tabellprefiksen du har spesifisert er ugyldig for denne databasen. Prøv andre tegn, for eksempel med bindestrek.',
	'INST_ERR_PREFIX_TOO_LONG'	=> 'Tabellprefiksen du har spesifisert er for lang. Den maksimale lengden er på %d tegn.',
	'INST_ERR_USER_TOO_LONG'	=> 'Brukernavnet du har skrevet er for langt. Den maksimale lengden er på 20 tegn.',
	'INST_ERR_USER_TOO_SHORT'	=> 'Brukernavnet du har skrevet er for kort. Minimumslengden er på 3 tegn.',
	'INVALID_PRIMARY_KEY'	=> 'Ugyldig hovednøkkel: %s',
	'MBSTRING_CHECK'	=> '<samp>mbstring</samp> Tilleggssjekk',
	'MBSTRING_CHECK_EXPLAIN'	=> '<samp>mbstring</samp> er en PHP-utvidelse som gir multibyte-strengfunksjoner. Mange muligheter av mbstring er ikke kombitable med phpBB og må bli slått av.',
	'MBSTRING_FUNC_OVERLOAD'	=> 'Funksjon overbelastet',
	'MBSTRING_FUNC_OVERLOAD_EXPLAIN'	=> '<var>mbstring.func_overbelastning</var> må være satt til enten 0 eller 4.',
	'MBSTRING_ENCODING_TRANSLATION'	=> 'Transparent inkodning av tegn',
	'MBSTRING_ENCODING_TRANSLATION_EXPLAIN'	=> '<var>mbstring.encoding_translation</var> må være satt til 0.',
	'MBSTRING_HTTP_INPUT'	=> 'HTTP-inputtegnkonversasjon',
	'MBSTRING_HTTP_INPUT_EXPLAIN'	=> '<var>mbstring.http_input</var> må være satt til <samp>pass</samp>.',
	'MBSTRING_HTTP_OUTPUT'	=> 'HTTP-outputtegnkonversasjon',
	'MBSTRING_HTTP_OUTPUT_EXPLAIN'	=> '<var>mbstring.http_output</var> må være satt til <samp>0</samp>.',
	'MAKE_FOLDER_WRITABLE'	=> 'Bekreft at denne mappen eksisterer og er skrivbar og prøv igjen:<br />»<strong>%s</strong>',
	'MAKE_FOLDERS_WRITABLE'	=> 'Bekreft at disse mappene eksisterer og er skrivbare og prøv igjen:<br />»<strong>%s</strong>',
	
	'MYSQL_SCHEMA_UPDATE_REQUIRED'   => 'MySQL-databaseskjemaet ditt for phpBB er utdatert. phpBB trenger et skjema for MySQL 3.x/4.x, men serveren kjører MySQL %2s.<br /><strong>Før du fortsetter oppdateringen, må du oppgradere skjemaet.</strong><br /><br />Du kan lese <a href="http://www.phpbb.com/kb/article/doesnt-have-a-default-value-errors/">kunnskapsbaseartikkelen om oppgradering av MySQL-skjemaet</a>. Hvis du får problemer, kan du bruke <a href="http://www.phpbb.com/community/viewforum.php?f=46">supportforumene</a>.',
	
	'NAMING_CONFLICT'	=> 'Konflikt: %s og %s er begge aliaser<br /><br />%s    * * ** ',
	'NEXT_STEP'	=> 'Fortsett til neste steg',
	'NOT_FOUND'	=> 'Kan ikke finne',
	'NOT_UNDERSTAND'	=> 'Kan ikke forstå %s #%d, tabell %s ("%s").',
	'NO_CONVERTORS'	=> 'Ingen konverteringer er tilgjengelige for bruk.',
	'NO_CONVERT_SPECIFIED'	=> 'Ingen konverteringer er spesifisert.',
	'NO_LOCATION'	=> 'Kan ikke bestemme område. Hvis Imagemagick er installert, kan du spesifisere plasseringen i administrasjonspanelet.',
	'NO_TABLES_FOUND'	=> 'Ingen tabeller er funnet.',
	'OVERVIEW_BODY'	=> 'Velkommen til phpBB3!<br /><br />phpBB™ er forumsystemet som har flest brukere på verdensbasis. phpBB3 er den absolutt nyeste utgaven, og støtter seg på en syv år lang tradisjon med phpBB-oppgraderinger. Som sine forgjengere er phpBB3 funksjonsrikt, brukervennlig fullt ut støttet av phpBB-teamet. phpBB3 forbedrer alt det som gjorde phpBB2 til den suksessen det var (og er), og legger til en god del funksjoner som ikke fantes i tidligere utgaver. Vi håper det overgår dine forventninger.<br /><br />Dette installasjonssystemet vil guide deg gjennom installasjonen av phpBB3, oppdatering til siste versjon fra tidligere utgaver, samt konvertering fra andre forumsystemer (inkludert oppgradering fra phpBB2). For mer installasjon bør du lese <a href="../docs/INSTALL.html">installasjonsguiden</a>.<br /><br />For å se phpBB3s lisens eller for å finne ut hvordan du kan få hjelp med ditt forum velger du de respektive valgene i sidemenyen. For å fortsette velger du den fanen ovenfor som tilsvarer det du ønsker å gjøre.',
	'PCRE_UTF_SUPPORT'	=> 'PCRE UTF-8-støtte',
	'PCRE_UTF_SUPPORT_EXPLAIN'	=> 'PhpBB vil <strong>ikke</strong> virke hvis PHP-installasjonen ikke er avhenging av UTF-8-støtte i PCRE-utvidelsen.',
	'PHP_OPTIONAL_MODULE'	=> 'Alternative moduler',
	'PHP_OPTIONAL_MODULE_EXPLAIN'	=> '<strong>Alternativ</strong> - Disse modulene og applikasjonene er ikke tilgjengelige. Hadde de vært tilgjengelige, ville også forumet fått flere funksjoner.',
	'PHP_SUPPORTED_DB'	=> 'Databaser',
	'PHP_SUPPORTED_DB_EXPLAIN'	=> '<strong>Påkrevd</strong> - Du må ha support for minst en type database med mulighet for tilkobling via PHP. Hvis ingen databaser er tilgjengelige, bør du kontakte webhotellet ditt eller se gjennom PHP-installasjonsdokumentasjonen.',
	'PHP_REGISTER_GLOBALS'	=> 'PHP-innstillingen <var>register_globals</var> er deaktivert.',
	'PHP_REGISTER_GLOBALS_EXPLAIN'	=> 'phpBB kan fortsatt kjøre med denne innstillingen aktivert, men hvis mulig, er det anbefalt at register_globals er deaktivert på grunn av sikkerhetsmessige årsaker.',
	'PHP_SAFE_MODE'	=> 'Sikker modus',
	'PHP_SETTINGS'	=> 'PHP-versjon og -innstillinger',
	'PHP_SETTINGS_EXPLAIN'	=> '<strong>Påkrevd</strong> - Du må kjøre versjon 4.3.3. eller nyere av PHP for å kunne installere phpBB. Hvis <var>sikker</var> er vist mens PHP-installasjonen kjøres, er sikker modus aktivert. Dette vil benytte seg av flere muligheter.',
	'PHP_VERSION_REQD'	=> 'PHP-versjon >= 4.3.3',
	'POST_ID'	=> 'Post-ID',
	'PREFIX_FOUND'	=> 'En undersøkelse av tabellene viste at den installasjonsgylige tabellprefiksen <strong>%s</strong> er benyttet.',
	'PREPROCESS_STEP'	=> 'Oppretter preprossessfunksjoner/-spørringer',
	'PRE_CONVERT_COMPLETE'	=> 'Alle prekonverteringstrinn er komplette. Du kan nå begynne konverteringsprosessen. Merk deg at du kan gjøre en del handlinger manuelt. Etter konverteringen bør du undersøke rettigheter og om filer er riktig kopiert.',
	'PROCESS_LAST'	=> 'Behandler siste fremstilinger',
	'REFRESH_PAGE'	=> 'Oppdater for å fortsette',
	'REFRESH_PAGE_EXPLAIN'	=> 'Hvis ja, vil konvertøren oppdatere for å fortsette konverteringen. Hvis dette er din første konvertering for testing og til å fastsette feilmeldinger, anbefales det å velge Nei.',
	'REQUIREMENTS_TITLE'	=> 'Installasjonskompitabilitet',
	'REQUIREMENTS_EXPLAIN'	=> 'Før installasjonen kan begynne, vil phpBB kjøre noen undersøkelser mot serveren for å undersøke om det kan installeres. Det er viktig at du undersøker resultatene før du går videre. Det er også lurt å lese gjennom dem hvis du vil benytte deg av andre muligheter som krever slike løsninger.',
	'RETRY_WRITE'	=> 'Skriv konfigurasjonsfilen på nytt',
	'RETRY_WRITE_EXPLAIN'	=> 'Hvis du vil, kan du endre rettighetene til config.php slik at phpBB kan skrive til den. Skulle du ønske det, kan du klike på Prøv igjen-knappen under. Husk å sette tilbake rettighetene til config.php etter at installasjonen er fullført.',
	'SCRIPT_PATH'	=> 'Sti',
	'SCRIPT_PATH_EXPLAIN'	=> 'Stien/mappen hvor phpBB er plassert, for eksempel <samp>phpBB3/</samp>.',
	'SELECT_LANG'	=> 'Velg språk',
	'SERVER_CONFIG'	=> 'Serverkonfigurasjon',
	'SOFTWARE'	=> 'Forumprogramvare',
	'SPECIFY_OPTIONS'	=> 'Spesifiser konverteringsalternativer.',
	'STAGE_ADMINISTRATOR'	=> 'Administratordetaljer',
	'STAGE_ADVANCED'	=> 'Avanserte innstillinger',
	'STAGE_ADVANCED_EXPLAIN'	=> 'Disse instillingene er kun nødvendige om noe annet enn standard er påkrevd. Hvis du er usikker, gå til neste side. Disse innstillingene vil også bli tilgjengelige fra administrasjonspanelet.',
	'STAGE_CONFIG_FILE'	=> 'Konfigurasjonsfil',
	'STAGE_CREATE_TABLE'	=> 'Lag databasetabeller',
	'STAGE_CREATE_TABLE_EXPLAIN'	=> 'Databasetabellene som er påkrevd av phpBB 3.0. er laget og utfylt med litt nødvendig informasjon. Gå til neste steg for å fullføre installasjonen.',
	'STAGE_DATABASE'	=> 'Databaseinnstillinger',
	'STAGE_FINAL'	=> 'Siste trinn',
	'STAGE_INTRO'	=> 'Introduksjon',
	'STAGE_IN_PROGRESS'	=> 'Konvertering pågår',
	'STAGE_REQUIREMENTS'	=> 'Påkrevde detaljer',
	'STAGE_SETTINGS'	=> 'Innstillinger',
	'STARTING_CONVERT'	=> 'Starter konverteringsprosessen',
	'STEP_PERCENT_COMPLETED'	=> 'Steg <strong>%d</strong> av <strong>%d</strong>',
	'SUB_INTRO'	=> 'Introduksjon',
	'SUB_LICENSE'	=> 'Lisens',
	'SUB_SUPPORT'	=> 'Support',
	'SUCCESSFUL_CONNECT'	=> 'Feilfri tilkobling',
	'SUPPORT_BODY'	=> 'For alle stabile utgaver av phpBB vil full støtte bli gitt. Dette inkluderer:</p><ul><li>installasjon</li><li>konfigurering</li><li>tekniske spørsmål</li><li>problemer relatert til potensielle bugs i koden</li><li>oppdatering fra Releasekandidatversjoner (RC) til siste stabile utgave</li><li>konvertering fra phpBB 2.0.x til phpBB3</li><li>konvertering fra andre forumsystemer til phpBB3 (les mer i <a href="http://www.phpbb.com/community/viewforum.php?f=65">Konverteringsforumet</a>)</li></ul><p>Vi anbefaler alle som fortsatt bruker BETA-versjoner av phpBB3 til å erstatte installasjonen med en fersk kopi av siste versjon (da det ikke er mulig å oppgradere fra BETA-versjoner).</p><h2>Modifikasjoner og design</h2><p>For problemer relatert til modifikasjoner, vennligst still spørsmålet i <a href="http://www.phpbb.com/community/viewforum.php?f=81">modifikasjonsforumet</a>.<br />For problemer relatert til ulike design, still spørsmålet i <a href="http://www.phpbb.com/community/viewforum.php?f=80">designforumet</a>.<br /><br />Hvis spørsmålet ditt relaterer seg til en spesifik modifikasjon eller et spesifikt design stiller du spørsmålet i emnet som er dedikert denne pakken.</p><h2>Hvordan få hjelp?</h2><p><a href="http://www.phpbb.com/community/viewtopic.php?f=14&t=571070">phpBBs velkomstpakke</a><br /><a href="http://www.phpbb.com/support/">Supportseksjonen</a><br /><a href="http://www.phpbb.com/support/documentation/3.0/quickstart/">Hurtigstartsguide</a><br /><br />For å forsikre deg om at du alltid får med deg informasjon om nye utgaver kan du <a href="http://www.phpbb.com/support/">mailinglisten</a><h2>phpBB på norsk</h2><p>phpBB er mye brukt av nordmenn, og en gjeng dedikerte phpBB-brukere har derfor startet en <a href="http://www.phpbb.no">norsk nettside for phpBB</a>. Her finner du alt du trenger til phpBB, på norsk! Vi hjelper deg med alle problemer du måtte ha knyttet til phpBB. Ta turen innom, uansett om du har problemer eller bare ønsker å slå av en prat med noen andre som også drifter et forum. Forøvrig er det vi som har oversatt phpBB3 også, så dersom du har noen kommentarer til den norske oversettelsen er det bare å si ifra.<br /><br />Du finner oss her: <a href="http://www.phpbb.no">phpBB.no</a></p><br /><br />',
	'SYNC_FORUMS'	=> 'Starter forumoppdatering',
	'SYNC_TOPICS'	=> 'Starter emneoppdatering',
	'SYNC_TOPIC_ID'	=> 'Oppdaterer emner fra <var>emne-ID</var> %1$s til %2$s.',
	'TABLES_MISSING'	=> 'Fant ikke disse tabellene:<br />» <strong>%s</strong>.',
	'TABLE_PREFIX'	=> 'Tabellprefiks i databasen',
	'TABLE_PREFIX_SAME'	=> 'Tabellprefiksen må være brukt av programvaren du konverterer fra.<br />» Den spesifiserte tabellprefiksen var %s',
	'TESTS_PASSED'	=> 'Undersøkelsene er fullført.',
	'TESTS_FAILED'	=> 'Noen undersøkelser feilet.',
	'UNABLE_WRITE_LOCK'	=> 'Kunne ikke skrive til filen',
	'UNAVAILABLE'	=> 'Utilgjengelig',
	'UPDATE_TOPICS_POSTED'	=> 'Genererer emneinformasjon',
	'VERSION'	=> 'Versjon',
	'WELCOME_INSTALL'	=> 'Velkommen til phpBB 3-installasjonen',
	'ALL_FILES_UP_TO_DATE'	=> 'Alle filer er oppdatert til seneste phpBB-versjon. Du burde nå <a href="../ucp.php?mode=login">logge inn i forumet</a> og sjekke om alt virker som det skal. Ikke glem å slette, gi nytt navn til eller flytte install-mappen!',
	'ARCHIVE_FILE'	=> 'Kildefil i arkivet',
	'BACK'	=> 'Tilbake',
	'BINARY_FILE'	=> 'Binær fil',
	'CHECK_FILES'	=> 'Undersøker filer',
	'CHECK_FILES_AGAIN'	=> 'Gjentar undersøkelse',
	'CHECK_FILES_EXPLAIN'	=> 'I neste trinn vil alle filer bli sjekket i forhold til neste versjon - dette kan ta litt tid hvis det er første gang.',
	'CHECK_FILES_UP_TO_DATE'	=> 'Ifølge databasen er dette den nyeste versjonen. Du kan gjennomføre en filundersøkelse for å finne ut om det virkelig er seneste versjon.',
	'CHECK_UPDATE_DATABASE'	=> 'Fortsett oppdateringsprosessen',
	'COLLECTED_INFORMATION'	=> 'Informasjon om samlede filer',
	'COLLECTED_INFORMATION_EXPLAIN'	=> 'Listen under viser filer som trenger oppdatering. Les informasjonen i begynnelsen av hver statusboks for å se hva de mener og hva du må gjøre for å fullføre oppdateringen.',
	'COMPLETE_LOGIN_TO_BOARD'	=> 'Du burde nå <a href="../ucp.php?mode=login">logge inn i forumet</a> og undersøke om alt fungerer som det skal. Ikke glem å slette, gi nytt navn til eller flytte installasjonsmappen!',
	'CURRENT_FILE'	=> 'Begynnelse av konflikt - Originalfilkode før oppdatering',
	'CURRENT_VERSION'	=> 'Foreløpig versjon',
	'DATABASE_TYPE'	=> 'Databasetype',
	'DATABASE_UPDATE_INFO_OLD'	=> 'Databaseoppdateringen i install/-mappen er av nyeste versjon.',
	'DESTINATION'	=> 'Destinasjonsfil',
	'DIFF_INLINE'	=> 'Inni',
	'DIFF_RAW'	=> 'Raw-samlede differanser',
	'DIFF_SEP_EXPLAIN'	=> 'Kode brukt i oppdatert/ny fil',
	'DIFF_SIDE_BY_SIDE'	=> 'Side for side',
	'DIFF_UNIFIED'	=> 'Samlede differanser',
	'DO_NOT_UPDATE'	=> 'Ikke oppdater denne filen',
	'DOWNLOAD'	=> 'Last ned',
	'DOWNLOAD_AS'	=> 'Last ned som',
	'DOWNLOAD_UPDATE_METHOD'	=> 'Last ned modifiserte filer',
	'DOWNLOAD_UPDATE_METHOD_EXPLAIN'	=> 'Etter nedlastingen må du pakke ut filene. Du vil finne de modifiserte filene du trenger for å laste den opp inni den. Last opp filene til de spesifiserte mappene etter det. Undersøk deretter filene før du fullfører.',
	
   'DOWNLOAD_CONFLICTS'            => 'Last ned konflikter i denne filen',
   'DOWNLOAD_CONFLICTS_EXPLAIN'      => 'Søk etter &lt;&lt;&lt; for å finne konflikter',
   
	'ERROR'	=> 'Feil',
	'FILE_ALREADY_UP_TO_DATE'	=> 'Filen er av nyeste versjon',
	'FILE_DIFF_NOT_ALLOWED'	=> 'Filen kan ikke bli gjort om',
	'FILE_USED'	=> 'Informasjon brukt fra',
	'FILES_CONFLICT'	=> 'Konfliktfiler',
	'FILES_CONFLICT_EXPLAIN'	=> 'Følgende filer er modifisert og kan ikke sammenlignes med de originale filene fra den gamle versjonen. PhpBB så at disse kan skape problemer. Undersøk konfliktene og prøv og løse problemene manuelt eller bruk sammenslåingsfunksjonen og fortsett prosessen. Hvis du løser det manuelt, vær sikker på at du gjør det riktig. Du kan også velge en spesiell sammenslåingsmetode for hver enkel fil. Den første vil fjerne de problematiske linjene, den andre lar være å oppdatere den.',
	'FILES_MODIFIED'	=> 'Modifiserte filer',
	'FILES_MODIFIED_EXPLAIN'	=> 'Følgende filer er modifiserte og er ulike de originale filene. Oppdateringen kommer til å slå sammen den nye og den modifiserte filen.',
	'FILES_NEW'	=> 'Nye filer',
	'FILES_NEW_EXPLAIN'	=> 'Følgende filer er lagt til etter installasjonen.',
	'FILES_NEW_CONFLICT'	=> 'Nye konfliktfiler',
	'FILES_NEW_CONFLICT_EXPLAIN'	=> 'Følgende filer er nye i den seneste versjonen, men det finnes allerede en fil med samme navn i mappen. Denne filen vil bli overskrevet av den nye.',
	'FILES_NOT_MODIFIED'	=> 'Ikkemodifiserte filer',
	'FILES_NOT_MODIFIED_EXPLAIN'	=> 'Disse filene er ikke modifiserte, og kan trygt oppdateres.',
	'FILES_UP_TO_DATE'	=> 'Oppdaterte filer',
	'FILES_UP_TO_DATE_EXPLAIN'	=> 'Disse filene trenger ingen oppdatering.',
	'FTP_SETTINGS'	=> 'FTP-innstillinger',
	'FTP_UPDATE_METHOD'	=> 'FTP-opplastning',
	'INCOMPATIBLE_UPDATE_FILES'	=> 'Oppdateringsfilene er ukompitable med din nye versjon. Din installerte versjon er %1$s og oppdateringsfilen er for oppdatering fra phpBB %2$s til %3$s.',
	'INCOMPLETE_UPDATE_FILES'	=> 'Oppdateringsfilene er ukomplette.',
	'LATEST_VERSION'	=> 'Nyeste versjon',
	'LINE'	=> 'Linje',
	'LINE_ADDED'	=> 'Lagt til',
	'LINE_MODIFIED'	=> 'Endret',
	'LINE_REMOVED'	=> 'Slettet',
	'LINE_UNMODIFIED'	=> 'Uendret',
	'LOGIN_UPDATE_EXPLAIN'	=> 'Du må logge inn for å oppdatere.',
	'MAPPING_FILE_STRUCTURE'	=> 'For å forenkle opplastingen, holder disse filene oversikt over phpBB-installasjonen.',
	'MERGE_NO_MERGE_NEW_OPTION'	=> 'Ikke slå sammen - bruk en ny fil',
	'MERGE_NO_MERGE_MOD_OPTION'	=> 'ikke slå sammen - bruk gjeldende fil',
	'MERGE_MOD_FILE_OPTION'	=> 'Slå sammen modifikasjoner (bruk ny phpBB-kode sammen med den problematiske)',
	'MERGE_NEW_FILE_OPTION'	=> 'Slå sammen modifikasjoner (bruk modifisert kode sammen med den problematiske)',
	'MERGE_SELECT_ERROR'	=> 'Sammenslåingsetode er ikke spesifisert.',
	'NEW_FILE'	=> 'Slutt på konflikt',
	'NO_AUTH_UPDATE'	=> 'Unødvendig å oppdatere.',
	'NO_ERRORS'	=> 'Ingen feil',
	'NO_UPDATE_FILES'	=> 'Ikke oppdater følgende filer',
	'NO_UPDATE_FILES_EXPLAIN'	=> 'Følgende filer er nye eller modifiserte, men mappen de vanligvis befinner seg i ble ikke funnet av installasjonsskriptet. Hvis denne listen viser filer som ikke er i mappene language/ eller styles/, har du modifisert mappestrukturen, og dermed gjort oppdateringen ukomplett.',
	'NO_UPDATE_FILES_OUTDATED'	=> 'Ingen oppdateringsmappe er funnet; bekreft at du lastet opp riktige filer.<br /><br />Installasjonen er <strong>ikke</strong> oppdatert. Oppdateringer for phpBB %1$s er tilgjengelige, besøk <a href="http://www.phpbb.com/downloads.php" rel="external">phpBB.coms nedlastingsside</a> for å laste ned riktig oppdateringspakke fra versjon %2$s til versjon %3$s.',
	'NO_UPDATE_FILES_UP_TO_DATE'	=> 'Versjonen er oppdatert. Du trenger ikke å kjøre oppdateringsverktøyet. Hvis du ønsker å sjekke om oppdateringen er korrekt, kan du se gjennom filene.',
	'NO_UPDATE_INFO'	=> 'Oppdateringsfilinfomasjon ble ikke funnet.',
	'NO_UPDATES_REQUIRED'	=> 'Ingen oppdateringer er tilgjengelige.',
	'NO_VISIBLE_CHANGES'	=> 'Ingen synlige endringer.',
	'NOTICE'	=> 'Notat',
	'NUM_CONFLICTS'	=> 'Antall konflikter',
	'OLD_UPDATE_FILES'	=> 'Oppdateringsfilene er utdaterte. Oppdateringsfilene er for oppdatering fra versjon %1$s til %2$s, men den seneste versjonen er phpBB %3$s.',
	'PERFORM_DATABASE_UPDATE'	=> 'Gjennomfør databaseoppdatering',
	'PERFORM_DATABASE_UPDATE_EXPLAIN'	=> 'Under ser du en link til databaseoppdateringsskriptet. Dette må bli kjørt separat fordi det kan føre til uønskede hendelser etter innlogging. Databaseoppdateringen kan ta litt tid, så ikke stopp den hvis det ser ut til at den har hengt seg opp. Etter oppdateringen, lukk vinduet/fanen og fortsett oppdateringsprosessen.',
	'PREVIOUS_VERSION'	=> 'Forrige versjon',
	'PROGRESS'	=> 'Progress',
	'RESULT'	=> 'Resultat',
	'RUN_DATABASE_SCRIPT'	=> 'Oppdater databsen nå',
	'SELECT_DIFF_MODE'	=> 'Velg endringsmetode',
	'SELECT_DOWNLOAD_FORMAT'	=> 'Velg nedlastingsarkivformat',
	'SELECT_FTP_SETTINGS'	=> 'Velg FTP-innstillinger',
	'SHOW_DIFF_CONFLICT'	=> 'Vis forskjeller/konflikter',
	'SHOW_DIFF_FINAL'	=> 'Se resultatfilen',
	'SHOW_DIFF_MODIFIED'	=> 'Vis sammenslåtte forskjeller',
	'SHOW_DIFF_NEW'	=> 'Vis fildetaljer',
	'SHOW_DIFF_NEW_CONFLICT'	=> 'Vis forskjeller',
	'SHOW_DIFF_NOT_MODIFIED'	=> 'Vis forskjeller',
	'SOME_QUERIES_FAILED'	=> 'Noen kommandoer feilet, gjeldende informasjon vises nedenfor.',
	'SQL'	=> 'SQL',
	'SQL_FAILURE_EXPLAIN'	=> 'Dette er sannsynligvis ikke noe å bekymre seg for, da oppdateringen vil fortsette. Skulle det feile, søk hjelp i supportforumene. Se <a href="../docs/README.html">README</a> for flere detaljer.',
	'STAGE_FILE_CHECK'	=> 'Undersøk filene',
	'STAGE_UPDATE_DB'	=> 'Oppdater databasen',
	'STAGE_UPDATE_FILES'	=> 'Oppdater filene',
	'STAGE_VERSION_CHECK'	=> 'Versjonsundersøkelse',
	'STATUS_CONFLICT'	=> 'Modifisert fil som skaper problemer',
	'STATUS_MODIFIED'	=> 'Modifisert fil',
	'STATUS_NEW'	=> 'Ny fil',
	'STATUS_NEW_CONFLICT'	=> 'Ny problematisk fil',
	'STATUS_NOT_MODIFIED'	=> 'Ikkemodifisert fil',
	'STATUS_UP_TO_DATE'	=> 'Oppdatert fil',
	'UPDATE_COMPLETED'	=> 'Oppdatering er fullført',
	'UPDATE_DATABASE'	=> 'Oppdater database',
	'UPDATE_DATABASE_EXPLAIN'	=> 'I neste steg vil databasen bli oppdatert.',
	'UPDATE_DATABASE_SCHEMA'	=> 'Oppdater databaseskjema',
	'UPDATE_FILES'	=> 'Oppdater filene',
	'UPDATE_FILES_NOTICE'	=> 'Bekreft at du har oppdatert filene, da denne filen bare oppdaterer databasen.',
	'UPDATE_INSTALLATION'	=> 'Oppdater phpBB',
	'UPDATE_INSTALLATION_EXPLAIN'	=> 'Med dette alternativet kan du oppdatere phpBB.<br />I løpet av denne prosessen vil alle filene bli undersøkt. Du kan gjennomsøke alle filene før oppdateringen.<br /><br />Oppdateringen i seg selv kan bli gjort via to metoder:</p><h2>Manuell oppdatering</h2><p>Ved å oppdatere manuelt, kan du være sikker på at du ikke mister noen MOD-er. Da må du laste ned oppdateringspakken fra phpBB.com og deretter laste den opp til serveren. Etter dette må du se om filene er i riktig mappe.</p><h2>Automatisk</h2><p>Denne metoden oppdaterer forumet automatisk uten at du trenger å laste ned noe. Dette vil bli gjort av seg selv. For å kunne bruke denne metoden, må du oppgi visse FTP-innloggingsdetaljer. Når du er ferdig, bør du sjekke om filene er riktig oppdatert.',
	'UPDATE_INSTRUCTIONS'	=> '    <h1>Lanseringsinformasjon</h1>

    <p>Les <a href="%1$s" title="%1$s">lanseringsinformasjonen for seneste versjon</a> før du fortsetter oppdateringsprosessen, da denne kan inneholde brukbar informasjon. Den inneholder også nedlastingslinker.</p>

    <br />

    <h1>Hvordan oppdatere din installasjon</h1>

    <p>For å utføre oppdateringer, må du gå gjennom følgende steg:</p>

    <ul style="margin-left: 20px; font-size: 1.1em;">
      <li>Gå til <a href="http://www.phpbb.com/downloads.php" title="http://www.phpbb.com/downloads.php">phpBB.coms nedlastingsside</a> og last ned riktig "phpBB Update Package"-arkiv.<br /><br /></li>
      <li>Pakk ut mappen.<br /><br /></li>
      <li>Last opp install/-mappen til din phpBB-mappe (hvor filen config.php er).<br /><br /></li>
    </ul>

    <p>Nå vil forumet være utilgjengelig for normale brukere på grunn av install/-mappen.<br /><br />
    <strong><a href="%2$s" title="%2$s">Start oppdateringsprosessen.</a></strong><br />
    <br />
    Du vil få all nødvendig informasjon under oppdateringsprosessen. Du vil også bli informert når oppdateringen er fullført. Lykke til ;)
    </p>',
	'UPDATE_METHOD'	=> 'Opplastingsmetode',
	'UPDATE_METHOD_EXPLAIN'	=> 'Du kan nå velge foretrukket oppdateringsmetode. FTP-opplastingen krever at du fyller ut et skjema med innloggingsinformasjon. Ved bruk av denne metoden, vil filene automatisk bli flyttet og sikkerhetskopier vil få filendelsen .bak. Hvis du velger å laste ned modifiserte filer, kan du pakke dem ut og laste dem opp til korrekt mappe manuelt senere.',
	'UPDATE_SUCCESS'	=> 'Oppdateringen er fullført',
	'UPDATE_SUCCESS_EXPLAIN'	=> 'Alle filer er oppdaterte. Neste steg undersøker om oppdateringen var riktig utført.',
	'UPDATE_VERSION_OPTIMIZE'	=> 'Oppdaterer versjonen, og optimaliserer tabellene.',
	'UPDATING_DATA'	=> 'Oppdaterer data.',
	'UPDATING_TO_LATEST_STABLE'	=> 'Oppdaterer databasen.',
	'UPDATED_VERSION'	=> 'Oppdatert versjon',
	'UPLOAD_METHOD'	=> 'Opplastingsmetode',
	'UPDATE_DB_SUCCESS'	=> 'Databaseoppdateringen er fullført',
	'VERSION_CHECK'	=> 'Versjonstest',
	'VERSION_CHECK_EXPLAIN'	=> 'Undersøker om phpBB er oppdatert til nyeste versjon.',
	'VERSION_NOT_UP_TO_DATE'	=> 'PhpBB-versjonen din er ikke oppdatert. Fortsett oppdateringsprosessen.',
	'VERSION_NOT_UP_TO_DATE_ACP'	=> 'PhpBB-versjonen din er ikke oppdatert.<br />Under ser du en link til lanseringsinformasjonen for seneste versjon, og instruksjoner til hvordan du oppdaterer forumet.',
	'VERSION_UP_TO_DATE'	=> 'Installasjonen er oppdatert, og ingen oppdateringer er nødvendige for din phpBB-versjon. Du kan fortsette uansett hvis du vil gjennomføre en undersøkelse.',
	'VERSION_UP_TO_DATE_ACP'	=> 'Installasjonen er oppdatert, og ingen nyere versjoner er tilgjengelige for ditt phpBB-forum. Du trenger ikke å oppdatere.',
	'VIEWING_FILE_CONTENTS'	=> 'Viser fildetaljer',
	'VIEWING_FILE_DIFF'	=> 'Filforskjeller',
	'WRONG_INFO_FILE_FORMAT'	=> 'Feil filformat',
	'CONFIG_BOARD_EMAIL_SIG'	=> 'Med vennlig hilsen, forumledelsen.',
	'CONFIG_SITE_DESC'	=> 'En liten beskrivelse av ditt forum',
	'CONFIG_SITENAME'	=> 'dittdomene.no',
	'DEFAULT_INSTALL_POST'	=> 'Dette er et eksempelemne i din phpBB3-installasjon. Alt ser ut til å fungere fint. Du kan slette dette emnet hvis du vil, og fortsette med å sette opp forumstrukturen din. Under installasjonen ble din første kategori og ditt første forum tilegnet et sett med rettigheter for følgende predefinerte brukergrupper: administratorer, søkeroboter, globale moderatorer, gjester, registrerte brukere og registrerte COPPA-brukere. Hvis du velger å slette denne kategorien og dette forumet, så må du ikke glemme å tilegne rettigheter for disse gruppene til alle nye kategorier og forumer du lager, hvis ikke vil det ikke være mulig for noen å se dem (dette er nytt i phpBB 3.0). Det er anbefalt at du heller endrer navn på den allerede eksisterende kategorien og forumet og deretter kopierer rettighetene fra dem når du lager nye kategorier og forum, da dette gjør det enklere for deg nå i begynnelsen. Kos deg med phpBB3, og lykke til med forumet ditt!',
	'EXT_GROUP_ARCHIVES'	=> 'Arkiver',
	'EXT_GROUP_DOCUMENTS'	=> 'Dokumenter',
	'EXT_GROUP_DOWNLOADABLE_FILES'	=> 'Nedlastbare filer',
	'EXT_GROUP_FLASH_FILES'	=> 'Flash-filer',
	'EXT_GROUP_IMAGES'	=> 'Bilder',
	'EXT_GROUP_PLAIN_TEXT'	=> 'Rene tekstfiler',
	'EXT_GROUP_QUICKTIME_MEDIA'	=> 'Quicktime Media',
	'EXT_GROUP_REAL_MEDIA'	=> 'Real Media',
	'EXT_GROUP_WINDOWS_MEDIA'	=> 'Windows Media',
	'FORUMS_FIRST_CATEGORY'	=> 'Min første kategori',
	'FORUMS_TEST_FORUM_DESC'	=> 'Dette er et testforum som du kan slette hvis du måtte ønske det.',
	'FORUMS_TEST_FORUM_TITLE'	=> 'Testforum',
	'RANKS_SITE_ADMIN_TITLE'	=> 'Forumadministrator',
	'SMILIES_ARROW'	=> 'Pil',
	'SMILIES_CONFUSED'	=> 'Usikker',
	'SMILIES_COOL'	=> 'Kul',
	'SMILIES_CRYING'	=> 'Gråtende',
	'SMILIES_EMARRASSED'	=> 'Flau',
	'SMILIES_EVIL'	=> 'Ond',
	'SMILIES_EXCLAMATION'	=> 'Utropstegn',
	'SMILIES_GEEK'	=> 'Nerd',
	'SMILIES_IDEA'	=> 'Idé',
	'SMILIES_LAUGHING'	=> 'Leende',
	'SMILIES_MAD'	=> 'Sint',
	'SMILIES_MR_GREEN'	=> 'Hr. Grønn',
	'SMILIES_NEUTRAL'	=> 'Nøytral',
	'SMILIES_QUESTION'	=> 'Spørsmålstegn',
	'SMILIES_RAZZ'	=> 'Gjeip',
	'SMILIES_ROLLING_EYES'	=> 'Rullende øyne',
	'SMILIES_SAD'	=> 'Trist',
	'SMILIES_SHOCKED'	=> 'Sjokkert',
	'SMILIES_SMILE'	=> 'Smilende',
	'SMILIES_SURPRISED'	=> 'Overrasket',
	'SMILIES_TWISTED_EVIL'	=> 'Slem',
	'SMILIES_UBER_GEEK'	=> 'Kjempenerd',
	'SMILIES_VERY_HAPPY'	=> 'Veldig glad',
	'SMILIES_WINK'	=> 'Blunkende',
	'TOPICS_TOPIC_TITLE'	=> 'Gratulerer med ditt nye phpBB3-forum!',
	
	'DOWNLOAD_UPDATE_METHOD_BUTTON'		=> 'Last ned modifiserte filer (anbefalt)',
	'TRY_DOWNLOAD_METHOD'		=> 'Du kan prøve metoden med å laste ned modifiserte filer.<br />Denne metoden fungerer alltid og er også den anbefalte.',
	'TRY_DOWNLOAD_METHOD_BUTTON'=> 'Prøv denne metoden nå',
	'CONTINUE_UPDATE'				=> 'Fortsett oppdateringsprosessen',
	
	'DB_UPDATE_NOT_SUPPORTED'	=> 'Beklager, men dette skriptet støtter ikke oppdatering fra versjoner av phpBB før “%1$s”. Den versjonen du har installert er “%2$s”. Oppdater til en tidligere versjon før du kjører dette skriptet. Hjelp med dette er tilgjengelig i supportforumet hos phpBB.com og phpBB.no.',
 	'FIREBIRD_DBMS_UPDATE_REQUIRED'		=> 'phpBB støtter ikke lenger versjoner av Firebird/Interbase som er lavere enn 2.1. Oppdater Firebird til minst 2.1.0 før du fortsetter med oppdateringen.',
	'VERSION_NOT_UP_TO_DATE_TITLE'	=> 'phpBB-installasjonen er ikke oppdatert.'
));

?>