<?php
/**
*
* common [Bahasa Indonesia]
*
* @package language
* @version $Id: common.php 2009 Sastra Manurung
* @copyright (c) 2009 Zourbuth Studio
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » “ ” …
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> '',
	'DIRECTION'			=> 'ltr',
	'DATE_FORMAT'		=> '|d M Y|',	// 01 Jan 2007 (with Relative days enabled)
	'USER_LANG'			=> 'en-gb',

	'1_DAY'			=> '1 hari',
	'1_MONTH'		=> '1 bulan',
	'1_YEAR'		=> '1 tahun',
	'2_WEEKS'		=> '2 minggu',
	'3_MONTHS'		=> '3 bulan',
	'6_MONTHS'		=> '6 bulan',
	'7_DAYS'		=> '7 hari',

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'Account anda telah diaktifkan.',
	'ACCOUNT_DEACTIVATED'			=> 'Account anda telah dinonaktifkan secara manual dan hanya dapat diaktifkan kembali oleh administrator.',
	'ACCOUNT_NOT_ACTIVATED'			=> 'Account anda belum diaktifkan.',
	'ACP'							=> 'Papan Pengaturan Administrasi',
	'ACTIVE'						=> 'aktif',
	'ACTIVE_ERROR'					=> 'Nama pengguna yang dimaksud non-aktifkan sekarang ini. Jika anda memiliki permasalahan mengenai pengaktifan account anda, silahkan menghubungi administrator.',
	'ADMINISTRATOR'					=> 'Administrator',
	'ADMINISTRATORS'				=> 'Administrator',
	'AGE'							=> 'Umur',
	'AIM'							=> 'AIM',
	'ALLOWED'						=> 'Diijinkan',
	'ALL_FILES'						=> 'Semua file',
	'ALL_FORUMS'					=> 'Semua forum',
	'ALL_MESSAGES'					=> 'Semua pesan',
	'ALL_POSTS'						=> 'Semua post',
	'ALL_TIMES'						=> 'Waktu dalam %1$s %2$s',
	'ALL_TOPICS'					=> 'Semua topik',
	'AND'							=> 'Dan',
	'ARE_WATCHING_FORUM'			=> 'Anda telah berlanggan untuk diberitahukan mengenai post yang baru di forum ini.',
	'ARE_WATCHING_TOPIC'			=> 'Anda telah berlanggan untuk diberitahukan mengenai post yang baru di topik ini.',
	'ASCENDING'						=> 'Urutkan menaik',
	'ATTACHMENTS'					=> 'Lampiran',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'File gambar yang anda coba lampirkan tidak sah.',
	'AUTHOR'						=> 'Pengarang',
	'AUTH_NO_PROFILE_CREATED'		=> 'Pembuatan profil pengguna tidak berhasil.',
	'AVATAR_DISALLOWED_CONTENT'		=> 'Upload ditolak karena file yang diupload dikenali kemungkinan penyerangan.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'File ini tidak dapat ditampilkan karena ekstensi file <strong>%s</strong> tidak diijinkan.',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'Avatar yang dimaksud tidak dapat diupload karena remote data kelihatannya tidak sah ataupun rusak.',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'File avatar yang diupload kosong.',
	'AVATAR_INVALID_FILENAME'		=> '%s adalah nama file yang tidak sah.',
	'AVATAR_NOT_UPLOADED'			=> 'Avatar tidak dapat diupload.',
	'AVATAR_NO_SIZE'				=> 'Ukuran panjang dan lebar avatar yang di-link-kan tidak dapat ditentukan. Mohon diisi secara manual.',
	'AVATAR_PARTIAL_UPLOAD'			=> 'File yang dimaksud diupload secara parsial.',
	'AVATAR_PHP_SIZE_NA'			=> 'Ukuran file avatar terlalu besar.<br />Batas ukuran besar file maksimum yang diijinkan yang diatur di php.ini tidak dapat ditentukan.',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'Ukuran file avatar terlalu besar. Ukuran maksimum file upload adalah %1$d %2$s.<br />Mohon dicatat bahwa ini diatur pada php.ini dan tidak dapat dikesampingkan.',
	'AVATAR_URL_INVALID'			=> 'URL yang anda maksudkan tidak sah.',
	'AVATAR_URL_NOT_FOUND'			=> 'File yang dimaksud tidak dapat ditemukan.',
	'AVATAR_WRONG_FILESIZE'			=> 'Besar ukuran file avatar harus diantara 0 dan %1d %2s.',
	'AVATAR_WRONG_SIZE'				=> 'Lebar ukuran avatar yang diajukan adalah %5$d piksel dan tinggi %6$d piksel. Paling tidak lebarnya %1$d pixels dan panjangnya %2$d pixels, tetapi lebarnya tidak boleh lebih besar dari %3$d pixels dan tingginya %4$d pixels.',

	'BACK_TO_TOP'			=> 'Atas',
	'BACK_TO_PREV'			=> 'Kembali kehalaman sebelumnya',
	'BAN_TRIGGERED_BY_EMAIL'=> 'Sebuah larangan telah dikirimkan ke alamat e-mail anda.',
	'BAN_TRIGGERED_BY_IP'	=> 'Sebuah larangan telah dikeluarkan untuk alamat IP anda.',
	'BAN_TRIGGERED_BY_USER'	=> 'Sebuah larangan telah dikeluarkan untuk nama pengguna anda.',
	'BBCODE_GUIDE'			=> 'Panduan BBCode',
	'BCC'					=> 'BCC',
	'BIRTHDAYS'				=> 'Yang berulang tahun',
	'BOARD_BAN_PERM'		=> 'Anda telah dilarang secara permanen <strong>permanently</strong> di halaman ini.<br /><br />Silahkan menghubungi %2$sBoard Administrator%3$s untuk informasi lebih lanjut.',
	'BOARD_BAN_REASON'		=> 'Alasan yang diberikan untuk larangan: <strong>%s</strong>',
	'BOARD_BAN_TIME'		=> 'Anda telah dilarang di halaman ini sampai <strong>%1$s</strong>.<br /><br />Silahkan menghubungi %2$sBoard Administrator%3$s untuk informasi lebih lanjut.',
	'BOARD_DISABLE'			=> 'Maaf, halaman ini tidak tersedia sekarang.',
	'BOARD_DISABLED'		=> 'Halaman ini belum dapat digunakan sekarang.',
	'BOARD_UNAVAILABLE'		=> 'Maaf, halaman ini tidak dapat digunakan untuk sementara, cobalah beberapa saat lagi.',
	'BROWSING_FORUM'		=> 'Pengguna yang berada di forum ini: %1$s',
	'BROWSING_FORUM_GUEST'	=> 'Pengguna yang berada di forum ini: %1$s dan %2$d tamu',
	'BROWSING_FORUM_GUESTS'	=> 'Pengguna yang berada di forum ini: %1$s dan %2$d tamu',
	'BYTES'					=> 'Bytes',

	'CANCEL'				=> 'Batalkan',
	'CHANGE'				=> 'Ubah',
	'CHANGE_FONT_SIZE'		=> 'Ubah ukuran huruf',
	'CHANGING_PREFERENCES'	=> 'Mengubah pilihan halaman',
	'CHANGING_PROFILE'		=> 'Mengubah pengaturan profil',

	//-- mod : AJAX Chat ----------------------------------------------------
	//-- add
	'CHAT'					=> 'Chat',
	'CHAT_EXPLAIN'			=> 'Chat Center',
	//-- fin mod : AJAX Chat ------------------------------------------------

	'CLICK_VIEW_PRIVMSG'	=> '%sMasuk ke inbox%s',
	'COLLAPSE_VIEW'			=> 'Persempit tampilan',
	'CLOSE_WINDOW'			=> 'Tutup halaman',
	'COLOUR_SWATCH'			=> 'Pencarian warna',
	'COMMA_SEPARATOR'		=> ', ',	// Used in pagination of ACP & prosilver, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'Konfirmasikan',
	'CONFIRM_CODE'			=> 'Kode konfirmasi',
	'CONFIRM_CODE_EXPLAIN'	=> 'Masukkan kode dengan tepat seperti yang ditampilkan. Semua huruf tidak case sensitif dan tidak ada angka nol.',
	'CONFIRM_CODE_WRONG'	=> 'Kode konfirmasi yang anda masukkan tidak tepat.',
	'CONFIRM_OPERATION'		=> 'Apakah anda yakin ingin melakukan ini?',
	'CONGRATULATIONS'		=> 'Selamat kepada',
	'CONNECTION_FAILED'		=> 'Koneksi gagal!.',
	'CONNECTION_SUCCESS'	=> 'Koneksi berhasil!',
	'COOKIES_DELETED'		=> 'Semua cookies halaman telah berhasil dihapus.',
	'CURRENT_TIME'			=> 'Sekarang ini %s',

	'DAY'					=> 'Hari',
	'DAYS'					=> 'Hari',
	'DELETE'				=> 'Hapus',
	'DELETE_ALL'			=> 'Hapus semua',
	'DELETE_COOKIES'		=> 'Hapus cookie halaman',
	'DELETE_MARKED'			=> 'Hapus yang ditandai',
	'DELETE_POST'			=> 'Hapus post',
	'DELIMITER'				=> 'Pembatas',
	'DESCENDING'			=> 'Urutkan menurun',
	'DISABLED'				=> 'Tidak aktif',
	'DISPLAY'				=> 'Tampilkan',
	'DISPLAY_GUESTS'		=> 'Tampilkan tamu',
	'DISPLAY_MESSAGES'		=> 'Tampilkan pesan-pesan sebelumnya',
	'DISPLAY_POSTS'			=> 'Tampilkan post-post sebelumnya',
	'DISPLAY_TOPICS'		=> 'Tampilkan topik-topik sebelumnya',
	'DOWNLOADED'			=> 'Didownload',
	'DOWNLOADING_FILE'		=> 'Mendownload file',
	'DOWNLOAD_COUNT'		=> 'Didownload %d kali',
	'DOWNLOAD_COUNTS'		=> 'Didownload %d kali',
	'DOWNLOAD_COUNT_NONE'	=> 'Belum didownload sama sekali',
	'VIEWED_COUNT'			=> 'Dilihat %d kali',
	'VIEWED_COUNTS'			=> 'Dilihat %d kali',
	'VIEWED_COUNT_NONE'		=> 'Belum dilihat sama sekali',

	'EDIT_POST'							=> 'Ubah post',
	'EMAIL'								=> 'E-mail', // Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'Alamat e-mail',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'Pengiriman e-mail dijalankan dengan masalah pada <strong>baris %1$s</strong>. Responsi: %2$s.',
	'EMPTY_SUBJECT'						=> 'Anda harus memasukkan subjek jika memulai topik baru.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'Anda harus memasukkan subjek jika membuat pesan baru.',
	'ENABLED'							=> 'Aktif',
	'ENCLOSURE'							=> 'Lampiran',
	'ERR_CHANGING_DIRECTORY'			=> 'Tidak dapat mengubah direktori.',
	'ERR_CONNECTING_SERVER'				=> 'Koneksi error ke server.',
	'ERR_JAB_AUTH'						=> 'Tidak dapat diotorisasikan ke sever Jabber.',
	'ERR_JAB_CONNECT'					=> 'Tidak dapat dihubungkan ke sever Jabber.',
	'ERR_UNABLE_TO_LOGIN'				=> 'Nama pengguna dan kata sandi yang anda masukkan salah.',
	'ERR_UNWATCHING'					=> 'Error terjadi pada saat mencoba berhenti berlangganan.',
	'ERR_WATCHING'						=> 'Error terjadi pada saat mencoba berlangganan.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'Path phpBB yang anda tentukan sepertinya salah.',
	'EXPAND_VIEW'						=> 'Perluas tampilan',
	'EXTENSION'							=> 'Ekstensi',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'The extension <strong>%s</strong> has been deactivated and can no longer be displayed.',

	'FAQ'					=> 'Bantuan',
	'FAQ_EXPLAIN'			=> 'Pertanyaan Yang Sering Diajukan',
	'FILENAME'				=> 'Nama file',
	'FILESIZE'				=> 'Ukuran file',
	'FILEDATE'				=> 'Tanggal file',
	'FILE_COMMENT'			=> 'Komentar file',
	'FILE_NOT_FOUND'		=> 'Fila yang dicari tidak dapat ditemukan.',
	'FIND_USERNAME'			=> 'Cari anggota',
	'FOLDER'				=> 'Folder',
	'FORGOT_PASS'			=> 'Saya lupa kata sandi',
	'FORM_INVALID'			=> 'Formulir yang diajukan salah. Silahkan ajukan lagi.',
	'FORUM'					=> 'Forum',
	'FORUMS'				=> 'Forum',
	'FORUMS_MARKED'			=> 'Semua forum telah ditandai dibaca.',
	'FORUM_CAT'				=> 'Kategori forum',
	'FORUM_INDEX'			=> 'Halaman Indeks',
	'FORUM_LINK'			=> 'Link Forum',
	'FORUM_LOCATION'		=> 'Lokasi Forum',
	'FORUM_LOCKED'			=> 'Forum Dikunci',
	'FORUM_RULES'			=> 'Peraturan Forum',
	'FORUM_RULES_LINK'		=> 'Silahkan klik di sini untuk melihat peraturan forum',
	'FROM'					=> 'dari',
	'FSOCK_DISABLED'		=> 'Operasi tersebut tidak dapat dilakukan karena fungsi <var>fsockopen</var> telah dimatikan atau server tersebut tidak ditemukan.',

	'FTP_FSOCK_HOST'				=> 'Host FTP',
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'Server FTP digunakan untuk menghubungkan situs anda.',
	'FTP_FSOCK_PASSWORD'			=> 'Kata sandi FTP',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'Kata sandi untuk nama pengguna FTP anda.',
	'FTP_FSOCK_PORT'				=> 'Port FTP',
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'Port digunakan untuk menghubungkan server anda.',
	'FTP_FSOCK_ROOT_PATH'			=> 'Path ke phpBB',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'Path dari the root ke halaman phpBB anda.',
	'FTP_FSOCK_TIMEOUT'				=> 'FTP timeout',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'Jumlah waktu, dalam detik, untuk sistem menunggu balasan dari sever anda.',
	'FTP_FSOCK_USERNAME'			=> 'Nama pengguna FTP',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'Nama pengguna yang digunakan untuk menghubungkan ke server anda.',

	'FTP_HOST'					=> 'Host FTP',
	'FTP_HOST_EXPLAIN'			=> 'Sever FTP digunakan untuk menghubungkan ke situs anda.',
	'FTP_PASSWORD'				=> 'Kata sandi FTP',
	'FTP_PASSWORD_EXPLAIN'		=> 'Kata sandi untuk nama pengguna FTP anda.',
	'FTP_PORT'					=> 'Port FTP',
	'FTP_PORT_EXPLAIN'			=> 'Port digunakan untuk menghubungkan ke situs anda.',
	'FTP_ROOT_PATH'				=> 'Path ke phpBB',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'Path dari the root ke halaman phpBB anda.',
	'FTP_TIMEOUT'				=> 'FTP timeout',
	'FTP_TIMEOUT_EXPLAIN'		=> 'Jumlah waktu, dalam detik, untuk sistem menunggu balasan dari sever anda.',
	'FTP_USERNAME'				=> 'Nama pengguna FTP',
	'FTP_USERNAME_EXPLAIN'		=> 'Nama pengguna yang digunakan untuk menghubungkan ke server anda.',

	'GENERAL_ERROR'				=> 'General Error',
    'GB'						=> 'GB',
    'GIB'						=> 'GiB',
	'GO'						=> 'Laksanakan',
	'GOTO_PAGE'					=> 'Pergi ke halaman',
	'GROUP'						=> 'Grup',
	'GROUPS'					=> 'Grup',
	'GROUP_ERR_TYPE'			=> 'Tipe grup yang ditentukan tidak tepat.',
	'GROUP_ERR_USERNAME'		=> 'Belum ada nama grup yang ditentukan.',
	'GROUP_ERR_USER_LONG'		=> 'Nama grup tidak boleh melebihi 60 karakter. Nama grup yang ditentukan terlalu panjang.',
	'GUEST'						=> 'Tamu',
	'GUEST_USERS_ONLINE'		=> 'Ada %d tamu online',
	'GUEST_USERS_TOTAL'			=> '%d tamu',
	'GUEST_USERS_ZERO_ONLINE'	=> 'Ada 0 tamu yang online',
	'GUEST_USERS_ZERO_TOTAL'	=> '0 tamu',
	'GUEST_USER_ONLINE'			=> 'Ada %d tamu yang online',
	'GUEST_USER_TOTAL'			=> '%d tamu',
	'G_ADMINISTRATORS'			=> 'Administrator',
	'G_BOTS'					=> 'Bot',
	'G_GUESTS'					=> 'Tamu',
	'G_REGISTERED'				=> 'Pengguna Terdaftar',
	'G_REGISTERED_COPPA'		=> 'Pengguna COPPA Terdaftar',
	'G_GLOBAL_MODERATORS'		=> 'Global Moderators',

	'HIDDEN_USERS_ONLINE'			=> '%d pengguna tersembunyi yang online',
	'HIDDEN_USERS_TOTAL'			=> '%d tersembunyi',
	'HIDDEN_USERS_TOTAL_AND'		=> '%d tersembunyi dan ',
	'HIDDEN_USERS_ZERO_ONLINE'		=> '0 pengguna tersembunyi yang online',
	'HIDDEN_USERS_ZERO_TOTAL'		=> '0 tersembunyi',
	'HIDDEN_USERS_ZERO_TOTAL_AND'	=> '0 tersembunyi dan ',
	'HIDDEN_USER_ONLINE'			=> '%d pengguna tersembunyi yang online',
	'HIDDEN_USER_TOTAL'				=> '%d tersembunyi',
	'HIDDEN_USER_TOTAL_AND'			=> '%d tersembunyi dan ',
	'HIDE_GUESTS'					=> 'Sembunyikan tamu-tamu',
	'HIDE_ME'						=> 'Sembunyikan status online saya di sesi ini',
	'HOURS'							=> 'Jam',
	'HOME'							=> 'Home',

	'ICQ'						=> 'ICQ',
	'ICQ_STATUS'				=> 'Status ICQ',
	'IF'						=> 'Jika',
	'IMAGE'						=> 'Gambar',
	'IMAGE_FILETYPE_INVALID'	=> 'Tipe file gambar %d untuk mimetype %s tidak didukung.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'Tipe file gambar tidak cocok: dibutuhkan ekstensi %1$s tetapi ekstensi %2$s yang diberikan.',
	'IN'						=> 'dalam',
	'INDEX'						=> 'Halaman Indeks',
	'INFORMATION'				=> 'Informasi',
	'INTERESTS'					=> 'Minat',
	'INVALID_DIGEST_CHALLENGE'	=> 'Intisari tantangan tidak benar.',
	'INVALID_EMAIL_LOG'			=> '<strong>%s</strong> kemungkinan merupakan alamat e-mail yang salah?',
	'IP'						=> 'IP',
	'IP_BLACKLISTED'			=> 'IP Anda %1$s telah diblokir karena sudah dimasukkan kedalam daftar hitam. Untuk keterangan lebih lanjut, silahkan lihat <a href="%2$s">%2$s</a>.',

	'JABBER'				=> 'Jabber',
	'JOINED'				=> 'Bergabung',
	'JUMP_PAGE'				=> 'Masukkan nomor halaman yang ingin dituju',
	'JUMP_TO'				=> 'Lompat ke',
	'JUMP_TO_PAGE'			=> 'Klik untuk melompat ke page…',

	'KB'					=> 'KB',
	'KIB'					=> 'KiB',

	'LAST_POST'							=> 'Post terakhir',
	'LAST_UPDATED'						=> 'Update terakhir',
	'LAST_VISIT'						=> 'Kunjungan terakhir',
	'LDAP_NO_LDAP_EXTENSION'			=> 'Ekstensi LDAP tidak tersedia.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'Tidak dapat tersambung ke LDAP server.',
	'LEGEND'							=> 'Daftar Grup',
	'LOCATION'							=> 'Lokasi',
	'LOCK_POST'							=> 'Tutup post',
	'LOCK_POST_EXPLAIN'					=> 'Mencegah pengubahan',
	'LOCK_TOPIC'						=> 'Tutup topik',
	'LOGIN'								=> 'Masuk',
	'LOGIN_CHECK_PM'					=> 'Masuk untuk memeriksa pesan pribadi anda.',
	'LOGIN_CONFIRMATION'				=> 'Konfirmasi masuk',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'Untuk mencegah penyerangan account, halaman membutuhkan anda untuk memasukkan kode konfirmasi setelah jumlah kegagalan maksimum untuk masuk tercapai. Kode tersebut ditampilkan dalam gambar sperti yang anda lihat dibawah ini. Jika anda mengalami kesulitan untuk melihat ataupun tidak dapat membaca kode tersebut silahkan menghubungi %sAdministrator%s.',
	'LOGIN_ERROR_ATTEMPTS'				=> 'Anda telah mencapai batas maksimum percobaan untuk bisa masuk. Sebagai tambahan terhadap nama pengguna dan kata sandi anda, anda juga harus memasukkan kode konfirmasi yang anda lihat dibawah ini.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'Anda belum diotentifikasi oleh Apache.',
	'LOGIN_ERROR_PASSWORD'				=> 'Anda telah memasukkan kata sandi yang salah. Silahkan periksa kata sandi anda dan coba lagi. Jika anda masih mengalami masalah silahkan menghubungi %sAdministrator%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'Kata sandi tidak mungkin dikonversikan pada saat mengupdate bulletin board’s software ini. Silahkan %smeminta kata sandi baru%s. Jika anda masih mengalami masalah silahkan hubungi %sAdministrator%s.',
	'LOGIN_ERROR_USERNAME'				=> 'Anda telah memasukan nama pengguna yang salah. Silahkan periksa nama pengguna anda dan coba lagi. Jika anda masih mengalami kesulitan silahkan hubungi %sAdministrator%s.',
	'LOGIN_FORUM'						=> 'Untuk dapat melihat atau mempost di forum ini anda harus memasukkan kata sandinya.',
	'LOGIN_INFO'						=> 'Untuk masuk anda harus didaftarkan terlebih dahulu. Pendaftaran hanya membutuhkan waktu yang singkat, namun memberikan kemampuan yang lebih. Administrator juga dapat memberikan ijin tambahan untuk pengguna yang terdaftar. Sebelum mendaftar anda harus menyetujui syarat-syarat dan kebijakan penggunaan. Silahkan juga membaca peraturan di setiap forum yang anda masuki.',
	'LOGIN_VIEWFORUM'					=> 'Untuk melihat forum ini anda harus didaftarkan dan dimasukkan.',
	'LOGIN_EXPLAIN_EDIT'				=> 'Untuk mengubah post di dalam forum ini anda harus didaftarkan dan dimasukkan.',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'Untuk melihat daftar online anda harus didaftarkan dan dimasukkan.',
	'LOGOUT'							=> 'Keluar',
	'LOGOUT_USER'						=> 'Keluar [ %s ]',
	'LOG_ME_IN'							=> 'Masukkan saya secara otomatis setiap kunjungan',

	'MARK'					=> 'Tandai',
	'MARK_ALL'				=> 'Tandai semua',
	'MARK_FORUMS_READ'		=> 'Tandai forum sudah dibaca',
	'MB'					=> 'MB',
	'MIB'					=> 'MiB',
	'MCP'					=> 'Papan Pengaturan Moderator',
	'MEMBERLIST'			=> 'Daftar Anggota',
	'MEMBERLIST_EXPLAIN'	=> 'Lihat daftar lengkap anggota',
	'MERGE'					=> 'Gabungkan',
	'MERGE_POSTS'			=> 'Gabungkan post',
	'MERGE_TOPIC'			=> 'Gabungkan topik',
	'MESSAGE'				=> 'Pesan',
	'MESSAGES'				=> 'Pesan-pesan',
	'MESSAGE_BODY'			=> 'Isi pesan',
	'MINUTES'				=> 'Menit',
	'MODERATE'				=> 'Moderasi',
	'MODERATOR'				=> 'Moderator',
	'MODERATORS'			=> 'Moderator-moderator',
	'MONTH'					=> 'Bulan',
	'MOVE'					=> 'Pindahkan',
	'MSNM'					=> 'MSNM/WLM',

	'NA'						=> 'Tidak ada',
	'NEWEST_USER'				=> 'Anggota terbaru: <strong>%s</strong>',
	'NEW_MESSAGE'				=> 'Pesan baru',
	'NEW_MESSAGES'				=> 'Pesan-pesan baru',
	'NEW_PM'					=> '<strong>%d</strong> pesan baru',
	'NEW_PMS'					=> '<strong>%d</strong> pesan baru',
	'NEW_POST'					=> 'Post baru',
	'NEW_POSTS'					=> 'Post-post baru',
	'NEXT'						=> 'Berikutnya',		// Used in pagination
	'NEXT_STEP'					=> 'Berikutnya',
	'NEVER'						=> 'Jangan pernah',
	'NO'						=> 'Tidak',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'Anda tidak diijinkan untuk mengatur grup ini.',
	'NOT_AUTHORISED'			=> 'anda tidak berhak mengakses area ini.',
	'NOT_WATCHING_FORUM'		=> 'Anda tidak berlangganan untuk mengupdate forum ini lagi.',
	'NOT_WATCHING_TOPIC'		=> 'Anda tidak berlangganan topik ini lagi.',
	'NOTIFY_ADMIN'				=> 'Silahkan memberitahukan administrator atau webmaster.',
	'NOTIFY_ADMIN_EMAIL'		=> 'Silahkan memeberitahukan administrator atau webmaster: <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'		=> 'Anda tidak diijinkan untuk mengakses file ini.',
	'NO_ACTION'					=> 'Tidak ada tindakan yang ditentukan.',
	'NO_ADMINISTRATORS'			=> 'Tidak ada administrator.',
	'NO_AUTH_ADMIN'				=> 'Akses ke Papan Pengaturan Administrator tidak diijinkan karena anda tidak memiliki ijin administrasi.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'Anda tidak dapat mengotentifikasi ulang sebagai pengguna yang lain.',
	'NO_AUTH_OPERATION'			=> 'Anda tidak memiliki ijin yang dibutuhkan untuk menyelesaikan operasi ini.',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'Tidak dapat menyambungkan ke host smtp : %1$s : %2$s',
	'NO_BIRTHDAYS'				=> 'Tidak ada yang berulang tahun hari ini',
	'NO_EMAIL_MESSAGE'			=> 'Pesan e-mail kosong.',
	'NO_EMAIL_RESPONSE_CODE'	=> 'Tidak bisa mendapatkan kode respon dari server mail.',
	'NO_EMAIL_SUBJECT'			=> 'Tidak ada subjek e-mail yang dimasukkan.',
	'NO_FORUM'					=> 'Forum yang anda pilih tidak ada.',
	'NO_FORUMS'					=> 'Halaman ini tidak memiliki forum.',
	'NO_GROUP'					=> 'Grup pengguna yang diminta tidak ada.',
	'NO_GROUP_MEMBERS'			=> 'Grup ini belum memiliki anggota sekarang.',
	'NO_IPS_DEFINED'			=> 'Tidak ada alamat IP atau nama host yang ditentukan',
	'NO_MEMBERS'				=> 'Tidak ada anggota yang ditemukan untuk kriteria pencarian ini.',
	'NO_MESSAGES'				=> 'Tidak ada pesan',
	'NO_MODE'					=> 'Tidak ada mode yang ditentukan.',
	'NO_MODERATORS'				=> 'Tidak ada moderator.',
	'NO_NEW_MESSAGES'			=> 'Tidak ada pesan baru',
	'NO_NEW_PM'					=> '<strong>0</strong> pesan baru',
	'NO_NEW_POSTS'				=> 'Tidak ada pesan baru',
	'NO_ONLINE_USERS'			=> 'Tidak ada pengguna yang terdaftar',
	'NO_POSTS'					=> 'Tidak ada post',
	'NO_POSTS_TIME_FRAME'		=> 'Tidak ada post yang ada di dalam topik ini untuk batas waktu yang dipilih.',
	'NO_SUBJECT'				=> 'Tidak ada subjek yang dimasukkan',								// Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'		=> 'Pencarian yang dimaksud tidak ada.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'Tidak ada metode otentifikasi yang didukung.',
	'NO_TOPIC'					=> 'Topik yang diminta tidak ada.',
	'NO_TOPIC_FORUM'			=> 'Topik atau forum sudah tidak ada lagi.',
	'NO_TOPICS'					=> 'Tidak ada topik atau post di forum ini.',
	'NO_TOPICS_TIME_FRAME'		=> 'Tidak ada topik di dalam forum ini untuk rentang waktu yang dipilih.',
	'NO_UNREAD_PM'				=> '<strong>0</strong> pesan tak terbaca',
	'NO_UPLOAD_FORM_FOUND'		=> 'Upload dimulai tetapi tidak ada ditemukan bentuk file yang benar.',
	'NO_USER'					=> 'Tidak ada pengguna.',
	'NO_USERS'					=> 'Tidak ada pengguna.',
	'NO_USER_SPECIFIED'			=> 'Tidak ada nama pengguna yang ditentukan.',

	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_POSTS_IN_QUEUE'		=> array(
		0			=> 'Tidak ada post diantrian',		// 0
		1			=> '1 post diantrian',		// 1
		2			=> '%d post diantrian',		// 2+
	),

	'OCCUPATION'				=> 'Pekerjaan',
	'OFFLINE'					=> 'Offline',
	'ONLINE'					=> 'Online',
	'ONLINE_BUDDIES'			=> 'Teman Online',
	'ONLINE_USERS_TOTAL'		=> 'Total <strong>%d</strong> pengguna yang online :: ',
	'ONLINE_USERS_ZERO_TOTAL'	=> 'Total <strong>0</strong> pengguna yang online :: ',
	'ONLINE_USER_TOTAL'			=> 'Total <strong>%d</strong> pengguna yang online :: ',
	'OPTIONS'					=> 'Pilihan',

	'PAGE_OF'				=> 'Halaman <strong>%1$d</strong> dari <strong>%2$d</strong>',
	'PASSWORD'				=> 'Kata sandi',
	'PLAY_QUICKTIME_FILE'	=> 'Mainkan file Quicktime',
	'PM'					=> 'PM',
	'POSTING_MESSAGE'		=> 'Mempost pesan di %s',
	'POSTING_PRIVATE_MESSAGE'	=> 'Membuat pesan pribadi',
	'POST'					=> 'Post',
	'POST_ANNOUNCEMENT'		=> 'Umumkan',
	'POST_STICKY'			=> 'Sticky',
	'POSTED'				=> 'Dipost',
	'POSTED_IN_FORUM'		=> 'dalam',
	'POSTED_ON_DATE'		=> 'pada',
	'POSTS'					=> 'Post',
	'POSTS_UNAPPROVED'		=> 'Setidaknya ada satu post di topik ini yang belum disetujui.',
	'POST_BY_AUTHOR'		=> 'oleh',
	'POST_BY_FOE'			=> 'Post ini dibuat oleh <strong>%1$s</strong> yang ada didalam daftar pengguna tersisih anda. %2$sTampilkan post ini%3$s.',
	'POST_DAY'				=> '%.2f post perhari',
	'POST_DETAILS'			=> 'Keterangan post',
	'POST_NEW_TOPIC'		=> 'Postkan topik baru',
	'POST_PCT'				=> '%.2f%% semua post',
	'POST_PCT_ACTIVE'		=> '%.2f%% dari post pengguna',
	'POST_PCT_ACTIVE_OWN'	=> '%.2f%% dari post anda',
	'POST_REPLY'			=> 'Postkan balasan',
	'POST_REPORTED'			=> 'Klik untuk melihat laporan',
	'POST_SUBJECT'			=> 'Subjek post',
	'POST_TIME'				=> 'Waktu post',
	'POST_TOPIC'			=> 'Postkan topik baru',
	'POST_UNAPPROVED'		=> 'Post ini sedang menunggu persetujuan',
	'PREVIEW'				=> 'Lihat Pratayang',
	'PREVIOUS'				=> 'Sebelumnya',		// Used in pagination
	'PREVIOUS_STEP'			=> 'Sebelumnya',
	'PRIVACY'				=> 'Privasi',
	'PRIVATE_MESSAGE'		=> 'Pesan pribadi',
	'PRIVATE_MESSAGES'		=> 'Pesan-pesan pribadi',
	'PRIVATE_MESSAGING'		=> 'Perpesanan pribadi',
	'PROFILE'				=> 'Papan Pengaturan Pengguna',

	'READING_FORUM'				=> 'Melihat topik di %s',
	'READING_GLOBAL_ANNOUNCE'	=> 'Membaca pengumuman global',
	'READING_LINK'				=> 'Mengikuti link forum %s',
	'READING_TOPIC'				=> 'Membaca topik di %s',
	'READ_PROFILE'				=> 'Profil',
	'REASON'					=> 'Alasan',
	'RECORD_ONLINE_USERS'		=> 'Pengguna terbanyak yang pernah online <strong>%1$s</strong> pada %2$s',
	'REDIRECT'					=> 'Alihkan',
	'REDIRECTS'					=> 'Total pengalihan',
	'REGISTER'					=> 'Daftar',
	'REGISTERED_USERS'			=> 'Pengguna terdaftar:',
	'REG_USERS_ONLINE'			=> 'Ada %d pengguna terdaftar dan ',
	'REG_USERS_TOTAL'			=> '%d terdaftar, ',
	'REG_USERS_TOTAL_AND'		=> '%d terdaftar dan ',
	'REG_USERS_ZERO_ONLINE'		=> 'Ada 0 pengguna terdaftar dan ',
	'REG_USERS_ZERO_TOTAL'		=> '0 terdaftar, ',
	'REG_USERS_ZERO_TOTAL_AND'	=> '0 terdaftar dan ',
	'REG_USER_ONLINE'			=> 'Ada %d pengguna terdaftar dan ',
	'REG_USER_TOTAL'			=> '%d terdaftar, ',
	'REG_USER_TOTAL_AND'		=> '%d terdaftar dan ',
	'REMOVE'					=> 'Singkirkan',
	'REMOVE_INSTALL'			=> 'Silahkan hapus, pindahkan atau beri nama yang lain untuk direktori install sebelum anda menggunakan halaman ini. Jika direktori ini masih ada, hanya Papan Pengaturan Administrator yang bisa diakses.',
	'REPLIES'					=> 'Balasan',
	'REPLY_WITH_QUOTE'			=> 'Balas dengan petikan',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'Membalas ke pengumuman global',
	'REPLYING_MESSAGE'			=> 'Membalas ke pesan di %s',
	'REPORT_BY'					=> 'Dilaporkan oleh',
	'REPORT_POST'				=> 'Laporkan post',
	'REPORTING_POST'			=> 'Melaporkan post',
	'RESEND_ACTIVATION'			=> 'Kirim ulang aktifasi e-mail',
	'RESET'						=> 'Reset',
	'RESTORE_PERMISSIONS'		=> 'Kembalikan ijin',
	'RETURN_INDEX'				=> '%sKembali ke halaman indeks%s',
	'RETURN_FORUM'				=> '%sKembali ke forum yang terakhir dikunjungi%s',
	'RETURN_PAGE'				=> '%sKembali ke halaman sebelumnya%s',
	'RETURN_TOPIC'				=> '%sKembali ke topik yang terakhir dikunjungi%s',
	'RETURN_TO'					=> 'Kembali ke',
	'RULES_ATTACH_CAN'			=> 'Anda <strong>dapat</strong> mempost lampiran di forum ini',
	'RULES_ATTACH_CANNOT'		=> 'Anda <strong>tidak dapat</strong> mempost lampiran di forum ini',
	'RULES_DELETE_CAN'			=> 'Anda <strong>dapat</strong> menghapus post anda di forum ini',
	'RULES_DELETE_CANNOT'		=> 'Anda <strong>tidak dapat</strong> menghapus post anda di forum ini',
	'RULES_DOWNLOAD_CAN'		=> 'Anda <strong>dapat</strong> mendownload lampiran di forum ini',
	'RULES_DOWNLOAD_CANNOT'		=> 'Anda <strong>tidak dapat</strong> mendownload lampiran di forum ini',
	'RULES_EDIT_CAN'			=> 'Anda <strong>dapat</strong> mengubah post anda di forum ini',
	'RULES_EDIT_CANNOT'			=> 'Anda <strong>tidak dapat</strong> mengubah post anda di forum ini',
	'RULES_LOCK_CAN'			=> 'Anda <strong>dapat</strong> mengunci topik anda di forum ini',
	'RULES_LOCK_CANNOT'			=> 'Anda <strong>tidak dapat</strong> mengunci topik anda di forum ini',
	'RULES_POST_CAN'			=> 'Anda <strong>dapat</strong> membuat topik baru di forum ini',
	'RULES_POST_CANNOT'			=> 'Anda <strong>tidak dapat</strong> membuat topik baru di forum ini',
	'RULES_REPLY_CAN'			=> 'Anda <strong>dapat</strong> membalas topik di forum ini',
	'RULES_REPLY_CANNOT'		=> 'Anda <strong>tidak dapat</strong> membalas topik di forum ini',
	'RULES_VOTE_CAN'			=> 'Anda <strong>dapat</strong> memberikan suara di forum ini',
	'RULES_VOTE_CANNOT'			=> 'Anda <strong>tidak dapat</strong> memberikan suara di forum ini',

	'SEARCH'					=> 'Cari',
	'SEARCH_MINI'				=> 'Cari…',
	'SEARCH_ADV'				=> 'Pencarian lanjutan',
	'SEARCH_ADV_EXPLAIN'		=> 'Lihat pilihan pencarian lanjutan',
	'SEARCH_KEYWORDS'			=> 'Cari untuk kata kunci',
	'SEARCHING_FORUMS'			=> 'Pencarian forum',
	'SEARCH_ACTIVE_TOPICS'		=> 'Lihat topik yang aktif',
	'SEARCH_FOR'				=> 'Cari',
	'SEARCH_FORUM'				=> 'Cari forum ini…',
	'SEARCH_NEW'				=> 'Lihat post baru',
	'SEARCH_POSTS_BY'			=> 'Cari post dengan',
	'SEARCH_SELF'				=> 'Lihat post anda',
	'SEARCH_TOPIC'				=> 'Cari topik ini…',
	'SEARCH_UNANSWERED'			=> 'Lihat post yang belum terjawab',
	'SECONDS'					=> 'Detik',
	'SELECT'					=> 'Pilih',
	'SELECT_ALL_CODE'			=> 'Pilih semua',
	'SELECT_DESTINATION_FORUM'	=> 'Silahkan pilih forum tujuan',
	'SELECT_FORUM'				=> 'Pilih forum',
	'SEND_EMAIL'				=> 'E-mail',				// Used for submit buttons
	'SEND_EMAIL_USER'			=> 'E-mail',				// Used as: {L_SEND_EMAIL_USER} {USERNAME} -> E-mail UserX
	'SEND_PRIVATE_MESSAGE'		=> 'Kirim pesan pribadi',
	'SETTINGS'					=> 'Pengaturan',
	'SIGNATURE'					=> 'Tanda tangan',
	'SKIP'						=> 'Lompat ke isi',
	'SMTP_NO_AUTH_SUPPORT'		=> 'Server SMTP tidak mendukung otentifikasi.',
	'SORRY_AUTH_READ'			=> 'Anda tidak berhak membaca di forum ini.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'anda tidak berhak mendownload lampiran.',
	'SORT_BY'					=> 'Urutkan sesuai',
	'SORT_JOINED'				=> 'Tanggal bergabung',
	'SORT_LOCATION'				=> 'Lokasi',
	'SORT_RANK'					=> 'Ranking',
	'SORT_TOPIC_TITLE'			=> 'Judul topik',
	'SORT_USERNAME'				=> 'Nama pengguna',
	'SPLIT_TOPIC'				=> 'Pisahkan topik',
	'SQL_ERROR_OCCURRED'		=> 'SQL error terjadi pada saat mem-fetching halaman ini. Silahkan hubungi %sAdministrator%s jika masalah ini tetap ada.',
	'STATISTICS'				=> 'Statistik',
	'START_WATCHING_FORUM'		=> 'Langganan forum',
	'START_WATCHING_TOPIC'		=> 'Langganan topik',
	'STOP_WATCHING_FORUM'		=> 'Berhenti langganan forum',
	'STOP_WATCHING_TOPIC'		=> 'Berhenti langganan topik',
	'SUBFORUM'					=> 'Subforum',
	'SUBFORUMS'					=> 'Subforum',
	'SUBJECT'					=> 'Subjek',
	'SUBMIT'					=> 'Ajukan',

	'TERMS_USE'			=> 'Syarat Penggunaan',
	'TEST_CONNECTION'	=> 'Coba koneksi',
	'THE_TEAM'			=> 'Team',
	'TIME'				=> 'Waktu',

	'TOO_LONG'						=> 'Nilai yang anda masukkan terlalu panjang.',

	'TOO_LONG_AIM'					=> 'Nama tampilan yang anda masukkan terlalu panjang.',
	'TOO_LONG_CONFIRM_CODE'			=> 'Kode konfirmasi yang anda masukkan terlalu panjang.',
	'TOO_LONG_DATEFORMAT'			=> 'Format tanggal yang anda masukkan terlalu panjang.',
	'TOO_LONG_ICQ'					=> 'Nomor ICQ yang anda masukkan terlalu panjang.',
	'TOO_LONG_INTERESTS'			=> 'Minat-minat yang anda masukkan terlalu panjang.',
	'TOO_LONG_JABBER'				=> 'Nama account Jabber yang anda masukkan terlalu panjang.',
	'TOO_LONG_LOCATION'				=> 'Lokasi yang anda masukkan terlalu panjang.',
	'TOO_LONG_MSN'					=> 'Nama MSNM/WLM yang anda masukkan terlalu panjang.',
	'TOO_LONG_NEW_PASSWORD'			=> 'Kata sandi yang anda masukkan terlalu panjang.',
	'TOO_LONG_OCCUPATION'			=> 'Pekerjaan yang anda masukkan terlalu panjang.',
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'Kata sandi konfirmasi yang anda masukkan terlalu panjang.',
	'TOO_LONG_USER_PASSWORD'		=> 'Kata sandi yang anda masukkan terlalu panjang.',
	'TOO_LONG_USERNAME'				=> 'Nama pengguna yang anda masukkan terlalu panjang.',
	'TOO_LONG_EMAIL'				=> 'Alamat e-mail yang anda masukkan terlalu panjang.',
	'TOO_LONG_EMAIL_CONFIRM'		=> 'Alamat e-mail konfirmasi yang anda masukkan terlalu panjang.',
	'TOO_LONG_WEBSITE'				=> 'Alamat website yang anda masukkan terlalu panjang.',
	'TOO_LONG_YIM'					=> 'Nama The Yahoo! Messenger yang anda masukkan terlalu panjang.',

	'TOO_MANY_VOTE_OPTIONS'			=> 'Anda mencoba memberikan pilihan suara terlalu banyak.',

	'TOO_SHORT'						=> 'Nilai yang anda masukkan terlalu pendek.',

	'TOO_SHORT_AIM'					=> 'Nama tampilan yang anda masukkan terlalu pendek.',
	'TOO_SHORT_CONFIRM_CODE'		=> 'Kode konfirmasi yang anda masukkan terlalu pendek.',
	'TOO_SHORT_DATEFORMAT'			=> 'Format tanggal yang anda masukkan terlalu pendek.',
	'TOO_SHORT_ICQ'					=> 'Nomor ICQ yang anda masukkan terlalu pendek.',
	'TOO_SHORT_INTERESTS'			=> 'Minat-minat yang anda masukkan terlalu pendek.',
	'TOO_SHORT_JABBER'				=> 'Nama account Jabber yang anda masukkan terlalu pendek.',
	'TOO_SHORT_LOCATION'			=> 'Lokasi yang anda masukkan terlalu pendek.',
	'TOO_SHORT_MSN'					=> 'Nama MSNM/WLM yang anda masukkan terlalu pendek.',
	'TOO_SHORT_NEW_PASSWORD'		=> 'Kata sandi yang anda masukkan terlalu pendek.',
	'TOO_SHORT_OCCUPATION'			=> 'Pekerjaan yang anda masukkan terlalu pendek.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'Konfirmasi kata sandi yang anda masukkan terlalu pendek.',
	'TOO_SHORT_USER_PASSWORD'		=> 'Kata sandi yang anda masukkan terlalu pendek.',
	'TOO_SHORT_USERNAME'			=> 'Nama pengguna yang anda masukkan terlalu pendek.',
	'TOO_SHORT_EMAIL'				=> 'Alamat e-mail yang anda masukkan terlalu pendek.',
	'TOO_SHORT_EMAIL_CONFIRM'		=> 'Konfirmasi alamat e-mail yang anda masukkan terlalu pendek.',
	'TOO_SHORT_WEBSITE'				=> 'Website yang anda masukkan terlalu pendek.',
	'TOO_SHORT_YIM'					=> 'Nama Yahoo! Messenger yang anda masukkan terlalu pendek.',

	'TOPIC'				=> 'Topik',
	'TOPICS'			=> 'Topik',
	'TOPIC_ICON'		=> 'Ikon topik',
	'TOPIC_LOCKED'		=> 'Topik ini dikunci, anda tidak dapat megubah post atau membuat balasan.',
	'TOPIC_LOCKED_SHORT'=> 'Topik dikunci',
	'TOPIC_MOVED'		=> 'Topik dipindahkan',
	'TOPIC_REVIEW'		=> 'Tinjauan Topik',
	'TOPIC_TITLE'		=> 'Judul Topik',
	'TOPIC_UNAPPROVED'	=> 'Topik ini belum disetujui',
	'TOTAL_ATTACHMENTS'	=> 'Lampiran',
	'TOTAL_LOG'			=> '1 log',
	'TOTAL_LOGS'		=> '%d log',
	'TOTAL_NO_PM'		=> 'Total 0 pesan pribadi',
	'TOTAL_PM'			=> 'Total 1 pesan pribadi',
	'TOTAL_PMS'			=> 'Total %d pesan pribadi',
	'TOTAL_POSTS'		=> 'Total post',
	'TOTAL_POSTS_OTHER'	=> 'Total post <strong>%d</strong>',
	'TOTAL_POSTS_ZERO'	=> 'Total post <strong>0</strong>',
	'TOPIC_REPORTED'	=> 'Topik ini telah diberitakan',
	'TOTAL_TOPICS_OTHER'=> 'Total topik <strong>%d</strong>',
	'TOTAL_TOPICS_ZERO'	=> 'Total topik <strong>0</strong>',
	'TOTAL_USERS_OTHER'	=> 'Total anggota <strong>%d</strong>',
	'TOTAL_USERS_ZERO'	=> 'Total anggota <strong>0</strong>',
	'TRACKED_PHP_ERROR'	=> 'Jejak error PHP: %s',

	'UNABLE_GET_IMAGE_SIZE'	=> 'Tidak bisa mendapatkan ukuran gambar.',
	'UNABLE_TO_DELIVER_FILE'=> 'Tidak bisa mengirimkan file.',
	'UNKNOWN_BROWSER'		=> 'Browser tidak dikenali',
	'UNMARK_ALL'			=> 'Hapus semua tanda',
	'UNREAD_MESSAGES'		=> 'Pesan tak terbaca',
	'UNREAD_PM'				=> '<strong>%d</strong> pesan tak terbaca',
	'UNREAD_PMS'			=> '<strong>%d</strong> pesan tak terbaca',
	'UNWATCHED_FORUMS'			=> 'Anda tidak dapat berlangganan lagi untuk forum yang dipilih.',
	'UNWATCHED_TOPICS'			=> 'Anda tidak dapat berlangganan lagi untuk topik yang dipilih.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'Anda tidak dapat berlangganan lagi untuk catatan yang dipilih.',
	'UPDATE'				=> 'Update',
	'UPLOAD_IN_PROGRESS'	=> 'Upload sedang dalam proses.',
	'URL_REDIRECT'			=> 'Jika browser anda tidak mendukung meta redirection %ssilahkan klik DI SINI untuk dialihkan%s.',
	'USERGROUPS'			=> 'Grup',
	'USERNAME'				=> 'Nama pengguna',
	'USERNAMES'				=> 'Nama-nama pengguna',
	'USER_AVATAR'			=> 'Avatar pengguna',
	'USER_CANNOT_READ'		=> 'Anda tidak dapat membaca post di forum ini.',
	'USER_POST'				=> '%d Post',
	'USER_POSTS'			=> '%d Post',
	'USERS'					=> 'Pengguna',
	'USE_PERMISSIONS'		=> 'Coba ijin pengguna',

	'VARIANT_DATE_SEPARATOR'	=> ' / ',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'Dilihat',

	//-- mod : AJAX Chat ----------------------------------------------------
	//-- add
	'VIEWING_CHAT'            => 'Melihat Chat & Teriakkan',
	//-- fin mod : AJAX Chat ------------------------------------------------

	'VIEWING_FAQ'				=> 'Melihat Bantuan',
	'VIEWING_MEMBERS'			=> 'Melihat keterangan anggota',
	'VIEWING_ONLINE'			=> 'Melihat siapa yang online',
	'VIEWING_MCP'				=> 'Melihat papan pengaturan moderator',
	'VIEWING_MEMBER_PROFILE'	=> 'Melihat profil anggota',
	'VIEWING_PRIVATE_MESSAGES'	=> 'Melihat pesan pribadi',
	'VIEWING_REGISTER'			=> 'Mendaftarkan account',
	'VIEWING_UCP'				=> 'Melihat papan pengaturan pengguna',
	'VIEWS'						=> 'Dilihat',
	'VIEW_BOOKMARKS'			=> 'Lihat penanda halaman',
	'VIEW_FORUM_LOGS'			=> 'Lihat daftar log',
	'VIEW_LATEST_POST'			=> 'Lihat pesan terbaru',
	'VIEW_NEWEST_POST'			=> 'Lihat post yang belum dibaca',
	'VIEW_NOTES'				=> 'Lihat catatan pengguna',
	'VIEW_ONLINE_TIME'			=> 'didasarkan pada pengguna yang aktif selama %d menit terakhir',
	'VIEW_ONLINE_TIMES'			=> 'didasarkan pada pengguna yang aktif selama %d menit terakhir',
	'VIEW_TOPIC'				=> 'Melihat topik',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'Pengumuman: ',
	'VIEW_TOPIC_GLOBAL'			=> 'Pengumuman Global: ',
	'VIEW_TOPIC_LOCKED'			=> 'Dikunci: ',
	'VIEW_TOPIC_LOGS'			=> 'Lihat log topik',
	'VIEW_TOPIC_MOVED'			=> 'Dipindahkan: ',
	'VIEW_TOPIC_POLL'			=> 'Poll: ',
	'VIEW_TOPIC_STICKY'			=> 'Sticky: ',
	'VISIT_WEBSITE'				=> 'Mengunjungi website',

	'WARNINGS'			=> 'Peringatan',
	'WARN_USER'			=> 'Peringati pengguna',
	'WELCOME_SUBJECT'	=> 'Selamat datang di forum %s',
	'WEBSITE'			=> 'Website',
	'WHOIS'				=> 'Whois',
	'WHO_IS_ONLINE'		=> 'Siapa yang online',
	'WRONG_PASSWORD'	=> 'Anda memasukkan kata sandi yang salah.',

	'WRONG_DATA_ICQ'			=> 'Nomor ICQ yang anda masukkan salah.',
	'WRONG_DATA_JABBER'			=> 'Nama yang anda masukkan bukan nama account jabber yang benar.',
	'WRONG_DATA_LANG'			=> 'Bahasa yang anda tentukan tidak benar.',
	'WRONG_DATA_WEBSITE'		=> 'Alamat situs web harus merupakan URL yang benar, termasuk protokol. Sebagai contoh http://www.example.com/.',
	'WROTE'						=> 'menulis',

	'YEAR'				=> 'Tahun',
	'YEAR_MONTH_DAY'	=> '(TTTT-BB-HH)',
	'YES'				=> 'Ya',
	'YIM'				=> 'YIM',
	'YOU_LAST_VISIT'	=> 'Kunjungan terakhir pada: %s',
	'YOU_NEW_PM'		=> 'Sebuah pesan pribadi yang baru sudah ada di kotak masuk anda.',
	'YOU_NEW_PMS'		=> 'Sebuah pesan-pesan pribadi yang baru sudah ada di kotak masuk anda.',
	'YOU_NO_NEW_PM'		=> 'Tidak ada pesan pribadi yang baru.',

	'datetime'			=> array(
		'TODAY'		=> 'Hari ini',
		'TOMORROW'	=> 'Besok',
		'YESTERDAY'	=> 'Kemarin',

		'Sunday'	=> 'Minggu',
		'Monday'	=> 'Senin',
		'Tuesday'	=> 'Selasa',
		'Wednesday'	=> 'Rabu',
		'Thursday'	=> 'Kamis',
		'Friday'	=> 'Jumat',
		'Saturday'	=> 'Sabtu',

		'Sun'		=> 'Minggu',
		'Mon'		=> 'Senin',
		'Tue'		=> 'Selasa',
		'Wed'		=> 'Rabu',
		'Thu'		=> 'Kamis',
		'Fri'		=> 'Jumat',
		'Sat'		=> 'Sabtu',

		'January'	=> 'Januari',
		'February'	=> 'Februari',
		'March'		=> 'Maret',
		'April'		=> 'April',
		'May'		=> 'Mei',
		'June'		=> 'Juni',
		'July'		=> 'Juli',
		'August'	=> 'Agustus',
		'September' => 'September',
		'October'	=> 'Oktober',
		'November'	=> 'November',
		'December'	=> 'Desember',

		'Jan'		=> 'Jan',
		'Feb'		=> 'Feb',
		'Mar'		=> 'Mar',
		'Apr'		=> 'Apr',
		'May_short'	=> 'Mei',	// Short representation of "May". May_short used because in English the short and long date are the same for May.
		'Jun'		=> 'Jun',
		'Jul'		=> 'Jul',
		'Aug'		=> 'Agt',
		'Sep'		=> 'Sep',
		'Oct'		=> 'Okt',
		'Nov'		=> 'Nov',
		'Dec'		=> 'Des',
	),

	'tz'				=> array(
		'-12'	=> 'UTC - 12 jam',
		'-11'	=> 'UTC - 11 jam',
		'-10'	=> 'UTC - 10 jam',
		'-9.5'	=> 'UTC - 9:30 jam',
		'-9'	=> 'UTC - 9 jam',
		'-8'	=> 'UTC - 8 jam',
		'-7'	=> 'UTC - 7 jam',
		'-6'	=> 'UTC - 6 jam',
		'-5'	=> 'UTC - 5 jam',
		'-4.5'	=> 'UTC - 4:30 jam',
		'-4'	=> 'UTC - 4 jam',
		'-3.5'	=> 'UTC - 3:30 jam',
		'-3'	=> 'UTC - 3 jam',
		'-2'	=> 'UTC - 2 jam',
		'-1'	=> 'UTC - 1 jam',
		'0'		=> 'UTC',
		'1'		=> 'UTC + 1 jam',
		'2'		=> 'UTC + 2 jam',
		'3'		=> 'UTC + 3 jam',
		'3.5'	=> 'UTC + 3:30 jam',
		'4'		=> 'UTC + 4 jam',
		'4.5'	=> 'UTC + 4:30 jam',
		'5'		=> 'UTC + 5 jam',
		'5.5'	=> 'UTC + 5:30 jam',
		'5.75'	=> 'UTC + 5:45 jam',
		'6'		=> 'UTC + 6 jam',
		'6.5'	=> 'UTC + 6:30 jam',
		'7'		=> 'UTC + 7 jam',
		'8'		=> 'UTC + 8 jam',
		'8.75'	=> 'UTC + 8:45 jam',
		'9'		=> 'UTC + 9 jam',
		'9.5'	=> 'UTC + 9:30 jam',
		'10'	=> 'UTC + 10 jam',
		'10.5'	=> 'UTC + 10:30 jam',
		'11'	=> 'UTC + 11 jam',
		'11.5'	=> 'UTC + 11:30 jam',
		'12'	=> 'UTC + 12 jam',
		'12.75'	=> 'UTC + 12:45 jam',
		'13'	=> 'UTC + 13 jam',
		'14'	=> 'UTC + 14 jam',
		'dst'	=> '[ <abbr title="Daylight Saving Time">DST</abbr> ]',
	),

	'tz_zones'	=> array(
		'-12'	=> '[UTC - 12] Baker Island Time',
		'-11'	=> '[UTC - 11] Niue Time, Samoa Standard Time',
		'-10'	=> '[UTC - 10] Hawaii-Aleutian Standard Time, Cook Island Time',
		'-9.5'	=> '[UTC - 9:30] Marquesas Islands Time',
		'-9'	=> '[UTC - 9] Alaska Standard Time, Gambier Island Time',
		'-8'	=> '[UTC - 8] Pacific Standard Time',
		'-7'	=> '[UTC - 7] Mountain Standard Time',
		'-6'	=> '[UTC - 6] Central Standard Time',
		'-5'	=> '[UTC - 5] Eastern Standard Time',
		'-4.5'	=> '[UTC - 4:30] Venezuelan Standard Time',
		'-4'	=> '[UTC - 4] Atlantic Standard Time',
		'-3.5'	=> '[UTC - 3:30] Newfoundland Standard Time',
		'-3'	=> '[UTC - 3] Amazon Standard Time, Central Greenland Time',
		'-2'	=> '[UTC - 2] Fernando de Noronha Time, South Georgia &amp; the South Sandwich Islands Time',
		'-1'	=> '[UTC - 1] Azores Standard Time, Cape Verde Time, Eastern Greenland Time',
		'0'		=> '[UTC] Western European Time, Greenwich Mean Time',
		'1'		=> '[UTC + 1] Central European Time, West African Time',
		'2'		=> '[UTC + 2] Eastern European Time, Central African Time',
		'3'		=> '[UTC + 3] Moscow Standard Time, Eastern African Time',
		'3.5'	=> '[UTC + 3:30] Iran Standard Time',
		'4'		=> '[UTC + 4] Gulf Standard Time, Samara Standard Time',
		'4.5'	=> '[UTC + 4:30] Afghanistan Time',
		'5'		=> '[UTC + 5] Pakistan Standard Time, Yekaterinburg Standard Time',
		'5.5'	=> '[UTC + 5:30] Indian Standard Time, Sri Lanka Time',
		'5.75'	=> '[UTC + 5:45] Nepal Time',
		'6'		=> '[UTC + 6] Bangladesh Time, Bhutan Time, Novosibirsk Standard Time',
		'6.5'	=> '[UTC + 6:30] Cocos Islands Time, Myanmar Time',
		'7'		=> '[UTC + 7] Indochina Time, Krasnoyarsk Standard Time',
		'8'		=> '[UTC + 8] Chinese Standard Time, Australian Western Standard Time, Irkutsk Standard Time',
		'8.75'	=> '[UTC + 8:45] Southeastern Western Australia Standard Time',
		'9'		=> '[UTC + 9] Japan Standard Time, Korea Standard Time, Chita Standard Time',
		'9.5'	=> '[UTC + 9:30] Australian Central Standard Time',
		'10'	=> '[UTC + 10] Australian Eastern Standard Time, Vladivostok Standard Time',
		'10.5'	=> '[UTC + 10:30] Lord Howe Standard Time',
		'11'	=> '[UTC + 11] Solomon Island Time, Magadan Standard Time',
		'11.5'	=> '[UTC + 11:30] Norfolk Island Time',
		'12'	=> '[UTC + 12] New Zealand Time, Fiji Time, Kamchatka Standard Time',
		'12.75'	=> '[UTC + 12:45] Chatham Islands Time',
		'13'	=> '[UTC + 13] Tonga Time, Phoenix Islands Time',
		'14'	=> '[UTC + 14] Line Island Time',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'd M Y, H:i'			=> '01 Jan 2007, 13:37',
		'd M Y H:i'				=> '01 Jan 2007 13:37',
		'M jS, \'y, H:i'		=> 'Jan 1st, \'07, 13:37',
		'D M d, Y g:i a'		=> 'Mon Jan 01, 2007 1:37 pm',
		'F jS, Y, g:i a'		=> 'January 1st, 2007, 1:37 pm',
		'|d M Y|, H:i'			=> 'Today, 13:37 / 01 Jan 2007, 13:37',
		'|F jS, Y|, g:i a'		=> 'Today, 1:37 pm / January 1st, 2007, 1:37 pm'
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=> 'D M d, Y g:i a', // Mon Jan 01, 2007 1:37 pm

));

?>