<?php
/**
*
* common [Farsi]
*
* @package language
* @version $Id$
* @copyright (c) 2005 phpBB Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » “ ” …
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> '<a href="http://maghsad.com/">Persian Translation</a>',
	'DIRECTION'			=> 'rtl',
	'DATE_FORMAT'		=> '|d M Y|',	// 01 Jan 2007 (with Relative days enabled)
	'USER_LANG'			=> 'fa',

	'1_DAY'			=> '1 روز',
	'1_MONTH'		=> '1 ماه',
	'1_YEAR'		=> '1 سال',
	'2_WEEKS'		=> '2 هفته',
	'3_MONTHS'		=> '3 ماه',
	'6_MONTHS'		=> '6 ماه',
	'7_DAYS'		=> '7 روز',

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'اکانت شما قبلا فعال گرديده است .',
	'ACCOUNT_DEACTIVATED'			=> 'اکانت شما بصورت دستي غيرفعال شده است ، توانايي فعال کردن اکانت را فقط مدير سايت دارد.',
	'ACCOUNT_NOT_ACTIVATED'			=> 'اکانت شما فعال نيست .',
	'ACP'							=> 'مرکز مديريت',
	'ACTIVE'						=> 'فعال',
	'ACTIVE_ERROR'					=> 'نام کاربري تعيين شده در حال حاضر غيرفعال است. در صورتي که مشکلي در فعال کردن حساب کاربري خود داريد, با مديريت سايت تماس بگيريد.',
	'ADMINISTRATOR'					=> 'مدير سايت',
	'ADMINISTRATORS'				=> 'مديران سايت',
	'AGE'							=> 'سن',
	'AIM'							=> 'AIM',
	'ALLOWED'						=> 'Allowed',
	'ALL_FILES'						=> 'همه فايل ها',
	'ALL_FORUMS'					=> 'همه انجمن ها',
	'ALL_MESSAGES'					=> 'همه پيغام ها',
	'ALL_POSTS'						=> 'همه پست ها',
    'ALL_TIMES'            => 'ساعت سایت بر اساس%1$s %2$s تنظیم شده است',
	'ALL_TOPICS'					=> 'همه مبحث ها',
	'AND'							=> 'و',
	'ARE_WATCHING_FORUM'			=> 'شما در اين انجمن مشترک شديد ، در صورت ارسال مبحث هاي جديد باخبر خواهيد شد.',
	'ARE_WATCHING_TOPIC'			=> 'شما در اين مبحث مشترک شديد ، در صورت ارسال پست هاي جديد باخبر خواهيد شد.',
	'ASCENDING'						=> 'صعودي',
	'ATTACHMENTS'					=> 'پيوست ها',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'تصوير مانده شده براي پيوست بي اعتبار است',
	'AUTHOR'						=> 'نويسنده',
	'AUTH_NO_PROFILE_CREATED'		=> 'ايجاد مشخصات کاربري ناموفق بود.',
	'AVATAR_DISALLOWED_CONTENT'		=> 'آپلود به دليل مسائل امنيتي تاييد نشد. تصوير شما نبايد vector باشد.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'فايل قابليت نمايش ندارد براي اينکه پسوند <strong>%s</strong> اجازه نمي دهد',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'The specified avatar could not be uploaded because the remote data appears to be invalid or corrupted.',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'فايل آواتار آپلود شده خالي مي باشد.',
	'AVATAR_INVALID_FILENAME'		=> '%s نام فايلي بي اعتبار است.',
	'AVATAR_NOT_UPLOADED'			=> 'نماد آپلود نشد .',
	'AVATAR_NO_SIZE'				=> 'طول و عرض آواتار نعيين نمي شود. لطفا آن را بصورت دستي تعيين کنيد.',
	'AVATAR_PARTIAL_UPLOAD'			=> 'The specified file was only partially uploaded.',
	'AVATAR_PHP_SIZE_NA'			=> 'حجم فايل آواتار زياد است.<br />The maximum allowed filesize set in php.ini could not be determined.',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'حجم فايل آواتار زياد است. حد اکثر حجم مجاز  %1$d %2$sمي باشد.<br />این تنظیمات در php.ini اعمال شده و قابل تغییر نیست.',
	'AVATAR_URL_INVALID'			=> 'آدرس تعيين شده به اعتبار مي باشد.',
	'AVATAR_URL_NOT_FOUND'			=> 'فايل تعيين شده پيدا نشد.',
	'AVATAR_WRONG_FILESIZE'			=> 'حجم فايل آواتار بايد بين 0 و %1d %2 باشد.',
	'AVATAR_WRONG_SIZE'				=> 'The submitted avatar is %5$d pixels wide and %6$d pixels high. Avatars must be at least %1$d pixels wide and %2$d pixels high, but no larger than %3$d pixels wide and %4$d pixels high.',

	'BACK_TO_TOP'			=> 'بالا',
	'BACK_TO_PREV'			=> 'بازگشت به صفحه قبلي',
	'BAN_TRIGGERED_BY_EMAIL'=> 'A ban has been issued on your e-mail address.',
	'BAN_TRIGGERED_BY_IP'	=> 'A ban has been issued on your IP address.',
	'BAN_TRIGGERED_BY_USER'	=> 'A ban has been issued on your username.',
	'BBCODE_GUIDE'			=> 'BBCode guide',
	'BCC'					=> 'BCC',
	'BIRTHDAYS'				=> 'متولدين امروز',
	'BOARD_BAN_PERM'		=> 'You have been <strong>permanently</strong> banned from this board.<br /><br />Please contact the %2$sBoard Administrator%3$s for more information.',
	'BOARD_BAN_REASON'		=> 'Reason given for ban: <strong>%s</strong>',
	'BOARD_BAN_TIME'		=> 'You have been banned from this board until <strong>%1$s</strong>.<br /><br />Please contact the %2$sBoard Administrator%3$s for more information.',
	'BOARD_DISABLE'			=> 'اين انجمن در حال حاضر غير فعال است',
	'BOARD_DISABLED'		=> 'اين انجمن در حال حاضر غير فعال شده است.',
	'BOARD_UNAVAILABLE'		=> 'اين انجمن موقتا غير فعال شده است.لطفا چند لحظه ديگر تلاش كنيد.',
	'BROWSING_FORUM'		=> 'کاربران حاضر : %1$s',
	'BROWSING_FORUM_GUEST'	=> 'کاربران حاضر در اين انجمن: %1$s و %2$d مهمان',
	'BROWSING_FORUM_GUESTS'	=> 'کاربران حاضر در اين انجمن: %1$s و %2$d مهمان',
	'BYTES'					=> 'بايت',

	'CANCEL'				=> 'لغو',
	'CHANGE'				=> 'ويرايش',
	'CHANGE_FONT_SIZE'		=> 'ويرايش اندازه فونت ها',
	'CHANGING_PREFERENCES'	=> 'ويرايش پيکربندي انجمن',
	'CHANGING_PROFILE'		=> 'ويرايش تنظيمات مشخصات',
	'CLICK_VIEW_PRIVMSG'	=> '%sرفتن به اينباکس شما%s',
	'COLLAPSE_VIEW'			=> 'Collapse view',
	'CLOSE_WINDOW'			=> 'بستن پنجره',
	'COLOUR_SWATCH'			=> 'Colour swatch',
	'COMMA_SEPARATOR'		=> ', ',	// Used in pagination of ACP & prosilver, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'تاييد',
	'CONFIRM_CODE'			=> 'کد تصديق',
    'CONFIRM_CODE_EXPLAIN'	=> 'کد ظاهر شده را با رعایت کوچک و بزرگی عینا وارد کنید.',
	'CONFIRM_CODE_WRONG'	=> 'کد تاييد وارد شده اشتباه مي باشد.',
	'CONFIRM_OPERATION'		=> 'آیا از انجام این کار مطمئنید ؟',
	'CONGRATULATIONS'		=> 'تبريک مي گوييم به',
	'CONNECTION_FAILED'		=> 'اتصال انجام نشد.',
	'CONNECTION_SUCCESS'	=> 'اتصال با موفقيت انجام شد!',
	'COOKIES_DELETED'		=> 'کوکي هاي همه بوردها با موفقيت حذف شدند.',
	'CURRENT_TIME'			=> 'امروز %s',

	'DAY'					=> 'روز',
	'DAYS'					=> 'روز',
	'DELETE'				=> 'حذف',
	'DELETE_ALL'			=> 'حذف همه',
	'DELETE_COOKIES'		=> 'حذف كوكي هاي انجمن و خروج',
	'DELETE_MARKED'			=> 'حذف نشاته گذاري شده ها',
	'DELETE_POST'			=> 'حذف پست',
	'DELIMITER'				=> 'Delimiter',
	'DESCENDING'			=> 'نزولي',
	'DISABLED'				=> 'غيرفعال شده است',
	'DISPLAY'				=> 'نمايش',
	'DISPLAY_GUESTS'		=> 'نمايش مهمان ها',
	'DISPLAY_MESSAGES'		=> 'نمايش پيغام ها از آخرين',
	'DISPLAY_POSTS'			=> 'نمايش پست ها از پيشين',
	'DISPLAY_TOPICS'		=> 'نمايش مبحث هاي از پيشين',
	'DOWNLOADED'			=> 'دانلود شده',
	'DOWNLOADING_FILE'		=> 'درحال دريافت فايل',
	'DOWNLOAD_COUNT'		=> 'دانلود %d بار',
	'DOWNLOAD_COUNTS'		=> 'دانلود %d بار',
	'DOWNLOAD_COUNT_NONE'	=> 'هيچ دانلودي صورت نگرفته است',
	'VIEWED_COUNT'			=> 'بازديد %d بار',
	'VIEWED_COUNTS'			=> 'بازديد %d بار',
	'VIEWED_COUNT_NONE'		=> 'تاکنون هيچ بازديدي نشده است',

	'EDIT_POST'							=> 'ويرايش پست',
	'EMAIL'								=> 'E-mail', // Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'آدرس ايميل',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'Ran into problems sending e-mail at <strong>Line %1$s</strong>. Response: %2$s.',
	'EMPTY_SUBJECT'						=> 'شما بايد بهنگام ارسال مبحث جديد يک عنوان براي آن انتخاب کنيد.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'You must specify a subject when composing a new message.',
	'ENABLED'							=> 'فعال شده',
	'ENCLOSURE'							=> 'Enclosure',
	'ENTER_USERNAME'					=> 'نام کاربری را وارد کنید',
	'ERR_CHANGING_DIRECTORY'			=> 'Unable to change directory.',
	'ERR_CONNECTING_SERVER'				=> 'Error connecting to the server.',
	'ERR_JAB_AUTH'						=> 'Could not authorise on Jabber server.',
	'ERR_JAB_CONNECT'					=> 'Could not connect to Jabber server.',
	'ERR_UNABLE_TO_LOGIN'				=> 'The specified username or password is incorrect.',
	'ERR_UNWATCHING'					=> 'An error occured while trying to unsubscribe.',
	'ERR_WATCHING'						=> 'An error occured while trying to subscribe.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'The phpBB path specified appears to be invalid.',
	'EXPAND_VIEW'						=> 'Expand view',
	'EXTENSION'							=> 'Extension',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'توسعه <strong>%s</strong> غیر فعال شده و دیگر نمی توان آن را ادامه داد',

	'FAQ'					=> 'پرسش و پاسخ',
	'FAQ_EXPLAIN'			=> 'سوالات مکرر',
	'FILENAME'				=> 'نام فايل',
	'FILESIZE'				=> 'حجم فايل',
	'FILEDATE'				=> 'تاريخ فايل',
	'FILE_COMMENT'			=> 'توضيحات فايل',
	'FILE_NOT_FOUND'		=> 'فايل درخواست شده يافت نشد.',
	'FIND_USERNAME'			=> 'جستجوي يک کاربر',
	'FOLDER'				=> 'پوشه',
	'FORGOT_PASS'			=> 'من کلمه عبورم را فراموش کرده ام !',
	'FORM_INVALID'			=> 'فرم ارسال نامعتبر بود. لطفا مجددا روی دکمه ارسال کلیک کنید تا مطلب ارسال شود.',
	'FORUM'					=> 'انجمن',
	'FORUMS'				=> 'انجمن ها',
	'FORUMS_MARKED'			=> 'انجمن های انتخابی به عنوان خوانده شده علامت زده شدند.',
	'FORUM_CAT'				=> 'شاخه انجمن',
	'FORUM_INDEX'			=> 'صفحه اول',
	'FORUM_LINK'			=> 'لينك انجمن',
	'FORUM_LOCATION'		=> 'انجمن ساکن',
	'FORUM_LOCKED'			=> 'انجمن بسته است',
	'FORUM_RULES'			=> 'قوانين انجمن',
	'FORUM_RULES_LINK'		=> 'لطفا براي مشاهده قوانين انجمن اينجارا کليک کنيد',
	'FROM'					=> 'از',
	'FSOCK_DISABLED'		=> 'The operation could not be completed because the <var>fsockopen</var> function has been disabled or the server being queried could not be found.',
			'FSOCK_TIMEOUT'			=> 'A timeout occurred while reading from the network stream.',

	'FTP_FSOCK_HOST'				=> 'FTP host',
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'FTP server used to connect your site.',
	'FTP_FSOCK_PASSWORD'			=> 'FTP password',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'Password for your FTP username.',
	'FTP_FSOCK_PORT'				=> 'FTP port',
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'Port used to connect to your server.',
	'FTP_FSOCK_ROOT_PATH'			=> 'Path to phpBB',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'Path from the root to your phpBB board.',
	'FTP_FSOCK_TIMEOUT'				=> 'FTP timeout',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'The amount of time, in seconds, that the system will wait for a reply from your server.',
	'FTP_FSOCK_USERNAME'			=> 'FTP username',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'Username used to connect to your server.',

	'FTP_HOST'					=> 'FTP host',
	'FTP_HOST_EXPLAIN'			=> 'FTP server used to connect your site.',
	'FTP_PASSWORD'				=> 'FTP password',
	'FTP_PASSWORD_EXPLAIN'		=> 'Password for your FTP username.',
	'FTP_PORT'					=> 'FTP port',
	'FTP_PORT_EXPLAIN'			=> 'Port used to connect to your server.',
	'FTP_ROOT_PATH'				=> 'Path to phpBB',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'Path from the root to your phpBB board.',
	'FTP_TIMEOUT'				=> 'FTP timeout',
	'FTP_TIMEOUT_EXPLAIN'		=> 'The amount of time, in seconds, that the system will wait for a reply from your server.',
	'FTP_USERNAME'				=> 'FTP username',
	'FTP_USERNAME_EXPLAIN'		=> 'Username used to connect to your server.',

	'GENERAL_ERROR'				=> 'خطاي کلي',
	'GO'						=> 'برو',
	'GOTO_PAGE'					=> 'برو به صفحه',
	'GROUP'						=> 'گروه',
	'GROUPS'					=> 'گروه ها',
	'GROUP_ERR_TYPE'			=> 'Inappropriate group type specified.',
	'GROUP_ERR_USERNAME'		=> 'هيچ نام گروهي تعريف نشده است.',
	'GROUP_ERR_USER_LONG'		=> 'Group names cannot exceed 60 characters. The specified group name is too long.',
	'GUEST'						=> 'مهمان',
	'GUEST_USERS_ONLINE'		=> 'در حال حاضر %d مهمان انلاين داريم',
	'GUEST_USERS_TOTAL'			=> '%d مهمان ها',
	'GUEST_USERS_ZERO_ONLINE'	=> 'در حال حاضر هيچ مهمان آنلايني نداريم',
	'GUEST_USERS_ZERO_TOTAL'	=> '0 مهمان',
	'GUEST_USER_ONLINE'			=> 'در حال حاضر %d مهمان آنلاين داريم',
	'GUEST_USER_TOTAL'			=> '%d مهمان',
	'G_ADMINISTRATORS'			=> 'مديران سايت',
	'G_BOTS'					=> 'Bot ها',
	'G_GUESTS'					=> 'مهمان',
	'G_REGISTERED'				=> 'کاربران عضو شده',
	'G_REGISTERED_COPPA'		=> 'کاربران عضو شده COPPA',
	'G_GLOBAL_MODERATORS'		=> 'مديران انجمن',

	'HIDDEN_USERS_ONLINE'		=> '%d کاربر مخفي آنلاين',
	'HIDDEN_USERS_TOTAL'		=> '%d مخفي و ',
	'HIDDEN_USERS_TOTAL_AND'		=> '%d کاربر مخفي و ',
	'HIDDEN_USERS_ZERO_ONLINE'	=> '0 کاربر مخفي آنلاين',
	'HIDDEN_USERS_ZERO_TOTAL'	=> '0 مخفي و ',
	'HIDDEN_USERS_ZERO_TOTAL_AND'	=> 'هيچ کاربر مخفي و  ',
	'HIDDEN_USER_ONLINE'		=> '%d کاربر مخفي آنلاين',
	'HIDDEN_USER_TOTAL'			=> '%d مخفي و ',
	'HIDDEN_USER_TOTAL_AND'			=> ' %d مخفي و  ',
	'HIDE_GUESTS'				=> 'مخفي کردن مهمانها',
	'HIDE_ME'					=> 'پيغام آنلاين بودن من را نشان نده',
	'HOURS'						=> 'ساعت',
	'HOME'						=> 'خانه',

	'ICQ'						=> 'ICQ',
	'ICQ_STATUS'				=> 'ICQ status',	
	'IF'						=> 'If',
	'IMAGE'						=> 'تصوير',
	'IMAGE_FILETYPE_INVALID'	=> 'Image file type %d for mimetype %s not supported.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'Image file type mismatch: expected extension %1$s but extension %2$s given.',
	'IN'						=> 'in',
	'INDEX'						=> 'صفحه فهرست',
	'INFORMATION'				=> 'اطلاعات',
	'INTERESTS'					=> 'علايق',
	'INVALID_DIGEST_CHALLENGE'	=> 'Invalid digest challenge.',
	'INVALID_EMAIL_LOG'			=> '<strong>%s</strong> possibly an invalid e-mail address?',
	'IP'						=> 'IP',
	'IP_BLACKLISTED'			=> 'آي پي شما %1$ در ليست بن شدگان قرار گرفته است . براي اطلاعات بيشتر به اين آدرس برويد : <a href="%2$s">%2$s</a>',

	'JABBER'				=> 'Jabber',
	'JOINED'				=> 'تاريخ عضويت',
	'JUMP_PAGE'				=> 'شما صفحه مورد نظر خود را وارد نماييد',
	'JUMP_TO'				=> 'انتقال به',
	'JUMP_TO_PAGE'			=> 'براي انتقال به صفحه کليک کنيد ...',

	'KB'					=> 'کيلوبايت',
	'KIB'					=> 'KiB',

	'LAST_POST'							=> 'آخرين پست',
	'LAST_UPDATED'						=> 'آخرين به روزرساني',
	'LAST_VISIT'						=> 'آخرين بازديد',
	'LDAP_NO_LDAP_EXTENSION'			=> 'LDAP extension not available.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'Could not connect to LDAP server.',
	'LDAP_SEARCH_FAILED'				=> 'An error occured while searching the LDAP directory.',
	'LEGEND'							=> 'اختصارات',
	'LOCATION'							=> 'محل سکونت',
	'LOCK_POST'							=> 'بستن مبحث',
	'LOCK_POST_EXPLAIN'					=> 'جلوگيري از ويرايش',
	'LOCK_TOPIC'						=> 'بستن مبحث',
	'LOGIN'								=> 'ورود',
	'LOGIN_CHECK_PM'					=> 'ورود براي چک کردن پيغام هاي خصوصي',
	'LOGIN_CONFIRMATION'				=> 'تصديق ورود',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'To prevent brute forcing accounts the board requires you to enter a confirmation code after a maximum amount of failed logins. The code is displayed in the image you should see below. If you are visually impaired or cannot otherwise read this code please contact the %sBoard Administrator%s.', // unused
	'LOGIN_ERROR_ATTEMPTS'				=> 'تعداد تلاش  ناموفق شما برای ورود بیش از حد مجاز بوده. برای ورود علاوه بر نام کاربری و پسورد، باید کد ضدروبات زیر را نیز وارد کنید.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'You have not been authenticated by Apache.',
	'LOGIN_ERROR_PASSWORD'				=> 'شما کلمه عبور اشتباهي وارد کرده ايد. لطفا کلمه عبور خود را چک کرده و دوباره سعي کنيد. در صورتي که مشکلي داريد با %sمدير سايت%s درميان بگذاريد.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'It was not possible to convert your password when updating this bulletin board’s software. Please %srequest a new password%s. If you continue to have problems please contact the %sBoard Administrator%s.',
	'LOGIN_ERROR_USERNAME'				=> 'نام کاربری وارد شده نادرست است.
<br />
		 اگر از صحت نام کاربری وارد شده مطمئنید و با تلاش مجدد نتوانستید وارد شوید، با %sمدیریت انجمن%s تماس بگیرید.',
	'LOGIN_FORUM'						=> 'براي هرگونه فعاليت در اين انجمن بايد كلمه عبور انجمن را وارد كنيد.',
	'LOGIN_INFO'						=> 'اگر عضو هستيد، با نام كاربري و كلمه عبور خود وارد شويد. <br />اگر عضو نيستيد،مي توانيد عضو شويد. براي عضويت فقط دقايق کوتاهي از وقت خود را تا تکميل عضويت صرف مي کنيد. ',
	'LOGIN_VIEWFORUM'					=> 'برای دیدن مطالب این انجمن باید عضو شده باشید و با حساب کاربری خود وارد شده باشید.',
	'LOGIN_EXPLAIN_EDIT'				=> 'برای ویرایش ارسال ها باید با حساب کاربری خود وارد شده باشید.',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'برای نمایش لیست کاربران آنلاین باید با حساب کاربری خود وارد شوید',
	'LOGOUT'							=> 'خروج',
	'LOGOUT_USER'						=> 'خروج [ %s ]',
	'LOG_ME_IN'							=> 'مرا در هر بازديد به ياد داشته باش !',

	'MARK'					=> 'نشانه گذاري',
	'MARK_ALL'				=> 'نشانه گذاري همه',
	'MARK_FORUMS_READ'		=> 'نشانه گذاري انجمن ها بعنوان خوانده شده',
	'MARK_SUBFORUMS_READ'	=> 'نشانه گذاری زیر انجمن ها به عنوان خوانده شده',
	'MB'					=> 'مگابايت',
	'MIB'					=> 'MiB',
	'MCP'					=> 'کنترل پنل مدير انجمن',
	'MEMBERLIST'			=> 'کاربران',
	'MEMBERLIST_EXPLAIN'	=> 'مشاهده ليست کامل از کاربران',
	'MERGE'					=> 'ادغام',
	'MERGE_POSTS'			=> 'انتقال پست ها',
	'MERGE_TOPIC'			=> 'ادغام مبحث',
	'MESSAGE'				=> 'پيغام',
	'MESSAGES'				=> 'پيغام ها',
	'MESSAGE_BODY'			=> 'متن پيغام',
	'MINUTES'				=> 'دقيقه',
	'MODERATE'				=> 'اداره کردن',
	'MODERATOR'				=> 'مدير انجمن',
	'MODERATORS'			=> 'مديران انجمن',
	'MONTH'					=> 'ماه',
	'MOVE'					=> 'انتقال',
	'MSNM'					=> 'MSNM/WLM',	

	'NA'						=> 'N/A',
	'NEWEST_USER'				=> 'آخرين کاربر عضو شده  <strong>%s</strong>',
	'NEW_MESSAGE'				=> 'پغام جديد',
	'NEW_MESSAGES'				=> 'پيغام هاي جديد',
	'NEW_PM'					=> '<strong>%d</strong> پيغام جديد',
	'NEW_PMS'					=> '<strong>%d</strong> پيغام جديد',
	'NEW_POST'					=> 'پست جدید',	// Not used anymore
	'NEW_POSTS'					=> 'پست های جدید',	// Not used anymore
	'NEXT'						=> 'بعدي',		// Used in pagination
	'NEXT_STEP'					=> 'بعدي',
	'NEVER'						=> 'هيچ گاه',
	'NO'						=> 'خير',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'شما اجازه مديريت اين گروه را نداريد.',
	'NOT_AUTHORISED'			=> 'You are not authorised to access this area.',
	'NOT_WATCHING_FORUM'		=> 'شما ديگر از به روزرساني اين انجمن با اطلاع نمي شويد.',
	'NOT_WATCHING_TOPIC'		=> 'شما ديگر از به روزرساني مبحث با اطلاع نمي شويد.',
	'NOTIFY_ADMIN'				=> 'لطفا به مدير سايت يا وبمستر اطلاع دهيد.',
	'NOTIFY_ADMIN_EMAIL'		=> 'لطفا مدير سايت يا وبمستر را باخبر کنيد: <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'		=> 'شما اجازه دسترسی به این فایل را ندارید.',
	'NO_ACTION'					=> 'وظیفه ای تعیین نشده',
	'NO_ADMINISTRATORS'			=> 'بنیان گذاری وجود ندارد.',
	'NO_AUTH_ADMIN'				=> 'شما اجازه دسترسی به بخش مدیریت را ندارید',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'You are not able to re-authenticate as a different user.',
	'NO_AUTH_OPERATION'			=> 'You do not have the necessary permissions to complete this operation.',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'Could not connect to smtp host : %1$s : %2$s',
	'NO_BIRTHDAYS'				=> 'هيچ کس متولد امروز نمي باشد',
	'NO_EMAIL_MESSAGE'			=> 'پيغام ايميل خالي مي باشد.',
	'NO_EMAIL_RESPONSE_CODE'	=> 'Could not get mail server response codes.',
	'NO_EMAIL_SUBJECT'			=> 'عنوان ايميل مشخص نشده است.',
	'NO_FORUM'					=> 'The forum you selected does not exist.',
	'NO_FORUMS'					=> 'اين بورد هيچ انجمني ندارد.',
	'NO_GROUP'					=> 'The requested usergroup does not exist.',
	'NO_GROUP_MEMBERS'			=> 'This group currently has no members.',
	'NO_IPS_DEFINED'			=> 'No IP addresses or hostnames defined',
	'NO_MEMBERS'				=> 'هيچ کاربري در جستجوي اين معيار يافت نشد.',
	'NO_MESSAGES'				=> 'بدون پيغام',
	'NO_MODE'					=> 'No mode specified.',
	'NO_MODERATORS'				=> 'مديري تعيين نشده.',
	'NO_NEW_MESSAGES'			=> 'بدون پيغام جديد',
	'NO_NEW_PM'					=> '<strong>0</strong> پيغام جديد',
	'NO_NEW_POSTS'				=> 'بدون پست جديد',	// Not used anymore
	'NO_ONLINE_USERS'			=> 'بدون كاربران آنلاين',
	'NO_POSTS'					=> 'بدون پست',
	'NO_POSTS_TIME_FRAME'		=> 'No posts exist inside this topic for the selected time frame.',
	'NO_SUBJECT'				=> 'هيچ عنواني انتخاب نشده است.',								// Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'		=> 'The specified search backend doesn’t exist.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'No supported authentication methods.',
	'NO_TOPIC'					=> 'مبحث درخواست شده موجود نمي باشد.',
	'NO_TOPIC_FORUM'			=> 'The topic or forum no longer exists.',
	'NO_TOPICS'					=> 'هيچ مبحث يا پستي در اين انجمن موجود نيست.',
	'NO_TOPICS_TIME_FRAME'		=> 'No topics exist inside this forum for the selected time frame.',
	'NO_UNREAD_PM'				=> '<strong>0</strong> unread messages',
	'NO_UNREAD_POSTS'			=> 'بدون پست جدید',

	'NO_UPLOAD_FORM_FOUND'		=> 'Upload initiated but no valid file upload form found.',
	'NO_USER'					=> 'The requested user does not exist.',
	'NO_USERS'					=> 'The requested users do not exist.',
	'NO_USER_SPECIFIED'			=> 'هيچ نام کاربري تعيين نشده است.',
		// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_POSTS_IN_QUEUE'		=> array(
		0			=> 'پستي در صف نمي باشد',		// 0
		1			=> 'يك پست در صف است.',		// 1
		2			=> 'پست در صف است.',		// 2+
	),

	'OCCUPATION'				=> 'شغل',
	'OFFLINE'					=> 'آفلاين',
	'ONLINE'					=> 'آنلاين',
	'ONLINE_BUDDIES'			=> 'دوستان آنلاين',
	'ONLINE_USERS_TOTAL'		=> 'درکل <strong>%d</strong> کاربر آنلاين داريم :: ',
	'ONLINE_USERS_ZERO_TOTAL'	=> 'درکل <strong>0</strong> کاربر آنلاين داريم :: ',
	'ONLINE_USER_TOTAL'			=> 'بطور کلي ما <strong>%d</strong> کاربر آنلاين داريم :: ',
	'OPTIONS'					=> 'تنظيمات',

	'PAGE_OF'				=> 'صفحه <strong>%1$d</strong> از <strong>%2$d</strong>',
	'PASSWORD'				=> 'کلمه عبور',
		
			'PIXEL'					=> 'px',

		
	'PLAY_QUICKTIME_FILE'	=> 'نمايش فايل Quick Time',
	'PM'					=> 'پیام خصوصی',
	'PM_REPORTED'			=> 'برای نمایش گزارش کلیک کنید',
	'POSTING_MESSAGE'		=> 'پیام های ارسال شده در %s',
	'POSTING_PRIVATE_MESSAGE'	=> 'درحال نوشتن پيغام خصوصي',
	'POST'					=> 'پست',
	'POST_ANNOUNCEMENT'		=> 'اطلاعيه',
	'POST_STICKY'			=> 'مهم',
	'POSTED'				=> 'ارسال شده در',
	'POSTED_IN_FORUM'		=> 'in',
	'POSTED_ON_DATE'		=> 'در',
	'POSTS'					=> 'پست ها ',
	'POSTS_UNAPPROVED'		=> 'At least one post in this topic has not been approved.',
	'POST_BY_AUTHOR'		=> 'توسط',
	'POST_BY_FOE'			=> 'This post was made by <strong>%1$s</strong> who is currently on your ignore list. %2$sDisplay this post%3$s.',
	'POST_DAY'				=> 'میانگین ارسال در روز : %.2f',
	'POST_DETAILS'			=> 'اطلاعات مطلب',
	'POST_NEW_TOPIC'		=> 'ارسال مبحث جديد',
	'POST_PCT'				=> '%.2f%% از همه پستها',
	'POST_PCT_ACTIVE'		=> '%.2f%% از پست هاي کاربران',
	'POST_PCT_ACTIVE_OWN'	=> '%.2f%% از پست هاي شما',
	'POST_REPLY'			=> 'ارسال پاسخ',
	'POST_REPORTED'			=> 'براي مشاهده گزارش کليک کنيد',
	'POST_SUBJECT'			=> 'موضوع پست',
	'POST_TIME'				=> 'زمان پست',
	'POST_TOPIC'			=> 'ارسال مبحث جديد',
	'POST_UNAPPROVED'		=> 'اين پست در ليست انتظار براي تاييد شدن قرار گرفت.',
	'PREVIEW'				=> 'پيش نمايش',
	'PREVIOUS'				=> 'قبلي',		// Used in pagination
	'PREVIOUS_STEP'			=> 'قبلي',
	'PRIVACY'				=> 'حريم شخصی',
	'PRIVATE_MESSAGE'		=> 'پيغام خصوصي',
	'PRIVATE_MESSAGES'		=> 'پيغام هاي خصوصي',
	'PRIVATE_MESSAGING'		=> 'Private messaging',
	'PROFILE'				=> 'کنترل پنل کاربري',

	'READING_FORUM'				=> 'مشاهده مبحث در %s',
	'READING_GLOBAL_ANNOUNCE'	=> 'Reading global announcement',
	'READING_LINK'				=> 'Following forum link %s',
	'READING_TOPIC'				=> 'در حال خواندن مبحث در %s',
	'READ_PROFILE'				=> 'مشخصات',
	'REASON'					=> 'دليل',
	'RECORD_ONLINE_USERS'		=> 'بيشترين تعداد افراد آنلاين هم زمان <strong>%1$s</strong>  نفر در تاريخ  %2$s',
	'REDIRECT'					=> 'بازگرداني',
	'REDIRECTS'					=> 'کل بازگرداني ها',
	'REGISTER'					=> 'عضويت',
	'REGISTERED_USERS'			=> 'كاربران آنلاين:',
	'REG_USERS_ONLINE'			=> 'كاربران آنلاين %d و ',
	'REG_USERS_TOTAL'			=> '%d عضو شده, ',
	'REG_USERS_TOTAL_AND'		=> '%d عضو شده و  ',
	'REG_USERS_ZERO_ONLINE'		=> 'كاربران آنلاين 0 و ',
	'REG_USERS_ZERO_TOTAL'		=> '0 عضو شده, ',
	'REG_USERS_ZERO_TOTAL_AND'	=> 'هيچ کاربر عضو و  ',
	'REG_USER_ONLINE'			=> 'عضو آنلاين %d ',
	'REG_USER_TOTAL'			=> '%d عضو شده, ',
	'REG_USER_TOTAL_AND'		=> '%d عضو شده و ',
	'REMOVE'					=> 'حذف',
	'REMOVE_INSTALL'			=> 'لطفا قبل از استفاده از انجمن دايرکتوري install را حذف،جابا جا يا تغيير نام دهيد. اين دايرکتوري هم اکنون حاضر است, فقط مديرسايت (در ACP) اجازه دسترسي دارد.',
	'REPLIES'					=> 'پاسخ ها',
	'REPLY_WITH_QUOTE'			=> 'پاسخ بهمراه نقل قول',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'Replying to global announcement',
	'REPLYING_MESSAGE'			=> 'Replying to message in %s',
	'REPORT_BY'					=> 'گزارش توسط',
	'REPORT_POST'				=> 'گزارش نوشته نامناسب',
	'REPORTING_POST'			=> 'Reporting post',
	'RESEND_ACTIVATION'			=> 'ارسال دوباره ايميل فعال سازي',
	'RESET'						=> 'دوباره',
	'RESTORE_PERMISSIONS'		=> 'به حالت اول برگرداندن سطح دسترسي',
	'RETURN_INDEX'				=> '%sبازگشت به صفحه فهرست%s',
	'RETURN_FORUM'				=> '%sبازگشت به آخرين انجمن بازديد شده%s',
	'RETURN_PAGE'				=> '%sبازگشت به صفحه قبلي%s',
	'RETURN_TOPIC'				=> '%sبازگشت به آخرين مبحث بازديد شده%s',
	'RETURN_TO'					=> 'بازگشت به',
		
		
	
	'FEED'						=> 'Feed',
	'FEED_NEWS'					=> 'News',

		
		
	'RULES_ATTACH_CAN'			=> 'شما <strong>مي توانيد</strong> فايل هاي پيوست در اين انجمن ارسال کنيد',
	'RULES_ATTACH_CANNOT'		=> 'شما <strong>نمي توانيد</strong> فايل هاي پيوست در اين انجمن ارسال کنيد',
	'RULES_DELETE_CAN'			=> 'شما <strong>مي توانيد</strong> پست هاي خود را در اين انجمن حذف کنيد',
	'RULES_DELETE_CANNOT'		=> 'شما <strong>نمي توانيد</strong> پست هاي خود را در اين انجمن حذف کنيد',
	'RULES_DOWNLOAD_CAN'		=> 'شما <strong>مي توانيد</strong> فايل هاي پيوست را در اين انجمن دريافت کنيد',
	'RULES_DOWNLOAD_CANNOT'		=> 'شما <strong>نمي توانيد</strong> فايل هاي پيوست را در اين انجمن دريافت کنيد',
	'RULES_EDIT_CAN'			=> 'شما <strong>مي توانيد</strong> پست هاي خود را در اين انجمن ويرايش کنيد',
	'RULES_EDIT_CANNOT'			=> 'شما <strong>نمي توانيد</strong> پست هاي خود را در اين انجمن ويرايش کنيد',
	'RULES_LOCK_CAN'			=> 'شما <strong>مي توانيد</strong> مبحث هاي خود را در اين انجمن قفل کنيد',
	'RULES_LOCK_CANNOT'			=> 'شما <strong>نمي توانيد</strong> مبحث هاي خود را در اين انجمن قفل کنيد',
	'RULES_POST_CAN'			=> 'شما <strong>مي توانيد</strong> يک مبحث جديد در اين انجمن ارسال کنيد',
	'RULES_POST_CANNOT'			=> 'شما <strong>نمي توانيد</strong> مبحث جديدي در اين انجمن ايجاد کنيد',
	'RULES_REPLY_CAN'			=> 'شما <strong>مي توانيد</strong> به مباحث در اين انجمن پاسخ دهيد',
	'RULES_REPLY_CANNOT'		=> 'شما <strong>نمي توانيد</strong> به مباحث در اين انجمن پاسخ دهيد',
	'RULES_VOTE_CAN'			=> 'شما <strong>مي توانيد</strong> به نظرسنجي ها در اين انجمن راي دهيد',
	'RULES_VOTE_CANNOT'			=> 'شما <strong>نمي توانيد</strong> به نظرسنجي ها در اين انجمن راي دهيد',

	'SEARCH'					=> 'جستجو',
	'SEARCH_MINI'				=> 'جستجو ...',
	'SEARCH_ADV'				=> 'جستجوي پيشرفته',
	'SEARCH_ADV_EXPLAIN'		=> 'مشاهده تنظيمات جستجوي پيشرفته',
	'SEARCH_KEYWORDS'			=> 'جستجو براي کلمات کليدي',
	'SEARCHING_FORUMS'			=> 'Searching forums',
	'SEARCH_ACTIVE_TOPICS'		=> 'نمايش مبحث هاي فعال',
	'SEARCH_FOR'				=> 'جستجو براي',
	'SEARCH_FORUM'				=> 'جستجو در اين انجمن...',	
	'SEARCH_NEW'				=> 'مشاهده پست هاي جديد',
	'SEARCH_POSTS_BY'			=> 'Search posts by',
	'SEARCH_SELF'				=> 'نمايش پست هاي شما',
	'SEARCH_TOPIC'				=> 'جستجو در اين مبحث...',
	'SEARCH_UNANSWERED'			=> 'مشاهده پست هاي بدون جواب',
	'SECONDS'					=> 'ثانيه',
	'SELECT'					=> 'انتخاب',
	'SELECT_ALL_CODE'			=> 'انتخاب همه',
	'SELECT_DESTINATION_FORUM'	=> 'لطفا يک انجمن مقصد انتخاب کنيد',
	'SELECT_FORUM'				=> 'انتخاب يک انجمن',
	'SEND_EMAIL'				=> 'E-mail',				// Used for submit buttons
	'SEND_EMAIL_USER'			=> 'ايميل',				// Used as: {L_SEND_EMAIL_USER} {USERNAME} -> E-mail UserX
	'SEND_PRIVATE_MESSAGE'		=> 'ارسال پيغام خصوصي',
	'SETTINGS'					=> 'تنظيمات',
	'SIGNATURE'					=> 'امضا',
	'SKIP'						=> 'انتقال به محتوا',
	'SMTP_NO_AUTH_SUPPORT'		=> 'SMTP server does not support authentication.',
	'SORRY_AUTH_READ'			=> 'شما اجازه خواندن اين انجمن را نداريد.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'شما اجازه دريافت فايل هاي پيوست را نداريد.',
	'SORT_BY'					=> 'مرتب سازي بر اساس',
	'SORT_JOINED'				=> 'تاريخ عضويت',
	'SORT_LOCATION'				=> 'محل سکونت',
	'SORT_RANK'					=> 'امتياز',
	'SORT_TOPIC_TITLE'			=> 'عنوان مبحث',
	'SORT_USERNAME'				=> 'نام کاربري',
	'SPLIT_TOPIC'				=> 'شکافتن مبحث',
	'SQL_ERROR_OCCURRED'		=> 'An SQL error occurred while fetching this page. Please contact the %sBoard Administrator%s if this problem persists.',
	'STATISTICS'				=> 'آمار و اطلاعات',
	'START_WATCHING_FORUM'		=> 'اشتراک در انجمن',
	'START_WATCHING_TOPIC'		=> 'اشتراک در مبحث',
	'STOP_WATCHING_FORUM'		=> 'لغو اشتراک در انجمن',
	'STOP_WATCHING_TOPIC'		=> 'لغو اشتراک در مبحث',
	'SUBFORUM'					=> 'زير انجمن',
	'SUBFORUMS'					=> 'زير انجمن ها',
	'SUBJECT'					=> 'موضوع',
	'SUBMIT'					=> 'ارسال',

	'TERMS_USE'			=> 'قوانين انجمن',
	'TEST_CONNECTION'	=> 'تست اتصال',
	'THE_TEAM'			=> 'ليست مديران',
	'TIME'				=> 'زمان',
	'TOO_LARGE'						=> 'The value you entered is too large.',
	'TOO_LARGE_MAX_RECIPIENTS'		=> 'The value of <strong>Maximum number of allowed recipients per private message</strong> setting you entered is too large.',

	'TOO_LONG'						=> 'مقدار وارد شده خيلي طولاني است.',

	'TOO_LONG_AIM'					=> 'نام نمايشي وارد شده طولاني است.',
	'TOO_LONG_CONFIRM_CODE'			=> 'کد تاييد وارد شده طولاني مي باشد',
	'TOO_LONG_DATEFORMAT'			=> 'حالت زماني وارد شده طولاني مي باشد.',
	'TOO_LONG_ICQ'					=> 'شماره ICQ وارد شده طولاني مي باشد.',
	'TOO_LONG_INTERESTS'			=> 'دلبستگي هاي وارد شده طولاني مي باشد.',
	'TOO_LONG_JABBER'				=> 'اکانت Jabber وارد شده طولاني مي باشد.',
	'TOO_LONG_LOCATION'				=> 'محل سکونت وارد شده طولاني مي باشد.',
	'TOO_LONG_MSN'					=> 'نام MSNM/WLM وارد شده طولاني مي باشد',
	'TOO_LONG_NEW_PASSWORD'			=> 'کلمه عبور وارد شده طولاني مي باشد.',
	'TOO_LONG_OCCUPATION'			=> 'شغل وارد شده طولاني مي باشد.',
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'تاييديه کلمه عبور طولاني مي باشد',
	'TOO_LONG_USER_PASSWORD'		=> 'کلمه عبور وارد شده طولاني مي باشد.',
	'TOO_LONG_USERNAME'				=> 'نام کاربري وارد شده طولاني مي باشد.',
	'TOO_LONG_EMAIL'				=> 'آدرس ايميل وارد شده طولاني مي باشد',
	'TOO_LONG_EMAIL_CONFIRM'		=> 'تاييد آدرس ايميل طولاني مي باشد.',
	'TOO_LONG_WEBSITE'				=> 'آدرس وبسايت وارد شده طولاني مي باشد.',
	'TOO_LONG_YIM'					=> 'نام ياهو مسنجر وراد شده طولاني مي باشد.',

	'TOO_MANY_VOTE_OPTIONS'			=> 'شما تلاش کردید تعداد زیادی گزینه را رای دهید.',
	'TOO_SHORT'						=> 'مقدار وارد شده توسط شما خیلی کوتاه است.',

	'TOO_SHORT_AIM'					=> 'نام نمايشي وارد شده کوتاه مي باشد.',
	'TOO_SHORT_CONFIRM_CODE'		=> 'کد تاييد وارد شده کوتاه مي باشد.',
	'TOO_SHORT_DATEFORMAT'			=> 'فرمت زماني وارد شده کوتاه مي باشد.',
	'TOO_SHORT_ICQ'					=> 'شماره ICQ وارد شده کوتاه مي باشد.',
	'TOO_SHORT_INTERESTS'			=> 'علايق وارد شده خيلي كوتاه است.',
	'TOO_SHORT_JABBER'				=> 'اکانت Jabber وارد شده کوتاه مي باشد.',
	'TOO_SHORT_LOCATION'			=> 'محل سکونت وارد شده کوتاه مي باشد.',
	'TOO_SHORT_MSN'					=> 'نام MSNM/WLM وارد شده کوتاه مي باشد.',
	'TOO_SHORT_NEW_PASSWORD'		=> 'کلمه عبور وارد شده موتاه مي باشد.',
	'TOO_SHORT_OCCUPATION'			=> 'شغل وارد شده کوتاه مي باشد.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'تاييديه کلمه عبور کوتاه مي باشد.',
	'TOO_SHORT_USER_PASSWORD'		=> 'کلمه عبور وارد شده کوتاه مي باشد.',
	'TOO_SHORT_USERNAME'			=> 'نام کاربري وارد شده کوتاه مي باشد.',
	'TOO_SHORT_EMAIL'				=> 'آدرس ايميل وارد شده کوتاه مي باشد.',
	'TOO_SHORT_EMAIL_CONFIRM'		=> 'تاييديه آدرس ايميل کوتاه مي باشد.',
	'TOO_SHORT_WEBSITE'				=> 'آدرس وب سايت وارد شده کوتاه مي باشد.',
	'TOO_SHORT_YIM'					=> 'نام ياهو! مسنجر وارد شده کوتاه مي باشد.',
	'TOO_SMALL'						=> 'The value you entered is too small.',
	'TOO_SMALL_MAX_RECIPIENTS'		=> 'The value of <strong>Maximum number of allowed recipients per private message</strong> setting you entered is too small.',


	'TOPIC'				=> 'مبحث',
	'TOPICS'			=> 'مباحث',
	'TOPIC_ICON'		=> 'آيكن مبحث',
	'TOPIC_LOCKED'		=> 'اين مبحث بسته شده است.شما نمي توانيد پست هاي خود را ويرايش يا پست جديدي ارسال کنيد. ',
	'TOPIC_LOCKED_SHORT'=> 'مبحث قفل شده',
	'TOPIC_MOVED'		=> 'مبحث انتقال يافته',
	'TOPIC_REVIEW'		=> 'مرورکننده مبحث',
	'TOPIC_TITLE'		=> 'عنوان مبحث',
	'TOPIC_UNAPPROVED'	=> 'اين مبحث تاييد نشده است.',
	'TOTAL_ATTACHMENTS'	=> 'پيوست(ها)',
	'TOTAL_LOG'			=> '1 عمل',
	'TOTAL_LOGS'		=> '%d عمليات',
	'TOTAL_NO_PM'		=> '0 پيغام خصوصي در کل',
	'TOTAL_PM'			=> '1 پيغام خصوصي در کل',
	'TOTAL_PMS'			=> '%d پيغام خصوصي در کل',
	'TOTAL_POSTS'		=> 'تعداد پست ها',
	'TOTAL_POSTS_OTHER'	=> 'تعداد پست ها <strong>%d</strong>',
	'TOTAL_POSTS_ZERO'	=> 'کل پست ها <strong>0</strong>',
	'TOPIC_REPORTED'	=> 'This topic has been reported',
	'TOTAL_TOPICS_OTHER'=> 'تعداد مبحث ها <strong>%d</strong>',
	'TOTAL_TOPICS_ZERO'	=> 'کل مبحث ها <strong>0</strong>',
	'TOTAL_USERS_OTHER'	=> 'تعداد کاربران <strong>%d</strong>',
	'TOTAL_USERS_ZERO'	=> 'تعداد کاربران <strong>0</strong>',
	'TRACKED_PHP_ERROR'	=> 'خطاهاي زنجيره PHP: %s',

	'UNABLE_GET_IMAGE_SIZE'	=> 'It was not possible to determine the dimensions of the image.',
	'UNABLE_TO_DELIVER_FILE'=> 'Unable to deliver file.',
	'UNKNOWN_BROWSER'		=> 'مرورگر ناشناخته',
	'UNMARK_ALL'			=> 'لغوانتخاب همه',
	'UNREAD_MESSAGES'		=> 'پيغام هاي خوانده نشده',
	'UNREAD_PM'				=> '<strong>%d</strong> پيغام خوانده نشده',
	'UNREAD_PMS'			=> '<strong>%d</strong> پيغام خوانده نشده',
	'UNREAD_POST'			=> 'پست خوانده نشده',
	'UNREAD_POSTS'			=> 'دارای پست جدید',
		'UNWATCH_FORUM_CONFIRM'		=> 'Are you sure you wish to unsubscribe from this forum?',
	'UNWATCH_FORUM_DETAILED'	=> 'Are you sure you wish to unsubscribe from the forum “%s”?',
	'UNWATCH_TOPIC_CONFIRM'		=> 'Are you sure you wish to unsubscribe from this topic?',
	'UNWATCH_TOPIC_DETAILED'	=> 'Are you sure you wish to unsubscribe from the topic “%s”?',
	'UNWATCHED_FORUMS'			=> 'You are no longer subscribed to the selected forums.',
	'UNWATCHED_TOPICS'			=> 'You are no longer subscribed to the selected topics.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'You are no longer subscribed to the selected entries.',
	'UPDATE'				=> 'Update',
	'UPLOAD_IN_PROGRESS'	=> 'The upload is currently in progress.',
	'URL_REDIRECT'			=> 'If your browser does not support meta redirection %splease click HERE to be redirected%s.',
	'USERGROUPS'			=> 'گروه کاربري',
	'USERNAME'				=> 'نام کاربري',
	'USERNAMES'				=> 'نام هاي کاربري',
	'USER_AVATAR'			=> 'نماد کاربر',
	'USER_CANNOT_READ'		=> 'شما نمي توانيد پست هاي اين انجمن را بخوانيد.',
	'USER_POST'				=> '%d پست',
	'USER_POSTS'			=> '%d پست',
	'USERS'					=> 'کاربران',
	'USE_PERMISSIONS'		=> 'امتحان کردن سطوح دسترسی این کاربر',

	'VARIANT_DATE_SEPARATOR'	=> ' / ',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'بازديد شده',
	'VIEWING_FAQ'				=> 'در حال مشاهده پرسش و پاسخ ها',
	'VIEWING_MEMBERS'			=> 'درحال مشاهده اطلاعات کاربر',
	'VIEWING_ONLINE'			=> 'نمايش کساني که آنلاين هستند!',
	'VIEWING_MCP'				=> 'تماشاي کنترل پنل مدير انجمن',
	'VIEWING_MEMBER_PROFILE'	=> 'تماشاي مشخصات کاربر',
	'VIEWING_PRIVATE_MESSAGES'	=> 'تماشاي پيغام هاي خصوصي',
	'VIEWING_REGISTER'			=> 'Registering account',
	'VIEWING_UCP'				=> 'تماشاي کنترل پنل کاربري',
	'VIEWS'						=> 'بازديدها',
	'VIEW_BOOKMARKS'			=> 'نمايش نشانه گذاري شده ها',
	'VIEW_FORUM_LOGS'			=> 'نمايش اعمال',
	'VIEW_LATEST_POST'			=> 'نمایش آخرین ارسال',
	'VIEW_NEWEST_POST'			=> 'نمايش اولين پست خوانده نشده',
	'VIEW_NOTES'				=> 'نمايش يادداشت هاي کاربر',
	'VIEW_ONLINE_TIME'			=> 'اطلاعات اين قسمت بر اساس %d دقيقه قبل مي باشد',
	'VIEW_ONLINE_TIMES'			=> 'اطلاعات اين قسمت بر اساس %d دقيقه قبل مي باشد',
	'VIEW_TOPIC'				=> 'مشاهده مبحث',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'اطلاعيه: ',
	'VIEW_TOPIC_GLOBAL'			=> 'اطلاعيه کلي : ',
	'VIEW_TOPIC_LOCKED'			=> 'قفل شده: ',
	'VIEW_TOPIC_LOGS'			=> 'نمايش کارنامه',
	'VIEW_TOPIC_MOVED'			=> 'انتقال يافته : ',
	'VIEW_TOPIC_POLL'			=> 'نظر سنجي: ',
	'VIEW_TOPIC_STICKY'			=> 'مهم: ',
	'VISIT_WEBSITE'				=> 'نمايش وبسايت',

	'WARNINGS'			=> 'اخطارها',
	'WARN_USER'			=> 'دادن اخطار به کاربر',
		'WATCH_FORUM_CONFIRM'	=> 'Are you sure you wish to subscribe to this forum?',
	'WATCH_FORUM_DETAILED'	=> 'Are you sure you wish to subscribe to the forum “%s”?',
	'WATCH_TOPIC_CONFIRM'	=> 'Are you sure you wish to subscribe to this topic?',
	'WATCH_TOPIC_DETAILED'	=> 'Are you sure you wish to subscribe to the topic “%s”?',
	'WELCOME_SUBJECT'	=> 'به انجمن هاي %s خوش آمديد',
	'WEBSITE'			=> 'وب سايت',
	'WHOIS'				=> 'جستجو',
	'WHO_IS_ONLINE'		=> 'چه کسي حاضر است ؟',
	'WRONG_PASSWORD'	=> 'شما کلمه عبور اشتباهي را وارد کرده ايد.',

	'WRONG_DATA_ICQ'			=> 'شماره وارد شده شماره صحيحي براي ICQ نمي باشد',
	'WRONG_DATA_JABBER'			=> 'نام وارد شده اکانت صحيح Jabber نمي باشد.',
	'WRONG_DATA_LANG'			=> 'زبان مشخص شده صحيح نمي باشد.',
	'WRONG_DATA_WEBSITE'		=> 'آدرس سايت بايد صحيح و به همراه پرولتوکل باش.مثال : http://www.Maghsad.com',
	'WROTE'						=> 'نوشته است',

	'YEAR'				=> 'سال',
	'YEAR_MONTH_DAY'	=> '(YYYY-MM-DD)',
	'YES'				=> 'بلي',
	'YIM'				=> 'YIM',	
	'YOU_LAST_VISIT'	=> 'آخرين بازديد شما: %s',
	'YOU_NEW_PM'		=> 'A new private message is waiting for you in your Inbox.',
	'YOU_NEW_PMS'		=> 'New private messages are waiting for you in your Inbox.',
	'YOU_NO_NEW_PM'		=> 'No new private messages are waiting for you.',

	'datetime'			=> array(
		'TODAY'		=> 'امروز',
		'TOMORROW'	=> 'فردا',
		'YESTERDAY'	=> 'ديروز',

		'Sunday'	=> 'يکشنبه',
		'Monday'	=> 'دوشنبه',
		'Tuesday'	=> 'سه شنبه',
		'Wednesday'	=> 'چهارشنبه',
		'Thursday'	=> 'پنج شنبه',
		'Friday'	=> 'جمعه',
		'Saturday'	=> 'شنبه',

		'Sun'		=> 'يکشنبه',
		'Mon'		=> 'دوشنبه',
		'Tue'		=> 'سه شنبه',
		'Wed'		=> 'چهارشنبه',
		'Thu'		=> 'پنج شنبه',
		'Fri'		=> 'جمعه',
		'Sat'		=> 'شنبه',

		'January'	=> 'ژانويه',
		'February'	=> 'فبريه',
		'March'		=> 'مارس',
		'April'		=> 'آپريل',
		'May'		=> 'مه',
		'June'		=> 'ژوئن',
		'July'		=> 'جولاي',
		'August'	=> 'آگوست',
		'September' => 'سپتامبر',
		'October'	=> 'اکتبر',
		'November'	=> 'نوامبر',
		'December'	=> 'دسامبر',

		'Jan'		=> 'ژانويه',
		'Feb'		=> 'فبريه',
		'Mar'		=> 'مارس',
		'Apr'		=> 'آپريل',
		'May_short'	=> 'مه',	// Short representation of "May". May_short used because in English the short and long date are the same for May.
		'Jun'		=> 'ژوئن',
		'Jul'		=> 'جولاي',
		'Aug'		=> 'آگوست',
		'Sep'		=> 'سپتامبر',
		'Oct'		=> 'اکتبر',
		'Nov'		=> 'نوامبر',
		'Dec'		=> 'دسامبر',
	),

	'tz'				=> array(
		'-12'	=> 'UTC - 12 ساعت',
		'-11'	=> 'UTC - 11 ساعت',
		'-10'	=> 'UTC - 10 ساعت',
		'-9.5'	=> 'UTC - 9:30 ساعت',
		'-9'	=> 'UTC - 9 ساعت',
		'-8'	=> 'UTC - 8 ساعت',
		'-7'	=> 'UTC - 7 ساعت',
		'-6'	=> 'UTC - 6 ساعت',
		'-5'	=> 'UTC - 5 ساعت',
		'-4.5'	=> 'UTC - 4:30 ساعت',
		'-4'	=> 'UTC - 4 ساعت',
		'-3.5'	=> 'UTC - 3:30 ساعت',
		'-3'	=> 'UTC - 3 ساعت',
		'-2'	=> 'UTC - 2 ساعت',
		'-1'	=> 'UTC - 1 ساعت',
		'0'		=> 'UTC',
		'1'		=> 'UTC + 1 ساعت',
		'2'		=> 'UTC + 2 ساعت',
		'3'		=> 'UTC + 3 ساعت',
		'3.5'	=> 'UTC + 3:30 ساعت',
		'4'		=> 'UTC + 4 ساعت',
		'4.5'	=> 'UTC + 4:30 ساعت',
		'5'		=> 'UTC + 5 ساعت',
		'5.5'	=> 'UTC + 5:30 ساعت',
		'5.75'	=> 'UTC + 5:45 ساعت',
		'6'		=> 'UTC + 6 ساعت',
		'6.5'	=> 'UTC + 6:30 ساعت',
		'7'		=> 'UTC + 7 ساعت',
		'8'		=> 'UTC + 8 ساعت',
		'8.75'	=> 'UTC + 8:45 ساعت',
		'9'		=> 'UTC + 9 ساعت',
		'9.5'	=> 'UTC + 9:30 ساعت',
		'10'	=> 'UTC + 10 ساعت',
		'10.5'	=> 'UTC + 10:30 ساعت',
		'11'	=> 'UTC + 11 ساعت',
		'11.5'	=> 'UTC + 11:30 ساعت',
		'12'	=> 'UTC + 12 ساعت',
		'12.75'	=> 'UTC + 12:45 ساعت',
		'13'	=> 'UTC + 13 ساعت',
		'14'	=> 'UTC + 14 ساعت',
		'dst'	=> '[  <abbr title="افزودن یک ساعت بر ساعات روز">ساعت تابستانی</abbr> ]',
	),

	'tz_zones'	=> array(
		'-12'	=> '[UTC - 12] Baker Island Time',
		'-11'	=> '[UTC - 11] Niue Time, Samoa Standard Time',
		'-10'	=> '[UTC - 10] Hawaii-Aleutian Standard Time, Cook Island Time',
		'-9.5'	=> '[UTC - 9:30] Marquesas Islands Time',
		'-9'	=> '[UTC - 9] Alaska Standard Time, Gambier Island Time',
		'-8'	=> '[UTC - 8] Pacific Standard Time',
		'-7'	=> '[UTC - 7] Mountain Standard Time',
		'-6'	=> '[UTC - 6] Central Standard Time',
		'-5'	=> '[UTC - 5] Eastern Standard Time',
		'-4.5'	=> '[UTC - 4:30] Venezuelan Standard Time',
		'-4'	=> '[UTC - 4] Atlantic Standard Time',
		'-3.5'	=> '[UTC - 3:30] Newfoundland Standard Time',
		'-3'	=> '[UTC - 3] Amazon Standard Time, Central Greenland Time',
		'-2'	=> '[UTC - 2] Fernando de Noronha Time, South Georgia &amp; the South Sandwich Islands Time',
		'-1'	=> '[UTC - 1] Azores Standard Time, Cape Verde Time, Eastern Greenland Time',
		'0'		=> '[UTC] Western European Time, Greenwich Mean Time',
		'1'		=> '[UTC + 1] Central European Time, West African Time',
		'2'		=> '[UTC + 2] Eastern European Time, Central African Time',
		'3'		=> '[UTC + 3] Moscow Standard Time, Eastern African Time',
		'3.5'	=> '[UTC + 3:30] Iran Standard Time',
		'4'		=> '[UTC + 4] Gulf Standard Time, Samara Standard Time',
		'4.5'	=> '[UTC + 4:30] Afghanistan Time',
		'5'		=> '[UTC + 5] Pakistan Standard Time, Yekaterinburg Standard Time',
		'5.5'	=> '[UTC + 5:30] Indian Standard Time, Sri Lanka Time',
		'5.75'	=> '[UTC + 5:45] Nepal Time',
		'6'		=> '[UTC + 6] Bangladesh Time, Bhutan Time, Novosibirsk Standard Time',
		'6.5'	=> '[UTC + 6:30] Cocos Islands Time, Myanmar Time',
		'7'		=> '[UTC + 7] Indochina Time, Krasnoyarsk Standard Time',
		'8'		=> '[UTC + 8] Chinese Standard Time, Australian Western Standard Time, Irkutsk Standard Time',
		'8.75'	=> '[UTC + 8:45] Southeastern Western Australia Standard Time',
		'9'		=> '[UTC + 9] Japan Standard Time, Korea Standard Time, Chita Standard Time',
		'9.5'	=> '[UTC + 9:30] Australian Central Standard Time',
		'10'	=> '[UTC + 10] Australian Eastern Standard Time, Vladivostok Standard Time',
		'10.5'	=> '[UTC + 10:30] Lord Howe Standard Time',
		'11'	=> '[UTC + 11] Solomon Island Time, Magadan Standard Time',
		'11.5'	=> '[UTC + 11:30] Norfolk Island Time',
		'12'	=> '[UTC + 12] New Zealand Time, Fiji Time, Kamchatka Standard Time',
		'12.75'	=> '[UTC + 12:45] Chatham Islands Time',
		'13'	=> '[UTC + 13] Tonga Time, Phoenix Islands Time',
		'14'	=> '[UTC + 14] Line Island Time',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'd M y, H:i'			=> '23 مرداد 88, 13:33',
		'd M Y H:i'				=> '23 مرداد 1388 13:33',
		'jS M y, H:i'			=> '23 ام مرداد 1388, 13:33',
		'D d M y, g:i a'		=> 'جمعه 23 مرداد 1388, 1:33 pm',
		'F jS, y, g:i a'		=> 'مرداد 23 ام, 1388, 1:33 pm',
		'|d M y|, H:i'			=> 'امروز, 13:33 / 23 مرداد 88, 13:33',
		'|jS F Y|, g:i a'		=> 'امروز, 1:33 pm / 23 ام مرداد 1388, 1:33 pm'
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=> 'D d M y, g:i a', //جمعه 23 مرداد 1388, 1:33 pm
	
//BEGIN phpBB 3.0.5 Additionals by www.Maghsad.com

	'GB'						=> 'GB',
	'GIB'						=> 'GiB',

//END phpBB 3.0.5 Additionals by www.Maghsad.com
	
	
	
	
		// START 3.0.5 to 3.0.6 changes - www.phpBB.Maghsad.com	
		
	'G_NEWLY_REGISTERED'		=> 'Newly registered users',

////////////////////////

	'NO_FEED_ENABLED'			=> 'Feeds are not available on this board.',
	'NO_FEED'					=> 'The requested feed is not available.',

////////////////////////

	'FEED'						=> 'Feed',
	'FEED_NEWS'					=> 'News',

////////////////////////

	'SEARCH_UNREAD'				=> 'مشاهده پست های خوانده نشده',

//////////////////////
     
     'SEARCH_USER_POSTS'			=> 'جستجو در ارسال های کاربر',

//////////////////////

	'SORT_POSTS'				=> 'ارسال ها',

///////////////////////

	'TOPICS_UNAPPROVED'	=> 'At least one topic in this forum has not been approved.',

//////////////////////

	'TOPICS_UNAPPROVED'	=> 'At least one topic in this forum has not been approved.',
		
///////////////////

	'USER_NEW_PERMISSION_DISALLOWED'	=> 'We are sorry, but you are not authorised to use this feature. You may have just registered here and may need to participate more to be able to use this feature.',

///////////////////////

	'FEED_TOPICS_ACTIVE'		=> 'مباحث فعال',
	'FEED_TOPICS_NEW'			=> 'مباحث جدید',



		
		//END 3.0.5 to 3.0.6 changes - www.phpBB.Maghsad.com					
));

?>