--TEST--
maxdb bind_param/bind_result tinyint values
--SKIPIF--
<?php require 'skipif.inc'; ?>
--FILE--
<?php
	include "connect.inc";
	
	/*** test maxdb_connect 127.0.0.1 ***/
	$link = maxdb_connect("localhost", $user, $passwd);

	maxdb_select_db($link, $db);

        maxdb_report (MAXDB_REPORT_OFF);
  	maxdb_query($link,"DROP TABLE test_bind_fetch");
        maxdb_report (MAXDB_REPORT_ERROR);

  	maxdb_query($link,"CREATE TABLE test_bind_fetch(c1 smallint,
                                                     c2 smallint,
                                                     c3 smallint not NULL,
                                                     c4 smallint,
                                                     c5 smallint,
                                                     c6 smallint,
                                                     c7 smallint)");

	$stmt = maxdb_prepare ($link, "INSERT INTO test_bind_fetch VALUES(?,?,?,?,?,?,?)");
	maxdb_bind_param($stmt, "iiiiiii", $c1,$c2,$c3,$c4,$c5,$c6,$c7);

	$c1 = -23;
	$c2 = 300;
	$c3 = 0;
	$c4 = -100;
	$c5 = -127;
	$c6 = 30;
	$c7 = 0;

	maxdb_execute($stmt);
	maxdb_stmt_close($stmt);

	maxdb_query($link, "INSERT INTO test_bind_fetch VALUES (-23,300,0,-100,-127,+30,0)");

	$c1 = $c2 = $c3 = $c4 = $c5 = $c6 = $c7 = NULL;

	$stmt = maxdb_prepare($link, "SELECT * FROM test_bind_fetch");
	maxdb_bind_result($stmt, $c1, $c2, $c3, $c4, $c5, $c6, $c7);
	maxdb_execute($stmt);
	maxdb_fetch($stmt);

	$test = array($c1,$c2,$c3,$c4,$c5,$c6,$c7);

	var_dump($test);

	maxdb_stmt_close($stmt);
	maxdb_close($link);
?>
--EXPECT--
array(7) {
  [0]=>
  int(-23)
  [1]=>
  int(300)
  [2]=>
  int(0)
  [3]=>
  int(-100)
  [4]=>
  int(-127)
  [5]=>
  int(30)
  [6]=>
  int(0)
}
