--TEST--
maxdb bind_param+bind_result char/text 
--FILE--
<?php
	include "connect.inc";
	
	/*** test maxdb_connect 127.0.0.1 ***/
	$link = maxdb_connect("localhost", $user, $passwd);

	maxdb_select_db($link, $db);

        maxdb_report (MAXDB_REPORT_OFF);
  	maxdb_query($link,"DROP TABLE test_bind_fetch");
        maxdb_report (MAXDB_REPORT_ERROR);
  	maxdb_query($link,"CREATE TABLE test_bind_fetch(c1 char(10), c2 varchar(200))");

	$stmt = maxdb_prepare($link, "INSERT INTO test_bind_fetch VALUES (?,?)");
	maxdb_bind_param($stmt, "ss", $q1, $q2);
	$q1 = "1234567890";
	$q2 = "this is a test";
	maxdb_execute($stmt);
	maxdb_stmt_close($stmt);

	$stmt = maxdb_prepare($link, "SELECT * FROM test_bind_fetch");
	maxdb_bind_result($stmt, $c1, $c2);
	maxdb_execute($stmt);
	maxdb_fetch($stmt);

	$test = array($c1,$c2);

	var_dump($test);

	maxdb_stmt_close($stmt);
	maxdb_close($link);
?>
--EXPECT--
array(2) {
  [0]=>
  string(10) "1234567890"
  [1]=>
  string(14) "this is a test"
}
